/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.estoque.posicaoestoque;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.FamiliaProduto;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.contabil.MesFiscal;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioMensalRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.estoque.relatorio.PosicaoEstoqueRelatorio;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.GradeValorRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.sped.fiscal.TipoCalculoCusto;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.estoque.posicaoestoque.PosicaoEstoque;
import java.time.LocalDate;
import java.util.List;

public class PosicaoEstoqueReportExecute
extends AbstractReporteExecute<PosicaoEstoque> {
    public PosicaoEstoqueReportExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        PosicaoEstoque parametros = (PosicaoEstoque)this.fromJson(parametrosObj, PosicaoEstoque.class);
        return this.executa(sessao, parametros);
    }

    public Remessa executa(Sessao sessao, PosicaoEstoque posicaoEstoqueWrapper) throws UnicoMensagemUsuarioException {
        Entidade fornecedor = null;
        Produto produto = null;
        String familia = null;
        List linhas = null;
        List colunas = null;
        if (!NumberUtil.longNullOuZero((Long)posicaoEstoqueWrapper.getIdFornecedor())) {
            fornecedor = (Entidade)EntidadeRN.getInstance().buscarPorId(posicaoEstoqueWrapper.getIdFornecedor());
        }
        if (!NumberUtil.longNullOuZero((Long)posicaoEstoqueWrapper.getIdProduto())) {
            produto = (Produto)ProdutoRN.getInstance().buscarPorId(posicaoEstoqueWrapper.getIdProduto());
        }
        if (!NumberUtil.longNullOuZero((Long)posicaoEstoqueWrapper.getIdFamilia())) {
            familia = ((FamiliaProduto)FamiliaProdutoRN.getInstance().buscarPorId(posicaoEstoqueWrapper.getIdFamilia())).getNome();
        }
        if (!ListMapUtil.listNullOrEmpty((List)posicaoEstoqueWrapper.getLinhas())) {
            linhas = GradeValorRN.getInstance().buscaPorIds(posicaoEstoqueWrapper.getLinhas());
        }
        if (!ListMapUtil.listNullOrEmpty((List)posicaoEstoqueWrapper.getColunas())) {
            colunas = GradeValorRN.getInstance().buscaPorIds(posicaoEstoqueWrapper.getColunas());
        }
        if (posicaoEstoqueWrapper.getTipoCusto() == TipoCalculoCusto.CUSTO_MEDIO_ATUAL || posicaoEstoqueWrapper.getTipoCusto() == TipoCalculoCusto.CUSTO_MEDIO_DATA) {
            LocalDate dataBase = posicaoEstoqueWrapper.getDataSaldo() == null ? DataHoraFactory.getData() : posicaoEstoqueWrapper.getDataSaldo();
            String ano = String.valueOf(dataBase.getYear());
            MesFiscal mes = (MesFiscal)EnumUtils.getPorId(MesFiscal.class, (Object)dataBase.getMonthValue());
            for (Filial filial : posicaoEstoqueWrapper.getFiliais()) {
                if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CUSTO_MEDIO_MENSAL)) {
                    if (!CustoMedioMensalRN.getInstance().isExisteRegistrosPendentesDeCalculo(filial.getIdEmpresa(), ano, mes)) continue;
                    throw new UnicoMensagemUsuarioException("WEST16", "Existe c\u00e1lculo de custo m\u00e9dio pendente no per\u00edodo especificado. Por favor verifique.");
                }
                if (!CustoMedioDiarioRN.getInstance().isExisteRegistrosPendentesDeCalculo(filial.getId(), ano, mes)) continue;
                throw new UnicoMensagemUsuarioException("WEST17", "Existe c\u00e1lculo de custo m\u00e9dio pendente no per\u00edodo especificado. Por favor verifique.");
            }
        }
        return new PosicaoEstoqueRelatorio().getRelatorio(sessao, posicaoEstoqueWrapper.getSaida(), posicaoEstoqueWrapper.getFiliais(), posicaoEstoqueWrapper.getDataSaldo(), posicaoEstoqueWrapper.getIdsLocalEstoque(), posicaoEstoqueWrapper.getIdGrupoProduto(), fornecedor, produto, posicaoEstoqueWrapper.getIdFamilia(), familia, posicaoEstoqueWrapper.isImprimirSaldoTotal(), posicaoEstoqueWrapper.isSaldoPorLocaEstoque(), posicaoEstoqueWrapper.isApenasSaldosPositivos(), posicaoEstoqueWrapper.isApenasSaldosNegativos(), posicaoEstoqueWrapper.isApenasSaldosZero(), posicaoEstoqueWrapper.getImprimirCampo().intValue(), posicaoEstoqueWrapper.getTipoCusto().getIdInt(), posicaoEstoqueWrapper.isInativo(), posicaoEstoqueWrapper.getTipoCusto().getDescricao(), linhas, colunas, posicaoEstoqueWrapper.getTipoAgrupamento(), posicaoEstoqueWrapper.isImprimirDadosExpedicao(), posicaoEstoqueWrapper.isImprimirInformacoesVenda(), posicaoEstoqueWrapper.isExibirVariacoes(), posicaoEstoqueWrapper.isExibirNumeroSerie(), posicaoEstoqueWrapper.getTiposProduto());
    }
}

