/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.financeiro.dre;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DRE;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DRECustoOperacional;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DREDespesaOperacional;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DREDetalhe;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DREImposto;
import br.intelidata.commons.modulo.financeiro.relatorio.dre.DREReceitaOperacionalBruta;
import br.intelidata.commons.modulo.vendas.regranegocio.DRERN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.dre.AbstractDreReportController;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.dre.Dre;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.dre.DreReportExecute;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/dres"})
@SubMenuMapping(MENU="SubMenuFinanceiroRelatorio", NOME="DRE", ICONE="icon-imprimir", ROTA="/reports-financeiro/dres", PROGRAMA=441)
public class DreReportController
extends AbstractDreReportController {
    public Class<? extends AbstractJob> job() {
        return DreReportExecute.class;
    }

    protected Object getDre(Sessao sessao, Dre dreWrapper) throws UnicoMensagemUsuarioException {
        DRE dre = DRERN.getInstance().montaDRE(sessao, dreWrapper.getFiliais(), dreWrapper.getPeriodoInicial(), dreWrapper.getPeriodoFinal(), null);
        dre.carregarDados();
        for (DREDespesaOperacional despesa : dre.getDespesasOperacionais().getListaDespesas()) {
            despesa.carregarPeriodos(dre.getListaPeriodo());
        }
        for (DRECustoOperacional custo : dre.getCustosOperacionais().getListaCustos()) {
            custo.carregarPeriodos(dre.getListaPeriodo());
        }
        for (DREImposto imposto : dre.getDeducoesReceitaBruta().getOutrosImpostos().getListaImpostos()) {
            imposto.carregarPeriodos(dre.getListaPeriodo());
        }
        this.carregaMeiosPagamento(dre.getReceitaOperacionalBruta(), dreWrapper.getPeriodoInicial(), dreWrapper.getPeriodoFinal());
        return dre;
    }

    public void carregaMeiosPagamento(DREReceitaOperacionalBruta receitaOperacionalBruta, LocalDate dataInicial, LocalDate dataFinal) {
        ArrayList<DREDetalhe> meiosPagamentoDre = new ArrayList<DREDetalhe>();
        BigDecimal somaMeiosPagamento = BigDecimal.ZERO;
        HashMap mapMeiosPagamento = DRERN.getInstance().buscaMeiosPagamentoVendas(dataInicial, dataFinal, receitaOperacionalBruta);
        for (Map.Entry entryMeioPagamento : mapMeiosPagamento.entrySet()) {
            meiosPagamentoDre.add(new DREDetalhe((String)entryMeioPagamento.getKey(), (BigDecimal)entryMeioPagamento.getValue()));
            somaMeiosPagamento = somaMeiosPagamento.add((BigDecimal)entryMeioPagamento.getValue());
        }
        if (!Util.listNullOrEmpty(meiosPagamentoDre)) {
            meiosPagamentoDre.sort(Comparator.comparing(DREDetalhe::getDescricao));
            if (somaMeiosPagamento.compareTo(receitaOperacionalBruta.getValorTotal()) != 0) {
                meiosPagamentoDre.add(new DREDetalhe("N\u00e3o definido", receitaOperacionalBruta.getValorTotal().subtract(somaMeiosPagamento)));
            }
        }
        receitaOperacionalBruta.setListaMeiopagamento(meiosPagamentoDre);
    }
}

