/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.producao.possivelproducao;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.producao.relatorio.QuantidadeProducaoPorSaldoInsumosRelatorio;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.producao.possivelproducao.PossivelProducao;
import br.intelidata.uniplusweb.web.rest.app.report.producao.possivelproducao.PossivelProducaoWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class PossivelProducaoReportExecute
extends AbstractReporteExecute<PossivelProducaoWrapper> {
    public PossivelProducaoReportExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        PossivelProducaoWrapper parametros = (PossivelProducaoWrapper)this.fromJson(parametrosObj, PossivelProducaoWrapper.class);
        return this.executa(sessao, parametros);
    }

    public Remessa executa(Sessao sessao, PossivelProducaoWrapper wrapperReport) throws UnicoMensagemUsuarioException {
        List listaProdutos = this.montarListaProdutosReport(wrapperReport.getListaProdutos());
        return new QuantidadeProducaoPorSaldoInsumosRelatorio().getRelatorio(Contexto.getInstance().getSessao(), wrapperReport.getSaida(), listaProdutos);
    }

    private List<HashMap<String, Object>> montarListaProdutosReport(List<PossivelProducao> listaProdutos) {
        ArrayList<HashMap<String, Object>> lista = new ArrayList<HashMap<String, Object>>();
        if (listaProdutos != null) {
            listaProdutos.forEach(possivelProducao -> {
                Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(Long.valueOf(possivelProducao.getIdProduto()));
                HashMap<String, Object> mapItem = new HashMap<String, Object>();
                mapItem.put("produto", produto);
                mapItem.put("id", produto.getId());
                mapItem.put("codigo", produto.getCodigo());
                mapItem.put("descricao", produto.getNome());
                mapItem.put("ordemvariacao", possivelProducao.getOrdemVariacao());
                mapItem.put("descricaoVariacao", possivelProducao.getDescricaoVariacao());
                lista.add(mapItem);
            });
        }
        return lista;
    }
}

