/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb;

import br.intelidata.commons.core.sql.ConectaBanco;
import br.intelidata.commons.domain.pojo.enuns.batch.TypeQueue;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import java.util.Map;
import javax.sql.DataSource;
import org.postgresql.Driver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;

@Configuration
@Profile(value={"aws", "dev", "prod", "test"})
public class ApplicationDatabaseConfig {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JdbcTemplate jdbcTemplatePostgresql;
    private JdbcTemplate jdbcTemplate;

    public ApplicationDatabaseConfig(UnipluswebProperties unipluswebProperties, DataSource dataSource) {
        SimpleDriverDataSource sds = new SimpleDriverDataSource((java.sql.Driver)new Driver(), unipluswebProperties.getDatasource().getUrl().replace("uniplusweb", "postgres"), "replica", "r2pl3c1");
        this.jdbcTemplatePostgresql = new JdbcTemplate((DataSource)sds);
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    @Autowired
    public void onCreateDataBase() {
        String database;
        try {
            this.log.info("Criando usu\u00e1rios");
            ConectaBanco conectaBanco = new ConectaBanco();
            conectaBanco.criarNovosUsuarios(this.jdbcTemplatePostgresql.getDataSource().getConnection());
        }
        catch (Throwable ex) {
            this.log.error("Erro ao criar usu\u00e1rios", ex);
        }
        this.log.info("Verificando o database 'uniplusweb'");
        try {
            database = (String)this.jdbcTemplatePostgresql.queryForObject("SELECT datname FROM pg_catalog.pg_database WHERE lower(datname) = lower('uniplusweb');", new Object[0], String.class);
        }
        catch (EmptyResultDataAccessException ex) {
            database = null;
        }
        if (StringUtil.stringNullOrEmpty(database)) {
            this.log.info("Criando o database 'uniplusweb'");
            this.jdbcTemplatePostgresql.execute("CREATE DATABASE uniplusweb WITH ENCODING='UTF8'");
        }
        this.jdbcTemplate.execute("CREATE TABLE IF NOT EXISTS tenant ( id bigserial, codigo character varying(40), descricao character varying(128), urldatabase character varying(128), inativo smallint, inicializado smallint, ultimoacesso date, usuarios smallint, validoate date, secret character varying(256), CONSTRAINT tenant_pkey PRIMARY KEY (id), CONSTRAINT codigo_unk UNIQUE (codigo))");
        this.createTableTask();
        this.createQueue();
        this.metricas();
        this.log.info("Database 'uniplusweb' inicializada com sucesso");
    }

    private void createTableTask() {
        if (!this.existeSequencia("task_id_seq")) {
            this.jdbcTemplate.execute("CREATE SEQUENCE public.task_id_seq");
        }
        String task = "CREATE TABLE IF NOT EXISTS public.task(id bigint NOT NULL DEFAULT nextval('task_id_seq'::regclass),uuid character varying(40),name character varying(255) COLLATE pg_catalog.\"default\",tenant character varying(40) COLLATE pg_catalog.\"default\",taskstatus smallint,classname character varying(512) COLLATE pg_catalog.\"default\",parameters text COLLATE pg_catalog.\"default\",metadata character varying(255) COLLATE pg_catalog.\"default\",t0 timestamp without time zone,t1 timestamp without time zone,t2 timestamp without time zone,errormessage character varying(512) COLLATE pg_catalog.\"default\",printstack text COLLATE pg_catalog.\"default\",queue smallint,recurring smallint,tipo character varying(10),cronexpression character varying(64) COLLATE pg_catalog.\"default\",url text,currenttimemillis bigint,uuidtask character varying(40),tipojob smallint,resumo text,retorno character varying(2048),cronconfiguradotelaespecifica smallint NULL,amiinstancia character varying(2048),tenantsconfigurados text,CONSTRAINT tasks_pkey PRIMARY KEY (id))";
        this.jdbcTemplate.execute(task);
        this.createColumnIfNotExists("task", "cronconfiguradotelaespecifica", "smallint");
        this.createColumnIfNotExists("task", "amiinstancia", "character varying(2048)");
        this.createColumnIfNotExists("task", "tipo", "character varying(10)");
        this.createColumnIfNotExists("task", "tenantsconfigurados", "text");
        this.updateColumn("task", "retorno", "text");
        this.updateColumn("task", "cronexpression", "character varying(128)");
        this.updateColumn("task", "resumo", "text");
        this.updateColumn("tenant", "ultimoacesso", "timestamp without time zone");
        this.jdbcTemplate.execute("DROP INDEX IF EXISTS tasks_status_idx");
        this.jdbcTemplate.execute("CREATE INDEX tasks_status_idx ON public.task USING btree (taskstatus ASC NULLS LAST, t0 ASC NULLS LAST) TABLESPACE pg_default;");
        this.jdbcTemplate.execute("DROP INDEX IF EXISTS tasks_uuid_idx");
        this.jdbcTemplate.execute("CREATE INDEX tasks_uuid_idx ON public.task USING btree (uuid ASC NULLS LAST) TABLESPACE pg_default;");
    }

    private void createQueue() {
        if (!this.existeSequencia("task_queue_id_seq")) {
            this.jdbcTemplate.execute("CREATE SEQUENCE public.task_queue_id_seq");
        }
        String queue = "CREATE TABLE IF NOT EXISTS public.taskqueue (id bigint NOT NULL DEFAULT nextval('task_queue_id_seq'::regclass), code smallint, name character varying(64) COLLATE pg_catalog.\"default\", priority smallint, paused smallint , currenttimemillis bigint)";
        this.jdbcTemplate.execute(queue);
        this.jdbcTemplate.execute("TRUNCATE taskqueue");
        String insert = "INSERT INTO taskqueue(code, name, priority, paused) values (" + TypeQueue.RECURRING_QUEUE.getId() + ", '" + TypeQueue.RECURRING_QUEUE.getDescricao() + "', " + TypeQueue.RECURRING_QUEUE.getPriority() + ", 0), (" + TypeQueue.CARGA_BASE.getId() + ", '" + TypeQueue.CARGA_BASE.getDescricao() + "', " + TypeQueue.CARGA_BASE.getPriority() + ", 0), (" + TypeQueue.EMAIL_QUEUE.getId() + ", '" + TypeQueue.EMAIL_QUEUE.getDescricao() + "', " + TypeQueue.EMAIL_QUEUE.getPriority() + ", 0), (" + TypeQueue.REPORT_QUEUE.getId() + ", '" + TypeQueue.REPORT_QUEUE.getDescricao() + "', " + TypeQueue.REPORT_QUEUE.getPriority() + ", 0);";
        this.jdbcTemplate.execute(insert);
    }

    private void metricas() {
        String metricas = "CREATE TABLE IF NOT EXISTS public.metrica (\n    id SERIAL PRIMARY KEY,\n    tenant TEXT NOT NULL,\n    endpoint TEXT NOT NULL,\n    method TEXT NOT NULL,\n    statuscode INT NOT NULL,\n    duracao BIGINT NOT NULL,\n    datahora TIMESTAMP DEFAULT now(),\n    currenttimemillis bigint \n)";
        this.jdbcTemplate.execute(metricas);
        this.jdbcTemplate.execute("DROP INDEX IF EXISTS idx_request_metrics_datahora");
        this.jdbcTemplate.execute("DROP INDEX IF EXISTS idx_request_metrics_endpoint");
        this.jdbcTemplate.execute("DROP INDEX IF EXISTS idx_request_metrics_tenant");
        this.jdbcTemplate.execute("CREATE INDEX idx_request_metrics_datahora ON public.metrica (datahora)");
        this.jdbcTemplate.execute("CREATE INDEX idx_request_metrics_endpoint ON public.metrica (endpoint)");
        this.jdbcTemplate.execute("CREATE INDEX idx_request_metrics_tenant ON public.metrica (tenant)");
        this.jdbcTemplate.execute("CREATE OR REPLACE VIEW vw_metricas AS\nSELECT\n\ttenant,\n    endpoint,\n    method,\n    COUNT(*) AS total_calls,\n    ROUND(AVG(duracao), 2) AS media,\n    MAX(duracao) AS max_duration_ms,\n    PERCENTILE_CONT(0.95) WITHIN GROUP (ORDER BY duracao) AS p95_duration_ms,\n    PERCENTILE_CONT(0.99) WITHIN GROUP (ORDER BY duracao) AS p99_duration_ms,\n    MIN(datahora) AS first_call,\n    MAX(datahora) AS last_call\nFROM metrica\nWHERE datahora >= NOW() - INTERVAL '1 day'\nGROUP BY tenant, endpoint, method\nORDER BY media DESC;");
    }

    private boolean existeSequencia(String sequencia) {
        Map seq;
        String sql = "SELECT * FROM information_schema.sequences WHERE sequence_schema = 'public' AND sequence_name='" + sequencia + "'";
        try {
            seq = this.jdbcTemplate.queryForMap(sql);
        }
        catch (EmptyResultDataAccessException ex) {
            seq = null;
        }
        return !ListMapUtil.mapNullOrEmpty((Map)seq);
    }

    private void createColumnIfNotExists(String table, String column, String type) {
        if (!this.existsColumn(table, column)) {
            this.jdbcTemplate.execute("ALTER TABLE " + table + " ADD " + column + " " + type);
        }
    }

    private void updateColumn(String table, String column, String type) {
        if (this.existsColumn(table, column)) {
            this.jdbcTemplate.execute("ALTER TABLE " + table + " ALTER COLUMN " + column + " TYPE " + type);
        }
    }

    private boolean existsColumn(String table, String column) {
        Map seq;
        String sql = "SELECT column_name FROM information_schema.columns WHERE table_name='" + table + "' and column_name='" + column + "'";
        try {
            seq = this.jdbcTemplate.queryForMap(sql);
        }
        catch (EmptyResultDataAccessException ex) {
            seq = null;
        }
        return !ListMapUtil.mapNullOrEmpty((Map)seq);
    }
}

