/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.config;

import br.intelidata.commons.bridge.RuntimeDataSource;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.spring.multitenant.DataSourceFactory;
import br.intelidata.uniplusweb.core.spring.multitenant.MultitenantDataSource;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
public class DatabaseConfiguration {
    @Autowired
    private DataSourceFactory dataSourceFactory;
    @Autowired
    private UnipluswebProperties unipluswebProperties;

    @Profile(value={"dev", "prod", "aws"})
    @Bean(name={"dataSource"})
    public DataSource dataSource() {
        return this.dataSourceFactory.criaDataSource(this.unipluswebProperties.getDatasource().getUrl());
    }

    @Profile(value={"test"})
    @Bean(name={"dataSource"})
    public DataSource dataSourceTest() {
        return DataSourceBuilder.create().driverClassName("org.postgresql.Driver").url("jdbc:postgresql://localhost:5432/uniplusweb-test").build();
    }

    @Bean
    public RuntimeDataSource multitenantDataSource() {
        return new MultitenantDataSource();
    }
}

