/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.util;

import br.intelidata.uniplusweb.core.spring.JSR310DateSerializer;
import br.intelidata.uniplusweb.core.spring.JSR310DateTimeSerializer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.util.Date;
import org.apache.commons.lang3.time.FastDateFormat;

public class DateUtil {
    private static final FastDateFormat FAST_DATE_FORMAT_DATA_8 = FastDateFormat.getInstance((String)"dd/MM/yyyy");
    private static final DateTimeFormatter ISO_DATE_OPTIONAL_TIME = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).optionalStart().appendLiteral('T').append(DateTimeFormatter.ISO_OFFSET_TIME).toFormatter();

    public static String JSR310DateTimeSerializer(TemporalAccessor temporalAccessor) {
        return JSR310DateTimeSerializer.ISO_FORMATTER.format(temporalAccessor);
    }

    public static String JSR310DateSerializer(TemporalAccessor temporalAccessor) {
        return JSR310DateSerializer.ISO_FORMATTER.format(temporalAccessor);
    }

    public static String date2String(Date data) {
        if (data != null) {
            return FAST_DATE_FORMAT_DATA_8.format(data);
        }
        return null;
    }

    public static Date string2Date(String valor) {
        if (valor != null) {
            try {
                SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy");
                return format.parse(valor);
            }
            catch (ParseException ex) {
                return null;
            }
        }
        return null;
    }

    public static LocalDate string2LocalDate(String valor) {
        if (valor == null) {
            return null;
        }
        try {
            String pattern = valor.length() == "dd/MM/yyyy".length() ? "dd/MM/yyyy" : "dd/MM/yy";
            return LocalDate.parse(valor, DateTimeFormatter.ofPattern(pattern));
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    public static LocalDateTime string2LocalDateTime(String valor) {
        if (valor == null) {
            return null;
        }
        try {
            return LocalDateTime.parse(valor, DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm"));
        }
        catch (DateTimeParseException ex) {
            return null;
        }
    }

    public static LocalDate stringISO2LocalDateWeb(String data) {
        return LocalDate.parse(data, ISO_DATE_OPTIONAL_TIME);
    }

    public static LocalDateTime stringISO2LocalDateTimeWeb(String data) {
        return LocalDateTime.parse(data, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    }

    public static LocalDate ultimoDiaMes(LocalDate date) {
        return date.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static String formataDataHora(Temporal dataHora, String mascara) {
        if (dataHora == null) {
            return "";
        }
        try {
            return DateTimeFormatter.ofPattern(mascara).format(dataHora);
        }
        catch (DateTimeException ex) {
            return "";
        }
    }
}

