/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.core.util;

import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.uniplusweb.core.util.ULID;
import java.security.SecureRandom;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;

/*
 * Exception performing whole class analysis ignored.
 */
public class ULID {
    private static final char[] ENCODING_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'J', 'K', 'M', 'N', 'P', 'Q', 'R', 'S', 'T', 'V', 'W', 'X', 'Y', 'Z'};
    private static final byte[] DECODING_CHARS = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, -1, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 1, 18, 19, 1, 20, 21, 0, 22, 23, 24, 25, 26, -1, 27, 28, 29, 30, 31, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 1, 18, 19, 1, 20, 21, 0, 22, 23, 24, 25, 26, -1, 27, 28, 29, 30, 31};
    private static final int MASK = 31;
    private static final int MASK_BITS = 5;
    private static final long TIMESTAMP_OVERFLOW_MASK = -281474976710656L;
    private static final long TIMESTAMP_MSB_MASK = -65536L;
    private static final long RANDOM_MSB_MASK = 65535L;
    private final Random random;

    public ULID() {
        this((Random)new SecureRandom());
    }

    public ULID(Random random) {
        Objects.requireNonNull(random, "random must not be null!");
        this.random = random;
    }

    public void appendULID(StringBuilder stringBuilder) {
        Objects.requireNonNull(stringBuilder, "stringBuilder must not be null!");
        ULID.internalAppendULID((StringBuilder)stringBuilder, (long)System.currentTimeMillis(), (Random)this.random);
    }

    public String nextULID() {
        return this.nextULID(System.currentTimeMillis());
    }

    public String nextULID(long timestamp) {
        return ULID.internalUIDString((long)timestamp, (Random)this.random);
    }

    public Value nextValue() {
        return this.nextValue(System.currentTimeMillis());
    }

    public Value nextValue(long timestamp) {
        return ULID.internalNextValue((long)timestamp, (Random)this.random);
    }

    public Value nextMonotonicValue(Value previousUlid) {
        return this.nextMonotonicValue(previousUlid, System.currentTimeMillis());
    }

    public Value nextMonotonicValue(Value previousUlid, long timestamp) {
        Objects.requireNonNull(previousUlid, "previousUlid must not be null!");
        if (previousUlid.timestamp() == timestamp) {
            return previousUlid.increment();
        }
        return this.nextValue(timestamp);
    }

    public Optional<Value> nextStrictlyMonotonicValue(Value previousUlid) {
        return this.nextStrictlyMonotonicValue(previousUlid, System.currentTimeMillis());
    }

    public Optional<Value> nextStrictlyMonotonicValue(Value previousUlid, long timestamp) {
        Value result = this.nextMonotonicValue(previousUlid, timestamp);
        if (result.compareTo(previousUlid) < 1) {
            return Optional.empty();
        }
        return Optional.of(result);
    }

    public static Value parseULID(String ulidString) {
        Objects.requireNonNull(ulidString, "ulidString must not be null!");
        if (ulidString.length() != 26) {
            throw new UnicoException("WWW698", "ulidString must be exactly 26 chars long.");
        }
        String timeString = ulidString.substring(0, 10);
        long time = ULID.internalParseCrockford((String)timeString);
        if ((time & 0xFFFF000000000000L) != 0L) {
            throw new UnicoException("WWW699", "ulidString must not exceed '7ZZZZZZZZZZZZZZZZZZZZZZZZZ'!");
        }
        String part1String = ulidString.substring(10, 18);
        String part2String = ulidString.substring(18);
        long part1 = ULID.internalParseCrockford((String)part1String);
        long part2 = ULID.internalParseCrockford((String)part2String);
        long most = time << 16 | part1 >>> 24;
        long least = part2 | part1 << 40;
        return new Value(most, least);
    }

    public static Value fromBytes(byte[] data) {
        int i;
        Objects.requireNonNull(data, "data must not be null!");
        if (data.length != 16) {
            throw new UnicoException("WWW700", "data must be 16 bytes in length!");
        }
        long mostSignificantBits = 0L;
        long leastSignificantBits = 0L;
        for (i = 0; i < 8; ++i) {
            mostSignificantBits = mostSignificantBits << 8 | (long)(data[i] & 0xFF);
        }
        for (i = 8; i < 16; ++i) {
            leastSignificantBits = leastSignificantBits << 8 | (long)(data[i] & 0xFF);
        }
        return new Value(mostSignificantBits, leastSignificantBits);
    }

    static void internalAppendCrockford(StringBuilder builder, long value, int count) {
        for (int i = count - 1; i >= 0; --i) {
            int index = (int)(value >>> i * 5 & 0x1FL);
            builder.append(ENCODING_CHARS[index]);
        }
    }

    static long internalParseCrockford(String input) {
        Objects.requireNonNull(input, "input must not be null!");
        int length = input.length();
        if (length > 12) {
            throw new UnicoException("WWW701", "input length must not exceed 12 but was " + length + "!");
        }
        long result = 0L;
        for (int i = 0; i < length; ++i) {
            char current = input.charAt(i);
            int value = -1;
            if (current < DECODING_CHARS.length) {
                value = DECODING_CHARS[current];
            }
            if (value < 0) {
                throw new UnicoException("WWW702", "Illegal character '" + current + "'!");
            }
            result |= (long)value << (length - 1 - i) * 5;
        }
        return result;
    }

    static void internalWriteCrockford(char[] buffer, long value, int count, int offset) {
        for (int i = 0; i < count; ++i) {
            int index = (int)(value >>> (count - i - 1) * 5 & 0x1FL);
            buffer[offset + i] = ENCODING_CHARS[index];
        }
    }

    static String internalUIDString(long timestamp, Random random) {
        ULID.checkTimestamp((long)timestamp);
        char[] buffer = new char[26];
        ULID.internalWriteCrockford((char[])buffer, (long)timestamp, (int)10, (int)0);
        ULID.internalWriteCrockford((char[])buffer, (long)random.nextLong(), (int)8, (int)10);
        ULID.internalWriteCrockford((char[])buffer, (long)random.nextLong(), (int)8, (int)18);
        return new String(buffer);
    }

    static void internalAppendULID(StringBuilder builder, long timestamp, Random random) {
        ULID.checkTimestamp((long)timestamp);
        ULID.internalAppendCrockford((StringBuilder)builder, (long)timestamp, (int)10);
        ULID.internalAppendCrockford((StringBuilder)builder, (long)random.nextLong(), (int)8);
        ULID.internalAppendCrockford((StringBuilder)builder, (long)random.nextLong(), (int)8);
    }

    static Value internalNextValue(long timestamp, Random random) {
        ULID.checkTimestamp((long)timestamp);
        long mostSignificantBits = random.nextLong();
        long leastSignificantBits = random.nextLong();
        mostSignificantBits &= 0xFFFFL;
        return new Value(mostSignificantBits |= timestamp << 16, leastSignificantBits);
    }

    private static void checkTimestamp(long timestamp) {
        if ((timestamp & 0xFFFF000000000000L) != 0L) {
            throw new UnicoException("WWW703", "ULID does not support timestamps after +10889-08-02T05:31:50.655Z!");
        }
    }
}

