/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.security.oauth2;

import org.springframework.http.ResponseEntity;
import org.springframework.security.oauth2.common.exceptions.OAuth2Exception;
import org.springframework.security.oauth2.provider.error.DefaultWebResponseExceptionTranslator;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class CustomWebResponseExceptionTranslator
extends DefaultWebResponseExceptionTranslator {
    public ResponseEntity<OAuth2Exception> translate(Exception ex) throws Exception {
        ResponseEntity responseEntity = super.translate(ex);
        OAuth2Exception auth2Exception = (OAuth2Exception)responseEntity.getBody();
        if (auth2Exception != null) {
            auth2Exception.addAdditionalInformation("message", auth2Exception.getMessage());
            auth2Exception.addAdditionalInformation("status", String.valueOf(auth2Exception.getHttpErrorCode()));
        }
        return new ResponseEntity((Object)auth2Exception, (MultiValueMap)responseEntity.getHeaders(), responseEntity.getStatusCode());
    }
}

