/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.service;

import br.intelidata.commons.core.licenca.DadosLicenca;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Sistema;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.util.TipoCache;
import org.springframework.cache.support.SimpleValueWrapper;
import org.springframework.stereotype.Service;

@Service
public class LicencaService {
    private final CacheService cacheService;

    public LicencaService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    public synchronized Sistema getSistema() {
        Sistema sistema = null;
        SimpleValueWrapper simpleValueWrapper = (SimpleValueWrapper)this.cacheService.get((Object)TipoCache.ID_SISTEMA.getId());
        if (simpleValueWrapper != null) {
            sistema = (Sistema)simpleValueWrapper.get();
        }
        if (sistema == null) {
            sistema = new Sistema();
            this.cacheService.put((Object)TipoCache.ID_SISTEMA.getId(), (Object)sistema);
            this.cacheService.removerCache(TipoCache.ID_LICENCAS.getId());
            simpleValueWrapper = (SimpleValueWrapper)this.cacheService.get((Object)TipoCache.ID_SISTEMA.getId());
            if (simpleValueWrapper != null) {
                sistema = (Sistema)simpleValueWrapper.get();
            }
        }
        return sistema;
    }

    public synchronized DadosLicenca getDadosLicenca() {
        DadosLicenca dadosLicenca = null;
        SimpleValueWrapper simpleValueWrapper = (SimpleValueWrapper)this.cacheService.get((Object)TipoCache.ID_LICENCAS.getId());
        if (simpleValueWrapper != null) {
            dadosLicenca = (DadosLicenca)simpleValueWrapper.get();
        }
        if (dadosLicenca == null) {
            dadosLicenca = LicencaManager.getInstance().getDadosLicencaWEB();
            this.cacheService.put((Object)TipoCache.ID_LICENCAS.getId(), (Object)dadosLicenca);
        }
        return dadosLicenca;
    }
}

