/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.batch;

import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.uniplusweb.core.service.RestoreBackupService;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import java.io.File;

public class TaskRestoreBkp
extends AbstractPrepareJob {
    private final TenantService tenantService = (TenantService)BeanUtil.getBean((String)"tenantService");
    private final RestoreBackupService restoreBackupService = (RestoreBackupService)BeanUtil.getBean((String)"restoreBackupService");
    private final StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");

    public TaskRestoreBkp(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void execute() throws Exception {
        Tenant tenant = this.tenantService.getTenant(this.getTask().getTenant());
        File backupTemp = this.storageService.downloadFile(this.getTask().getTenant(), TipoArquivoArmazenado.Backup, this.getTask().getUrl(), true, true);
        this.restoreBackupService.restaurarLocalmente(tenant, backupTemp);
    }

    public void onFailure(Exception ex) {
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return null;
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return null;
    }
}

