/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.bridge.Bridge;
import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Familia;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.licenca.ProdutoLicenca;
import br.intelidata.commons.core.licenca.ProdutoLicencaRN;
import br.intelidata.commons.core.logtracker.pojo.DiferencaLicencaContrato;
import br.intelidata.commons.core.logtracker.pojo.IdentificadorAceiteContrato;
import br.intelidata.commons.core.logtracker.pojo.IdentificadorAtivacao;
import br.intelidata.commons.core.logtracker.pojo.InfoLicenca;
import br.intelidata.commons.core.logtracker.pojo.SituacaoLicencaServidor;
import br.intelidata.commons.core.logtracker.retorno.RetornoInstalarLicenca;
import br.intelidata.commons.core.logtracker.retorno.RetornoIsItOk;
import br.intelidata.commons.core.logtracker.retorno.RetornoIsItOkFilial;
import br.intelidata.commons.core.logtracker.retorno.RetornoPedidoInstalacao;
import br.intelidata.commons.core.logtracker.retorno.RetornoReinstalacao;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sistema.UnicoSistema;
import br.intelidata.commons.core.sql.ControleConexoes;
import br.intelidata.commons.core.sql.DicionarioDados;
import br.intelidata.commons.core.sql.SGBDManager;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.InativoFilial;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Log;
import br.intelidata.commons.core.util.LogSistema;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.IndicadorFilial;
import br.intelidata.commons.domain.pojo.Usuario;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.CategoriaEventoSistema;
import br.intelidata.commons.domain.pojo.enuns.TipoAcesso;
import br.intelidata.commons.domain.pojo.enuns.TipoEnquadramentoFilial;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.enuns.TipoPessoa;
import br.intelidata.commons.domain.regranegocio.ConfiguradorFuncionalidadeCommonRN;
import br.intelidata.commons.domain.regranegocio.ConfiguradorModuloCommonRN;
import br.intelidata.commons.domain.regranegocio.ControleRN;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.domain.regranegocio.LicencaComboCommonRN;
import br.intelidata.commons.domain.regranegocio.LicencaCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EmpresaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EventoSistemaRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.LicencaRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.core.sgdb.IConnectionHandler;
import br.intelidata.uniplusweb.config.UnipluswebProperties;
import br.intelidata.uniplusweb.core.coreinterfaces.Profile;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.spring.multitenant.Tenant;
import br.intelidata.uniplusweb.core.spring.multitenant.TenantService;
import br.intelidata.uniplusweb.core.util.JsonUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.core.util.TipoCache;
import br.intelidata.uniplusweb.service.ConnectionOAuth2Service;
import br.intelidata.uniplusweb.service.IdentificadorLicencaService;
import br.intelidata.uniplusweb.service.LicencaService;
import br.intelidata.uniplusweb.service.MDCConfigService;
import br.intelidata.uniplusweb.service.socket.NotificationService;
import br.intelidata.uniplusweb.web.enums.StatusLicenca;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractScheduler;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.ValidacaoTenantReponse;
import br.intelidata.uniplusweb.web.rest.app.crud.gerenciadorlicenca.DadosLicencaWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.gerenciadorlicenca.LicencaRequestWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ValidadorLicencaWrapper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import unico.pojo.Licenca;
import unipaf.servidor.nfce.StatusPdvFilialHelper;

@Component
public class GerenciadorLicencaManager
extends AbstractScheduler {
    private static final long TEMPO_DE_ESPERA = 0x6DDD00L;
    private static final String MENSAGEM_ATRASADO = "1";
    private static final String MENSAGEM_VENCIDO = "2";
    private static final String TEXTO_CONTRATO = "3";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final TenantService tenantService;
    private final Map<String, ValidadorLicencaWrapper> mapLicencas;
    private final CacheService cacheService;
    private final ConnectionOAuth2Service connectionOAuth2Service;
    private final NotificationService notificationService;
    private final IdentificadorLicencaService identificadorLicencaService;
    private final Profile profile;
    @Autowired
    private final LicencaService licencaService;

    public GerenciadorLicencaManager(CacheService cacheService, ConnectionOAuth2Service connectionOAuth2Service, IdentificadorLicencaService identificadorLicencaService, UnipluswebProperties unipluswebProperties, IConnectionHandler connectionHandler, TenantService tenantService, MDCConfigService mdcConfigService, LicencaService licencaService, NotificationService notificationService, Profile profile) {
        super(unipluswebProperties, connectionHandler, tenantService, mdcConfigService);
        this.cacheService = cacheService;
        this.connectionOAuth2Service = connectionOAuth2Service;
        this.identificadorLicencaService = identificadorLicencaService;
        this.tenantService = tenantService;
        this.licencaService = licencaService;
        this.notificationService = notificationService;
        this.profile = profile;
        this.mapLicencas = new HashMap();
    }

    protected String nomeScheduler() {
        return "Gerenciador de licen\u00e7as";
    }

    @Async
    @Scheduled(fixedDelay=0x6DDD00L)
    public synchronized void agendador() {
        this.run();
    }

    public void executar(Tenant tenant) {
        this.log.info("Validando licen\u00e7as do tenant: " + tenant.getCodigo());
        try {
            this.verificarLicenca(tenant.getCodigo());
            this.recarregarLicencasCache();
        }
        catch (Exception ex) {
            this.log.error("Falhou ao validar a licen\u00e7a do tenant: " + tenant.getCodigo(), (Throwable)ex);
        }
        this.log.info("Licen\u00e7as validadas para o tenant: " + tenant.getCodigo());
    }

    public void recarregarLicencas() {
        List tenants = this.getTenants();
        this.log.info("Validando a licen\u00e7a de todos os tenants: {}", (Object)tenants.stream().map(Tenant::getCodigo).collect(Collectors.joining(",")));
        tenants.forEach(tenant -> {
            ContextoHolder.setTenant((String)tenant.getCodigo(), (String)this.tenantService.getDatabase(tenant.getCodigo()));
            this.mdcConfigService.confiMDC(tenant.getCodigo());
            try {
                Bridge.getBridge().initCache();
                this.connectionHandler.createConnection(false);
                this.login();
                this.executar(tenant);
            }
            catch (Exception ex) {
                try {
                    this.connectionHandler.rollback();
                    this.log.error("Falhou ao recarregar licen\u00e7as no tenant: " + tenant.getCodigo(), (Throwable)ex);
                }
                catch (Exception ex2) {
                    this.log.error("Falhou ao executar rolback no schedule " + this.nomeScheduler() + " no tenant {} : " + ex2.getMessage(), (Object)tenant.getCodigo());
                }
            }
            finally {
                Bridge.getBridge().remove();
                if (this.connectionHandler.isConnected()) {
                    try {
                        this.connectionHandler.releaseConnection();
                    }
                    catch (Exception ex) {
                        this.log.error("Falhou ao fechar a conex\u00e3o do schedule  " + this.nomeScheduler() + " do tenant {} : " + ex.getMessage(), (Object)tenant.getCodigo());
                    }
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ValidadorLicencaWrapper getDadosLicenca(Usuario usuario, boolean demonstracao) throws UnicoMensagemUsuarioException {
        String tenant = ContextoHolder.getTenant();
        ValidadorLicencaWrapper validador = (ValidadorLicencaWrapper)this.mapLicencas.get(tenant);
        Licenca licencaPrincipal = LicencaCommonRN.getInstance().buscarLicencaPrincipal();
        if (validador == null || licencaPrincipal == null) {
            if (demonstracao || licencaPrincipal == null) {
                int diasValidade = this.getDiasValidadeTenant(tenant);
                validador = new ValidadorLicencaWrapper(diasValidade == 0 ? StatusLicenca.DEMONSTRACAO_FINALIZADA : StatusLicenca.OK, diasValidade);
                this.mapLicencas.put(tenant, validador);
            } else {
                this.verificarLicenca(tenant, false);
                this.recarregarLicencasCache();
                validador = (ValidadorLicencaWrapper)this.mapLicencas.get(tenant);
            }
        }
        if (!this.mapLicencas.containsKey(tenant)) {
            throw new UnicoMensagemUsuarioException("WWW372", "N\u00e3o foi poss\u00edvel validar as licen\u00e7as do sistema.");
        }
        int usuariosPDV = StatusPdvFilialHelper.getTotalPdvsConectados();
        int usuariosConectados = ControleConexoes.getInstance().getNumeroUsuariosAtivos(this.connectionHandler.getConnection());
        int totalUsuarios = usuariosConectados + usuariosPDV;
        int totalUsuariosSistema = this.getNumeroUsuariosSistema();
        if (!TipoAcesso.TECNICO.equals((Object)usuario.getTipoAcesso()) && !usuario.isUsuarioRemoto() && demonstracao && totalUsuarios > 2 || !demonstracao && totalUsuarios > totalUsuariosSistema) {
            this.log.info("Demonstra\u00e7\u00e3o: " + (demonstracao ? "Sim" : "N\u00e3o") + " - Usu\u00e1rios PDV: " + usuariosPDV + " - Usu\u00e1rios: " + usuariosConectados + " - Total: " + totalUsuariosSistema);
            if (!usuario.isAdministrador()) throw new UnicoMensagemUsuarioException("COM236578", "N\u00famero de usu\u00e1rios maior que o contratado. Considere aumentar o n\u00famero de usu\u00e1rios contratados.");
            validador.setNumeroMaximoUsuarioAtingido(true);
            return validador;
        } else {
            validador.setNumeroMaximoUsuarioAtingido(false);
        }
        return validador;
    }

    public DadosLicencaWrapper pedidoInstalacao(LicencaRequestWrapper request, String tenant) throws UnicoMensagemUsuarioException {
        DadosLicencaWrapper dadosLicencaWrapper;
        block13: {
            String endpoint = "pedido-instalacao-uniplusweb";
            dadosLicencaWrapper = null;
            try {
                ResponseEntity response;
                Map send = this.identificadorLicencaService.getIdentificador();
                send.put("cnpj", request.getCnpj());
                JSONObject elem = JSONUtil.getJSONObject((Object)send);
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("pedidoInstalacaoRequest", (Object)elem);
                jsonObject.put("email", (Object)request.getEmail());
                jsonObject.put("senha", (Object)request.getSenha());
                jsonObject.put("tenant", (Object)tenant);
                try {
                    response = this.connectionOAuth2Service.post(endpoint, jsonObject, RetornoPedidoInstalacao.class);
                }
                catch (Exception ex) {
                    this.log.error("N\u00e3o foi poss\u00edvel processar o pedido de instala\u00e7\u00e3o para o CNPJ " + request.getCnpj() + ". Ser\u00e1 tentado utilizar reinstala\u00e7\u00e3o para o CNPJ.", (Throwable)ex);
                    try {
                        return this.reinstalarLicencas(request, tenant);
                    }
                    catch (Exception e) {
                        throw new UnicoMensagemUsuarioException("WWW688", "N\u00e3o foi poss\u00edvel concluir o processo: Retorno pedido de Instala\u00e7\u00e3o: " + ex.getMessage() + " - Retorno reinstala\u00e7\u00e3o: " + e.getMessage());
                    }
                }
                if (response != null) {
                    if (response.getStatusCode() == HttpStatus.OK) {
                        RetornoPedidoInstalacao retornoPedidoInstalacao = (RetornoPedidoInstalacao)response.getBody();
                        if (retornoPedidoInstalacao != null) {
                            this.validarFiliais(request.getCnpj(), retornoPedidoInstalacao.getLicencas());
                            boolean exibirContrato = false;
                            ProdutoLicenca produtoLicencaBase = null;
                            Filial filial = null;
                            if (retornoPedidoInstalacao.getLicencaPrincipal() != null) {
                                produtoLicencaBase = ProdutoLicencaRN.getInstance().getProduto(retornoPedidoInstalacao.getLicencaPrincipal().getChaveAtivacao());
                                if (produtoLicencaBase.isBase() && ((Familia)produtoLicencaBase.getFamilia().get(0)).isUtilizarWSParaAtivarLicenca()) {
                                    exibirContrato = true;
                                    ControleRN.getInstance().setUsuarioAdminViuContratoPLUS(SessaoUtil.getSessao(), false);
                                }
                                filial = this.getFilial(retornoPedidoInstalacao.getRazaoSocialClienteFinal(), request.getCnpj(), null);
                            }
                            dadosLicencaWrapper = new DadosLicencaWrapper(retornoPedidoInstalacao, produtoLicencaBase, filial, request.getCnpj(), exibirContrato);
                        }
                        break block13;
                    }
                    throw new UnicoMensagemUsuarioException("WWW689", "Falhou ao processar. Retorno do servidor: " + response.getStatusCode());
                }
                throw new UnicoMensagemUsuarioException("WWW690", "Falhou ao processar. Nenhum retorno do servidor.");
            }
            catch (Exception ex) {
                if (ex instanceof UnicoMensagemUsuarioException) {
                    throw (UnicoMensagemUsuarioException)((Object)ex);
                }
                this.log.error("N\u00e3o foi poss\u00edvel processar o pedido de instala\u00e7\u00e3o para o CNPJ " + request.getCnpj(), (Throwable)ex);
            }
        }
        if (dadosLicencaWrapper == null) {
            throw new UnicoMensagemUsuarioException("WWW361", "N\u00e3o foi poss\u00edvel processar o pedido de instala\u00e7\u00e3o.");
        }
        return dadosLicencaWrapper;
    }

    public void finalizarPedidoInstalacao(DadosLicencaWrapper dadosLicenca) throws UnicoMensagemUsuarioException {
        List licencas;
        String razaoSocial;
        this.gravarFilial(dadosLicenca);
        boolean resetouBase = false;
        boolean reinstalacao = false;
        if (dadosLicenca.getRetornoPedidoInstalacao() != null) {
            razaoSocial = dadosLicenca.getRetornoPedidoInstalacao().getRazaoSocialClienteFinal();
            licencas = dadosLicenca.getRetornoPedidoInstalacao().getLicencas();
            if (dadosLicenca.getRetornoPedidoInstalacao().getLicencaPrincipal() != null) {
                RetornoInstalarLicenca principal = dadosLicenca.getRetornoPedidoInstalacao().getLicencaPrincipal();
                LocalDate dataAtivacao = null;
                ProdutoLicenca produtoLicenca = ProdutoLicencaRN.getInstance().getProduto(principal.getChaveAtivacao());
                if (produtoLicenca.isBase() && ((Familia)produtoLicenca.getFamilia().get(0)).isUtilizarWSParaAtivarLicenca() && (dataAtivacao = LicencaRN.getInstance().getDataAtivacaoPorChaveReinstalacao(principal.getChaveAtivacao())) == null) {
                    dataAtivacao = DataHoraFactory.getData();
                }
                resetouBase = dadosLicenca.isReiniciarBase();
                this.comunicarAtivacao(principal.getChaveAtivacao(), dataAtivacao, dadosLicenca.getRetornoPedidoInstalacao().getRazaoSocialClienteFinal(), dadosLicenca.getCnpj(), ((Familia)produtoLicenca.getFamilia().get(0)).getDiasValidadeLicenca());
                this.gravarLicenca(principal, principal.getRazaoSocial(), dadosLicenca.getCnpj(), dadosLicenca.isReiniciarBase(), dataAtivacao);
            }
        } else {
            reinstalacao = true;
            razaoSocial = dadosLicenca.getRetornoReinstalacao().getRazaoSocialCliente();
            licencas = dadosLicenca.getRetornoReinstalacao().getLicencas();
        }
        if (!ListMapUtil.listNullOrEmpty((List)licencas)) {
            this.instalarListaLicencas(razaoSocial, dadosLicenca.getCnpj(), licencas, reinstalacao, !resetouBase && dadosLicenca.isReiniciarBase());
        }
        this.limparCacheSistema();
        this.recarregarLicencasCache();
        this.inativarFiliaisSemLicenca();
        ConfiguradorModuloCommonRN.getInstance().verificarSeExisteModulosNaBase(SessaoUtil.getSessao(), false);
        this.cacheService.clear();
        PropriedadeRN.getInstance().gravarTodasPropriedades(SessaoUtil.getSessao());
        this.verificarLicenca(ContextoHolder.getTenant());
    }

    private void inativarFiliaisSemLicenca() {
        String retornoInativarFiliaisSemLicenca = FilialRN.getInstance().inativarFilialSemLicenca(SessaoUtil.getSessao());
        if (!Util.stringNullOrEmpty((String)retornoInativarFiliaisSemLicenca)) {
            this.log.error(retornoInativarFiliaisSemLicenca);
        }
    }

    public void aceiteContrato(LicencaRequestWrapper request) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        Usuario usuario = sessao.getUsuario();
        String nomeUsuario = usuario.getCodigo() + "-" + usuario.getNome();
        LocalDateTime dataHora = DataHoraFactory.getDataHora();
        IdentificadorAceiteContrato aceiteContrato = new IdentificadorAceiteContrato();
        aceiteContrato.setDefinicao("ACEITOU_CONTRATO");
        aceiteContrato.setUsuario(nomeUsuario);
        aceiteContrato.setDataAceite(StringUtil.formataDataHora((Temporal)dataHora, (String)"dd/MM/yyyy HH:mm:SS"));
        Map send = this.identificadorLicencaService.getIdentificador((Object)aceiteContrato);
        send.put("dependents", request.getChaveLicenca());
        JSONObject elem = JSONUtil.getJSONObject((Object)send);
        ResponseEntity response = this.connectionOAuth2Service.execute("/api/", "isitok", elem, Object.class, HttpMethod.POST, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new UnicoMensagemUsuarioException("WWW363", "N\u00e3o foi poss\u00edvel processar o aceite de contrato.");
        }
        ControleRN.getInstance().setIdUsuarioDataAceitePLUS(sessao, usuario.getId(), dataHora);
        ControleRN.getInstance().setUsuarioAdminViuContratoPLUS(sessao, true);
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"}, justification="Compatibilidade")
    public DadosLicencaWrapper reinstalarLicencas(LicencaRequestWrapper request, String tenant) throws UnicoMensagemUsuarioException {
        DadosLicencaWrapper dadosLicencaWrapper;
        String endpoint = "pedido-reinstalar-uniplusweb";
        try {
            Map send = this.identificadorLicencaService.getIdentificador();
            send.put("cnpjCliente", request.getCnpj());
            JSONObject elem = JSONUtil.getJSONObject((Object)send);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("reinstalacaoRequest", (Object)elem);
            jsonObject.put("email", (Object)request.getEmail());
            jsonObject.put("senha", (Object)request.getSenha());
            jsonObject.put("tenant", (Object)tenant);
            ResponseEntity response = this.connectionOAuth2Service.post(endpoint, jsonObject, RetornoReinstalacao.class);
            if (response != null && response.getStatusCode() == HttpStatus.OK) {
                Filial filial = null;
                ProdutoLicenca produtoLicencaBase = null;
                RetornoReinstalacao reinstalacao = (RetornoReinstalacao)response.getBody();
                if (reinstalacao != null) {
                    ArrayList<RetornoInstalarLicenca> exclusoes = new ArrayList<RetornoInstalarLicenca>();
                    for (RetornoInstalarLicenca instalarLicenca : reinstalacao.getLicencas()) {
                        ProdutoLicenca produtoLicenca = ProdutoLicencaRN.getInstance().getProduto(instalarLicenca.getChaveAtivacao());
                        if (produtoLicenca == null) {
                            exclusoes.add(instalarLicenca);
                            continue;
                        }
                        if (produtoLicenca.isBase()) {
                            produtoLicencaBase = produtoLicenca;
                            String razaoSocialLicenca = null;
                            if (!Util.stringNullOrEmpty((String)instalarLicenca.getRazaoSocial())) {
                                razaoSocialLicenca = instalarLicenca.getRazaoSocial();
                            }
                            String cnpjLicenca = request.getCnpj();
                            if (!Util.stringNullOrEmpty((String)instalarLicenca.getCnpj())) {
                                cnpjLicenca = instalarLicenca.getCnpj();
                            }
                            filial = this.getFilial(razaoSocialLicenca, cnpjLicenca, instalarLicenca.getVariacaoCPF());
                            ControleRN.getInstance().setUsuarioAdminViuContratoPLUS(SessaoUtil.getSessao(), false);
                            instalarLicenca.setPeso(1);
                        } else if (produtoLicenca.isRequerCNPJ()) {
                            instalarLicenca.setPeso(2);
                        } else if (produtoLicenca.isPerguntaFilial()) {
                            instalarLicenca.setPeso(3);
                        } else if (produtoLicenca.getInterfaceIncrementoLicenca() != null) {
                            instalarLicenca.setPeso(4);
                        } else {
                            instalarLicenca.setPeso(5);
                        }
                        if (Util.stringNullOrEmpty((String)instalarLicenca.getCnpj()) || !Util.isApenasNumeros((String)instalarLicenca.getCnpj())) continue;
                        instalarLicenca.setCnpj(Util.formataCpfCnpj((String)instalarLicenca.getCnpj()));
                    }
                    reinstalacao.getLicencas().removeAll(exclusoes);
                    reinstalacao.getLicencas().sort(Comparator.comparingInt(RetornoInstalarLicenca::getPeso));
                    dadosLicencaWrapper = new DadosLicencaWrapper(reinstalacao, produtoLicencaBase, filial, request.getCnpj(), true);
                } else {
                    dadosLicencaWrapper = null;
                }
            } else {
                dadosLicencaWrapper = null;
            }
        }
        catch (Exception ex) {
            if (ex instanceof UnicoMensagemUsuarioException) {
                throw (UnicoMensagemUsuarioException)((Object)ex);
            }
            dadosLicencaWrapper = null;
            this.log.error("N\u00e3o foi poss\u00edvel processar o pedido de reinstala\u00e7\u00e3o para o CNPJ " + request.getCnpj(), (Throwable)ex);
        }
        if (dadosLicencaWrapper == null) {
            throw new UnicoMensagemUsuarioException("WWW366", "N\u00e3o foi poss\u00edvel processar o pedido de reinstala\u00e7\u00e3o.");
        }
        return dadosLicencaWrapper;
    }

    public void finalizarReinstalacao(DadosLicencaWrapper dadosLicenca) throws UnicoMensagemUsuarioException {
        this.gravarFilial(dadosLicenca);
        if (!ListMapUtil.listNullOrEmpty((List)dadosLicenca.getRetornoReinstalacao().getLicencas())) {
            this.instalarListaLicencas("", dadosLicenca.getCnpj(), dadosLicenca.getRetornoReinstalacao().getLicencas(), true, dadosLicenca.isReiniciarBase() && this.licencaService.getDadosLicenca().isDemonstracao());
        }
        this.limparCacheSistema();
        this.recarregarLicencasCache();
        this.inativarFiliaisSemLicenca();
        ConfiguradorModuloCommonRN.getInstance().verificarSeExisteModulosNaBase(SessaoUtil.getSessao(), false);
        this.cacheService.clear();
        PropriedadeRN.getInstance().gravarTodasPropriedades(SessaoUtil.getSessao());
        this.verificarLicenca(ContextoHolder.getTenant());
    }

    public String getTextoContrato() {
        String textoContrato = this.getMensagemServidor(TEXTO_CONTRATO);
        if (StringUtil.stringNullOrEmpty((String)textoContrato)) {
            textoContrato = ControleRN.getInstance().getRegistroControle().getTextoContratoPLUS();
        }
        if (!StringUtil.stringNullOrEmpty((String)textoContrato) && !textoContrato.equalsIgnoreCase("*")) {
            ControleRN.getInstance().atualizaMensagensPLUS(SessaoUtil.getSessao(), null, null, textoContrato);
        }
        return textoContrato;
    }

    private String getMensagemServidor(String numero) {
        String mensagem;
        if (LicencaManager.getInstance().isGnio()) {
            numero = StringUtil.all2Atring((Object)(Integer.parseInt(numero) + 10));
        }
        Map send = this.identificadorLicencaService.getIdentificador();
        send.put("numero", numero);
        JSONObject elem = JSONUtil.getJSONObject((Object)send);
        try {
            ResponseEntity response = this.connectionOAuth2Service.execute("/api/", "mensagem", elem, Map.class, HttpMethod.POST, new Object[0]);
            if (response == null || response.getStatusCode() != HttpStatus.OK) {
                return null;
            }
            Map resposta = (Map)response.getBody();
            mensagem = resposta != null ? (String)resposta.get("mensagem") : null;
        }
        catch (Exception ex) {
            mensagem = null;
        }
        return mensagem;
    }

    private void validarFiliais(String cnpjMatriz, List<RetornoInstalarLicenca> licencas) throws UnicoMensagemUsuarioException {
        FilialRN.getInstance().validarFiliais(cnpjMatriz, licencas, SessaoUtil.getSessao());
    }

    private void gravarFilial(DadosLicencaWrapper dadosLicenca) throws UnicoMensagemUsuarioException {
        if (dadosLicenca.getFilial() != null) {
            Filial filial = dadosLicenca.getFilial();
            if (!EmpresaRN.getInstance().isPossuiEmpresaCadastrada()) {
                EmpresaRN.getInstance().incluirEmpresaPadrao(SessaoUtil.getSessao());
            }
            if (!EmpresaRN.getInstance().isHabilitarEmpresaNoSistema() && Util.longNullOuZero((Long)filial.getIdEmpresa())) {
                filial.setIdEmpresa((Long)EmpresaRN.getInstance().getIdsEmpresas().get(0));
            }
            FilialRN.getInstance().gravar(1, filial, SessaoUtil.getSessao());
        }
    }

    private Filial getFilial(String razaoSocial, String cnpj, String variacaoCPF) throws UnicoMensagemUsuarioException {
        boolean filialNova;
        List filiais;
        Filial filial = FilialRN.getInstance().buscarQualquerFilialPorCnpj(cnpj, variacaoCPF);
        if (filial == null && !(filiais = FilialRN.getInstance().buscarLista()).isEmpty()) {
            filial = (Filial)filiais.get(0);
        }
        boolean bl = filialNova = filial == null;
        if (filialNova) {
            filial = new Filial();
            filial.setCodigo(FilialRN.getInstance().getCodigoUnico(SessaoUtil.getSessao()));
        }
        if (!filialNova && filial.getCnpj() != null && (filial.getCnpj().equalsIgnoreCase(UnicoSistema.getCNPJIntelidata()) || filial.getCnpj().equalsIgnoreCase(UnicoSistema.getCNPJDemonstracao()))) {
            filial.setBairro(null);
            filial.setCep(null);
            filial.setCidade(null);
            filial.setCnae(null);
            filial.setCnpj(null);
            filial.setComplemento(null);
            filial.setContador(null);
            filial.setEmail(null);
            filial.setEndereco(null);
            filial.setIdCidade(null);
            filial.setEstado(null);
            filial.setIdEstado(null);
            filial.setInscricaoEstadual(null);
            filial.setInscricaoEstadualST(null);
            filial.setInscricaoMunicipal(null);
            filial.setNome(null);
            filial.setNsu(null);
            filial.setNumero(null);
            filial.setTipoEnquadramento(TipoEnquadramentoFilial.LUCROPRESUMIDO);
            filial.setRazaoSocial(null);
            filial.setResponsavel(null);
            filial.setSite(null);
            filial.setSuframa(null);
            filial.setTelefone(null);
        }
        filial.setIndicadorFilial(IndicadorFilial.MATRIZ);
        filial.setRazaoSocial(razaoSocial);
        filial.setNome(razaoSocial);
        filial.setCnpj(cnpj);
        filial.setInativo(InativoFilial.NAO);
        filial.setTipoPessoa(Util.apenasNumeros((String)cnpj).length() == 11 ? TipoPessoa.FISICA : TipoPessoa.JURIDICA);
        if (filialNova) {
            Long idFilial = FilialRN.getInstance().incluirResumido(SessaoUtil.getSessao(), filial.getCodigo(), razaoSocial, razaoSocial, cnpj, IndicadorFilial.FILIAL, variacaoCPF);
            filial.setId(idFilial);
        } else {
            if (!Util.longNullOuZero((Long)filial.getIdEntidade())) {
                Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(filial.getIdEntidade());
                if (entidade != null && filial.getCnpj().equals(entidade.getCnpjCpf())) {
                    entidade.setNome(filial.getNome());
                    entidade.setRazaoSocial(filial.getRazaoSocialCompleta());
                    entidade.setCnpjCpf(filial.getCnpj());
                    entidade.setTipoPessoa(filial.getTipoPessoa());
                    entidade.setNaoValidarQuantidadeRegistros(true);
                    EntidadeRN.getInstance().gravar(1, entidade, SessaoUtil.getSessao());
                } else {
                    filial.setIdEntidade(null);
                }
            }
            FilialRN.getInstance().gravar(1, filial, SessaoUtil.getSessao());
        }
        return filial;
    }

    private boolean gravarLicenca(RetornoInstalarLicenca retornoInstalarLicenca, String razaoSocial, String cnpj, boolean permiteReiniciarBase, LocalDate dataAtivacao) throws UnicoMensagemUsuarioException {
        razaoSocial = razaoSocial.trim();
        Sessao sessao = SessaoUtil.getSessao();
        ProdutoLicenca produtoLicenca = ProdutoLicencaRN.getInstance().getProduto(retornoInstalarLicenca.getChaveAtivacao());
        boolean instalouLicenca = false;
        if (produtoLicenca != null) {
            if (produtoLicenca.equals((Object)ProdutoLicenca.ENTERPRISE) || produtoLicenca.equals((Object)ProdutoLicenca.ENTERPRISE_PLUS) || produtoLicenca.equals((Object)ProdutoLicenca.ENTERPRISE_GNIO) || produtoLicenca.equals((Object)ProdutoLicenca.MULTIEMPRESA)) {
                Filial filial = FilialCommonRN.getInstance().buscarQualquerFilialPorCnpj(cnpj, retornoInstalarLicenca.getVariacaoCPF());
                if (filial != null && InativoFilial.INATIVO_POR_LICENCA.equals((Object)filial.getInativo())) {
                    filial.setInativo(InativoFilial.NAO);
                    FilialRN.getInstance().gravar(1, filial, sessao);
                }
            } else if (produtoLicenca.equals((Object)ProdutoLicenca.TROCAR_RAZAO_SOCIAL)) {
                Filial filial = FilialRN.getInstance().buscarFilialPorCnpj(cnpj, retornoInstalarLicenca.getVariacaoCPF());
                if (filial == null) {
                    throw new UnicoMensagemUsuarioException("WWW365", "N\u00e3o foi poss\u00edvel instalar a licen\u00e7a de altera\u00e7\u00e3o de raz\u00e3o social porque n\u00e3o foi encontrado uma filial com o CNPJ " + cnpj);
                }
                filial.setRazaoSocial(razaoSocial);
                FilialRN.getInstance().gravar(1, filial, sessao);
            }
            if (permiteReiniciarBase) {
                DicionarioDados.getInstance().resetarBaseDados();
            }
            LicencaRN.getInstance().gravaLicenca(razaoSocial, cnpj, retornoInstalarLicenca.getChaveInstalacao(), retornoInstalarLicenca.getChaveAtivacao(), dataAtivacao, retornoInstalarLicenca.getVariacaoCPF(), retornoInstalarLicenca.getDataFimDegustacao(), retornoInstalarLicenca.getIdentificadorLicenca(), sessao);
            this.limparCacheSistema();
            ConfiguradorModuloCommonRN.getInstance().ativarDesativarPorProdutoLicenca(sessao, produtoLicenca, true);
            ConfiguradorFuncionalidadeCommonRN.getInstance().ativarDesativarPorProdutoLicenca(sessao, produtoLicenca, true);
            instalouLicenca = true;
        } else {
            EventoSistemaRN.getInstance().gravaEvento(sessao, false, CategoriaEventoSistema.INFORMACAO, "N\u00e3o foi encontrada a licen\u00e7a [" + retornoInstalarLicenca.getNomeLicenca() + "]. Verifique as licen\u00e7as no contrato.");
        }
        return instalouLicenca;
    }

    private boolean instalarListaLicencas(String razaoSocial, String CNPJ, List<RetornoInstalarLicenca> licencas, boolean reinstalacao, boolean permiteReiniciarBase) throws UnicoMensagemUsuarioException {
        boolean instalouLicencas = false;
        if (!Util.listNullOrEmpty(licencas)) {
            if (reinstalacao) {
                LicencaRN.getInstance().truncateLicencas();
                ConfiguradorModuloCommonRN.getInstance().truncateModulos();
                ConfiguradorFuncionalidadeCommonRN.getInstance().truncateFuncionalidades();
            }
            for (RetornoInstalarLicenca retornoInstalarLicenca : licencas) {
                String razaoSocialLicenca = razaoSocial;
                if (!Util.stringNullOrEmpty((String)retornoInstalarLicenca.getRazaoSocial())) {
                    razaoSocialLicenca = retornoInstalarLicenca.getRazaoSocial();
                }
                String cnpjLicenca = CNPJ;
                if (!Util.stringNullOrEmpty((String)retornoInstalarLicenca.getCnpj())) {
                    cnpjLicenca = retornoInstalarLicenca.getCnpj();
                }
                boolean licencaInstalada = this.gravarLicenca(retornoInstalarLicenca, razaoSocialLicenca, cnpjLicenca, false, null);
                instalouLicencas = instalouLicencas || licencaInstalada;
            }
            if (reinstalacao) {
                ConfiguradorModuloCommonRN.getInstance().montarModulosWeb(SessaoUtil.getSessao());
            }
            if (permiteReiniciarBase) {
                DicionarioDados.getInstance().resetarBaseDados();
            }
        }
        return instalouLicencas;
    }

    private void comunicarAtivacao(String chaveAtivacao, LocalDate dataAtivacao, String razaoSocial, String cnpj, int diasValidadeLicenca) throws UnicoMensagemUsuarioException {
        IdentificadorAtivacao identificadorAtivacao = new IdentificadorAtivacao();
        identificadorAtivacao.setDefinicao("ATIVACAO");
        identificadorAtivacao.setRazaoSocial(razaoSocial);
        identificadorAtivacao.setCnpj(cnpj);
        identificadorAtivacao.setDataAtivacao(Util.formataDataHora((Temporal)dataAtivacao, (String)"dd/MM/yyyy"));
        identificadorAtivacao.setDiasValidadeLicenca(diasValidadeLicenca);
        Map send = this.identificadorLicencaService.getIdentificador((Object)identificadorAtivacao);
        send.put("dependents", chaveAtivacao);
        JSONObject elem = JSONUtil.getJSONObject((Object)send);
        ResponseEntity response = this.connectionOAuth2Service.execute("/api/", "isitok", elem, Object.class, HttpMethod.POST, new Object[0]);
        if (response.getStatusCode() != HttpStatus.OK) {
            throw new UnicoMensagemUsuarioException("WWW364", "N\u00e3o foi poss\u00edvel conectar ao servidor para ativar a licen\u00e7a");
        }
    }

    private RetornoIsItOk isItOk(Licenca licenca) {
        try {
            Map resposta;
            Map send = this.identificadorLicencaService.getIdentificador();
            send.put("dependents", licenca.getChaveAtivacao());
            send.put("cnpj", licenca.getCnpj());
            JSONObject elem = JSONUtil.getJSONObject((Object)send);
            ResponseEntity response = this.connectionOAuth2Service.execute("/api/", "isitok", elem, Map.class, HttpMethod.POST, new Object[0]);
            if (response != null && response.getStatusCode() == HttpStatus.OK && (resposta = (Map)response.getBody()) != null) {
                Object jsonObject = resposta.get("diferencaLicencaContrato");
                DiferencaLicencaContrato diferencaLicencaContrato = null;
                if (jsonObject != null && !jsonObject.toString().isEmpty()) {
                    diferencaLicencaContrato = (DiferencaLicencaContrato)JsonUtil.fromJson((String)JsonUtil.toJson(jsonObject), DiferencaLicencaContrato.class);
                }
                List dadosFilial = null;
                Object jsonObjectDadosFilial = resposta.get("dadosFilial");
                if (jsonObjectDadosFilial != null && !jsonObjectDadosFilial.toString().isEmpty()) {
                    dadosFilial = JsonUtil.fromJsonList((String)JsonUtil.toJson(jsonObjectDadosFilial), RetornoIsItOkFilial.class);
                }
                List licencasAtivadasPorDegustacao = null;
                Object jsonLicencasAtivadasPorDegustacao = resposta.get("licencasAtivadasPorDegustacao");
                if (jsonLicencasAtivadasPorDegustacao instanceof JSONArray) {
                    licencasAtivadasPorDegustacao = JSONUtil.getObjectCollection((JSONArray)((JSONArray)jsonLicencasAtivadasPorDegustacao), String.class);
                } else if (jsonLicencasAtivadasPorDegustacao instanceof List) {
                    licencasAtivadasPorDegustacao = (List)jsonLicencasAtivadasPorDegustacao;
                }
                List licencasCombo = null;
                Object jsonObjectLicencasCombo = resposta.get("licencasCombo");
                if (jsonObjectLicencasCombo != null && !jsonObjectLicencasCombo.toString().isEmpty()) {
                    licencasCombo = JsonUtil.fromJsonList((String)JsonUtil.toJson(jsonObjectLicencasCombo), InfoLicenca.class);
                }
                boolean isWeb = resposta.getOrDefault("web", false);
                boolean isCombo = resposta.getOrDefault("combo", false);
                return new RetornoIsItOk((String)resposta.get("token"), true, diferencaLicencaContrato, Util.all2Atring(resposta.get("mensagemBloqueioEncerramento")), ((Integer)resposta.get("diasParaBloqueio")).intValue(), ((Integer)resposta.get("diasParaEncerramento")).intValue(), DataHoraFactory.string2LocalDate((String)Util.all2Atring(resposta.get("dataVencimentoLicenca")), (String)"dd/MM/yyyy"), dadosFilial, null, licencasAtivadasPorDegustacao, isWeb, licencasCombo, isCombo);
            }
        }
        catch (Exception e) {
            this.log.error("N\u00e3o foi poss\u00edvel validar as licen\u00e7as no logtracker.", (Throwable)e);
        }
        return null;
    }

    private int getDiasValidadeTenant(String tenant) {
        int diasRestantes = 0;
        try {
            Integer resposta;
            ResponseEntity response = this.connectionOAuth2Service.get("/validade-tenant/" + tenant, Integer.class, new Object[0]);
            if (response != null && response.getStatusCode() == HttpStatus.OK && (resposta = (Integer)response.getBody()) != null) {
                diasRestantes = resposta;
            }
        }
        catch (Exception ex) {
            this.log.error("N\u00e3o foi poss\u00edvel obter a quantidade de dias em demonstra\u00e7\u00e3o para o tenant: " + tenant, (Throwable)ex);
        }
        return diasRestantes;
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Falso positivo")
    public void verificarLicenca(String tenant) throws UnicoMensagemUsuarioException {
        this.verificarLicenca(tenant, true);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"}, justification="Falso positivo")
    public void verificarLicenca(String tenant, boolean atualizarDadosFilial) throws UnicoMensagemUsuarioException {
        LocalDateTime dataHoraConsulta;
        boolean isLicencaOK;
        RetornoIsItOk retornoConsulta;
        if (!SGBDManager.getInstance().existeTabela(LicencaCommonRN.getInstance().getTabela())) {
            return;
        }
        Sessao sessao = SessaoUtil.getSessao();
        Licenca licencaPrincipal = LicencaCommonRN.getInstance().buscarLicencaPrincipal();
        if (this.licencaService.getDadosLicenca().isDemonstracao() && licencaPrincipal == null) {
            int diasValidade = this.getDiasValidadeTenant(tenant);
            ValidadorLicencaWrapper validador = new ValidadorLicencaWrapper(diasValidade == 0 ? StatusLicenca.DEMONSTRACAO_FINALIZADA : StatusLicenca.OK, diasValidade);
            this.mapLicencas.put(tenant, validador);
            return;
        }
        if (licencaPrincipal == null || LicencaManager.getInstance().isLicencaLocal(licencaPrincipal.getChaveAtivacao())) {
            this.log.info("A licen\u00e7a {} n\u00e3o ser\u00e1 validada no servidor pois \u00e9 uma licen\u00e7a local.", (Object)(licencaPrincipal != null ? licencaPrincipal.getChaveAtivacao() : ""));
            this.mapLicencas.put(tenant, new ValidadorLicencaWrapper());
            return;
        }
        if (!((Familia)licencaPrincipal.getProdutoLicenca().getFamilia().get(0)).isUtilizarWS()) {
            this.log.info("A licen\u00e7a {} n\u00e3o ser\u00e1 validada no servidor pois esta marcada para n\u00e3o utilizar WS.", (Object)licencaPrincipal.getChaveAtivacao());
            this.mapLicencas.put(tenant, new ValidadorLicencaWrapper());
            return;
        }
        if (!this.profile.isDev()) {
            try {
                JSONObject params = new JSONObject();
                params.put("cnpj", (Object)licencaPrincipal.getCnpj());
                params.put("tenant", (Object)tenant);
                params.put("licencaBase", (Object)licencaPrincipal.getChaveAtivacao());
                ResponseEntity response = this.connectionOAuth2Service.post("/validar-tenant-contrato/", params, ValidacaoTenantReponse.class);
                if (response != null && response.getStatusCode() == HttpStatus.OK && response.getBody() != null) {
                    if (!((ValidacaoTenantReponse)response.getBody()).isValido()) {
                        this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.LICENCA_INVALIDA, ((ValidacaoTenantReponse)response.getBody()).getMensagem(), false));
                        return;
                    }
                } else {
                    this.log.error("O tenant n\u00e3o foi validado com o contrato atual");
                    this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.MENSAGEM_ADVERTENCIA, "N\u00e3o foi poss\u00edvel validar as licen\u00e7as.", false));
                }
            }
            catch (Exception ex) {
                this.log.error("O tenant n\u00e3o foi validado com o contrato atual", (Throwable)ex);
                this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.MENSAGEM_ADVERTENCIA, "N\u00e3o foi poss\u00edvel validar as licen\u00e7as.", false));
            }
        }
        int diasValidade = LicencaManager.getInstance().getFamilia().getDiasValidadeLicenca();
        int diasParaTomarAcao = LicencaManager.getInstance().getFamilia().getDiasAposVencimentoLicencaParaTomarAcao();
        int diasParaTomarNotificar = LicencaManager.getInstance().getFamilia().getDiasAposVencimentoLicencaParaNotificarUsuario();
        int diasParaExpirar = LicencaManager.getInstance().getFamilia().getDiasAposVencimentoParaExpirarLicenca();
        LocalDate dataValidadeAtual = licencaPrincipal.getDataValidade();
        LocalDate validoAte = dataValidadeAtual.plusDays(diasParaTomarAcao);
        LocalDate vencimento = dataValidadeAtual.plusDays(diasParaExpirar);
        try {
            retornoConsulta = this.isItOk(licencaPrincipal);
        }
        catch (Exception ex) {
            retornoConsulta = null;
        }
        if (retornoConsulta != null) {
            SituacaoLicencaServidor situacaoLicencaServidor = retornoConsulta.getSituacaoLicencaServidor();
            isLicencaOK = situacaoLicencaServidor.equals((Object)SituacaoLicencaServidor.AUTORIZADA);
            dataHoraConsulta = retornoConsulta.getDataHoraServidor();
            if (dataHoraConsulta == null) {
                dataHoraConsulta = DataHoraFactory.getDataHora();
            }
            boolean isLicencaOkWebService = !situacaoLicencaServidor.equals((Object)SituacaoLicencaServidor.NAO_AUTORIZADA);
            licencaPrincipal.setLicencaOkWebService(Boolean.valueOf(isLicencaOkWebService));
            licencaPrincipal.setDataUltimaConsulta(dataHoraConsulta.toLocalDate());
            licencaPrincipal.setNumeroUsuariosPermitidos(Integer.valueOf(retornoConsulta.getNumeroUsuariosSistema()));
            licencaPrincipal.setNumeroUsuariosMobile(Integer.valueOf(retornoConsulta.getNumeroUsuariosMobile()));
            licencaPrincipal.setNumeroUsuariosComanda(Integer.valueOf(retornoConsulta.getNumeroUsuariosComanda()));
            licencaPrincipal.setNumeroUsuariosMobilePdv(Integer.valueOf(retornoConsulta.getNumeroUsuariosMobilePDV()));
            LicencaCommonRN.getInstance().gravar(1, licencaPrincipal, sessao);
            LicencaComboCommonRN.getInstance().gravarLicencasCombo(sessao, retornoConsulta.getLicencasCombo());
            if (isLicencaOK) {
                if (atualizarDadosFilial) {
                    this.atualizarFiliaisComInformacaoWebService(retornoConsulta.getListaDadosFilial());
                }
                if (!Util.listNullOrEmpty((List)retornoConsulta.getLicencasAtivadasPorDegustacao())) {
                    List licencas = LicencaCommonRN.getInstance().getLicencasInstaladas();
                    for (Licenca licenca : licencas) {
                        if (licenca.getDataFimDegustacao() == null || !retornoConsulta.getLicencasAtivadasPorDegustacao().contains(licenca.getChaveAtivacao())) continue;
                        licenca.setDataFimDegustacao(null);
                        LicencaCommonRN.getInstance().gravar(1, licenca, sessao);
                    }
                }
            }
            if (situacaoLicencaServidor.equals((Object)SituacaoLicencaServidor.NAO_AUTORIZADA)) {
                if (!Util.stringNullOrEmpty((String)retornoConsulta.getMensagemBloqueioEncerramento())) {
                    this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.NAO_AUTORIZADA, retornoConsulta.getMensagemBloqueioEncerramento(), true));
                } else {
                    this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.NAO_AUTORIZADA, "Licen\u00e7a de utiliza\u00e7\u00e3o do sistema n\u00e3o est\u00e1 autorizada", false));
                }
                return;
            }
            if (situacaoLicencaServidor.equals((Object)SituacaoLicencaServidor.NAO_ENCONTRADA)) {
                LogSistema.escreve((String)Log.INFO, (String)("Licen\u00e7a " + licencaPrincipal.getChaveAtivacao() + " n\u00e3o foi encontrada"));
                this.log.info("Licen\u00e7a " + licencaPrincipal.getChaveAtivacao() + " n\u00e3o foi encontrada");
            }
            boolean existeLicencasParaDesinstalar = false;
            boolean existeLicencasParaInstalar = false;
            boolean instalouLicencas = false;
            boolean alterouChaveLicencaBase = false;
            if (retornoConsulta.getDiferencaLicencaContrato() != null) {
                existeLicencasParaDesinstalar = !Util.listNullOrEmpty((List)retornoConsulta.getDiferencaLicencaContrato().getLicencasParaDesinstalar());
                boolean bl = existeLicencasParaInstalar = !Util.listNullOrEmpty((List)retornoConsulta.getDiferencaLicencaContrato().getLicencasParaInstalar());
                if (existeLicencasParaDesinstalar) {
                    LicencaCommonRN.getInstance().desinstalarLicencas(sessao, retornoConsulta.getDiferencaLicencaContrato().getLicencasParaDesinstalar(), DataHoraFactory.getDataHora());
                }
                if (existeLicencasParaInstalar) {
                    String razaoSocial = licencaPrincipal.getRazaSocial();
                    String CNPJ = licencaPrincipal.getCnpj();
                    instalouLicencas = this.instalarListaLicencas(razaoSocial, CNPJ, retornoConsulta.getDiferencaLicencaContrato().getLicencasParaInstalar(), false, false);
                }
                if (!Util.stringNullOrEmpty((String)retornoConsulta.getDiferencaLicencaContrato().getLicencaBase()) && !licencaPrincipal.getChaveAtivacao().equalsIgnoreCase(retornoConsulta.getDiferencaLicencaContrato().getLicencaBase())) {
                    LicencaCommonRN.getInstance().atualizarChaveLicencaPrincipal(sessao, retornoConsulta.getDiferencaLicencaContrato().getLicencaBase());
                    alterouChaveLicencaBase = true;
                }
            }
            if (existeLicencasParaInstalar && instalouLicencas || existeLicencasParaDesinstalar || alterouChaveLicencaBase) {
                this.limparCacheSistema();
                this.recarregarLicencasCache();
                ConfiguradorModuloCommonRN.getInstance().verificarSeExisteModulosNaBase(SessaoUtil.getSessao(), false);
                PropriedadeRN.getInstance().gravarTodasPropriedades(SessaoUtil.getSessao());
                this.limparCacheSistema();
                licencaPrincipal = LicencaCommonRN.getInstance().buscarLicencaPrincipal();
                this.notificationService.simpleNotifyUserTenantNow(tenant, sessao.getIdUsuario(), TipoNotificacaoSimples.NONE, "Licen\u00e7as atualizadas com sucesso");
            }
            if (!retornoConsulta.isWeb() && licencaPrincipal.getLicencasInstaladas().stream().noneMatch(l -> ProdutoLicenca.WEB_DESKTOP.equals((Object)l.getProdutoLicenca()))) {
                this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.SISTEMA_NAO_WEB, "O contrato est\u00e1 marcado como Desktop e n\u00e3o pode ser usado em Web", false));
                return;
            }
            this.log.info("N\u00famero de usu\u00e1rios liberados para a licen\u00e7a '" + licencaPrincipal.getChaveAtivacao() + "': " + retornoConsulta.getNumeroUsuariosSistema());
            LogSistema.escreve((String)Log.INFO, (String)("N\u00famero de usu\u00e1rios liberados para a licen\u00e7a: " + retornoConsulta.getNumeroUsuariosSistema()));
            if (retornoConsulta.getDataVencimentoLicenca() != null) {
                dataValidadeAtual = retornoConsulta.getDataVencimentoLicenca();
                validoAte = dataValidadeAtual.plusDays(diasParaTomarAcao);
                vencimento = dataValidadeAtual.plusDays(diasParaExpirar);
                if (licencaPrincipal.getDataValidade().compareTo(dataValidadeAtual) != 0) {
                    licencaPrincipal.setDataValidade(dataValidadeAtual);
                    LicencaCommonRN.getInstance().gravar(1, licencaPrincipal, sessao);
                }
            }
            if (!Util.stringNullOrEmpty((String)retornoConsulta.getMensagemBloqueioEncerramento())) {
                int diasBloqueio = retornoConsulta.getDiasParaBloqueio() > 0 ? retornoConsulta.getDiasParaBloqueio() : retornoConsulta.getDiasParaEncerramento();
                this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.MENSAGEM_ADVERTENCIA, retornoConsulta.getMensagemBloqueioEncerramento(), true, diasBloqueio, 0));
                return;
            }
        } else {
            this.log.error("N\u00e3o foi poss\u00edvel consultar o LogTracker para validar a licen\u00e7a {}", (Object)licencaPrincipal.getChaveAtivacao());
            dataHoraConsulta = DataHoraFactory.getDataHora();
            isLicencaOK = false;
        }
        if (Math.abs(Util.getDiferencaEmHoras((LocalDateTime)DataHoraFactory.getDataHora(), (LocalDateTime)dataHoraConsulta)) > 12) {
            this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.NAO_AUTORIZADA, "Data do computador est\u00e1 inv\u00e1lida. Por favor verifique.", false));
            return;
        }
        if (licencaPrincipal.getDataFimDegustacao() != null && Util.getDiferencaEmDias((LocalDate)DataHoraFactory.getData(), (LocalDate)licencaPrincipal.getDataFimDegustacao()) < 0) {
            this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.DEGUSTACAO_FINALIZADA, "O per\u00edodo de degusta\u00e7\u00e3o do sistema expirou", false));
            return;
        }
        if (validoAte.compareTo(dataHoraConsulta.toLocalDate()) >= 0) {
            this.mapLicencas.put(tenant, new ValidadorLicencaWrapper());
        } else if (dataValidadeAtual.plusDays(diasParaTomarNotificar).compareTo(dataHoraConsulta.toLocalDate()) >= 0) {
            String mensagem;
            if (isLicencaOK) {
                LicencaCommonRN.getInstance().atualizarDataValidade(licencaPrincipal, dataValidadeAtual.plusDays(diasValidade), sessao);
                mensagem = "Licen\u00e7a " + licencaPrincipal.getChaveAtivacao() + " validada at\u00e9 " + dataValidadeAtual.plusDays(diasValidade);
            } else {
                mensagem = "Licen\u00e7a " + licencaPrincipal.getChaveAtivacao() + " n\u00e3o foi validada";
            }
            LogSistema.escreve((String)Log.INFO, (String)mensagem);
            this.log.info(mensagem);
            this.mapLicencas.put(tenant, new ValidadorLicencaWrapper());
        } else if (vencimento.compareTo(dataHoraConsulta.toLocalDate()) >= 0) {
            if (isLicencaOK) {
                LicencaCommonRN.getInstance().atualizarDataValidade(licencaPrincipal, dataValidadeAtual.plusDays(diasValidade), sessao);
                String mensagem = "Licen\u00e7a " + licencaPrincipal.getChaveAtivacao() + " validada at\u00e9 " + dataValidadeAtual.plusDays(diasValidade);
                this.log.info(mensagem);
                LogSistema.escreve((String)Log.INFO, (String)mensagem);
                this.mapLicencas.put(tenant, new ValidadorLicencaWrapper());
            } else {
                String mensagemAtraso = this.getMensagemServidor(MENSAGEM_ATRASADO);
                if (Util.stringNullOrEmpty((String)mensagemAtraso)) {
                    mensagemAtraso = ControleRN.getInstance().getRegistroControle().getMensagemAtrasoPLUS();
                    if (Util.stringNullOrEmpty((String)mensagemAtraso)) {
                        mensagemAtraso = LicencaManager.MENSAGEM_ATRASO_UNIPLUS;
                    }
                } else {
                    ControleRN.getInstance().atualizaMensagensPLUS(sessao, mensagemAtraso, null, null);
                }
                mensagemAtraso = mensagemAtraso.replace("@dataExpiracao", Util.formataDataHora((Temporal)vencimento, (String)"dd/MM/yyyy"));
                this.log.info("Licen\u00e7a " + licencaPrincipal.getChaveAtivacao() + " exibida mensagem: " + mensagemAtraso);
                LogSistema.escreve((String)Log.INFO, (String)("Licen\u00e7a " + licencaPrincipal.getChaveAtivacao() + " exibida mensagem: " + mensagemAtraso));
                this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.MENSAGEM_ADVERTENCIA, mensagemAtraso, false));
            }
        } else if (isLicencaOK) {
            String mensagem = "Licen\u00e7a " + licencaPrincipal.getChaveAtivacao() + " validada at\u00e9 " + dataValidadeAtual.plusDays(diasValidade);
            LicencaCommonRN.getInstance().atualizarDataValidade(licencaPrincipal, dataValidadeAtual.plusDays(diasValidade), sessao);
            this.log.info(mensagem);
            LogSistema.escreve((String)Log.INFO, (String)mensagem);
            this.mapLicencas.put(tenant, new ValidadorLicencaWrapper());
        } else {
            String mensagemVencido = this.getMensagemServidor(MENSAGEM_VENCIDO);
            if (Util.stringNullOrEmpty((String)mensagemVencido)) {
                mensagemVencido = ControleRN.getInstance().getRegistroControle().getMensagemVencidoPLUS();
                if (Util.stringNullOrEmpty((String)mensagemVencido)) {
                    mensagemVencido = LicencaManager.MENSAGEM_VENCIDO_UNIPLUS;
                }
            } else {
                ControleRN.getInstance().atualizaMensagensPLUS(sessao, null, mensagemVencido, null);
            }
            this.log.info("Licen\u00e7a " + licencaPrincipal.getChaveAtivacao() + " exibida mensagem: " + mensagemVencido);
            this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.LICENCA_INVALIDA, mensagemVencido, false));
        }
        ValidadorLicencaWrapper validador = (ValidadorLicencaWrapper)this.mapLicencas.get(tenant);
        if (validador != null) {
            if (validador.getStatusLicenca() == StatusLicenca.OK) {
                List cnpjs = FilialRN.getInstance().buscarCNPJFiliais();
                for (String cnpj : cnpjs) {
                    if (Util.isCnpjFilhoDe((String)cnpj, (String)licencaPrincipal.getCnpj()) || LicencaManager.getInstance().contemLicencaPorCNPJ(ProdutoLicenca.MULTICNPJ, cnpj) || LicencaManager.getInstance().contemLicencaPorCNPJ(ProdutoLicenca.MULTIEMPRESA, cnpj)) continue;
                    this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.LICENCA_INVALIDA, "Filial com CNPJ " + cnpj + " n\u00e3o \u00e9 uma filial da licen\u00e7a principal. Voc\u00ea precisa de uma licen\u00e7a de Multi-Empresa.", false));
                    return;
                }
                try {
                    LicencaRN.getInstance().validarCNPJLicencasFiliaisWeb(sessao);
                }
                catch (UnicoMensagemUsuarioException ex) {
                    this.log.warn("Licen\u00e7a inv\u00e1lida - Chave: " + licencaPrincipal.getChaveAtivacao(), (Throwable)ex);
                    this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.LICENCA_INVALIDA, ex.getMensagemSemCodigoDeErro(), false));
                    return;
                }
                if (licencaPrincipal.getDataFimDegustacao() != null) {
                    String strDegustacao = "O sistema est\u00e1 em degusta\u00e7\u00e3o at\u00e9 " + Util.formataDataHora((Temporal)licencaPrincipal.getDataFimDegustacao(), (String)"dd/MM/yyyy");
                    int diasDegustacao = Util.getDiferencaEmDias((LocalDate)DataHoraFactory.getData(), (LocalDate)licencaPrincipal.getDataFimDegustacao());
                    this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.MENSAGEM_ADVERTENCIA, strDegustacao, true, 0, diasDegustacao));
                } else {
                    List licencas = LicencaCommonRN.getInstance().getLicencasInstaladas();
                    Optional<Licenca> licencaComDegustacao = licencas.stream().filter(lic -> !lic.getProdutoLicenca().isBase() && lic.getDataFimDegustacao() != null).findFirst();
                    if (licencaComDegustacao.isPresent()) {
                        String strDegustacao = "O sistema possui licen\u00e7a em degusta\u00e7\u00e3o at\u00e9 " + Util.formataDataHora((Temporal)licencaComDegustacao.get().getDataFimDegustacao(), (String)"dd/MM/yyyy");
                        int diasDegustacao = Util.getDiferencaEmDias((LocalDate)DataHoraFactory.getData(), (LocalDate)licencaComDegustacao.get().getDataFimDegustacao());
                        this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.MENSAGEM_ADVERTENCIA, strDegustacao, true, 0, diasDegustacao));
                    }
                }
                this.validarPeriodoSemConexao(licencaPrincipal, tenant);
            }
        } else {
            this.log.error("Rotina de valida\u00e7\u00e3o de licen\u00e7as incorretas pois n\u00e3o entrou em nenhuma valida\u00e7\u00e3o. Licen\u00e7a: " + licencaPrincipal.getChaveAtivacao());
            throw new UnicoException("WWW373", "N\u00e3o foi poss\u00edvel validar as licen\u00e7as.");
        }
    }

    private void atualizarFiliaisComInformacaoWebService(List<RetornoIsItOkFilial> retornoIsItOkFiliais) throws UnicoMensagemUsuarioException {
        if (!Util.listNullOrEmpty(retornoIsItOkFiliais)) {
            for (RetornoIsItOkFilial retornoIsItOkFilial : retornoIsItOkFiliais) {
                Filial filial = FilialCommonRN.getInstance().buscarQualquerFilialPorCnpj(Util.formataCpfCnpj((String)retornoIsItOkFilial.getCnpj()), retornoIsItOkFilial.getVariacaoCPF());
                if (filial == null) continue;
                filial.setDataInicioReducaoZBlocox(retornoIsItOkFilial.getDataInicioReducaoZBlocox());
                filial.setDataInicioEstoqueBlocox(retornoIsItOkFilial.getDataInicioEstoqueBlocox());
                filial.setTransmitirestoqueblocox(retornoIsItOkFilial.isTransmitirestoqueblocox());
                FilialCommonRN.getInstance().gravar(1, filial, SessaoUtil.getSessao());
            }
        }
    }

    private void validarPeriodoSemConexao(Licenca licencaPrincipal, String tenant) {
        if (licencaPrincipal != null && licencaPrincipal.getProdutoLicenca().in(new AbstractEnum[]{ProdutoLicenca.UNIPLUS_START, ProdutoLicenca.UNIPLUS})) {
            if (LicencaManager.getInstance().isLicencaLocal(licencaPrincipal.getChaveAtivacao())) {
                return;
            }
            Familia familia = licencaPrincipal.getFamilia();
            LocalDate expiracao = licencaPrincipal.getDataValidade().plusDays(familia.getDiasAposVencimentoParaExpirarLicenca());
            LocalDate ultimaConsulta = licencaPrincipal.getDataUltimaConsulta();
            LocalDate hoje = DataHoraFactory.getData();
            if (ultimaConsulta == null) {
                if (hoje.compareTo(expiracao) > 0) {
                    this.log.info("Data do computador maior que a expira\u00e7\u00e3o da licen\u00e7a - " + licencaPrincipal.getChaveAtivacao());
                    this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.LICENCA_INVALIDA, "Sua licen\u00e7a de utiliza\u00e7\u00e3o do sistema est\u00e1 inv\u00e1lida. Por favor verifique", false));
                }
            } else if (hoje.compareTo(ultimaConsulta) < 0 || hoje.compareTo(expiracao) > 0) {
                this.log.info("Data do computador menor que a data da \u00faltima consulta ou maior que a expira\u00e7\u00e3o da licen\u00e7a - " + licencaPrincipal.getChaveAtivacao());
                this.mapLicencas.put(tenant, new ValidadorLicencaWrapper(StatusLicenca.LICENCA_INVALIDA, "Sua licen\u00e7a de utiliza\u00e7\u00e3o do sistema est\u00e1 inv\u00e1lida. Por favor verifique", false));
            }
        }
    }

    protected String logarUnicoException() {
        return "Falha ao validar as licen\u00e7as";
    }

    private int getNumeroUsuariosSistema() {
        int usuarios = this.licencaService.getDadosLicenca().getNumeroUsuariosServidor() > 0 ? this.licencaService.getDadosLicenca().getNumeroUsuariosServidor() : this.licencaService.getDadosLicenca().getNumeroUsuariosLicenca();
        Licenca licencaPrincipal = LicencaCommonRN.getInstance().buscarLicencaPrincipal();
        if (licencaPrincipal != null) {
            List listaLocacaoPDV;
            Integer usuariosTemporarios = (Integer)licencaPrincipal.getListaQuantidadeUsuarioTemporarios().get(DataHoraFactory.getData());
            if (usuariosTemporarios == null) {
                usuariosTemporarios = 0;
            }
            usuarios += usuariosTemporarios.intValue();
            if (!LicencaManager.getInstance().isLicencaLocal(licencaPrincipal.getChaveAtivacao()) && (listaLocacaoPDV = (List)licencaPrincipal.getListaLocacaoPDV().get(DataHoraFactory.getData())) != null) {
                usuarios -= listaLocacaoPDV.size();
            }
        }
        return usuarios;
    }

    private void limparCacheSistema() {
        Stream.of(TipoCache.values()).forEach(tipoCache -> this.cacheService.removerCache(tipoCache.getId()));
        this.cacheService.clear();
    }

    private void recarregarLicencasCache() {
        this.licencaService.getSistema();
        this.licencaService.getDadosLicenca();
    }
}

