/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.schedulers;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.cron.Cron;
import br.intelidata.commons.domain.pojo.ConfiguracaoScanntech;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoScanntechCommonRN;
import br.intelidata.commons.modulo.pdv.promocaoscanntech.upload.EnvioDadosScanntech;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.client.schedulers.AbstractPrepareScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScanntechEnvioOperacoesWebScheduler
extends AbstractPrepareScheduler {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FuncionalidadeService funcionalidadeService = (FuncionalidadeService)BeanUtil.getBean((String)"funcionalidadeService");

    public ScanntechEnvioOperacoesWebScheduler() {
        super("Scanntech (Envio de Opera\u00e7\u00f5es)", Cron.every30minutes(), TipoJob.SCANNTECH_ENVIO_OPERACOES_WEB);
    }

    public void execute() throws Exception {
        ConfiguracaoScanntech configuracao = ConfiguracaoScanntechCommonRN.getInstance().buscar(true);
        if (configuracao != null) {
            Sessao sessao = SessaoUtil.getSessaoSistema();
            this.log.info("Scanntech (Envio de Opera\u00e7\u00f5es) do tenant: " + this.getTask().getTenant());
            new EnvioDadosScanntech(sessao, configuracao).enviarDados();
            this.log.info("Scanntech (Envio de Opera\u00e7\u00f5es) completada para o tenant: " + this.getTask().getTenant());
        }
    }

    public void onFailure(Exception ex) {
    }

    public boolean isAtivo() {
        return this.funcionalidadeService.isAtiva(Funcionalidade.SCANNTECH);
    }

    public boolean abstractControlTransaction() {
        return false;
    }
}

