/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.client.thread;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.JobExecutorFile;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.modulo.cadastros.regranegocio.JobExecutorFileRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.thread.JobPersistent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.activation.DataSource;

public abstract class AbstractJobEmail_remover
extends JobPersistent {
    private final boolean gravarAnexoEmBanco;

    protected AbstractJobEmail_remover(TipoJob tipoJob, String nome, String detalhes, String parametros, String tenant, Long idUsuario, Long idFilial, boolean gravarAnexoEmBanco, boolean recreate) throws UnicoMensagemUsuarioException {
        super(nome, tipoJob, null, parametros, detalhes, tenant, idUsuario, idFilial, recreate, !gravarAnexoEmBanco, null);
        this.gravarAnexoEmBanco = gravarAnexoEmBanco;
    }

    protected List<DataSource> getRecuperarAnexos() throws UnicoMensagemUsuarioException {
        return this.getRecuperarAnexos(null);
    }

    protected List<DataSource> getRecuperarAnexos(String uuid) throws UnicoMensagemUsuarioException {
        ArrayList<DataSource> anexos = new ArrayList<DataSource>();
        List files = !StringUtil.stringNullOrEmpty((String)uuid) ? JobExecutorFileRN.getInstance().getArquivosPorIdJobExecutor(this.getJobId(), uuid) : JobExecutorFileRN.getInstance().getArquivosPorIdJobExecutor(this.getJobId());
        if (!ListMapUtil.listNullOrEmpty((List)files)) {
            for (JobExecutorFile f : files) {
                if (f.getArquivo() != null) {
                    anexos.addAll(FileUtil.extrairArquivos((InputStream)new ByteArrayInputStream(f.getArquivo())));
                } else if (!StringUtil.stringNullOrEmpty((String)f.getUrl())) {
                    try {
                        StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");
                        if (storageService.isFileServer()) {
                            File file = new File(f.getUrl());
                            if (file.exists()) {
                                anexos.addAll(FileUtil.extrairArquivos((InputStream)new FileInputStream(file)));
                            }
                        } else {
                            InputStream arquivo = new URL(f.getUrl()).openStream();
                            anexos.addAll(FileUtil.extrairArquivos((InputStream)arquivo));
                        }
                    }
                    catch (IOException ex) {
                        throw new UnicoMensagemUsuarioException("WWW346", "N\u00e3o foi poss\u00edvel anexar os arquivos no e-mail.");
                    }
                }
                JobExecutorFileRN.getInstance().excluir((AbstractPojo)f, this.getSessao());
            }
        }
        return anexos;
    }

    protected void gravarArquivo(DataSource[] anexos, String uuid) throws UnicoMensagemUsuarioException {
        if (anexos != null) {
            JobExecutorFile jobFile = new JobExecutorFile();
            jobFile.setIdJobExecutor(this.getJobId());
            byte[] arquivo = FileUtil.montaZipFile((DataSource[])anexos);
            if (this.gravarAnexoEmBanco) {
                jobFile.setArquivo(arquivo);
                jobFile.setUuid(uuid);
            } else {
                StorageService storageService = (StorageService)BeanUtil.getBean((String)"storageService");
                try {
                    File file = File.createTempFile("Anexos_email", ".zip");
                    file.deleteOnExit();
                    try (FileOutputStream fileoutputstream = new FileOutputStream(file);){
                        fileoutputstream.write(arquivo);
                    }
                    jobFile.setUrl(storageService.saveFile(super.getTenant(), TipoArquivoArmazenado.JobExecutor, file, false, null, true));
                }
                catch (IOException ex) {
                    throw new UnicoMensagemUsuarioException("WWW347", "N\u00e3o foi poss\u00edvel criar os arquivos tempor\u00e1rios para anexo.");
                }
            }
            JobExecutorFileRN.getInstance().incluir((AbstractPojo)jobFile, super.getSessao());
            if (!this.getConnectionHandler().isAutoCommit()) {
                this.getConnectionHandler().commitAndContinue();
            }
        }
    }
}

