/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.apuracaoimposto;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoEmissaoNotaFiscal;
import br.intelidata.commons.domain.pojo.fiscal.ApuracaoImposto;
import br.intelidata.commons.domain.pojo.fiscal.ApuracaoImpostoItem;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.sped.regranegocio.ApuracaoImpostoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/apuracoes-impostos"})
@SubMenuMapping(MENU="SubMenuPainelContadorLancamentos", NOME="Apura\u00e7\u00e3o de impostos - Sped", ICONE="icon-funcoes-auxiliares", ROTA="/speds/apuracoes-impostos", PROGRAMA=1102)
public class ApuracaoImpostoCrudController
extends CrudController<ApuracaoImposto, ApuracaoImpostoRN> {
    public ApuracaoImpostoCrudController() {
        super((AbstractRegraNegocio)ApuracaoImpostoRN.getInstance(), ApuracaoImposto::new, true, true);
        this.setItemSupplier(ApuracaoImpostoItem::new);
    }

    protected String getCacheId() {
        return "apuracoes-impostos";
    }

    protected GridBuilder<ApuracaoImpostoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("anoMes", "Per\u00edodo", 0, true));
        GridBuilder grid = new GridBuilder(ApuracaoImpostoRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial", "idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        grid.addOrdemDefault(new Ordem("anoMes", true));
        return grid;
    }

    @RequestMapping(value={"/validar-notafiscal-item-adicional"})
    @DBAutoCommit
    public void validarNotaFiscal(@RequestParam Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNotaFiscal);
        if (notaFiscal != null) {
            if (notaFiscal.getSerie().equals(ModeloNotaFiscal.NOTA_FISCAL_ELETRONICA.getId()) && !notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFE_AUTORIZADA) && TipoEmissaoNotaFiscal.PROPRIA.equals((Object)notaFiscal.getTipoEmissao())) {
                throw new UnicoMensagemUsuarioException("WNTF9347", "NF-e referenciada n\u00e3o est\u00e1 autorizada!");
            }
            if (notaFiscal.getSerie().equals(ModeloNotaFiscal.NOTA_FISCAL_ELETRONICA.getId()) && Util.stringNullOrEmpty((String)notaFiscal.getChaveNfe())) {
                throw new UnicoMensagemUsuarioException("WNTF9349", "A nota fiscal que voc\u00ea est\u00e1 tentando referenciar n\u00e3o possui chave de acesso!");
            }
        }
    }
}

