/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.comissaovendedormanutencao;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.Serie;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.TipoDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoComissao;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoComboBox;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimentoComissao;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.financeiro.ComissaoVendedor;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.modulo.comissao.regranegocio.ComissaoVendedorRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.TipoDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.SerieRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.comissaovendedormanutencao.ComissaoVendedorManutencao;
import br.intelidata.uniplusweb.web.rest.app.crud.comissaovendedormanutencao.ComissaoVendedorManutencaoWrapper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/comissao-vendedor-manutencao"})
@SubMenuMapping(MENU="SubMenuFinanceiroComissao", NOME="Manuten\u00e7\u00e3o de comiss\u00f5es", ICONE="icon-imprimir", ROTA="/financeiros/comissao-vendedor-manutencao", PROGRAMA=427)
public class ComissaoVendedorManutencaoSimpleController
extends SimpleController {
    @RequestMapping(value={"/pesquisar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ComissaoVendedorManutencao> buscarComissaoVendedor(@RequestBody ComissaoVendedorManutencaoWrapper comissao) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)comissao.getIdVendedor())) {
            throw new UnicoMensagemUsuarioException("WCMS14", "Vendedor n\u00e3o informado!");
        }
        List listaComissoes = ComissaoVendedorRN.getInstance().buscaComissoesParaManutencao(comissao.getIdVendedor(), comissao.getPeriodoInicial(), comissao.getPeriodoFinal(), comissao.getIdsFiliais(), comissao.isMostrarValoresZerados());
        if (Util.listNullOrEmpty((List)listaComissoes)) {
            throw new UnicoMensagemUsuarioException("WCMS13", "N\u00e3o h\u00e1 dados!");
        }
        ArrayList<ComissaoVendedorManutencao> comissoes = new ArrayList<ComissaoVendedorManutencao>();
        for (ComissaoVendedor comissaoVendedor : listaComissoes) {
            comissoes.add(new ComissaoVendedorManutencao(comissaoVendedor));
        }
        return comissoes;
    }

    @RequestMapping(value={"/gravar-manutencao"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarManutencaoComissaoVendedor(@RequestBody ComissaoVendedor comissaoVendedor, @RequestParam String documento, @RequestParam String serie, @RequestParam boolean isTransferencia, @RequestParam TipoDocumentoComboBox tipoDocumento, @RequestParam Long idVendedor) throws UnicoMensagemUsuarioException {
        if (isTransferencia) {
            ComissaoVendedor comissaoDebito = this.getComissaoVendedor(comissaoVendedor, documento, serie, tipoDocumento, true, true, idVendedor);
            ComissaoVendedor comissaoCredito = this.getComissaoVendedor(comissaoVendedor, documento, serie, tipoDocumento, false, true, idVendedor);
            ComissaoVendedorRN.getInstance().incluir((AbstractPojo)comissaoDebito, SessaoUtil.getSessao());
            ComissaoVendedorRN.getInstance().incluir((AbstractPojo)comissaoCredito, SessaoUtil.getSessao());
        } else {
            ComissaoVendedor comissao = this.getComissaoVendedor(comissaoVendedor, documento, serie, tipoDocumento, false, false, idVendedor);
            if (NumberUtil.longNullOuZero((Long)comissao.getId())) {
                ComissaoVendedorRN.getInstance().incluir((AbstractPojo)comissao, SessaoUtil.getSessao());
            } else {
                ComissaoVendedorRN.getInstance().alterar((AbstractPojo)comissao, SessaoUtil.getSessao());
            }
        }
    }

    @RequestMapping(value={"/comissao-excluir"})
    @DBAutoCommit
    public void excluirComissao(@RequestParam Long idComissao) throws UnicoMensagemUsuarioException {
        ComissaoVendedor comissao = (ComissaoVendedor)ComissaoVendedorRN.getInstance().buscarPorId(idComissao);
        ComissaoVendedorRN.getInstance().excluir((AbstractPojo)comissao, SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/baixar-comissao"}, method={RequestMethod.POST})
    @DBTransaction
    public void baixarComissao(@RequestBody ComissaoVendedorManutencaoWrapper comissaoWrapper) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty((List)comissaoWrapper.getComissoes())) {
            throw new UnicoMensagemUsuarioException("WCMS39", "N\u00e3o h\u00e1 dados para gerar o documento financeiro.");
        }
        if (NumberUtil.longNullOuZero((Long)comissaoWrapper.getIdTipoDocumento())) {
            throw new UnicoMensagemUsuarioException("WWW508", "Informe o tipo de documento");
        }
        if (comissaoWrapper.getEmissao() == null) {
            throw new UnicoMensagemUsuarioException("WWW509", "Informe a data de emiss\u00e3o");
        }
        if (comissaoWrapper.getVencimento() == null) {
            throw new UnicoMensagemUsuarioException("WWW510", "Informe a data de vencimento");
        }
        TipoDocumentoFinanceiro tipoDocumento = TipoDocumentoFinanceiroRN.getInstance().buscarPorId(comissaoWrapper.getIdTipoDocumento());
        ComissaoVendedorRN.getInstance().geraDuplicataPagarDasComissoes(SessaoUtil.getSessao(), comissaoWrapper.getComissoes(), comissaoWrapper.getIdVendedor(), comissaoWrapper.getPeriodoInicial(), comissaoWrapper.getPeriodoFinal(), tipoDocumento, comissaoWrapper.getEmissao(), comissaoWrapper.getVencimento(), comissaoWrapper.getIdsFiliais());
    }

    private ComissaoVendedor getComissaoVendedor(ComissaoVendedor comissao, String documento, String serieDoc, TipoDocumentoComboBox tipoDocumento, boolean origem, boolean isTransferencia, Long idVendedor) throws UnicoMensagemUsuarioException {
        Long idCupomFiscal = null;
        Long idNotaFiscal = null;
        Long idFinanceiro = null;
        if (tipoDocumento.equals((Object)TipoDocumentoComboBox.CUPOM_FISCAL)) {
            int coo;
            int pdv;
            try {
                pdv = Integer.parseInt(serieDoc.trim());
            }
            catch (NumberFormatException e) {
                pdv = 0;
            }
            try {
                coo = Integer.parseInt(documento.trim());
            }
            catch (NumberFormatException ex) {
                coo = 0;
            }
            if (coo > 0) {
                Operacao operacao = OperacaoRN.getInstance().getObjetoPorPdvCooFilial(Integer.valueOf(pdv), Integer.valueOf(coo), SessaoUtil.getSessao().getFilial().getCodigo());
                if (operacao == null) {
                    throw new UnicoMensagemUsuarioException("WCMS17", "Cupom fiscal n\u00e3o encontrado! Verifique.");
                }
                idCupomFiscal = operacao.getId();
            }
        } else if (tipoDocumento.equals((Object)TipoDocumentoComboBox.NOTA_FISCAL)) {
            Long idSerie = Long.parseLong(serieDoc);
            Serie serie = null;
            if (!Util.longNullOuZero((Long)idSerie)) {
                serie = (Serie)SerieRN.getInstance().buscarPorId(idSerie);
            }
            if (serie != null || documento != null) {
                NotaFiscal notaFiscal = null;
                if (serie != null && documento != null) {
                    notaFiscal = NotaFiscalRN.getInstance().buscarPorNumeroModeloSerieIdFilial(documento, serie.getCodigo(), serie.getModelo(), SessaoUtil.getSessao().getIdFilial(), TipoNotaFiscal.SAIDA);
                }
                if (notaFiscal == null) {
                    throw new UnicoMensagemUsuarioException("WCMS18", "Nota fiscal n\u00e3o encontrada! Verifique.");
                }
                idNotaFiscal = notaFiscal.getId();
            }
        } else if (tipoDocumento.equals((Object)TipoDocumentoComboBox.NFCE)) {
            if (documento != null || serieDoc != null) {
                Operacao operacao = null;
                if (documento != null && serieDoc != null) {
                    operacao = OperacaoRN.getInstance().getObjetoPorNFCESerieFilial(documento, serieDoc, SessaoUtil.getSessao().getFilial().getCodigo());
                }
                if (operacao == null) {
                    throw new UnicoMensagemUsuarioException("WCMS49", "NFC-e n\u00e3o encontrado! Verifique.");
                }
                idCupomFiscal = operacao.getId();
            }
        } else if (tipoDocumento.equals((Object)TipoDocumentoComboBox.SAT) && (documento != null || serieDoc != null)) {
            Operacao operacao = null;
            if (documento != null && serieDoc != null) {
                operacao = OperacaoRN.getInstance().getObjetoPorSATSerieFilial(documento, serieDoc, SessaoUtil.getSessao().getFilial().getCodigo());
            }
            if (operacao == null) {
                throw new UnicoMensagemUsuarioException("WCMS50", "SAT n\u00e3o encontrado! Verifique.");
            }
            idCupomFiscal = operacao.getId();
        }
        if (comissao.getDataMovimento() == null) {
            throw new UnicoMensagemUsuarioException("WCMS19", "Data de movimento n\u00e3o foi informada! Verifique.");
        }
        if (Util.bigDecimalNullOrZero((BigDecimal)comissao.getValorComissao())) {
            throw new UnicoMensagemUsuarioException("WCMS20", "Valor da comiss\u00e3o n\u00e3o informado! Verifique.");
        }
        ComissaoVendedor comissaoVendedor = new ComissaoVendedor();
        comissaoVendedor.setId(comissao.getId());
        comissaoVendedor.setDataMovimento(comissao.getDataMovimento());
        comissaoVendedor.setIdCupomFiscal(idCupomFiscal);
        comissaoVendedor.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        comissaoVendedor.setIdFinanceiro(idFinanceiro);
        comissaoVendedor.setIdNotaFiscal(idNotaFiscal);
        comissaoVendedor.setTipoComissao(TipoComissao.MANUAL);
        comissaoVendedor.setObservacao(comissao.getObservacao());
        comissaoVendedor.setValorComissao(comissao.getValorComissao());
        if (isTransferencia) {
            comissaoVendedor.setIdVendedor(origem ? idVendedor : comissao.getIdVendedor());
            comissaoVendedor.setTipoMovimento(origem ? TipoMovimentoComissao.DEBITO : TipoMovimentoComissao.CREDITO);
        } else {
            comissaoVendedor.setIdVendedor(idVendedor);
            comissaoVendedor.setTipoMovimento(comissao.getTipoMovimento());
            comissaoVendedor.setValorAbatimentos(comissao.getValorAbatimentos());
            comissaoVendedor.setValorBaseCalculo(comissao.getValorBaseCalculo());
        }
        return comissaoVendedor;
    }
}

