/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conciliacaofinanceira;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.MapResultSet;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.fiscal.ConciliacaoFinanceira;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.fiscal.ConciliacaoFinanceiraDetalheRN;
import br.intelidata.commons.domain.regranegocio.fiscal.ConciliacaoFinanceiraRN;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.conciliacaofinanceira.ExclusaoConciliacaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.conciliacaofinanceira.FiltroConciliacaoWrapper;
import java.io.File;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/conciliacao-financeira"})
@SubMenuMapping(MENU="SubMenuFiscalGeral", NOME="Concilia\u00e7\u00f5es financeiras eletr\u00f4nicas - ECONF", ICONE="icon-e-moeda", ROTA="/notas-fiscais/conciliacao-financeira", PROGRAMA=1129)
public class ConciliacaoFinanceiraCrudController
extends CrudController<ConciliacaoFinanceira, ConciliacaoFinanceiraRN> {
    public ConciliacaoFinanceiraCrudController() {
        super((AbstractRegraNegocio)ConciliacaoFinanceiraRN.getInstance(), ConciliacaoFinanceira::new, true, true);
    }

    protected String getCacheId() {
        return "conciliacao-financeira";
    }

    protected GridBuilder<?> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("data", "Data", 200, true));
        colunas.add(new ColunaSQL("documento", "Documento", 200, true));
        colunas.add(new ColunaSQL("serie", "S\u00e9rie", 200, true));
        colunas.add(new ColunaSQL("modelo", "Modelo", 200, true));
        colunas.add(new ColunaSQL("chaveacesso", "Chave", 500, true));
        colunas.add(new ColunaSQL("status", "Status", 200, true));
        colunas.add(new ColunaSQL("mensagemretorno", "Retorno", 500, true));
        GridBuilder grid = new GridBuilder(((ConciliacaoFinanceiraRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idfilial", "idfilial"));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        grid.addReferenciaDefault(new Referencia("data", "datahorafiltro"));
        grid.addCondicao(new Condicao("datahorafiltro", Operador.MAIOR_IGUAL_QUE, DataHoraFactory.getDataHora().with(TemporalAdjusters.firstDayOfMonth()).withHour(0).withMinute(0).withSecond(0).withNano(0)));
        grid.addCondicao(new Condicao("datahorafiltro", Operador.MENOR_IGUAL_QUE, DataHoraFactory.getDataHora().with(TemporalAdjusters.lastDayOfMonth()).withHour(23).withMinute(59).withSecond(59)));
        grid.addOrdemDefault(new Ordem("datahorafiltro", true));
        return grid;
    }

    protected void beforeRead(ConciliacaoFinanceira conciliacaoFinanceira, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Operacao op;
        if (!NumberUtil.longNullOuZero((Long)conciliacaoFinanceira.getIdNotaFiscal())) {
            NotaFiscal nota = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(conciliacaoFinanceira.getIdNotaFiscal());
            if (nota != null) {
                conciliacaoFinanceira.setNumeroNfe(nota.getNumeroNotaFiscal() + "/" + nota.getModelo() + " - " + nota.getRazaoSocial());
            }
        } else if (!NumberUtil.longNullOuZero((Long)conciliacaoFinanceira.getIdOperacao()) && (op = (Operacao)OperacaoRN.getInstance().buscarPorId(conciliacaoFinanceira.getIdOperacao())) != null) {
            conciliacaoFinanceira.setNumeroNfce(op.getNumeroNfce() + "/" + op.getSerieNfce() + " - " + op.getConsumidorNome());
        }
        conciliacaoFinanceira.setDetalhes(ConciliacaoFinanceiraDetalheRN.getInstance().buscarListaPorConciliacao(conciliacaoFinanceira.getId()));
    }

    @RequestMapping(value={"/filtrar-notas"})
    @DBAutoCommit
    public List<FiltroConciliacaoWrapper> filtraNotaFiscal(@RequestParam boolean isNfe, @RequestParam LocalDate inicio, @RequestParam LocalDate fim) {
        String cliente;
        String valor;
        String data;
        String modelo;
        String serie;
        String numero;
        List result;
        Sessao sessao = SessaoUtil.getSessao();
        if (isNfe) {
            result = NotaFiscalRN.getInstance().buscaNotasFiscaisConciliacao(sessao.getIdFilial(), inicio, fim);
            numero = "numeronotafiscal";
            serie = "modelo";
            modelo = "serie";
            data = "emissao";
            valor = "valortotalnota";
            cliente = "razaosocial";
        } else {
            result = OperacaoRN.getInstance().buscarOperacaoConciliacao(sessao, inicio, fim);
            numero = "numeronfce";
            serie = "serienfce";
            modelo = "modelonfce";
            data = "data";
            valor = "valorliquido";
            cliente = "consumidornome";
        }
        ArrayList<FiltroConciliacaoWrapper> filtros = new ArrayList<FiltroConciliacaoWrapper>();
        for (MapResultSet map : result) {
            FiltroConciliacaoWrapper filtro = new FiltroConciliacaoWrapper();
            filtro.setId((Long)map.get("id"));
            filtro.setNumero((String)map.get(numero));
            filtro.setEmissao((LocalDate)map.get(data));
            filtro.setModelo((String)map.get(modelo));
            filtro.setSerie((String)map.get(serie));
            filtro.setValor((BigDecimal)map.get(valor));
            filtro.setCliente((String)map.get(cliente));
            filtros.add(filtro);
        }
        return filtros;
    }

    @RequestMapping(value={"/transmitir"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void transmitir(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        NfeManagerWeb nfeManagerWeb = new NfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyConciliacaoNow(mensagem));
        nfeManagerWeb.enviarConciliacaoFinanceira(id);
    }

    @RequestMapping(value={"/cancelar"})
    @DBAutoCommit
    public void cancelar(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        NfeManagerWeb nfeManagerWeb = new NfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyConciliacaoNow(mensagem));
        nfeManagerWeb.cancelarConciliacaoFinanceira(id);
    }

    @RequestMapping(value={"/download-xml"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> downloadXml(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        ConciliacaoFinanceira conciliacao = (ConciliacaoFinanceira)ConciliacaoFinanceiraRN.getInstance().buscarPorId(id);
        if (conciliacao != null) {
            HashMap<String, byte[]> mapArquivos = new HashMap<String, byte[]>();
            String arquivo = null;
            if (conciliacao.getXmlAutorizacao() != null) {
                arquivo = "/" + conciliacao.getChaveAcesso() + "-" + Util.zeroEsquerda((Object)conciliacao.getSequencia(), (int)3) + "-econf.xml";
                mapArquivos.put(arquivo, conciliacao.getXmlAutorizacao());
            }
            if (conciliacao.getXmlCancelamento() != null) {
                String arquivoCan = "/" + conciliacao.getChaveAcesso() + "-" + Util.zeroEsquerda((Object)conciliacao.getSequencia(), (int)3) + "-canc-econf.xml";
                mapArquivos.put(arquivoCan, conciliacao.getXmlCancelamento());
            }
            if (mapArquivos.size() == 1) {
                return this.responseEntityService.createXMLResponse((byte[])mapArquivos.get(arquivo), arquivo);
            }
            File file = FileUtil.montaZipFilePorByte(mapArquivos, (String)"Xmls da conciliacao ".concat(conciliacao.getChaveAcesso()).concat(".zip"));
            return this.responseEntityService.createZIPResponse(FileUtil.file2ByteArray((File)file), "Xmls da conciliacao ".concat(conciliacao.getChaveAcesso()));
        }
        return null;
    }

    @RequestMapping(value={"/validar-exclusao"})
    @DBAutoCommit
    public ExclusaoConciliacaoWrapper validarExclusao(@RequestParam Long id) {
        ConciliacaoFinanceira conciliacao = (ConciliacaoFinanceira)ConciliacaoFinanceiraRN.getInstance().buscarPorId(id);
        ExclusaoConciliacaoWrapper exclusaoConciliacao = new ExclusaoConciliacaoWrapper();
        if (conciliacao != null) {
            exclusaoConciliacao.setPermiteCancelar(conciliacao.getStatus().isPodeCancelar());
            exclusaoConciliacao.setPermiteExcluir(conciliacao.getStatus().isPodeExcluir());
        }
        return exclusaoConciliacao;
    }
}

