/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.conhecimentotransporte.conhecimentotransporteentradanota;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ConhecimentoEntradaNota;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.conhecimento.regranegocio.ConhecimentoEntradaNotaRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/conhecimentos-transporte-entrada-notas"})
public class ConhecimentoTransporteEntradaNotaCrudController
extends CrudController<ConhecimentoEntradaNota, ConhecimentoEntradaNotaRN> {
    public ConhecimentoTransporteEntradaNotaCrudController() {
        super((AbstractRegraNegocio)ConhecimentoEntradaNotaRN.getInstance(), ConhecimentoEntradaNota::new, true, true);
    }

    @RequestMapping(value={"/buscar-nota-conhecimento-entrada"})
    @DBAutoCommit
    public ConhecimentoEntradaNota buscarNota(@RequestParam String numero, @RequestParam String modelo, @RequestParam String serie, @RequestParam Long idEntidade) throws UnicoMensagemUsuarioException {
        String nomeEntidade = EntidadeRN.getInstance().buscarNomeEntidadePorIdWeb(idEntidade);
        if (Util.stringNullOrEmpty((String)nomeEntidade)) {
            throw new UnicoMensagemUsuarioException("WCNT108", "Cliente/Fornecedor n\u00e3o encontrado");
        }
        NotaFiscal notaFiscal = NotaFiscalRN.getInstance().buscarNota(numero, modelo, serie, SessaoUtil.getSessao().getIdFilial(), idEntidade);
        if (notaFiscal == null) {
            throw new UnicoMensagemUsuarioException("WCNT109", "Nota fiscal n\u00e3o encontrada.");
        }
        ConhecimentoEntradaNota conhecimentoEntradaNota = new ConhecimentoEntradaNota();
        conhecimentoEntradaNota.setIdNotaFiscal(notaFiscal.getId());
        conhecimentoEntradaNota.setIdClienteFornecedor(idEntidade);
        conhecimentoEntradaNota.setNomeClienteFornecedor(nomeEntidade);
        conhecimentoEntradaNota.setNumeroNotaFiscal(numero);
        conhecimentoEntradaNota.setModelo(modelo);
        conhecimentoEntradaNota.setSerie(serie);
        conhecimentoEntradaNota.setEmissaoEntrada(notaFiscal.getEmissao());
        conhecimentoEntradaNota.setValor(notaFiscal.getValorTotalNota());
        conhecimentoEntradaNota.setNotaEntrada(notaFiscal.getTipoDocumento().equals((Object)TipoNotaFiscal.ENTRADA));
        return conhecimentoEntradaNota;
    }

    protected String getCacheId() {
        return "conhecimentos-transporte-entrada-notas";
    }

    protected GridBuilder<ConhecimentoEntradaNotaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idNotaFiscal", "id nota fiscal", 0, false));
        colunas.add(new ColunaSQL("numeroNotaFiscal", "numeroNotaFiscal", "N\u00famero", 30, true, new String[]{"fk_conhecentrada_conhec"}));
        colunas.add(new ColunaSQL("modelo", "modelo", "S\u00e9rie", 10, true, new String[]{"fk_conhecentrada_conhec"}));
        colunas.add(new ColunaSQL("cfopConhecimentoTransporte", "cfopConhecimentoTransporte", "CFOP", 10, true, new String[]{"fk_conhecentrada_conhec"}));
        colunas.add(new ColunaSQL("entradaSaida", "entradaSaida", "Data emiss\u00e3o", 20, true, new String[]{"fk_conhecentrada_conhec"}));
        colunas.add(new ColunaSQL("emissao", "emissao", "Data entrada", 20, true, new String[]{"fk_conhecentrada_conhec"}));
        colunas.add(new ColunaSQL("razaoSocial", "razaoSocial", "Transportadora", 300, true, new String[]{"fk_conhecentrada_conhec"}));
        colunas.add(new ColunaSQL("valorTotalNota", "valorTotalNota", "Valor documento", 50, true, new String[]{"fk_conhecentrada_conhec"}));
        GridBuilder grid = new GridBuilder(ConhecimentoEntradaNotaRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("tipodocumento", "tipodocumento", new String[]{"fk_conhecentrada_conhec"}));
        grid.addCodicaoDefault(new Condicao("tipodocumento", Operador.IGUAL, "CT"));
        grid.addReferenciaDefault(new Referencia("idfilial", "idfilial", new String[]{"fk_conhecentrada_conhec"}));
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getFilial().getId()));
        grid.setDistinct(true);
        return grid;
    }

    public Long create(ConhecimentoEntradaNota conhecimentoEntradaNota, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW249", "Inclus\u00e3o n\u00e3o implementada para este objeto");
    }

    public Long update(ConhecimentoEntradaNota conhecimentoEntradaNota, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW250", "Altera\u00e7\u00e3o n\u00e3o implementada para este objeto");
    }

    public void delete(Long id) throws UnicoMensagemUsuarioException {
        throw new UnicoMensagemUsuarioException("WWW251", "Exclusao nao implementada para este objeto");
    }
}

