/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contabilidades.contascontabeis;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.contabil.CodigoReduzidoContaContabilGrupo;
import br.intelidata.commons.domain.pojo.contabil.ConfiguracaoContabilidade;
import br.intelidata.commons.domain.pojo.contabil.ContaContabil;
import br.intelidata.commons.domain.pojo.contabil.ExercicioContabil;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimentoPlanoContas;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.contabilidade.enums.SistemaContabilEnum;
import br.intelidata.commons.modulo.contabilidade.regranegocio.CodigoReduzidoContaContabilGrupoRN;
import br.intelidata.commons.modulo.contabilidade.regranegocio.ConfiguracaoContabilidadeRN;
import br.intelidata.commons.modulo.contabilidade.regranegocio.ContaContabilRN;
import br.intelidata.commons.modulo.contabilidade.regranegocio.ExercicioContabilRN;
import br.intelidata.commons.modulo.contabilidade.regranegocio.integracao.UnicoIntegracaoContabilidade;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.contabilidades.contascontabeis.AuxiliarContaContabilWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public abstract class ContaContabilCrudController
extends CrudController<ContaContabil, ContaContabilRN> {
    public ContaContabilCrudController() {
        super((AbstractRegraNegocio)ContaContabilRN.getInstance(), ContaContabil::new, true, false);
    }

    @RequestMapping(value={"/importar"}, method={RequestMethod.POST})
    @DBTransaction
    public void importar(@RequestPart(value="file") MultipartFile file, @RequestPart(value="tipoSistema") SistemaContabilEnum tipo, @RequestPart(value="isSpedContabil") boolean isSpedContabil) throws UnicoMensagemUsuarioException, IOException {
        Remessa remessa = new Remessa(new Malote());
        remessa.getMalote().inclui("arquivo", file.getBytes());
        UnicoIntegracaoContabilidade integracaoContabilidade = new UnicoIntegracaoContabilidade(tipo, isSpedContabil);
        if (isSpedContabil) {
            integracaoContabilidade.importarPlanoContasContabilSped(SessaoUtil.getSessao(), remessa);
        } else {
            integracaoContabilidade.importarPlanoContasContabil(SessaoUtil.getSessao(), remessa);
        }
        this.notificationService.notifyTenantNow(NotificationType.CACHE_REFRESH, this.getCacheId());
    }

    @RequestMapping(value={"/buscar-mascara"})
    @DBAutoCommit
    public AuxiliarContaContabilWrapper carregarMascara(@RequestParam int nivelAtual, @RequestParam Long idExercicio, @RequestParam Long idContaPai, @RequestParam boolean isCreate) throws UnicoMensagemUsuarioException {
        AuxiliarContaContabilWrapper aux = new AuxiliarContaContabilWrapper();
        ConfiguracaoContabilidade configuracao = this.validaConfiguracaoPorNivel(nivelAtual, idExercicio);
        aux.setMascara(ContaContabilRN.getInstance().getMascaraExercicioContabil(nivelAtual, configuracao));
        if (isCreate) {
            ContaContabil contaPai = (ContaContabil)ContaContabilRN.getInstance().buscarPorId(idContaPai);
            ExercicioContabil exercicio = this.getExercicioContabil(idExercicio);
            String codigo = ContaContabilRN.getInstance().buscaCodigoExtenso((ContaContabil)(this.isUtilizaConfiguracaoCodigoReduzido() ? contaPai : null), exercicio.getId(), this.isUtilizaConfiguracaoCodigoReduzido() ? nivelAtual : 0, SessaoUtil.getSessao().getFilial().getIdEmpresa());
            aux.setValor(StringUtil.formatarString((String)codigo, (String)aux.getMascara()));
        }
        return aux;
    }

    @RequestMapping(value={"/validar-codigo"})
    @DBAutoCommit
    public String validarCodigo(@RequestParam String valor, @RequestParam Long idContaPai, @RequestParam int nivelAtual, @RequestParam Long idExercicio) throws UnicoMensagemUsuarioException {
        if (valor == null || valor.isEmpty()) {
            return "Informe o c\u00f3digo extenso";
        }
        ConfiguracaoContabilidade configuracao = this.validaConfiguracaoPorNivel(nivelAtual, idExercicio);
        String mascara = ContaContabilRN.getInstance().getMascaraExercicioContabil(nivelAtual, configuracao);
        ContaContabil contaPai = (ContaContabil)ContaContabilRN.getInstance().buscarPorId(idContaPai);
        ContaContabil contaGravada = ContaContabilRN.getInstance().buscaContaContabil(SessaoUtil.getSessao(), Util.limpaMascara((String)valor, (String)mascara), idExercicio);
        if (contaGravada != null && !contaGravada.getId().equals(idContaPai)) {
            return "Conta j\u00e1 existe!";
        }
        String[] valorPorNiveis = valor.split("[.]");
        for (int i = 0; i < valorPorNiveis.length; ++i) {
            String valorNivel = valorPorNiveis[i];
            int quantidadeConfiguracao = ContaContabilRN.getInstance().getQuantidadePorNivel(i + 1, configuracao);
            if (valorNivel.trim().length() == quantidadeConfiguracao) continue;
            return "C\u00f3digo inv\u00e1lido no n\u00edvel " + (i + 1);
        }
        if (!this.contaPertencePai(valor, contaPai)) {
            return "Conta inv\u00e1lida!";
        }
        return null;
    }

    @RequestMapping(value={"/validar-grupo-codigo-red"})
    @DBAutoCommit
    public String validarGripoCodReduzido(@RequestParam String valor) throws UnicoMensagemUsuarioException {
        if (valor == null || valor.isEmpty()) {
            return "Informe o grupo!";
        }
        int codigoGrupo = Integer.parseInt(valor);
        if (codigoGrupo < 0 || codigoGrupo > CodigoReduzidoContaContabilGrupoRN.getInstance().getTamanhoMaximo()) {
            return "Grupo inv\u00e1lido";
        }
        CodigoReduzidoContaContabilGrupo grupo = CodigoReduzidoContaContabilGrupoRN.getInstance().buscaGrupoCodigoReduzido(SessaoUtil.getSessao(), Integer.valueOf(codigoGrupo));
        if (grupo == null) {
            return "Grupo n\u00e3o cadastrado para este exerc\u00edcio cont\u00e1bil!";
        }
        if (grupo.getContadorAtual() == null || grupo.getContadorAtual() == 0L) {
            return "Contador atual n\u00e3o informado para o grupo!";
        }
        return null;
    }

    @RequestMapping(value={"/validar-codigo-red"})
    @DBAutoCommit
    public String validarCodigoReduzido(@RequestParam String valor, @RequestParam Long idExercicio) throws UnicoMensagemUsuarioException {
        if (valor == null || valor.isEmpty()) {
            return "Informe o c\u00f3digo reduzido!";
        }
        ExercicioContabil exercicioContabil = this.getExercicioContabil(idExercicio);
        ContaContabil contaGravada = ContaContabilRN.getInstance().buscaContaContabilPorCodigoReduzidoExercicio(valor, exercicioContabil.getId(), SessaoUtil.getSessao().getFilial().getIdEmpresa());
        if (contaGravada != null) {
            return "Conta j\u00e1 cadastrada para este c\u00f3digo reduzido!";
        }
        return null;
    }

    @RequestMapping(value={"/buscar-codigo-reduzido"})
    @DBAutoCommit
    public Long buscarCodigoReduzido(@RequestParam int codGrupo) throws UnicoMensagemUsuarioException {
        CodigoReduzidoContaContabilGrupo grupo = CodigoReduzidoContaContabilGrupoRN.getInstance().buscaGrupoCodigoReduzido(SessaoUtil.getSessao(), Integer.valueOf(codGrupo));
        return grupo != null ? grupo.getContadorAtual() : null;
    }

    protected GridBuilder<ContaContabilRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("codigoExtenso", "Extenso", 0, true));
        colunas.add(new ColunaSQL("codigoReduzido", "Reduzido", 0, true));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("idContaPai", "Conta Pai", 0, false));
        colunas.add(new ColunaSQL("nivelConta", "N\u00edvel", 0, false));
        GridBuilder grid = new GridBuilder(((ContaContabilRN)this.rn).getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigoExtenso"));
        ExercicioContabil exercicioContabil = this.getExercicioContabil();
        if (exercicioContabil != null) {
            grid.addReferenciaDefault(new Referencia("idexerciciocontabil"));
            grid.addCodicaoDefault(new Condicao("idexerciciocontabil", Operador.IGUAL, exercicioContabil.getId()));
        }
        return grid;
    }

    private ExercicioContabil getExercicioContabil() {
        ExercicioContabil exercicioContabil = null;
        Sessao sessao = SessaoUtil.getSessao();
        try {
            exercicioContabil = ExercicioContabilRN.getInstance().buscaExercioContabilidadeExterna(sessao, sessao.getFilial().getIdEmpresa());
        }
        catch (UnicoMensagemUsuarioException e) {
            return null;
        }
        return exercicioContabil;
    }

    @RequestMapping(value={"/dados-tree"})
    @DBAutoCommit
    public List buscarDadosTree(@RequestParam(required=false) boolean apenasAtivos, @RequestParam(required=false) TipoMovimentoPlanoContas tipoMovimento) {
        return ((ContaContabilRN)this.rn).buscarLista();
    }

    @RequestMapping(value={"/nome/{id}"})
    @DBAutoCommit
    public ContaContabil getNome(@PathVariable Long id) {
        return (ContaContabil)((ContaContabilRN)this.rn).buscarPorId(id);
    }

    protected void beforeCreate(ContaContabil contaContabil, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ExercicioContabil exercicioContabil = this.getExercicioContabil(contaContabil.getIdExercicioContabil());
        if (exercicioContabil != null) {
            this.validaConfiguracaoPorNivel(contaContabil.getNivelConta().intValue(), exercicioContabil.getId());
            contaContabil.setIdExercicioContabil(exercicioContabil.getId());
        }
        contaContabil.setIdEmpresa(SessaoUtil.getSessao().getFilial().getIdEmpresa());
        contaContabil.setCodigoExtenso(StringUtil.removeChar((String)contaContabil.getCodigoExtenso(), (char)'.'));
    }

    protected void afterCreate(ContaContabil contaContabil, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        CodigoReduzidoContaContabilGrupo grupo = CodigoReduzidoContaContabilGrupoRN.getInstance().buscaGrupoCodigoReduzido(SessaoUtil.getSessao(), Integer.valueOf(Integer.parseInt(contaContabil.getNumeroNivel1())));
        if (grupo == null || !PropriedadeRN.getInstance().getPropriedadeBoolean(Contexto.getInstance().getFilial(), 635)) {
            grupo = CodigoReduzidoContaContabilGrupoRN.getInstance().buscaGrupoCodigoReduzido(Contexto.getInstance().getSessao(), Integer.valueOf(1));
        }
        if (grupo != null) {
            grupo.setContadorAtual(Long.valueOf(Long.parseLong(contaContabil.getCodigoReduzido()) + 1L));
            CodigoReduzidoContaContabilGrupoRN.getInstance().alterar((AbstractPojo)grupo, SessaoUtil.getSessao());
        }
    }

    protected void afterUpdate(ContaContabil contaContabil, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        List filhos = ContaContabilRN.getInstance().buscaContaPorContaPai(contaContabil.getId());
        if (!Util.listNullOrEmpty((List)filhos)) {
            ContaContabilRN.getInstance().replicaDadosFilhos(Contexto.getInstance().getSessao(), contaContabil, filhos);
        }
    }

    private ConfiguracaoContabilidade validaConfiguracaoPorNivel(int nivelAtual, Long idExercicio) throws UnicoMensagemUsuarioException {
        if (this.getExercicioContabil(idExercicio) == null) {
            throw new UnicoMensagemUsuarioException("WCTB76", "Informe o exerc\u00edcio cont\u00e1bil!");
        }
        ConfiguracaoContabilidade configuracao = ConfiguracaoContabilidadeRN.getInstance().buscaConfiguracao(this.getExercicioContabil(idExercicio).getId());
        if (configuracao == null) {
            throw new UnicoMensagemUsuarioException("WCTB77", "Configura\u00e7\u00e3o n\u00e3o encontrada para este exerc\u00edcio! Verifique!");
        }
        Integer quantidadePorNivel = (Integer)BeanUtil.get((Object)configuracao, (String)("tamanhoNivel" + nivelAtual), (Object[])new Object[0]);
        if ((quantidadePorNivel == null || quantidadePorNivel == 0) && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 635)) {
            throw new UnicoMensagemUsuarioException("WCTB78", "Configura\u00e7\u00e3o n\u00e3o encontrada para n\u00edvel: " + nivelAtual + "! Verifique!");
        }
        return configuracao;
    }

    private ExercicioContabil getExercicioContabil(Long idExercicio) throws UnicoMensagemUsuarioException {
        ExercicioContabil exercicioContabil = null;
        if (!PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 497)) {
            if (!Util.longNullOuZero((Long)idExercicio)) {
                exercicioContabil = (ExercicioContabil)ExercicioContabilRN.getInstance().buscarPorId(idExercicio);
            }
        } else {
            exercicioContabil = ExercicioContabilRN.getInstance().buscaExercioContabilidadeExterna(SessaoUtil.getSessao(), SessaoUtil.getSessao().getFilial().getIdEmpresa());
        }
        return exercicioContabil;
    }

    private boolean contaPertencePai(String valor, ContaContabil contaPai) {
        if (contaPai != null && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 635)) {
            String[] valorPorNiveis = valor.split("[.]");
            for (int i = 0; i < contaPai.getNivelConta(); ++i) {
                if (valorPorNiveis[i].equals(BeanUtil.get((Object)contaPai, (String)("numeroNivel" + (i + 1)), (Object[])new Object[0]))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isUtilizaConfiguracaoCodigoReduzido() {
        return PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 635);
    }
}

