/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.contrato.notafiscalcontrato;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.pojo.vendas.ContratoVenda;
import br.intelidata.commons.domain.pojo.vendas.ContratoVendaNotaFiscal;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaNotaFiscalRN;
import br.intelidata.commons.modulo.contrato.regranegocio.ContratoVendaRN;
import br.intelidata.commons.modulo.contrato.relatorio.NotaFiscalContratoRelatorio;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.EmailUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CreateTaskEmail;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import br.intelidata.uniplusweb.web.rest.app.crud.contrato.notafiscalcontrato.ContratoNotaFiscalWrapper;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.activation.DataSource;
import javax.activation.FileDataSource;

public class JobContratoNotaFiscal
extends AbstractPrepareJob {
    private final TaskManager taskManager = (TaskManager)BeanUtil.getBean((String)"taskManager");

    public JobContratoNotaFiscal(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
    }

    public boolean isGzip() {
        return false;
    }

    public void execute() throws Exception {
        ContratoNotaFiscalWrapper wrapper = (ContratoNotaFiscalWrapper)this.getObjetoDeserializado(ContratoNotaFiscalWrapper.class);
        HashMap<Long, ArrayList<ContratoVendaNotaFiscal>> mapListaPorCliente = new HashMap<Long, ArrayList<ContratoVendaNotaFiscal>>();
        HashMap<Long, String> mapEmailCliente = new HashMap<Long, String>();
        HashMap<Long, String> mapNomeCliente = new HashMap<Long, String>();
        List contratos = wrapper.getNotasFiscais().stream().map(c -> ContratoVendaNotaFiscalRN.getInstance().buscaContratoNotaFiscal(c.getIdNotaFiscal(), true)).flatMap(Collection::stream).collect(Collectors.toList());
        for (ContratoVendaNotaFiscal contratoVendaNotaFiscal : contratos) {
            Entidade entidade;
            ContratoVenda contrato = (ContratoVenda)ContratoVendaRN.getInstance().buscarPorId(contratoVendaNotaFiscal.getIdContrato());
            if (contrato == null) continue;
            ArrayList<ContratoVendaNotaFiscal> listaPorCliente = (ArrayList<ContratoVendaNotaFiscal>)mapListaPorCliente.get(contrato.getIdCliente());
            if (listaPorCliente == null) {
                listaPorCliente = new ArrayList<ContratoVendaNotaFiscal>();
            }
            listaPorCliente.add(contratoVendaNotaFiscal);
            mapListaPorCliente.put(contrato.getIdCliente(), listaPorCliente);
            String email = (String)mapEmailCliente.get(contrato.getIdCliente());
            if (!StringUtil.stringNullOrEmpty((String)email) || (entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(contrato.getIdCliente())) == null) continue;
            email = entidade.getEmailFaturamento();
            if (StringUtil.stringNullOrEmpty((String)email)) {
                email = entidade.getEmail();
            }
            if (StringUtil.stringNullOrEmpty((String)email) && wrapper.isEnviarEmail()) {
                throw new UnicoMensagemUsuarioException("COM236648", "O e-mail do cliente [" + entidade + "] n\u00e3o foi cadastrado! Verifique.");
            }
            mapNomeCliente.put(contrato.getIdCliente(), !StringUtil.stringNullOrEmpty((String)entidade.getRazaoSocial()) ? entidade.getRazaoSocial() : entidade.getNome());
            mapEmailCliente.put(contrato.getIdCliente(), email);
        }
        HashMap<String, Remessa> mapRelatorio = new HashMap<String, Remessa>();
        for (Map.Entry entry : mapListaPorCliente.entrySet()) {
            String email = (String)mapEmailCliente.get(entry.getKey());
            String nomeEntidade = (String)mapNomeCliente.get(entry.getKey());
            StringBuilder sbNumeroNota = new StringBuilder();
            for (ContratoVendaNotaFiscal contratoVendaNotaFiscal : (List)entry.getValue()) {
                String numeroNF = NotaFiscalRN.getInstance().getNumeroNotaFiscal(contratoVendaNotaFiscal.getIdNotaFiscal());
                if (StringUtil.stringNullOrEmpty((String)numeroNF) || sbNumeroNota.indexOf(numeroNF) != -1) continue;
                if (sbNumeroNota.length() > 0) {
                    sbNumeroNota.append(", ");
                }
                sbNumeroNota.append(numeroNF);
            }
            if (wrapper.isEnviarEmail() && !Util.stringNullOrEmpty((String)email)) {
                this.gerarRelatorioPorEmail(nomeEntidade, email, sbNumeroNota.toString(), (List)entry.getValue());
                continue;
            }
            mapRelatorio.put(nomeEntidade.concat(".pdf"), new NotaFiscalContratoRelatorio().getRemessaRelatorioAnalitico((List)entry.getValue()));
        }
        if (wrapper.isEnviarEmail()) {
            this.addMensagemRetorno("COM23", "Os e-mails foram agendados com sucesso. Confirme se os mesmos foram enviados corretamente!");
        } else {
            this.saveFile(FileUtil.montaZipFilePorRemessa(mapRelatorio, (String)"pdf"));
        }
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao("Relat\u00f3rios gerados com successo!");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao("Falhou ao gerar os relat\u00f3rios");
    }

    private void gerarRelatorioPorEmail(String nomeEntidade, String emailFaturamento, String numeroNotaFiscal, List<ContratoVendaNotaFiscal> listaRelatorio) throws UnicoMensagemUsuarioException {
        String assunto = "Relat\u00f3rio de Clientes Finais - " + nomeEntidade;
        String mensagem = "Segue em anexo o relat\u00f3rio de clientes finais relativo \u00e0s notas fiscais " + numeroNotaFiscal;
        Remessa remessa = new NotaFiscalContratoRelatorio().getRemessaRelatorioAnalitico(listaRelatorio);
        FileDataSource fileDataSource = new FileDataSource((File)remessa.getMalote().getMapArquivos().get("pdf"));
        DataSource[] sources = new DataSource[]{fileDataSource};
        ParametrosEmailWeb parametrosEmailWeb = EmailUtil.getParametros((Sessao)SessaoUtil.getSessaoJob(), (String)emailFaturamento, null, (String)assunto, (String)mensagem);
        parametrosEmailWeb.setAnexos(sources);
        CreateTaskEmail taskEmail = new CreateTaskEmail(this.taskManager, parametrosEmailWeb, "Relat\u00f3rio de Clientes Finais");
        taskEmail.createTask((Object)parametrosEmailWeb, this.getTask().getUuid(), parametrosEmailWeb.getAssunto(), false);
    }
}

