/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.crescevendas;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.integracaocrescevendas.BuscaFilialConfiguradaCresceVendas;
import br.intelidata.commons.core.integracaocrescevendas.EnvioFechamentoCresceVendas;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.pafecf.FechamentoCresceVendas;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.pdv.regranegocio.FechamentoCresceVendasRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/fechamento-cresce-vendas"})
@SubMenuMapping(MENU="SubMenuVendasAuxiliar", NOME="Fechamento di\u00e1rio Cresce Vendas", ROTA="/vendas/fechamento-cresce-vendas", PROGRAMA=1000079)
public class FechamentoCresceVendasCrudController
extends CrudController<FechamentoCresceVendas, FechamentoCresceVendasRN> {
    public FechamentoCresceVendasCrudController() {
        super((AbstractRegraNegocio)FechamentoCresceVendasRN.getInstance(), FechamentoCresceVendas::new, true, true, false);
    }

    protected GridBuilder<FechamentoCresceVendasRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id"));
        colunas.add(new ColunaSQL("data", "Data", 0, true));
        colunas.add(new ColunaSQL("pendente", "Pendente", 0, true));
        colunas.add(new ColunaSQL("erro", "Erro", 0, true));
        GridBuilder gridBuilder = new GridBuilder(FechamentoCresceVendasRN.getInstance().getTabela(), colunas);
        gridBuilder.addOrdem(new Ordem("data", true));
        return gridBuilder;
    }

    @PostMapping(value={"/enviar-pendentes"})
    @DBTransaction
    public void enviarPendente(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        FechamentoCresceVendas fcv = (FechamentoCresceVendas)FechamentoCresceVendasRN.getInstance().buscarPorId(id);
        if (!fcv.isPendente()) {
            throw new UnicoMensagemUsuarioException("COM279905", "Permitido enviar somente os pendentes");
        }
        new EnvioFechamentoCresceVendas(new BuscaFilialConfiguradaCresceVendas().getMapFiliais(), fcv).enviar();
    }

    protected String getCacheId() {
        return "fechamento-cresce-vendas";
    }
}

