/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.davs;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoException;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.execoes.UnicoPerguntaUsuarioException;
import br.intelidata.commons.core.impressao.FormaUtilizacaoModeloImpressao;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.Caso;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Constante;
import br.intelidata.commons.core.sql.usql.Escolha;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.OperadorLogico;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.Separador;
import br.intelidata.commons.core.util.BeanUtil;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Extenso;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractDavItem;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Cidade;
import br.intelidata.commons.domain.pojo.CondicaoPagamento;
import br.intelidata.commons.domain.pojo.ConsultaPrecoProduto;
import br.intelidata.commons.domain.pojo.DescontoInterface;
import br.intelidata.commons.domain.pojo.Embalagem;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.EntidadeDesconto;
import br.intelidata.commons.domain.pojo.Extras;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.ItemKit;
import br.intelidata.commons.domain.pojo.ItemWeb;
import br.intelidata.commons.domain.pojo.PedidoItem;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.ProdutoPreco;
import br.intelidata.commons.domain.pojo.Promocao;
import br.intelidata.commons.domain.pojo.edi.EDIProcessado;
import br.intelidata.commons.domain.pojo.enuns.ComportamentoClienteAtrasoVendas;
import br.intelidata.commons.domain.pojo.enuns.StatusDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoExcluir;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoEmbalagem;
import br.intelidata.commons.domain.pojo.enuns.TipoKit;
import br.intelidata.commons.domain.pojo.enuns.TipoValorPreco;
import br.intelidata.commons.domain.pojo.enuns.TransacaoFinanceiraMeioPagamento;
import br.intelidata.commons.domain.pojo.expedicao.DocumentoConferidoInterface;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.domain.pojo.generico.VariavelTextoGenerico;
import br.intelidata.commons.domain.pojo.pvdav.AbstractDav;
import br.intelidata.commons.domain.pojo.pvdav.Dav;
import br.intelidata.commons.domain.pojo.pvdav.DavItem;
import br.intelidata.commons.domain.pojo.vendas.ConferenciaDocumentoItemDivergencia;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.AtacarejoWeb;
import br.intelidata.commons.domain.regranegocio.DavCommonRN;
import br.intelidata.commons.domain.regranegocio.DavItemCommonRN;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoCabecalhoRN;
import br.intelidata.commons.domain.regranegocio.ProdutoItemRN;
import br.intelidata.commons.domain.wrapper.DavPrecoWrapper;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cadastros.regranegocio.CidadeRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.ExtrasRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.TextoGenericoRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeDescontoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.LimiteCreditoRN;
import br.intelidata.commons.modulo.preco.regranegocio.FormacaoPrecoProdutoRN;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelNomePautaUtilizadaVenda;
import br.intelidata.commons.modulo.produto.regranegocio.EmbalagemRN;
import br.intelidata.commons.modulo.produto.regranegocio.GeradorKitVendaDav;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.VariacaoRN;
import br.intelidata.commons.modulo.pvdav.dao.ColunaCustomizavelValorProdutos;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavItemRN;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavRN;
import br.intelidata.commons.modulo.vendas.regranegocio.CondicaoPagamentoRN;
import br.intelidata.commons.modulo.vendas.regranegocio.ConferenciaDocumentoItemDivergenciaRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.MultipartUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.AtacarejoService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ImportacaoDadosColetor;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TabelaConfigurada;
import br.intelidata.uniplusweb.web.rest.app.crud.davs.DavAlterarEntidadeDescontoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.davs.DavPrecoAtacarejoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.davs.DavPromocaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.davs.DavWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.davs.MesclagemWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.kit.ItemKitController;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;

public abstract class DavCrudController
extends ItemKitController<Dav, DavItem, DavRN> {
    private final FuncionalidadeService funcionalidadeService;
    private final AtacarejoService atacarejoService;
    private final ModuloService moduloService;
    private TipoDocumentoDAV tipoDocumentoDAV;

    public DavCrudController(FuncionalidadeService funcionalidadeService, AtacarejoService atacarejoService, ModuloService moduloService) {
        super((AbstractRegraNegocio)DavRN.getInstance(), Dav::new, true, true);
        this.funcionalidadeService = funcionalidadeService;
        this.atacarejoService = atacarejoService;
        this.moduloService = moduloService;
        this.setItemSupplier(DavItem::new);
    }

    public DavCrudController(FuncionalidadeService funcionalidadeService, AtacarejoService atacarejoService, ModuloService moduloService, TipoDocumentoDAV tipoDocumentoDAV) {
        super((AbstractRegraNegocio)DavRN.getInstance(), Dav::new, true, true);
        this.funcionalidadeService = funcionalidadeService;
        this.atacarejoService = atacarejoService;
        this.moduloService = moduloService;
        this.setItemSupplier(DavItem::new);
        this.tipoDocumentoDAV = tipoDocumentoDAV;
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody Dav dav, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.create((AbstractPojo)dav, parentId);
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Dav dav, @PathVariable Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        return super.update((AbstractPojo)dav, parentId);
    }

    public ProdutoItemWeb<DavItem> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        Long idCliente;
        Entidade cliente = null;
        ArrayList<TipoEmbalagem> tipos = new ArrayList<TipoEmbalagem>();
        tipos.add(TipoEmbalagem.COMPRAVENDA);
        if (parametros.containsKey((Object)"idCliente") && !NumberUtil.longNullOuZero((Long)(idCliente = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCliente")))) {
            cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(idCliente);
        }
        Long idCondicaoPgmto = null;
        if (parametros.containsKey((Object)"idCondicaoPgmto")) {
            idCondicaoPgmto = StringUtil.convertFirstValueMapToLong(parametros, (String)"idCondicaoPgmto");
        }
        Long pauta = 0L;
        if (parametros.containsKey((Object)"pauta")) {
            pauta = StringUtil.convertFirstValueMapToLong(parametros, (String)"pauta");
        }
        List novosTipos = StringUtil.getAllValuesMap(parametros, (String)"tiposEmbalagem");
        if (!ListMapUtil.listNullOrEmpty(tipos)) {
            novosTipos.forEach(tipo -> {
                TipoEmbalagem tipoEmbalagem = Enum.valueOf(TipoEmbalagem.class, tipo);
                if (!tipos.contains(tipoEmbalagem)) {
                    tipos.add(tipoEmbalagem);
                }
            });
        }
        ProdutoItemWeb produtoItem = new ProdutoItemWeb();
        PedidoItem pedidoItem = new PedidoItem();
        pedidoItem.setQuantidade(BigDecimal.ONE);
        produtoItem.setItem((ItemWeb)pedidoItem);
        produtoItem.setProduto(produto);
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPesoProduto())) {
            ((PedidoItem)produtoItem.getItem()).setQuantidade(produto.getPesoProduto());
        }
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produto.getPrecoUnitario())) {
            ((PedidoItem)produtoItem.getItem()).setPreco(produto.getPrecoUnitario());
        }
        int origem = this.tipoDocumentoDAV.getId().equals(TipoDocumentoDAV.PEDIDO.getId()) ? 5 : 8;
        new ProdutoItemRN().carregaItem(SessaoUtil.getSessao(), produtoItem, cliente, null, idCondicaoPgmto, pauta, false, true, true, TipoValorPreco.PRECO, false, false, false, null, tipos, false, (AtacarejoWeb)this.atacarejoService, origem, true);
        ((PedidoItem)produtoItem.getItem()).setPautaPreco(pauta);
        if (cliente != null) {
            ((PedidoItem)produtoItem.getItem()).setPrecoUltimaVendaProduto(DavItemRN.getInstance().getPrecoUltimaVendaNfPorCliente(cliente.getId(), produtoItem.getProduto().getId()));
        }
        ProdutoItemWeb produtoItemDav = new ProdutoItemWeb();
        BeanUtil.copiarValores((Object)produtoItem, (Object)produtoItemDav, (boolean)false, null);
        return produtoItemDav;
    }

    @RequestMapping(value={"/buscar-assinatura"})
    @DBAutoCommit
    public Dav buscaAssinatura(@RequestParam Long idOrigem) throws UnicoMensagemUsuarioException {
        Dav dav = (Dav)DavRN.getInstance().buscarPorId(idOrigem);
        if (dav != null && dav.getAssinatura() != null) {
            MultipartFile file = MultipartUtil.montaMultiPartiPorBytes((byte[])dav.getAssinatura(), (String)"assinatura.png");
            String url = this.saveFile.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Venda, file, true);
            dav.setCaminhoAssinatura(url);
            return dav;
        }
        throw new UnicoMensagemUsuarioException("WWW660", "Venda n\u00e3o tem assinatura");
    }

    @RequestMapping(value={"/buscar-abertas"})
    @DBAutoCommit
    public List<Dav> buscaListaDavAberta(@RequestParam(required=false) String query, @RequestParam(required=false, defaultValue="6") int limit) {
        return DavRN.getInstance().buscarListDavAbertaWeb(SessaoUtil.getSessao(), query, limit);
    }

    @RequestMapping(value={"/validar-condicoes-pgmto"})
    @DBAutoCommit
    public String validarCondicaoPgmto(@RequestParam Long idCondicaoPgmto, @RequestParam Long idEntidade) throws UnicoMensagemUsuarioException {
        if (!this.tipoDocumentoDAV.equals((Object)TipoDocumentoDAV.ORCAMENTO)) {
            ComportamentoClienteAtrasoVendas comportamentoClienteAtrasoVendas = (ComportamentoClienteAtrasoVendas)PropriedadeRN.getInstance().getPropriedadeEnum(SessaoUtil.getSessao().getFilial(), 817);
            if (ComportamentoClienteAtrasoVendas.LIBERAR_A_VISTA.equals((Object)comportamentoClienteAtrasoVendas) && CondicaoPagamentoRN.getInstance().isCondicaoPagamentoAVista(idCondicaoPgmto)) {
                return null;
            }
            EntidadeRN.getInstance().permiteVender(SessaoUtil.getSessao(), (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade), true, true);
        } else {
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade);
            if (entidade != null && !EntidadeRN.getInstance().isLiberaVendaClienteAtrasado(entidade) && EntidadeRN.getInstance().isEntidadeBloqueadaPorAtraso(SessaoUtil.getSessao(), entidade.getId())) {
                return "PVDV233 - O cliente possui documentos em atraso.";
            }
        }
        return null;
    }

    @RequestMapping(value={"/ultimo-preco-venda-cliente"})
    @DBAutoCommit
    public BigDecimal getPrecoUltimaVendaPorCliente(@RequestParam Long idCliente, @RequestParam Long idProduto) {
        return DavItemRN.getInstance().getPrecoUltimaVendaNfPorCliente(idCliente, idProduto);
    }

    @RequestMapping(value={"/buscar-preco-produto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ProdutoItemWeb<PedidoItem> getPrecoProduto(@RequestBody DavPrecoWrapper wrapper) {
        Promocao promocao;
        Sessao sessao = SessaoUtil.getSessao();
        ProdutoDTOWeb produto = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, wrapper.getItem().getIdProduto());
        Long pautaAtacarejo = null;
        if (!NumberUtil.longNullOuZero((Long)wrapper.getItem().getIdEmbalagem()) && wrapper.getItem().getIdEmbalagem() != -1L) {
            wrapper.getItem().setIdUnidadeMedida(((Embalagem)EmbalagemRN.getInstance().buscarPorId(wrapper.getItem().getIdEmbalagem())).getIdUnidadeMedida());
        }
        if (this.atacarejoService.isAtacarejoHabilitado(sessao, wrapper.getIdCliente())) {
            pautaAtacarejo = this.atacarejoService.buscaPautaAtacarejo(produto, wrapper.getQuantidade(), sessao);
        }
        ProdutoPreco produtoPreco = pautaAtacarejo != null && pautaAtacarejo >= 0L ? this.atacarejoService.getPrecoAtacarejo(pautaAtacarejo, produto, wrapper.getItem().getIdEmbalagem(), sessao) : ProdutoRN.getInstance().getPreco(new ConsultaPrecoProduto(sessao.getFilial(), wrapper.getItem().getIdProduto(), wrapper.getItem().getPautaPreco(), VariacaoRN.getInstance().stringToMap(wrapper.getItem().getVariacoes()), wrapper.getItem().getIdEmbalagem()));
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PRECO_POR_FILIAL)) {
            Map map = FormacaoPrecoProdutoRN.getInstance().getPrecoMinimoVendaProdutoWeb(sessao.getIdFilial(), produto.getId());
            wrapper.getItem().setPrecoMinimoVenda((BigDecimal)map.get("precoMinimoVenda"));
            wrapper.getItem().setPrecoProdutoOriginal((BigDecimal)map.get("precoProdutoOriginal"));
            produtoPreco.setPrecoMinimoVenda((BigDecimal)map.get("precoMinimoVenda"));
            produtoPreco.setPrecoProdutoOriginal((BigDecimal)map.get("precoProdutoOriginal"));
        } else {
            wrapper.getItem().setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
            wrapper.getItem().setPrecoProdutoOriginal(produto.getPreco());
            produtoPreco.setPrecoMinimoVenda(produto.getPrecoMinimoVenda());
            produtoPreco.setPrecoProdutoOriginal(produto.getPreco());
        }
        if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)produtoPreco.getPrecoPromocao())) {
            wrapper.getItem().setDescontoPromocao(produtoPreco.getPreco().subtract(produtoPreco.getPrecoPromocao()));
            wrapper.getItem().setPreco(produtoPreco.getPrecoPromocao());
            wrapper.getItem().setIdPromocao(produtoPreco.getIdPromocao());
        } else {
            wrapper.getItem().setDescontoPromocao(BigDecimal.ZERO);
            wrapper.getItem().setPreco(produtoPreco.getPreco());
            wrapper.getItem().setIdPromocao(null);
        }
        wrapper.getItem().setPrecoOriginal(produtoPreco.getPreco());
        ProdutoItemWeb produtoItemWeb = new ProdutoItemWeb();
        produtoItemWeb.setProdutoPreco(produtoPreco);
        PedidoItem pedidoItem = new PedidoItem();
        BeanUtil.copiarValores((Object)wrapper.getItem(), (Object)pedidoItem, (boolean)false, (boolean)true, null);
        produtoItemWeb.setItem((ItemWeb)pedidoItem);
        if (!NumberUtil.longNullOuZero((Long)((PedidoItem)produtoItemWeb.getItem()).getIdPromocao()) && (promocao = PromocaoRN.getInstance().buscarPorId(((PedidoItem)produtoItemWeb.getItem()).getIdPromocao())) != null) {
            produtoItemWeb.setPromocao(promocao);
        }
        return produtoItemWeb;
    }

    @RequestMapping(value={"/calcular-precos-itens-por-condicao-pgmto"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<DavItem> calcularPrecoItensPorCondicaoPagamento(@RequestBody DavPrecoAtacarejoWrapper wrapper) throws UnicoMensagemUsuarioException {
        CondicaoPagamento condicaoPagamento = (CondicaoPagamento)CondicaoPagamentoRN.getInstance().buscarPorId(wrapper.getIdCondicaoPgmto());
        HashMap mapQtd = this.funcionalidadeService.isAtiva(Funcionalidade.ATACAREJO) ? wrapper.getItens().stream().collect(Collectors.groupingBy(AbstractDavItem::getIdproduto, Collectors.mapping(AbstractDavItem::getQuantidade, Collectors.reducing(BigDecimal.ZERO, BigDecimal::add)))) : new HashMap();
        boolean pautaPrecoItem = this.funcionalidadeService.isAtiva(Funcionalidade.PAUTA_PRECO_ITEM);
        for (DavItem item : wrapper.getItens()) {
            if (!pautaPrecoItem) {
                item.setPautaPreco(Long.valueOf(wrapper.getPautaPreco()));
            }
            if (item.getTipoKit() != TipoKit.KIT_COMPONENTE.getId().intValue()) {
                DavPrecoWrapper precoWrapper = new DavPrecoWrapper(item, mapQtd.getOrDefault(item.getIdproduto(), BigDecimal.ZERO));
                ProdutoPreco produtoPreco = this.getPrecoProduto(precoWrapper).getProdutoPreco();
                if (produtoPreco.getPrecoPromocao().compareTo(BigDecimal.ZERO) > 0) {
                    item.setPreco(produtoPreco.getPrecoPromocao());
                    item.setDescontoPromocao(produtoPreco.getPreco().subtract(produtoPreco.getPrecoPromocao()));
                } else {
                    item.setPreco(produtoPreco.getPreco());
                }
                item.setIdPromocao(produtoPreco.getIdPromocao());
                boolean possuiPromocaoPautaDesconto = produtoPreco.getPrecoProdutoOriginal().compareTo(item.getPreco()) != 0 || !NumberUtil.longNullOuZero((Long)item.getIdEntidadeDesconto());
                BigDecimal preco = item.getPreco();
                if (condicaoPagamento != null && condicaoPagamento.getFator().compareTo(BigDecimal.ZERO) > 0) {
                    if (condicaoPagamento.getFator().compareTo(BigDecimal.ONE) > 0) {
                        preco = condicaoPagamento.getFator().multiply(item.getPreco()).setScale(item.getPreco().scale(), RoundingMode.HALF_EVEN);
                    } else if (condicaoPagamento.getFator().compareTo(BigDecimal.ONE) < 0) {
                        preco = item.getPreco().subtract(condicaoPagamento.getFator().multiply(item.getPreco()).setScale(item.getPreco().scale(), RoundingMode.HALF_EVEN));
                    }
                }
                item.setPrecoComAcrecimo(preco);
                item.setPreco(item.getPrecoComAcrecimo());
                item.setPrecoMinimoVenda(produtoPreco.getPrecoMinimoVenda());
                if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)item.getPercentualdesconto())) {
                    BigDecimal bruto = item.getPreco().multiply(item.getQuantidade()).setScale(2, RoundingMode.HALF_EVEN);
                    if (item.getTipoValorDesconto() == 0) {
                        item.setDesconto(NumberUtil.valorDesconto((BigDecimal)bruto, (BigDecimal)item.getPercentualdesconto(), (int)2));
                    } else if (item.getTipoValorDesconto() == 1) {
                        item.setPercentualdesconto(NumberUtil.percentual((BigDecimal)item.getDesconto(), (BigDecimal)bruto));
                    }
                }
                BigDecimal total = item.getTotalSemDecontoSubTotal();
                total = total.subtract(item.getDescontoSubTotal()).setScale(2, RoundingMode.HALF_EVEN);
                item.setTotal(total);
            }
            if (item.getTipoKit() != TipoKit.KIT_PAI.getId().intValue()) continue;
            GeradorKitVendaDav geradorKitVendaDav = new GeradorKitVendaDav(this.tipoDocumentoDAV);
            geradorKitVendaDav.calcularRateioKit(SessaoUtil.getSessao(), (ItemKit)item, item.getFilhosKit(), wrapper.getIdCondicaoPgmto());
        }
        return wrapper.getItens();
    }

    @RequestMapping(value={"/calcular-precos-atacarejo"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<DavItem> atualizaProdutosAtacarejo(@RequestBody DavPrecoAtacarejoWrapper wrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        if (this.atacarejoService.isAtacarejoHabilitado(sessao, wrapper.getIdCliente())) {
            if (wrapper.getProduto() == null) {
                ProdutoDTOWeb prod = ProdutoRN.getInstance().buscarProdutoDTOWeb(sessao, wrapper.getIdProduto());
                wrapper.setProduto(prod);
            }
            List itens = wrapper.getItens().stream().map(it -> {
                if (Util.longNullOuZero((Long)it.getIdFamilia())) {
                    Long idFamilia = (Long)ProdutoRN.getInstance().buscarValorPorID(it.getIdProduto(), "idfamilia");
                    it.setIdFamilia(idFamilia);
                }
                return it;
            }).collect(Collectors.toList());
            this.atacarejoService.atualizaProdutosAtacarejo(sessao, wrapper.getProduto(), itens, wrapper.getIdCliente(), wrapper.getIdCondicaoPgmto(), it -> {
                DavItem item = (DavItem)it;
                BigDecimal total = item.getTotalSemDecontoSubTotal();
                total = total.subtract(item.getDescontoSubTotal()).setScale(2, RoundingMode.HALF_EVEN);
                item.setTotal(total);
            });
            GeradorKitVendaDav geradorKitVendaDav = new GeradorKitVendaDav(this.tipoDocumentoDAV);
            for (DavItem item : wrapper.getItens()) {
                if (item.getTipoKit() != TipoKit.KIT_PAI.getId().intValue()) continue;
                geradorKitVendaDav.calcularRateioKit(SessaoUtil.getSessao(), (ItemKit)item, item.getFilhosKit(), wrapper.getIdCondicaoPgmto());
            }
        }
        return wrapper.getItens();
    }

    @RequestMapping(value={"/buscar-dados-promocao"})
    @DBAutoCommit
    public DavPromocaoWrapper getDadosPromocao(@RequestBody DavItem itemDav) throws UnicoMensagemUsuarioException {
        if (!NumberUtil.longNullOuZero((Long)itemDav.getIdPromocao())) {
            Promocao promocao = PromocaoRN.getInstance().buscarPorId(itemDav.getIdPromocao());
            if (promocao != null) {
                return new DavPromocaoWrapper(DescontoRN.getInstance().isItemPermiteDesconto(SessaoUtil.getSessao().getFilial(), (DescontoInterface)itemDav, promocao), promocao.getNome(), promocao.getDataFinal());
            }
            throw new UnicoMensagemUsuarioException("WWW155", "Promo\u00e7\u00e3o n\u00e3o encontrada");
        }
        return new DavPromocaoWrapper(DescontoRN.getInstance().isItemPermiteDesconto(SessaoUtil.getSessao().getFilial(), (DescontoInterface)itemDav, null), null, null);
    }

    @RequestMapping(value={"/itens"})
    @DBAutoCommit
    public List<DavItem> buscarItens(@RequestParam Long idDav, @RequestParam(required=false, defaultValue="false") boolean conferencia) throws UnicoMensagemUsuarioException {
        Dav dav = (Dav)((DavRN)this.rn).buscarPorId(idDav);
        if (dav == null) {
            throw new UnicoMensagemUsuarioException("WWW182", "Documento n\u00e3o encontrado.");
        }
        Sessao sessao = SessaoUtil.getSessao();
        List itens = DavItemRN.getInstance().buscarListaPorIdDav(idDav);
        for (DavItem item : itens) {
            item.setItemPermiteDesconto(this.getDadosPromocao(item).isPermiteDesconto());
            item.setPrecoUltimaVendaProduto(DavItemRN.getInstance().getPrecoUltimaVendaNfPorCliente(dav.getIdCliente(), item.getIdProduto()));
            item.setDescricaoPauta(new ProdutoItemRN().descricaoPautaPreco(sessao, item.getPautaPreco()));
        }
        itens = this.agruparItensKit(itens);
        if (conferencia) {
            List lista = new ConferenciaDocumentoItemDivergenciaRN().conferir(new DocumentoConferidoInterface[]{dav});
            Map mapPorDav = lista.stream().filter(c -> c.getItemDav() != null).collect(Collectors.toMap(c -> c.getItemDav().getId(), Function.identity()));
            for (DavItem item : itens) {
                item.setConferencia((ConferenciaDocumentoItemDivergencia)mapPorDav.get(item.getId()));
            }
        }
        return itens;
    }

    @DBAutoCommit
    public List<DavItem> getItens(Long id) {
        Sessao sessao = SessaoUtil.getSessao();
        List itens = this.agruparItensKit(DavItemRN.getInstance().buscarListaPorIdDav(id));
        itens.forEach(item -> item.setDescricaoPauta(new ProdutoItemRN().descricaoPautaPreco(sessao, item.getPautaPreco())));
        return itens;
    }

    @PostMapping(value={"/processar-status-conferencia"})
    @DBAutoCommit
    public DavItem processarStatusConferencia(@RequestBody DavWrapper wrapper) {
        wrapper.getDavItem().getConferencia().processarStatus(wrapper.getItens().stream().map(AbstractDavItem::getConferencia).filter(Objects::nonNull).collect(Collectors.toList()), wrapper.getDavItem().getQuantidade());
        return wrapper.getDavItem();
    }

    @RequestMapping(value={"/validar-alteracao-exclusao-item"})
    @DBAutoCommit
    public boolean podeAlterarExcluirItem(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        if (!DavItemRN.getInstance().isPodeAlterarExcluir(id)) {
            throw new UnicoMensagemUsuarioException("WPVDV216", "N\u00e3o \u00e9 poss\u00edvel alterar um item, que j\u00e1 tem baixas no faturamento!");
        }
        return true;
    }

    @RequestMapping(value={"/itens-mesclagem"}, method={RequestMethod.POST})
    @DBAutoCommit
    public MesclagemWrapper buscarDadosMesclagem(@RequestBody List<Long> idsDav) {
        List idsVendedores = null;
        List itens = idsDav.stream().map(arg_0 -> ((DavItemRN)DavItemRN.getInstance()).buscarListaPorIdDav(arg_0)).flatMap(Collection::stream).collect(Collectors.toList());
        if (!ListMapUtil.listNullOrEmpty(itens)) {
            idsVendedores = DavItemRN.getInstance().buscarIdVendedoresPorItensWeb((Long[])itens.stream().map(AbstractDavItem::getId).toArray(Long[]::new));
        }
        return new MesclagemWrapper(idsVendedores, itens);
    }

    @RequestMapping(value={"/mesclar-itens"}, method={RequestMethod.POST})
    @DBTransaction
    public String mesclarItensDav(@RequestBody MesclagemWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)wrapper.getIdVendedor())) {
            throw new UnicoMensagemUsuarioException("WPVDV247", "O vendedor n\u00e3o foi informado. Por favor verifique");
        }
        boolean permiteClientesDiferentes = PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 1060);
        if (!permiteClientesDiferentes && PedidoRN.getInstance().isClientesDiferentes(wrapper.getIdsDavs())) {
            throw new UnicoMensagemUsuarioException("WPVDV296", "N\u00e3o \u00e9 permitido mesclar documentos de clientes diferentes");
        }
        Long codigo = DavRN.getInstance().mesclarDocumentos(SessaoUtil.getSessao(), wrapper.getIdVendedor(), wrapper.getIdsDavs(), wrapper.getItens());
        return "PVDV243 - DAV n\u00famero " + DavRN.getInstance().getCodigoDavFormatado(codigo) + " gravada com sucesso.";
    }

    @RequestMapping(value={"/gerar-pedido"}, method={RequestMethod.POST})
    @DBTransaction
    public String gerarPedido(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        Long idPedido = DavRN.getInstance().criarPedidoAPartirDeOrcamento(SessaoUtil.getSessao(), id);
        Dav pedido = (Dav)DavRN.getInstance().buscarPorId(idPedido);
        if (pedido != null) {
            return "PVDV188 - Pedido n\u00famero " + pedido.getCodigo() + " gerado com sucesso";
        }
        throw new UnicoMensagemUsuarioException("WWW163", "N\u00e3o foi poss\u00edvel gerar o pedido");
    }

    @RequestMapping(value={"{id}"}, method={RequestMethod.DELETE})
    @DBTransaction
    public void delete(@PathVariable Long id) throws UnicoMensagemUsuarioException {
        AbstractPojo ab = ((DavRN)this.rn).buscarPorId(id);
        if (ab == null) {
            throw new UnicoException("WWW153", id + " n\u00e3o encontrado");
        }
        if (!DavRN.getInstance().getStatusDav(id).getTipoAcaoExcluir().equals((Object)TipoAcaoExcluir.EXCLUIR)) {
            throw new UnicoMensagemUsuarioException("WWW154", "N\u00e3o \u00e9 poss\u00edvel excluir o documento.");
        }
        if (FilialRN.getInstance().aplicaRegrasDoPafEcf(SessaoUtil.getSessao()) && DavRN.getInstance().isImpressoEmEcf(id)) {
            throw new UnicoMensagemUsuarioException("WPVDV195", "Este documento n\u00e3o pode cancelado porque foi impresso em ECF");
        }
        DavRN.getInstance().alterarStatusDav(SessaoUtil.getSessao(), id, StatusDAV.CANCELADO);
        this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
    }

    @RequestMapping(value={"/atualizar-dados-impressao"}, method={RequestMethod.POST})
    @DBTransaction
    public void atualizarDadosImpressao(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        Dav dav = (Dav)((DavRN)this.rn).buscarPorId(id);
        dav.setImpresso(true);
        dav.setDataHoraImpressao(DataHoraFactory.getDataHora());
        if (dav.getTipodocumento().equals((Object)TipoDocumentoDAV.PEDIDO)) {
            DavRN.getInstance().impressao(SessaoUtil.getSessao(), dav);
        } else {
            DavRN.getInstance().alterar(dav, SessaoUtil.getSessao());
        }
    }

    @PostMapping(value={"/preparar-compartilhamento"})
    @DBAutoCommit
    public NotificacaoCompartilhamento prepararCompartilhamento(@RequestBody List<Long> idsDavs, @RequestParam(required=false) Long idTextoGenerico) throws UnicoMensagemUsuarioException {
        Long idCliente = null;
        StringBuilder davCodigos = new StringBuilder();
        List modelos = ModeloImpressaoCabecalhoRN.getInstance().buscarListaPorTipoModelo(SessaoUtil.getSessao(), this.tipoDocumentoDAV.getTipoModelo(), new FormaUtilizacaoModeloImpressao[]{FormaUtilizacaoModeloImpressao.EMAIL, FormaUtilizacaoModeloImpressao.IMPRESSAO_EMAIL});
        if (ListMapUtil.listNullOrEmpty((List)modelos)) {
            throw new UnicoMensagemUsuarioException("WWW557", "Nenhum modelo de e-mail configurado para " + this.tipoDocumentoDAV.getTipoModelo().getDescricao().toLowerCase() + ". Verifique");
        }
        List davs = DavRN.getInstance().buscarListaPorIds(idsDavs);
        for (Dav dav : davs) {
            if (FilialRN.getInstance().aplicaRegrasDoPafEcf(SessaoUtil.getSessao())) {
                if (!dav.getStatus().isPodeAlterar()) {
                    throw new UnicoMensagemUsuarioException("WWW558", "O compartilhamento do documento " + dav.getCodigo() + " n\u00e3o permitido para o status atual.");
                }
                if (dav.getCooGer() > 0) {
                    throw new UnicoMensagemUsuarioException("WWW559", "O documento " + dav.getCodigo() + " n\u00e3o pode ser compartilhado, porque j\u00e1 foi impresso em ECF.");
                }
            }
            if (idCliente == null) {
                idCliente = dav.getIdCliente();
                davCodigos = new StringBuilder(dav.getCodigo().toString());
                continue;
            }
            davCodigos.append(", ").append(dav.getCodigo());
            if (idCliente.equals(dav.getIdCliente())) continue;
            throw new UnicoMensagemUsuarioException("WWW560", "S\u00f3 \u00e9 poss\u00edvel compartilhar or\u00e7amentos com o mesmo cliente.");
        }
        NotificacaoCompartilhamento notificacaoCompartilhamento = new NotificacaoCompartilhamento();
        String assunto = this.tipoDocumentoDAV.getTipoModelo().getDescricao();
        notificacaoCompartilhamento.setAssunto(assunto + " " + davCodigos);
        Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(((Dav)davs.get(0)).getIdCliente());
        if (entidade != null) {
            String email = entidade.getEmailComprador();
            if (Util.stringNullOrEmpty((String)email)) {
                email = entidade.getEmail();
            }
            notificacaoCompartilhamento.setEmail(email);
            notificacaoCompartilhamento.setCelular(entidade.getNumeroEnvioWhatsapp());
        }
        if (!NumberUtil.longNullOuZero((Long)idTextoGenerico)) {
            notificacaoCompartilhamento.setMensagem(this.reescreveTextoMensagem(davs, idTextoGenerico));
        }
        return notificacaoCompartilhamento;
    }

    @PostMapping(value={"/preparar-texto-compartilhamento"})
    @DBAutoCommit
    public String prepararTextoEmail(@RequestBody List<Long> idsDavs, @RequestParam Long idTextoGenerico) {
        List davs = DavRN.getInstance().buscarListaPorIds(idsDavs);
        if (davs == null) {
            return null;
        }
        return this.reescreveTextoMensagem(davs, idTextoGenerico);
    }

    @PostMapping(value={"/incluir-registro-producao"})
    @DBAutoCommit
    public Map<String, Object> incluirRegistroProducao(@RequestBody List<Long> idsDavs) throws UnicoMensagemUsuarioException {
        return DavRN.getInstance().incluirRegistroProducao(SessaoUtil.getSessao(), idsDavs, true);
    }

    protected void beforeRead(Dav dav, int modo, Optional<Long> parentId) {
        if (modo == 7) {
            dav.setIdDavOriginal(dav.getId());
            dav.setCodigo(null);
            dav.setData(DataHoraFactory.getData());
            dav.setDuplicada(true);
            dav.setId(null);
            dav.setDataConferencia(null);
            dav.setIdUsuarioConferencia(null);
            dav.setStatusConferencia(null);
        }
        dav.setTotalGeral(dav.getValor());
    }

    protected void read(Dav dav, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.read((AbstractPojo)dav, modo, parentId);
        if (modo == 1 && !dav.getStatus().isPodeAlterar()) {
            throw new UnicoMensagemUsuarioException("PVDV294", "N\u00e3o \u00e9 poss\u00edvel alterar o documento selecionado. O status " + dav.getStatus().getDescricao() + " n\u00e3o permite altera\u00e7\u00e3o.");
        }
    }

    protected String getCacheId() {
        return "davs".concat(this.tipoDocumentoDAV != null ? this.tipoDocumentoDAV.name() : "").concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }

    protected GridBuilder<DavRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("idCliente", "idCliente", 0, false));
        colunas.add(new ColunaSQL("statusConferencia", "Status confer\u00eancia", 0, false));
        colunas.add(new ColunaSQL("codigo", "Documento", 130, true));
        colunas.add(new ColunaSQL("nome", "nomeCliente", "Cliente", 0, true, new String[]{"fk_dav_cliente"}));
        colunas.add(new ColunaSQL("nome", "nomeVendedor", "Vendedor", 0, true, new String[]{"fk_dav_representante"}));
        colunas.add(new ColunaSQL("data", "Data", 100, true));
        ColunaSQL colunaValor = new ColunaSQL("valor", "Valor", 120, true);
        colunaValor.setTotalizar(true);
        colunas.add(colunaValor);
        colunas.add(new ColunaSQL("status", "Status", 120, true));
        if (TipoDocumentoDAV.ORCAMENTO.equals((Object)this.tipoDocumentoDAV)) {
            colunas.add(new ColunaSQL("aprovado", "Aprovado", 100, true));
            colunas.add(new ColunaSQL("impresso", "Impresso", 100, true));
        } else if (TipoDocumentoDAV.PEDIDO.equals((Object)this.tipoDocumentoDAV)) {
            colunas.add(new ColunaSQL("impresso", "Impresso", 100, true));
            if (this.moduloService.isAtivo(Modulo.UNIPLUS_SHOP)) {
                ColunaSQL meioPagamento = new ColunaSQL("meiopagamento", "meioPagTransacaoFinanceira", "Meio Pgmto", 0, false, new String[]{"fk_dav_transacaofinanceira"});
                meioPagamento.setClasseEnum(TransacaoFinanceiraMeioPagamento.class);
                colunas.add(meioPagamento);
            }
            if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CONFERENCIA) && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 917)) {
                colunas.add(new ColunaSQL("statusconferencia", "Confer\u00eancia", 200, true));
            }
        } else if (TipoDocumentoDAV.PREVENDA.equals((Object)this.tipoDocumentoDAV) && FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CONFERENCIA) && PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 918)) {
            colunas.add(new ColunaSQL("statusconferencia", "Confer\u00eancia", 200, true));
        }
        ColunaSQL statusDav = new ColunaSQL("status", "statusDav", "Status", 0, false, new String[0]);
        statusDav.setClasseEnum(StatusDAV.class);
        colunas.add(statusDav);
        colunas.add(new ColunaSQL("data", "dataDav", "Data", 0, false, new String[0]));
        colunas.add(new ColunaSQL("entrega", "entrega", "Entrega", 0, false, new String[0]));
        colunas.add(new ColunaSQL("nome", "vendedorDav", "Vendedor", 0, false, new String[]{"fk_dav_representante"}));
        if (this.moduloService.isAtivo(Modulo.ECOMMERCE)) {
            Caso caso = new Caso();
            caso.add(new Condicao(Separador.ABRE_PARENTESIS));
            caso.add(new Condicao("codigoecommerce", Operador.IGUAL, ""));
            caso.add(new Condicao(OperadorLogico.OU));
            caso.add(new Condicao("codigoecommerce", Operador.IS_NULL));
            caso.add(new Condicao(Separador.FECHA_PARENTESIS));
            caso.setValor(new Constante((Object)"false"));
            Escolha escolhaEcommerce = new Escolha(caso, new Constante((Object)"true"));
            ColunaSQL colunaSQLEcommerce = new ColunaSQL(escolhaEcommerce, "ecommerce", "E-commerce", 80, false, false);
            colunaSQLEcommerce.setTipoDadoBase(TipoDadoBase.CHARACTER_VARYING);
            colunas.add(colunaSQLEcommerce);
        }
        String aliasTabela = this.tipoDocumentoDAV != null ? ((DavRN)this.rn).getTabela().concat(this.tipoDocumentoDAV.getId().toString()) : null;
        GridBuilder grid = new GridBuilder(DavRN.getInstance().getTabela(), colunas, aliasTabela);
        grid.addReferenciaDefault(new Referencia("tipodocumento"));
        grid.addReferenciaDefault(new Referencia("assinatura"));
        grid.addReferenciaDefault(new Referencia("idfilial"));
        grid.addReferenciaDefault(new Referencia("data"));
        grid.addReferenciaDefault(new Referencia("entrega"));
        grid.addReferenciaDefault(new Referencia("idRepresentante"));
        grid.addReferenciaDefault(new Referencia("valorfrete"));
        grid.addReferenciaDefault(new Referencia("descontosubtotal"));
        grid.addReferenciaDefault(new Referencia("pautapreco"));
        if (this.moduloService.isAtivo(Modulo.UNIPLUS_SHOP)) {
            grid.addReferenciaDefault(new Referencia("uniplusShop", "shop"));
        }
        if (this.moduloService.isAtivo(Modulo.ECOMMERCE)) {
            grid.addReferenciaDefault(new Referencia("codigoecommerce"));
        }
        if (this.tipoDocumentoDAV != null) {
            grid.addCodicaoDefault(new Condicao("tipodocumento", Operador.IGUAL, this.tipoDocumentoDAV.getId().intValue()));
        }
        grid.addCodicaoDefault(new Condicao("idfilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelValorProdutos(SessaoUtil.getSessao()));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelNomePautaUtilizadaVenda(SessaoUtil.getSessao(), FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)));
        return grid;
    }

    protected void beforeCreate(Dav dav, Optional<Long> parentId) {
        dav.setTipodocumento(this.tipoDocumentoDAV);
        dav.setCodigo(DavRN.getInstance().getCodigoDav(SessaoUtil.getSessao(), dav.getTipodocumento()));
        dav.setIdFilial(SessaoUtil.getSessao().getFilial().getId());
        if (dav.getData() == null) {
            dav.setData(DataHoraFactory.getData());
        }
    }

    protected void beforeSave(Dav dav, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty((List)dav.getItens())) {
            throw new UnicoMensagemUsuarioException("COM236587", "N\u00e3o existem itens para esse documento");
        }
        dav.setStatus(StatusDAV.FECHADO);
        dav.setIdUsuario(SessaoUtil.getSessao().getIdUsuario());
        dav.setCupomemitido(Integer.valueOf(0));
        if (dav.getTipodocumento().equals((Object)TipoDocumentoDAV.PREVENDA)) {
            dav.setTituloDav("PRE-VENDA");
        } else if (dav.getTipodocumento().equals((Object)TipoDocumentoDAV.ORCAMENTO)) {
            dav.setTituloDav("ORCAMENTO");
        } else if (dav.getTipodocumento().equals((Object)TipoDocumentoDAV.PEDIDO)) {
            dav.setTituloDav("PEDIDO");
        } else if (dav.getTipodocumento().equals((Object)TipoDocumentoDAV.DAV_OS)) {
            dav.setTituloDav("ORDEM DE SERVICO");
        }
        dav.setItens(this.separarItensKit(dav.getItens()));
        if (Util.longNullOuZero((Long)dav.getId())) {
            dav.getItens().forEach(it -> it.setId(null));
        }
        dav.setItensExcluidos(this.separarItensKit(dav.getItensExcluidos()));
        this.calcularTotais(dav);
        this.verificaGravar(dav);
    }

    protected List<TabelaConfigurada> getTabelasConfiguracaoRelatorio() {
        return Arrays.asList(new TabelaConfigurada(DavRN.getInstance().getTabela(), this.tipoDocumentoDAV.getDescricao()), new TabelaConfigurada(DavItemRN.getInstance().getTabela(), "Itens de ".concat(this.tipoDocumentoDAV.getDescricao().toLowerCase())));
    }

    @DBAutoCommit
    public EDIProcessado importarArquivoEdi(MultipartFile file, Long idEdi, @RequestParam MultiValueMap<String, String> parameters) throws UnicoMensagemUsuarioException {
        Long pautaPreco = StringUtil.convertFirstValueMapToLong(parameters, (String)"pautaPreco");
        Long idCondicaoPagamento = StringUtil.convertFirstValueMapToLong(parameters, (String)"idCondicaoPagamento");
        ImportacaoDadosColetor importacao = new ImportacaoDadosColetor(DavItem.class, idEdi, file, idCondicaoPagamento, pautaPreco, TipoValorPreco.PRECO);
        importacao.importar();
        return importacao.getEDIProcessado();
    }

    private void verificaGravar(Dav dav) throws UnicoMensagemUsuarioException {
        StatusDAV statusDAV;
        Sessao sessao = SessaoUtil.getSessao();
        if (LimiteCreditoRN.getInstance().isVerificarLimiteCredito(sessao, (AbstractDav)dav)) {
            try {
                LimiteCreditoRN.getInstance().validarLimiteCredito(sessao, (AbstractDav)dav);
            }
            catch (UnicoPerguntaUsuarioException e) {
                throw new UnicoMensagemUsuarioException("COM236588", "Esta venda excedeu o valor dispon\u00edvel de cr\u00e9dito. Venda n\u00e3o permitida.");
            }
        }
        if (this.funcionalidadeService.isAtiva(Funcionalidade.FINANCEIRO_DAV) && dav.getTipodocumento().equals((Object)TipoDocumentoDAV.PEDIDO)) {
            BigDecimal somaValoresAVista = dav.getDinheiro().add(dav.getCheque()).add(dav.getDevolucao()).add(dav.getOutros()).add(dav.getPix()).add(dav.getCarteiraDigital()).add(dav.getPosAVista());
            BigDecimal somaValoresAPrazo = dav.getPosAPrazo().add(dav.getOutrosParcelamentos());
            BigDecimal valorPago = dav.getAVista().add(dav.getAPrazo());
            if (valorPago.compareTo(BigDecimal.ZERO) > 0) {
                if (dav.getValor().compareTo(valorPago) != 0) {
                    throw new UnicoMensagemUsuarioException("WFIN1", "O valor pago deve ser igual ao valor do financeiro");
                }
                if (dav.getAVista().compareTo(somaValoresAVista) != 0) {
                    throw new UnicoMensagemUsuarioException("WFIN2", "A soma dos campos 'Dinheiro', 'Cheque', 'Devolu\u00e7\u00e3o', 'Outros', 'Pix', 'Carteira digital' e 'POS \u00e0 vista' deve ser igual ao valor do campo '\u00c0 vista'");
                }
                if (dav.getAPrazo().compareTo(somaValoresAPrazo) != 0) {
                    throw new UnicoMensagemUsuarioException("WFIN403", "A soma dos campos 'POS a prazo' e 'Parcelamento' deve ser igual ao valor do campo 'A prazo'");
                }
            }
        }
        if (!NumberUtil.longNullOuZero((Long)dav.getId()) && (statusDAV = DavRN.getInstance().getStatusDav(dav.getId())) != null) {
            if (statusDAV.equals((Object)StatusDAV.CANCELADO)) {
                throw new UnicoMensagemUsuarioException("COM236589", "O " + dav.getTipodocumento().getDescricao().toLowerCase() + " n\u00e3o pode ser alterado ou excluido porque j\u00e1 foi cancelado");
            }
            if (statusDAV.equals((Object)StatusDAV.NOTAFISCAL_GERADA)) {
                throw new UnicoMensagemUsuarioException("COM236590", "O " + dav.getTipodocumento().getDescricao().toLowerCase() + " n\u00e3o pode ser alterado ou excluido porque j\u00e1 foi gerada uma nota fiscal");
            }
            if (statusDAV.equals((Object)StatusDAV.PDV)) {
                throw new UnicoMensagemUsuarioException("COM1435", "O " + dav.getTipodocumento().getDescricao().toLowerCase() + " n\u00e3o pode ser alterado ou excluido porque j\u00e1 passou pelo PDV");
            }
        }
        BigDecimal valorMinimo = PropriedadeRN.getInstance().getPropriedadeBigDecimal(sessao.getFilial(), 1000030);
        if ((dav.getTipodocumento().equals((Object)TipoDocumentoDAV.PREVENDA) || dav.getTipodocumento().equals((Object)TipoDocumentoDAV.PEDIDO)) && valorMinimo.compareTo(BigDecimal.ZERO) > 0 && dav.getValor().compareTo(valorMinimo) > 0 && NumberUtil.longNullOuZero((Long)dav.getIdCliente())) {
            throw new UnicoMensagemUsuarioException("COM236591", "Por favor informe o cliente pois o valor do pedido ultrapassa R$ " + StringUtil.formataNumero((BigDecimal)valorMinimo, (String)"#,###,###,##0.00", (int)2));
        }
    }

    private void calculaTotalItem(DavItem davItem) {
        DavItemCommonRN.getInstance().calcularTotalItem((AbstractDavItem)davItem);
    }

    private void calcularTotais(Dav dav) throws UnicoMensagemUsuarioException {
        BigDecimal totalQuantidade = BigDecimal.ZERO;
        BigDecimal totalProdutos = BigDecimal.ZERO;
        BigDecimal descontoProdutos = BigDecimal.ZERO;
        BigDecimal baseDescontoSubTotal = BigDecimal.ZERO;
        for (DavItem item : dav.getItens()) {
            if (item.isCancelado() || item.getBrinde() != 0) continue;
            if (!TipoKit.KIT_COMPONENTE.getId().equals(item.getTipoKit())) {
                totalQuantidade = totalQuantidade.add(item.getQuantidade());
                totalProdutos = totalProdutos.add(item.getTotalSemDecontoSubTotal());
            }
            if (TipoKit.KIT_PAI.getId().equals(item.getTipoKit()) || !DescontoRN.getInstance().isItemPermiteDesconto(SessaoUtil.getSessao().getFilial(), (DescontoInterface)item, null)) continue;
            descontoProdutos = descontoProdutos.add(item.getDesconto());
            if (item.getDesconto().compareTo(BigDecimal.ZERO) != 0) continue;
            baseDescontoSubTotal = baseDescontoSubTotal.add(item.getTotalBruto());
        }
        this.rateioDescontoSubTotal(dav, baseDescontoSubTotal);
        if (dav.getValor().subtract(dav.getValorFrete()).subtract(dav.getOutrasDespesas()).setScale(2, RoundingMode.HALF_EVEN).compareTo(totalProdutos.subtract(dav.getDescontoSubTotal()).setScale(2, RoundingMode.HALF_EVEN)) != 0) {
            throw new UnicoMensagemUsuarioException("COM236592", "Os totais do documento n\u00e3o foram validados! Verifique.");
        }
    }

    private void rateioDescontoSubTotal(Dav dav, BigDecimal baseDescontoSubTotal) throws UnicoMensagemUsuarioException {
        BigDecimal descontoSubTotal = dav.getDescontoSubTotal();
        if (descontoSubTotal.compareTo(BigDecimal.ZERO) <= 0) {
            dav.getItens().forEach(item -> {
                item.setDescontoSubTotal(BigDecimal.ZERO);
                this.calculaTotalItem(item);
            });
            return;
        }
        DavItem maiorItem = null;
        BigDecimal rateioTotal = BigDecimal.ZERO;
        for (DavItem item2 : dav.getItens()) {
            if (item2.getDesconto().compareTo(BigDecimal.ZERO) != 0 || item2.getBrinde() == 1 || item2.getTipoKit() == TipoKit.KIT_PAI.getId().intValue()) {
                item2.setDescontoSubTotal(BigDecimal.ZERO);
                item2.setIdUsuarioDesconto(null);
                item2.setNomeUsuarioDesconto(null);
                this.calculaTotalItem(item2);
                continue;
            }
            if (!DescontoRN.getInstance().isItemPermiteDesconto(SessaoUtil.getSessao().getFilial(), (DescontoInterface)item2, null)) continue;
            BigDecimal rateio = item2.getTotalSemDecontoSubTotal().divide(baseDescontoSubTotal, 10, RoundingMode.HALF_EVEN);
            BigDecimal descontoItem = descontoSubTotal.multiply(rateio).setScale(2, RoundingMode.HALF_EVEN);
            item2.setDescontoSubTotal(descontoItem);
            this.calculaTotalItem(item2);
            rateioTotal = rateioTotal.add(descontoItem);
            if (maiorItem != null && item2.getTotalBruto().compareTo(maiorItem.getTotalBruto()) <= 0) continue;
            maiorItem = item2;
        }
        if (descontoSubTotal.compareTo(rateioTotal) != 0) {
            BigDecimal diferenca = descontoSubTotal.subtract(rateioTotal);
            if (maiorItem != null) {
                maiorItem.setDescontoSubTotal(maiorItem.getDescontoSubTotal().add(diferenca));
                this.calculaTotalItem(maiorItem);
                if (maiorItem.getDescontoSubTotal().compareTo(BigDecimal.ZERO) < 0) {
                    throw new UnicoMensagemUsuarioException("WPVDV232", "Desconto de subtotal inv\u00e1lido");
                }
            }
        }
    }

    private String reescreveTextoMensagem(List<Dav> davs, Long idTextoGenerico) {
        TextoGenerico textoGenerico = (TextoGenerico)TextoGenericoRN.getInstance().buscarPorId(idTextoGenerico);
        String mensagem = textoGenerico.getTexto();
        if (mensagem == null) {
            return null;
        }
        Filial filial = SessaoUtil.getSessao().getFilial();
        mensagem = mensagem.replace(VariavelTextoGenerico.RAZAO_SOCIAL.getId(), filial.getRazaoSocialCompleta());
        mensagem = mensagem.replace(VariavelTextoGenerico.CNPJ_EMPRESA.getId(), filial.getCnpj());
        mensagem = mensagem.replace(VariavelTextoGenerico.NOME_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getNome());
        mensagem = mensagem.replace(VariavelTextoGenerico.INSCRICAO_ESTADUAL_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getInscricaoEstadual());
        mensagem = mensagem.replace(VariavelTextoGenerico.ENDERECO_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getEndereco());
        mensagem = mensagem.replace(VariavelTextoGenerico.NUMERO_ENDERECO_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getNumero());
        mensagem = mensagem.replace(VariavelTextoGenerico.CIDADE_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getCidade());
        mensagem = mensagem.replace(VariavelTextoGenerico.CEP_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getCep());
        mensagem = mensagem.replace(VariavelTextoGenerico.UF_FILIAL_PEDIDO_OU_ORCAMENTO.getId(), filial.getEstado());
        mensagem = mensagem.replace(VariavelTextoGenerico.DATA_ATUAL.getId(), Util.formataDataHora((Temporal)DataHoraFactory.getData(), (String)"dd/MM/yyyy"));
        mensagem = mensagem.replace(VariavelTextoGenerico.DATA_ATUAL.getId(), Util.formataDataHora((Temporal)DataHoraFactory.getData(), (String)"dd/MM/yyyy"));
        mensagem = mensagem.replace(VariavelTextoGenerico.TOTAL_DOCUMENTOS_PEDIDO_OU_ORCAMENTO.getId(), String.valueOf(davs.size()));
        StringBuilder davCodigo = new StringBuilder();
        ArrayList<String> listDavNomeRepresentante = new ArrayList<String>();
        StringBuilder davNomeRepresentante = new StringBuilder();
        String davNomeCliente = "";
        BigDecimal davValor = BigDecimal.ZERO;
        Entidade cliente = null;
        boolean primeiroRegistro = true;
        for (Dav dav : davs) {
            Entidade vendedor = (Entidade)EntidadeRN.getInstance().buscarPorId(dav.getIdRepresentante());
            if (primeiroRegistro) {
                primeiroRegistro = false;
                cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(dav.getIdCliente());
                davCodigo = new StringBuilder(dav.getCodigo().toString());
                if (vendedor != null && !StringUtil.stringNullOrEmpty((String)vendedor.getNome())) {
                    listDavNomeRepresentante.add(vendedor.getNome());
                    davNomeRepresentante = new StringBuilder(vendedor.getNome());
                }
                davNomeCliente = cliente != null ? cliente.getNome() : "";
                davValor = dav.getValor();
                continue;
            }
            davCodigo.append(", ").append(dav.getCodigo());
            if (vendedor != null && !StringUtil.stringNullOrEmpty((String)vendedor.getNome()) && !listDavNomeRepresentante.contains(vendedor.getNome())) {
                davNomeRepresentante.append(", ").append(vendedor.getNome());
            }
            davValor = davValor.add(dav.getValor());
        }
        mensagem = mensagem.replace(VariavelTextoGenerico.CODIGO_DOCUMENTOS_PEDIDO_OU_ORCAMENTO.getId(), davCodigo);
        mensagem = mensagem.replace(VariavelTextoGenerico.NOME_CLIENTE_PEDIDO_OU_ORCAMENTO.getId(), davNomeCliente);
        mensagem = mensagem.replace(VariavelTextoGenerico.VENDEDOR_PEDIDO_OU_ORCAMENTO.getId(), davNomeRepresentante);
        mensagem = mensagem.replace(VariavelTextoGenerico.VALOR_TOTAL_DOCUMENTOS_PEDIDO_OU_ORCAMENTO.getId(), Util.formataNumero((BigDecimal)davValor, (String)"#,##0.00"));
        mensagem = mensagem.replace(VariavelTextoGenerico.VALOR_TOTAL_DOCUMENTOS_POR_EXTENSO_PEDIDO_OU_ORCAMENTO.getId(), new Extenso(davValor).toString());
        if (cliente != null) {
            Cidade c = (Cidade)CidadeRN.getInstance().buscarPorId(cliente.getEndereco().getIdCidade());
            String cidade = c.getNome();
            String cep = cliente.getEndereco().getCep();
            String estado = cliente.getEndereco().getEstado();
            mensagem = mensagem.replace(VariavelTextoGenerico.RAZAO_SOCIAL_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getRazaoSocial());
            mensagem = mensagem.replace(VariavelTextoGenerico.CNPJ_CPF_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getCnpjCpf());
            mensagem = mensagem.replace(VariavelTextoGenerico.INSCRICAO_ESTADUAL_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getInscricaoEstadual());
            mensagem = mensagem.replace(VariavelTextoGenerico.ENDERECO_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getEndereco().getEndereco());
            mensagem = mensagem.replace(VariavelTextoGenerico.BAIRRO_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getEndereco().getBairro());
            mensagem = mensagem.replace(VariavelTextoGenerico.COMPLEMENTO_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getEndereco().getComplemento());
            mensagem = mensagem.replace(VariavelTextoGenerico.NUMERO_ENDERECO_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getEndereco().getNumero());
            mensagem = mensagem.replace(VariavelTextoGenerico.CIDADE_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cidade != null ? cidade : " ");
            mensagem = mensagem.replace(VariavelTextoGenerico.CEP_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cep != null ? cep : " ");
            mensagem = mensagem.replace(VariavelTextoGenerico.UF_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), estado != null ? estado : " ");
            mensagem = mensagem.replace(VariavelTextoGenerico.PROFISSAO_ENTIDADE_PEDIDO_OU_ORCAMENTO.getId(), cliente.getProfissao());
        } else {
            mensagem = mensagem.replaceAll("<@[A-Za-z]+>", "");
        }
        return mensagem;
    }

    @RequestMapping(value={"/estornar-mesclagem"}, method={RequestMethod.POST})
    @DBTransaction
    public void estornarMesclagem(@RequestBody Long id) throws UnicoMensagemUsuarioException {
        if (!DavCommonRN.getInstance().isDocumentoOriginadoMesclagem(id)) {
            throw new UnicoMensagemUsuarioException("DAF199", "N\u00e3o \u00e9 poss\u00edvel estornar o documento selecionado pois o mesmo n\u00e3o \u00e9 originado de mesclagem");
        }
        DavRN.getInstance().estornarMesclagem(SessaoUtil.getSessao(), id, true);
    }

    @PostMapping(value={"/validar-entidade-desconto"})
    @DBTransaction
    public DavAlterarEntidadeDescontoWrapper validarEntidadeDesconto(@RequestBody DavWrapper wrapper, @RequestParam Long idEntidadeAtual) {
        ArrayList<DavItem> itensAlterados = new ArrayList<DavItem>();
        ArrayList<DavItem> itensParaExcluir = new ArrayList<DavItem>();
        for (DavItem item : wrapper.getItens()) {
            EntidadeDesconto entidadeDescontoAtual = EntidadeDescontoRN.getInstance().buscaDescontoProduto(idEntidadeAtual, item.getIdProduto());
            EntidadeDesconto entidadeDescontoAnterior = (EntidadeDesconto)EntidadeDescontoRN.getInstance().buscarPorId(item.getIdEntidadeDesconto());
            if (entidadeDescontoAtual == null) continue;
            if (entidadeDescontoAnterior != null && entidadeDescontoAnterior.getTipoDesconto().equals((Object)entidadeDescontoAtual.getTipoDesconto()) && entidadeDescontoAnterior.getDesconto().compareTo(entidadeDescontoAtual.getDesconto()) == 0) {
                item.setIdEntidadeDesconto(entidadeDescontoAtual.getId());
                item.setEntidadeDesconto(entidadeDescontoAtual);
                itensAlterados.add(item);
                continue;
            }
            itensParaExcluir.add(item);
        }
        return new DavAlterarEntidadeDescontoWrapper(itensAlterados, itensParaExcluir);
    }

    public List<Coluna> getColunasCustomizaveis() {
        return DavRN.getInstance().getColunaGridCustomozavelDavWW();
    }

    public Extras getCampoExtra(String nome, String tabela) {
        if (tabela.equals(DavRN.getInstance().getTabela()) && this.tipoDocumentoDAV != null) {
            return ExtrasRN.getInstance().buscarPorNomeTabela(this.tipoDocumentoDAV.getTabelaCamposExtra());
        }
        return null;
    }
}

