/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.davs.pedidovenda;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoDAV;
import br.intelidata.commons.domain.pojo.pvdav.Dav;
import br.intelidata.commons.domain.regranegocio.DavCommonRN;
import br.intelidata.commons.modulo.documentoauxiliarfaturamento.regranegocio.PedidoRN;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.AtacarejoService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.web.rest.app.crud.davs.DavCrudController;
import java.util.List;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConfiguracaoCampoExtra(TABELA="dav_pedidovenda", QUANTIDADE=QuantidadeCampoExtra.DAV)
@Component(value="pedidos-venda")
@RestController
@RequestMapping(value={"/api/pedidos-venda"})
@SubMenuMapping(MENU="SubMenuVendasGeral", NOME="Pedidos de venda", ROTA="/vendas/pedidos-venda", ICONE="icon-pedido", PROGRAMA=111)
public class PedidoVendaCrudController
extends DavCrudController {
    private final FuncionalidadeService funcionalidadeService;

    public PedidoVendaCrudController(FuncionalidadeService funcionalidadeService, AtacarejoService atacarejoService, ModuloService moduloService) {
        super(funcionalidadeService, atacarejoService, moduloService, TipoDocumentoDAV.PEDIDO);
        this.funcionalidadeService = funcionalidadeService;
    }

    @RequestMapping(value={"/gerar-pedidos-fat"}, method={RequestMethod.POST})
    @DBTransaction
    public void gerarPedidosFaturamento(@RequestBody List<Long> idsPedidos) throws UnicoMensagemUsuarioException {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.FINANCEIRO_DETALHADO_PEDIDO)) {
            throw new UnicoMensagemUsuarioException("WDAF131", "N\u00e3o \u00e9 poss\u00edvel transformar pedido de venda em pedido de faturamento quando a funcionalidade de financeiro detalhado estiver habilitada.");
        }
        if (!ListMapUtil.listNullOrEmpty(idsPedidos)) {
            for (Long id : idsPedidos) {
                PedidoRN.getInstance().importarDav(SessaoUtil.getSessao(), id);
            }
        }
    }

    @RequestMapping(value={"/trocar-filial"})
    @DBTransaction
    public void trocarFilial(@RequestParam Long idPedido, @RequestParam Long idFilial, @RequestParam Long idLocalEstoque) throws UnicoMensagemUsuarioException {
        Dav dav = (Dav)DavRN.getInstance().buscarPorId(idPedido);
        if (dav != null) {
            if (dav.getStatus().in(new AbstractEnum[]{StatusDAV.CANCELADO, StatusDAV.PDV, StatusDAV.NOTAFISCAL_GERADA, StatusDAV.MESCLADO, StatusDAV.TRANSFORMADO, StatusDAV.INCLUIDO_POR_CLIENTE})) {
                throw new UnicoMensagemUsuarioException("WPVDV281", "N\u00e3o \u00e9 permitido trocar a filial de pedidos com status \"" + dav.getStatus().getDescricao() + "\".");
            }
            if (!Util.stringNullOrEmpty((String)dav.getCodigoECommerce())) {
                throw new UnicoMensagemUsuarioException("WPVDV282", "N\u00e3o \u00e9 permitido trocar a filial de pedidos do e-commerce");
            }
            DavCommonRN.getInstance().validaLoteSerie(dav);
            Sessao sessao = SessaoUtil.getSessao();
            DavCommonRN.getInstance().validaTrocaFilial(dav, idFilial, idLocalEstoque, sessao);
            DavCommonRN.getInstance().gravar(1, dav, sessao);
        }
    }
}

