/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.desmontagem.vendas;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.TipoDadoBase;
import br.intelidata.commons.core.sql.usql.Caso;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Constante;
import br.intelidata.commons.core.sql.usql.Escolha;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.RastreabilidadeDocumento;
import br.intelidata.commons.domain.pojo.desmontagem.Desmontagem;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoProdutoReclassificacao;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.DesmontagemRN;
import br.intelidata.commons.domain.regranegocio.FilialCommonRN;
import br.intelidata.commons.modulo.estoque.regranegocio.EstoqueNegativoRN;
import br.intelidata.commons.modulo.notafiscal.enuns.StatusDesmontagemNotaFiscalItem;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemDesmontagemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.produto.regranegocio.LoteRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/desmontagens-vendas"})
public class DesmontagemVendasCrudController
extends CrudController<NotaFiscalItem, NotaFiscalItemRN> {
    public DesmontagemVendasCrudController() {
        super((AbstractRegraNegocio)NotaFiscalItemRN.getInstance(), NotaFiscalItem::new, true, true, false);
    }

    protected GridBuilder<?> getGridBuilder() {
        boolean possuiFiliais = FilialCommonRN.getInstance().getFiliais().size() > 1;
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("iditem", "id", "Id do item do documento", 0, false, new String[0]));
        colunas.add(new ColunaSQL("decimaisquantidade", "decimaisquantidade", "Decimais da quantidade", 0, false, new String[0]));
        colunas.add(new ColunaSQL("decimaispreco", "decimaispreco", "Decimais do pre\u00e7o", 0, false, new String[0]));
        colunas.add(new ColunaSQL("filial", "filial", "Filial", 80, possuiFiliais, new String[0]));
        colunas.add(new ColunaSQL("documento", "documento", "Documento", 150, true, new String[0]));
        colunas.add(new ColunaSQL("modelo", "modelo", "Modelo", 80, true, new String[0]));
        colunas.add(new ColunaSQL("emissao", "emissao", "Emiss\u00e3o", 100, true, new String[0]));
        colunas.add(new ColunaSQL("nomecliente", "nomecliente", "Cliente", 300, true, new String[0]));
        colunas.add(new ColunaSQL("produto", "codigoproduto", "C\u00f3digo", 100, true, new String[0]));
        colunas.add(new ColunaSQL("descricao", "nomeproduto", "Produto", 300, true, new String[0]));
        colunas.add(new ColunaSQL("codigounidademedida", "unidademedida", "UN", 70, true, new String[0]));
        colunas.add(new ColunaSQL("quantidadeoriginal", "quantidade", "Quantidade", 120, true, new String[0]));
        colunas.add(new ColunaSQL("precounitario", "precounitario", "Pre\u00e7o", 120, true, new String[0]));
        colunas.add(new ColunaSQL("total", "valortotalitem", "Total", 120, true, new String[0]));
        colunas.add(new ColunaSQL("cfop", "cfop", "CFOP", 80, true, new String[0]));
        ColunaSQL colunaStatus = new ColunaSQL(new Escolha(new Caso(new Condicao("contadororigemusada", Operador.MAIOR_QUE, 0), new Constante((Object)"S")), new Constante((Object)"N")), "statusdesmontagem");
        colunaStatus.setDescricao("Status");
        colunaStatus.setTamanho(120);
        colunaStatus.setVisivel(true);
        colunaStatus.setVirtual(true);
        colunaStatus.setClasseEnum(StatusDesmontagemNotaFiscalItem.class);
        colunaStatus.setNaoAlterarValorEnum(false);
        colunaStatus.setTipoDadoBase(TipoDadoBase.CHARACTER_VARYING);
        colunaStatus.setClasseValor(String.class);
        colunaStatus.setNaoUtilizarPesquisaRapida(true);
        colunas.add(colunaStatus);
        GridBuilder grid = new GridBuilder("vendaliquida_itens_view", colunas, "desmontagem-vendas");
        grid.addOrdemDefault(new Ordem("emissao", true));
        grid.addOrdemDefault(new Ordem("id", true));
        USelect subSelectStatus = new USelect("desmontagemorigem", "contadororigemusada");
        subSelectStatus.add(new ColunaSQL(Funcao.COUNT, "id", "contadororigemusada", new Object[0]));
        subSelectStatus.add((ColunaSQL)new Referencia("modelo"));
        subSelectStatus.add((ColunaSQL)new Referencia("iditemorigem"));
        subSelectStatus.add(new Condicao("modelo", Operador.IGUAL_REFERENCIA_EXTERNA, "modelo"));
        subSelectStatus.add(new Condicao("iditemorigem", Operador.IGUAL_REFERENCIA_EXTERNA, "id"));
        grid.addReferenciaDefault(new Referencia(subSelectStatus, "contadororigemusada"));
        grid.addReferenciaDefault(new Referencia("tipoProdutoReclassificacao", "tipoProdutoReclassificacao", new String[]{"fk_itvendaliqvw_produto"}));
        grid.addCodicaoDefault(new Condicao("tipoProdutoReclassificacao", Operador.IGUAL, TipoProdutoReclassificacao.RECLASSIFICADO.getId().intValue()));
        USelect subSelectItemFicha = new USelect("fichatecnicadesagregacao", "qtdsubitem");
        subSelectItemFicha.add(new ColunaSQL(Funcao.COUNT, "id", "qtdsubitem", new Object[0]));
        subSelectItemFicha.add((ColunaSQL)new Referencia("codigo", "codigoprodutoficha", new String[]{"fk_fichatecnicadesagreg_prod"}));
        subSelectItemFicha.add(new Condicao("codigoprodutoficha", Operador.IGUAL_REFERENCIA_EXTERNA, "codigoproduto"));
        grid.addReferenciaDefault(new Referencia(subSelectItemFicha, "qtdsubitem"));
        grid.addCodicaoDefault(new Condicao("qtdsubitem", Operador.MAIOR_QUE, 0));
        return grid;
    }

    @RequestMapping(value={"/gerar-desmontagem"})
    @DBTransaction
    public Map<String, Object> incluirDesmontagem(@RequestParam List<Long> ids, @RequestParam List<String> documentos, @RequestParam List<String> modelos, @RequestParam boolean gerarNotaFiscal) throws UnicoMensagemUsuarioException {
        if (Util.listNullOrEmpty(ids)) {
            throw new UnicoMensagemUsuarioException("COM279985", "Selecione um ou mais itens para gerar a desmontagem e notas fiscais.");
        }
        HashMap<String, Object> resultado = new HashMap<String, Object>();
        this.prepareGrid();
        FilterField filtro = new FilterField();
        filtro.setField("id");
        filtro.setFilter("contido_em");
        filtro.setType("String");
        filtro.setValues((String[])ids.stream().map(Objects::toString).toArray(String[]::new));
        FilterField filtro2 = new FilterField();
        filtro2.setField("documento");
        filtro2.setFilter("contido_em");
        filtro2.setType("String");
        filtro2.setValues((String[])documentos.stream().map(Objects::toString).toArray(String[]::new));
        FilterField filtro3 = new FilterField();
        filtro3.setField("modelo");
        filtro3.setFilter("contido_em");
        filtro3.setType("String");
        filtro3.setValues((String[])modelos.stream().map(Objects::toString).toArray(String[]::new));
        ArrayList<FilterField> filtros = new ArrayList<FilterField>();
        filtros.add(filtro);
        filtros.add(filtro2);
        filtros.add(filtro3);
        List dados = this.grid.getDadosWeb(0, 1000, "", null, filtros, null);
        ArrayList lista = new ArrayList();
        for (Object[] obj : dados) {
            LinkedHashMap<String, Object> linha = new LinkedHashMap<String, Object>();
            for (int i = 0; i < this.grid.getColunasSql().size(); ++i) {
                ColunaSQL coluna = (ColunaSQL)this.grid.getColunasSql().get(i);
                linha.put(coluna.getAlias(), obj[i]);
            }
            lista.add(linha);
        }
        Sessao sessao = SessaoUtil.getSessao();
        String msg = "";
        List desmontagensGeradas = DesmontagemRN.getInstance().geraDesmontagensDeVendas(sessao, lista);
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(Contexto.getInstance().getFilial(), 1005) || this.isPrecisaInformarLote(desmontagensGeradas)) {
            resultado.put("desmontagensGeradas", desmontagensGeradas);
        } else {
            if (desmontagensGeradas.stream().anyMatch(desmontagem -> Util.bigDecimalNullOrZero((BigDecimal)desmontagem.getPrecoUnitario()))) {
                if (desmontagensGeradas.size() == 1) {
                    throw new UnicoMensagemUsuarioException("WEST121", "O produto " + ((Desmontagem)desmontagensGeradas.get(0)).getNomeProduto() + " n\u00e3o possui custo, e sua desmontagem n\u00e3o ser\u00e1 gravada! Verifique.");
                }
                msg = "As desmontagens onde o produto principal n\u00e3o possui custo ser\u00e3o ignoradas!\nVerifique abaixo as desmontagens com esse problema:" + DesmontagemRN.getInstance().geraMensagemDesmontagensSemCusto(desmontagensGeradas);
            }
            EstoqueNegativoRN.getInstance().validarEstoqueDesmontagens(sessao, desmontagensGeradas);
            DesmontagemRN.getInstance().gravarDesmontagensGeradas(sessao, desmontagensGeradas, gerarNotaFiscal);
            msg = msg + (!Util.listNullOrEmpty((List)desmontagensGeradas) ? "<br><br>Desmontagem realizada com sucesso!<br>" + DesmontagemRN.getInstance().geraMensagemDesmontagensGeradas(desmontagensGeradas) : "");
            resultado.put("mensagem", msg.replace(Util.newLine(), "<br>"));
        }
        return resultado;
    }

    @RequestMapping(value={"/buscar-rastreabilidade"})
    @DBAutoCommit
    public List<RastreabilidadeDocumento> buscarRastreabilidade(@RequestParam Long idOrigem) {
        FilterField filtro = new FilterField();
        filtro.setField("id");
        filtro.setFilter("igual");
        filtro.setType("String");
        filtro.setValue1(idOrigem.toString());
        List dados = this.grid.getDadosWeb(0, 1000, "", null, Collections.singletonList(filtro), null);
        int idxModelo = this.grid.getIndexColuna("modelo", this.grid.getColunasSql());
        if (idxModelo > -1) {
            String modelo = (String)((Object[])dados.get(0))[idxModelo];
            return NotaFiscalItemDesmontagemRN.getInstance().buscarListaRastreabilidade((ModeloNotaFiscal)EnumUtils.getPorId(ModeloNotaFiscal.class, (Object)modelo), idOrigem);
        }
        return null;
    }

    private boolean isPrecisaInformarLote(List<Desmontagem> desmontagens) {
        boolean precisaInformarLote = false;
        if (LoteRN.getInstance().isSistemaControlaLote() && !Util.listNullOrEmpty(desmontagens)) {
            precisaInformarLote = desmontagens.stream().anyMatch(desmontagem -> LoteRN.getInstance().isLoteManual(SessaoUtil.getSessao().getFilial(), desmontagem.getIdProduto()));
        }
        return precisaInformarLote;
    }

    protected String getCacheId() {
        return "/api/desmontagens-vendas".concat("_ID_FILIAL_").concat(SessaoUtil.getSessao().getFilial().getId().toString());
    }
}

