/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.ecommerce.configuracaotransportadora;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.ecommerce.ConfiguracaoEcommerceTransportadora;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ecommerce.ConfiguracaoEcommerceTransportadoraRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;

public class ConfiguracaoTransportadoraAbstract
extends CrudController<ConfiguracaoEcommerceTransportadora, ConfiguracaoEcommerceTransportadoraRN> {
    @Autowired
    public ConfiguracaoTransportadoraAbstract() {
        super((AbstractRegraNegocio)ConfiguracaoEcommerceTransportadoraRN.getInstance(), ConfiguracaoEcommerceTransportadora::new, true, true);
    }

    protected String getCacheId() {
        return "configuracao-ecommerce-transportadora";
    }

    protected GridBuilder<ConfiguracaoEcommerceTransportadoraRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        if (LicencaManager.getInstance().isEnterprise()) {
            colunas.add(new ColunaSQL("codigo", "codigofilial", "C\u00f3digo filial", 120, true, new String[]{"fk_config_transp_filial"}));
            colunas.add(new ColunaSQL("nome", "nomefilial", "Nome filial", 350, true, new String[]{"fk_config_transp_filial"}));
        }
        colunas.add(new ColunaSQL("inativo", "inativo", "Inativo", 80, true, new String[0]));
        GridBuilder grid = new GridBuilder(((ConfiguracaoEcommerceTransportadoraRN)this.rn).getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("nome"));
        return grid;
    }

    protected void beforeSave(ConfiguracaoEcommerceTransportadora configuracao, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (!LicencaManager.getInstance().isEnterprise()) {
            configuracao.setIdFilial(SessaoUtil.getSessao().getIdFilial());
        }
    }

    @RequestMapping(value={"existe-configuracao"})
    @DBAutoCommit
    public boolean existeConfiguracao() {
        return ConfiguracaoEcommerceTransportadoraRN.getInstance().buscarPorIdFilialAtiva(SessaoUtil.getSessao().getFilial().getId()) != null;
    }
}

