/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.filial.signatario;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.Signatario;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.SignatarioRN;
import br.intelidata.commons.sped.contabil.IdentificacaoSignatario;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/signatarios"})
public class SignatarioCrudController
extends CrudController<Signatario, SignatarioRN> {
    public SignatarioCrudController() {
        super((AbstractRegraNegocio)SignatarioRN.getInstance(), Signatario::new);
        this.dependsOn("idFilial");
    }

    protected void beforeSave(Signatario signatario, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (Util.longNullOuZero((Long)signatario.getIdFilial())) {
            throw new UnicoMensagemUsuarioException("WWW64", "Id filial nao informado");
        }
        if (Util.stringNullOrEmpty((String)signatario.getNome())) {
            throw new UnicoMensagemUsuarioException("WWW61", "Campo Nome n\u00e3o informado");
        }
        if (Util.stringNullOrEmpty((String)signatario.getCpf())) {
            throw new UnicoMensagemUsuarioException("WWW62", "Campo Cpf n\u00e3o informado");
        }
        Util.validaCPFCNPJ((int)0, (String)signatario.getCpf());
        if (signatario.getIdentificacaoSignatario() == null) {
            throw new UnicoMensagemUsuarioException("WWW63", "Campo Tipo n\u00e3o selecionado");
        }
    }

    protected GridBuilder<SignatarioRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("idFilial", "idFilial", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        colunas.add(new ColunaSQL("cpf", "CPF", 300, true));
        colunas.add(new ColunaSQL("identificacaoSignatario", "identificacaoSignatario", 0, true, IdentificacaoSignatario.class));
        return new GridBuilder(SignatarioRN.getInstance().getTabela(), colunas);
    }

    protected String getCacheId() {
        return "signatarios";
    }
}

