/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.model.Coluna;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.sql.usql.USelect;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.EnumSimNao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Banco;
import br.intelidata.commons.domain.pojo.ConfiguracoesAdicionaisFinanceiro;
import br.intelidata.commons.domain.pojo.Devolucao;
import br.intelidata.commons.domain.pojo.EncargoFinanceiro;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.EventoFinanceiro;
import br.intelidata.commons.domain.pojo.EventoFinanceiroDestino;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.FinanceiroImagem;
import br.intelidata.commons.domain.pojo.FinanceiroLancamento;
import br.intelidata.commons.domain.pojo.HierarquiaPlanoContas;
import br.intelidata.commons.domain.pojo.PagamentoRecorrente;
import br.intelidata.commons.domain.pojo.ParametroCalculoEncargo;
import br.intelidata.commons.domain.pojo.StatusExclusaoEventoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.EEventos;
import br.intelidata.commons.domain.pojo.enuns.StatusDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.financeiro.ColunaValorFinanceiroLancamento;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteCarteira;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteLancamento;
import br.intelidata.commons.domain.pojo.financeiro.PagamentoFinanceiro;
import br.intelidata.commons.domain.pojo.financeiro.TipoCobranca;
import br.intelidata.commons.domain.pojo.financeiro.TipoFinanceiro;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.DocumentoCobranca;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.TipoImpressaoUBoleto;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.TipoSaidaBoleto;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.BancoCommonRN;
import br.intelidata.commons.domain.regranegocio.ContaCorrenteCarteiraCommonRN;
import br.intelidata.commons.domain.regranegocio.FinanceiroDadoCommonRN;
import br.intelidata.commons.domain.regranegocio.FinanceiroImagemCommonRN;
import br.intelidata.commons.domain.regranegocio.PerfilPermissaoCommonRN;
import br.intelidata.commons.domain.regranegocio.TipoDocumentoFinanceiroCommonRN;
import br.intelidata.commons.domain.regranegocio.financeiro.cobranca.CobrancaEscrituralRN;
import br.intelidata.commons.domain.regranegocio.financeiro.cobranca.RemessaCobrancaEscritural;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.devolucao.regranegocio.DevolucaoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.ContatoEntidadeRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.centrocusto.enuns.TipoRateioCentroCusto;
import br.intelidata.commons.modulo.financeiro.centrocusto.regranegocio.CentroCustoRateioRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.BancoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteLancamentoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.DescontoDocumentoFinanceiroItemRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.EventoFinanceiroDestinoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.EventoFinanceiroRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroLancamentoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.NegociacaoFinanceiroOrigemRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.TipoCobrancaRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.TipoDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.produto.dao.ColunaCustomizavelStatusCoferenciaNFFinanceiro;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.PropriedadeService;
import br.intelidata.uniplusweb.service.socket.NotificationType;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.FinanceiroWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.IFileFinanceiro;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.ReabrirChequeWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.AcrescimoDescontoWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.BaixaDocumentoFinanceiroWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.CalculoEncargoFinanceiroWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ExclusaoEstornoDocumentosFinanceirosWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ParametrosValidacaoDocumentosFinanceirosWrapper;
import br.intelidata.uniplusweb.web.rest.app.wrapper.TrocaEndossoWrapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/financeiros"})
public class FinanceiroCrudController
extends CrudController<FinanceiroDado, FinanceiroDadoRN>
implements IFileFinanceiro {
    private final TipoFinanceiro tipoFinanceiro;
    private PropriedadeService propriedadeService;
    private FuncionalidadeService funcionalidadeService;
    private TaskManager taskManager;

    @Autowired
    public FinanceiroCrudController(ResponseEntityService responseEntityService, PropriedadeService propriedadeService, FuncionalidadeService funcionalidadeService, TaskManager taskManager) {
        this(responseEntityService, propriedadeService, funcionalidadeService, null, taskManager);
        this.propriedadeService = propriedadeService;
        this.funcionalidadeService = funcionalidadeService;
        this.taskManager = taskManager;
    }

    public FinanceiroCrudController(ResponseEntityService responseEntityService, PropriedadeService propriedadeService, FuncionalidadeService funcionalidadeService, TipoFinanceiro tipoFinanceiro, TaskManager taskManager) {
        super((AbstractRegraNegocio)FinanceiroDadoRN.getInstance(), FinanceiroDado::new, true, true);
        this.propriedadeService = propriedadeService;
        this.funcionalidadeService = funcionalidadeService;
        this.responseEntityService = responseEntityService;
        this.tipoFinanceiro = tipoFinanceiro;
        this.taskManager = taskManager;
    }

    @DBAutoCommit
    public String lastValidCode() {
        String numeroDocumento = TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro) ? PropriedadeRN.getInstance().getPropriedadeString(SessaoUtil.getSessao().getFilial(), 734) + (PropriedadeRN.getInstance().getPropriedadeInt(SessaoUtil.getSessao().getFilial(), 736) + 1) : PropriedadeRN.getInstance().getPropriedadeString(SessaoUtil.getSessao().getFilial(), 733) + (PropriedadeRN.getInstance().getPropriedadeInt(SessaoUtil.getSessao().getFilial(), 735) + 1);
        return numeroDocumento;
    }

    @RequestMapping(value={"/documentos-cobranca-remessa"})
    @DBAutoCommit
    public List<DocumentoCobranca> getDocumentosCobrancaRemessa(@RequestParam(required=false) LocalDate vencInicial, @RequestParam(required=false) LocalDate vencFinal, @RequestParam(required=false) LocalDate emitInicial, @RequestParam(required=false) LocalDate emitFinal, @RequestParam(required=false) Long idEntidade, @RequestParam(required=false) Long idContaCorrente, @RequestParam(required=false, defaultValue="0") Integer statusRemessa, @RequestParam(required=false) Long idTipoDocumento, @RequestParam(required=false) Long idCidade, @RequestParam(required=false) Long idEstado, @RequestParam(required=false) Long idRota) {
        return FinanceiroDadoRN.getInstance().buscarDocumentosCobranca(SessaoUtil.getSessao(), null, vencInicial, vencFinal, emitInicial, emitFinal, idEntidade, idContaCorrente, statusRemessa, false, Collections.singletonList(SessaoUtil.getSessao().getIdFilial()), idTipoDocumento, idEstado, idCidade, idRota);
    }

    @RequestMapping(value={"/documentos-remessa"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<DocumentoCobranca> getDocumentosCobrancaRemessa(@RequestBody List<Long> idsDocumentos) throws UnicoMensagemUsuarioException {
        if (Util.listNullOrEmpty(idsDocumentos)) {
            throw new UnicoMensagemUsuarioException("WCBE56", "Os documentos n\u00e3o foram informados!");
        }
        return FinanceiroDadoRN.getInstance().buscarDocumentosParaRemessa(SessaoUtil.getSessao(), idsDocumentos);
    }

    @RequestMapping(value={"/buscar-validar-documentos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<FinanceiroDado> getListaDocumentosSelecionados(@RequestBody ParametrosValidacaoDocumentosFinanceirosWrapper parametros) throws UnicoMensagemUsuarioException {
        List<FinanceiroDado> documentos = parametros.getIdsDocumentos().stream().map(id -> (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(id)).filter(Objects::nonNull).peek(financeiroDado -> {
            if (parametros.isAtualizarDadosPagmto()) {
                financeiroDado.setPagamento(DataHoraFactory.getData());
                financeiroDado.setBaixa(DataHoraFactory.getData());
                financeiroDado.setValorPago(BigDecimal.ZERO);
                financeiroDado.setIdUsuario(SessaoUtil.getSessao().getIdUsuario());
            }
        }).collect(Collectors.toList());
        if (ListMapUtil.listNullOrEmpty(documentos)) {
            throw new UnicoMensagemUsuarioException("FIN303", "Documentos n\u00e3o encontrados.");
        }
        if (parametros.isValidarDocumentos()) {
            for (FinanceiroDado financeiroDado2 : documentos) {
                if (financeiroDado2.getStatus().equals(StatusDocumentoFinanceiro.ABERTO.getId())) continue;
                throw new UnicoMensagemUsuarioException("FIN304", "Selecione somente documentos abertos.");
            }
        }
        if (parametros.isValidarNegociacao()) {
            this.validarNegociacao(documentos);
        }
        if (parametros.isPrepararBaixa()) {
            this.prepararDocumentosParaBaixa(documentos);
        }
        return documentos;
    }

    @RequestMapping(value={"/zerar-nosso-numero"}, method={RequestMethod.POST})
    @DBTransaction
    public void zerarNossoNumero(@RequestBody ParametrosValidacaoDocumentosFinanceirosWrapper parametros) throws UnicoMensagemUsuarioException {
        FinanceiroDadoRN.getInstance().zerarNossoNumero(SessaoUtil.getSessao(), this.getListaDocumentosSelecionados(parametros));
    }

    @RequestMapping(value={"/documentos-boletos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<FinanceiroDado> getDocumentosFinanceirosBoletos(@RequestBody ParametrosValidacaoDocumentosFinanceirosWrapper parametros) throws UnicoMensagemUsuarioException {
        List listaDocumentosSelecionados = this.getListaDocumentosSelecionados(parametros);
        if (listaDocumentosSelecionados != null) {
            ArrayList<FinanceiroDado> documentosParaRemover = new ArrayList<FinanceiroDado>();
            for (FinanceiroDado fd : listaDocumentosSelecionados) {
                if (fd.getTipoDocumento().isPermiteGerarBoleto() && fd.getTipoDocumento().getAcao().equals((Object)TipoAcaoFinanceiro.RECEBER)) continue;
                documentosParaRemover.add(fd);
            }
            for (FinanceiroDado fd : documentosParaRemover) {
                listaDocumentosSelecionados.remove(fd);
            }
            if (Util.listNullOrEmpty((List)listaDocumentosSelecionados)) {
                throw new UnicoMensagemUsuarioException("WFIN109", "N\u00e3o \u00e9 permitido gerar boletos dos documentos que foram selecionados! Verifique.");
            }
            if (!Util.listNullOrEmpty(documentosParaRemover)) {
                this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, "Alguns documentos foram exclu\u00eddos da gera\u00e7\u00e3o dos boletos por n\u00e3o possu\u00edrem permiss\u00e3o para essa opera\u00e7\u00e3o.");
            }
        }
        return listaDocumentosSelecionados;
    }

    @RequestMapping(value={"/imprimir-2-via-boleto"}, method={RequestMethod.POST})
    @DBTransaction
    public ResponseEntity<byte[]> gerar2ViaBoleto(@RequestBody List<FinanceiroDado> documentos) throws UnicoMensagemUsuarioException {
        Long idContaBoleto = documentos.get(0).getIdContaGeraBoleto();
        Long idCarteira = documentos.get(0).getIdCarteiraGeradaUBoleto();
        Integer diasInstrucaoCobranca = documentos.get(0).getDiasInstrucaoCobrancaBoleto();
        List idsDocumentos = documentos.stream().map(FinanceiroDado::getId).collect(Collectors.toList());
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(idContaBoleto);
        if (contaCorrente == null) {
            throw new UnicoMensagemUsuarioException("COM236544", "Conta corrente n\u00e3o encontrado");
        }
        if (!ContaCorrenteRN.getInstance().isContaCorrenteImprimeBoleto(contaCorrente.getId())) {
            throw new UnicoMensagemUsuarioException("WWW668", "Esta conta corrente n\u00e3o emite boletos.");
        }
        TipoImpressaoUBoleto tipoImpressao = contaCorrente.getTipoImpressaoUBoleto();
        Banco banco = (Banco)BancoCommonRN.getInstance().buscarPorId(contaCorrente.getIdbanco());
        if (banco == null) {
            throw new UnicoMensagemUsuarioException("COM236545", "Banco n\u00e3o encontrado");
        }
        ContaCorrenteCarteira contaCarteira = (ContaCorrenteCarteira)ContaCorrenteCarteiraCommonRN.getInstance().buscarPorId(idCarteira);
        if (contaCarteira == null) {
            List carteiras = ContaCorrenteCarteiraCommonRN.getInstance().buscarListaPorContaCorrente(idContaBoleto, true);
            if (Util.listNullOrEmpty((List)carteiras) || carteiras.size() > 1) {
                throw new UnicoMensagemUsuarioException("COM236546", "Carteira n\u00e3o encontrada");
            }
            contaCarteira = (ContaCorrenteCarteira)carteiras.get(0);
        }
        RemessaCobrancaEscritural remessa = CobrancaEscrituralRN.getInstance().imprimirBoletosWeb(SessaoUtil.getSessao(), FinanceiroDadoRN.getInstance().buscarDocumentosParaRemessa(SessaoUtil.getSessao(), idsDocumentos), contaCorrente, contaCarteira, banco, false, TipoSaidaBoleto.IMPRESSORA, null, tipoImpressao, PropriedadeRN.getInstance().getPropriedadeBigDecimal(SessaoUtil.getSessao().getFilial(), 592), null, diasInstrucaoCobranca, null);
        return this.responseEntityService.createPDFResponse(remessa.getRemessa(), remessa.getNomeArquivo());
    }

    @RequestMapping(value={"/validar-negociacao"})
    @DBAutoCommit
    public boolean validarNegociacao(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        return this.validarNegociacao(Collections.singletonList(FinanceiroDadoRN.getInstance().buscarPorId(id)));
    }

    @RequestMapping(value={"/calcular-encargos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public CalculoEncargoFinanceiroWrapper calculaEncargosFinanceiro(@RequestBody CalculoEncargoFinanceiroWrapper encargos) throws UnicoMensagemUsuarioException {
        Map parametros = FinanceiroDadoRN.getInstance().getParametrosCalculoEncargo();
        Map parametrosEncargosPorContaCorrente = ContaCorrenteRN.getInstance().getParametrosCalculoEncargoPorContaCorrente();
        Map parametrosTiposDocumentos = TipoDocumentoFinanceiroCommonRN.getInstance().getParametrosCalculoEncargoPorTipoDocumento();
        if (parametros != null) {
            BigDecimal valorJuros = BigDecimal.ZERO;
            BigDecimal valorMulta = BigDecimal.ZERO;
            BigDecimal valorDesconto = BigDecimal.ZERO;
            List documentos = encargos.getDocumentos().stream().map(financeiroDado -> (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(financeiroDado.getId())).filter(Objects::nonNull).collect(Collectors.toList());
            for (FinanceiroDado documento : documentos) {
                EncargoFinanceiro encargo;
                ParametroCalculoEncargo parametro = null;
                if (!Util.longNullOuZero((Long)documento.getIdContaGeraBoleto())) {
                    parametro = (ParametroCalculoEncargo)parametrosEncargosPorContaCorrente.get(documento.getIdContaGeraBoleto());
                }
                if (parametro == null && (parametro = (ParametroCalculoEncargo)parametrosTiposDocumentos.get(documento.getTipoDocumento().getId())) == null) {
                    parametro = (ParametroCalculoEncargo)parametros.get(documento.getIdFilial());
                }
                if ((encargo = FinanceiroDadoRN.getInstance().calcularEncargosFinanceiros(encargos.getPagamento(), documento.getSaldo(), documento.getVencimentoCalculoEncargos() != null ? documento.getVencimentoCalculoEncargos() : documento.getVencimento(), parametro, documento.getVencimentoCalculoEncargos() != null && documento.getVencimentoCalculoEncargos().compareTo(documento.getVencimento()) != 0)) == null) continue;
                valorJuros = valorJuros.add(encargo.getValorJuros());
                valorMulta = valorMulta.add(encargo.getValorMulta());
                valorDesconto = valorDesconto.add(encargo.getDesconto());
            }
            encargos.setJuros(valorJuros);
            encargos.setMulta(valorMulta);
            encargos.setDesconto(valorDesconto);
            BigDecimal valorParaPagar = encargos.getDocumentos().stream().map(FinanceiroDado::getSaldo).reduce(BigDecimal.ZERO, BigDecimal::add);
            if (!NumberUtil.bigDecimalNullOrZero((BigDecimal)valorDesconto) && !NumberUtil.bigDecimalNullOrZero((BigDecimal)valorParaPagar)) {
                encargos.setPercentualDescontoAnterior(valorDesconto.divide(valorParaPagar, 6, RoundingMode.HALF_EVEN).multiply(Util.CEM).setScale(2, RoundingMode.HALF_EVEN));
            }
            return encargos;
        }
        throw new UnicoMensagemUsuarioException("FIN308", "Par\u00e2metros de financeiro n\u00e3o definido");
    }

    @RequestMapping(value={"/saldo-devolucao"})
    @DBAutoCommit
    public BigDecimal buscarSaldoDevolucao(@RequestParam String documento, @RequestParam Long idEntidade) throws UnicoMensagemUsuarioException {
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.SALDO_DEVOLUCAO_CONTROLADO_FINANCEIRO)) {
            return this.buscarFinanceiroSaldoDevolucao(documento, idEntidade).getSaldo();
        }
        Devolucao devolucao = DevolucaoRN.getInstance().buscarPorCodigo(Long.valueOf(documento), SessaoUtil.getSessao().getIdFilial());
        if (devolucao != null) {
            if (idEntidade.equals(devolucao.getIdcliente())) {
                if (SessaoUtil.getSessao().getIdFilial().equals(devolucao.getIdfilial())) {
                    return devolucao.getSaldo();
                }
                throw new UnicoMensagemUsuarioException("WFIN91", "Devolu\u00e7\u00e3o n\u00e3o pertence \u00e0 filial que ter\u00e1 os documentos baixados! Verifique.");
            }
            throw new UnicoMensagemUsuarioException("WFIN92", "Devolu\u00e7\u00e3o n\u00e3o pertence ao cliente que ter\u00e1 os documentos baixados! Verifique.");
        }
        throw new UnicoMensagemUsuarioException("WFIN93", "Devolu\u00e7\u00e3o n\u00e3o encontrada! Verifique.");
    }

    @RequestMapping(value={"/saldo-devolucao-controlado-financeiro"})
    @DBAutoCommit
    public FinanceiroDado buscarFinanceiroSaldoDevolucao(@RequestParam String documento, @RequestParam Long idEntidade) throws UnicoMensagemUsuarioException {
        FinanceiroDado financeiroDado = FinanceiroDadoRN.getInstance().buscarPorNumeroDocumento(documento, idEntidade, SessaoUtil.getSessao().getIdFilial());
        if (financeiroDado != null) {
            return financeiroDado;
        }
        throw new UnicoMensagemUsuarioException("WFIN84", "Documento n\u00e3o encontrada! Verifique.");
    }

    @RequestMapping(value={"/documento-cadastrado"})
    @DBAutoCommit
    public boolean verificarDocumentoCadastrado(@RequestParam Long idBanco, @RequestParam String agencia, @RequestParam String conta, @RequestParam String numeroCheque) throws UnicoMensagemUsuarioException {
        FinanceiroDado chequeExistente = FinanceiroDadoRN.getInstance().buscarChequePorNumero(idBanco, agencia, conta, numeroCheque);
        if (chequeExistente != null) {
            throw new UnicoMensagemUsuarioException("WFIN87", "O cheque: [" + chequeExistente.getDocumento() + "] ag\u00eancia: [" + chequeExistente.getAgencia() + "] conta: [" + chequeExistente.getNumeroContaCorrente() + "], j\u00e1 foi cadastrado em outra baixa! Verifique");
        }
        return false;
    }

    @RequestMapping(value={"/baixar-documentos"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public List<Long> baixarDocumentos(@RequestPart(required=false) MultipartFile file, @RequestPart(value="baixaDocumento") BaixaDocumentoFinanceiroWrapper baixaDocumento, @RequestPart(name="gravarArquivos", required=false) EnumSimNao gravarArquivos, @RequestPart(name="descricao", required=false) String descricao, @RequestPart(name="nomeArquivo", required=false) String nomeArquivo) throws UnicoMensagemUsuarioException {
        int numeroPropriedade;
        ArrayList<FinanceiroDado> documentosBaixados = new ArrayList<FinanceiroDado>();
        Map parametros = FinanceiroDadoRN.getInstance().getParametrosCalculoEncargo();
        Map parametrosTiposDocumentos = TipoDocumentoFinanceiroCommonRN.getInstance().getParametrosCalculoEncargoPorTipoDocumento();
        Map parametrosEncargosPorContaCorrente = ContaCorrenteRN.getInstance().getParametrosCalculoEncargoPorContaCorrente();
        boolean entidadeDiferente = false;
        Long idEntidadeAnterior = null;
        for (FinanceiroDado documentoVerificar : baixaDocumento.getDocumentos()) {
            FinanceiroDado documentoVerificado = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(documentoVerificar.getId());
            if (documentoVerificado == null) {
                throw new UnicoMensagemUsuarioException("WFIN68", "Documento " + documentoVerificar.getDocumento() + " n\u00e3o existe! \nTalvez, durante o processo de informar os dados da baixa, algum usu\u00e1rio excluiu este documento! Verifique.\nImposs\u00edvel continuar!");
            }
            if (!entidadeDiferente) {
                if (idEntidadeAnterior == null) {
                    idEntidadeAnterior = documentoVerificado.getIdEntidade();
                } else if (!idEntidadeAnterior.equals(documentoVerificado.getIdEntidade())) {
                    entidadeDiferente = true;
                }
            }
            if (TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro)) {
                EncargoFinanceiro encargo;
                ParametroCalculoEncargo parametro = null;
                if (!Util.longNullOuZero((Long)documentoVerificado.getIdContaGeraBoleto())) {
                    parametro = (ParametroCalculoEncargo)parametrosEncargosPorContaCorrente.get(documentoVerificado.getIdContaGeraBoleto());
                }
                if (parametro == null && (parametro = (ParametroCalculoEncargo)parametrosTiposDocumentos.get(documentoVerificado.getTipoDocumento().getId())) == null) {
                    parametro = (ParametroCalculoEncargo)parametros.get(documentoVerificado.getIdFilial());
                }
                if ((encargo = FinanceiroDadoRN.getInstance().calcularEncargosFinanceiros(baixaDocumento.getPagamento(), documentoVerificado.getSaldo(), documentoVerificado.getVencimentoCalculoEncargos() != null ? documentoVerificado.getVencimentoCalculoEncargos() : documentoVerificado.getVencimento(), parametro, documentoVerificado.getVencimentoCalculoEncargos() != null && documentoVerificado.getVencimentoCalculoEncargos().compareTo(documentoVerificado.getVencimento()) != 0)) != null) {
                    documentoVerificado.setJuros(encargo.getValorJuros());
                    documentoVerificado.setMulta(encargo.getValorMulta());
                    documentoVerificado.setDesconto(encargo.getDesconto());
                }
            }
            documentosBaixados.add(documentoVerificado);
        }
        if (ListMapUtil.listNullOrEmpty((List)baixaDocumento.getPagamentos())) {
            throw new UnicoMensagemUsuarioException("WFIN69", "Efetue um lan\u00e7amento de baixa");
        }
        for (PagamentoFinanceiro pagamento : baixaDocumento.getPagamentos()) {
            if (ListMapUtil.listNullOrEmpty((List)pagamento.getDocumentosTrocaEndosso())) continue;
            ArrayList<FinanceiroDado> documentos = new ArrayList<FinanceiroDado>(pagamento.getDocumentosTrocaEndosso().size());
            for (FinanceiroDado doc : pagamento.getDocumentosTrocaEndosso()) {
                FinanceiroDado documento = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(doc.getId());
                if (documento == null) {
                    throw new UnicoMensagemUsuarioException("WWW296", "Documento ".concat(doc.getDocumento()).concat(" n\u00e3o encontrado."));
                }
                documento.setMulta(doc.getMulta());
                documento.setJuros(doc.getJuros());
                documentos.add(documento);
            }
            pagamento.setDocumentosTrocaEndosso(documentos);
        }
        HierarquiaPlanoContas planoContaJuros = null;
        HierarquiaPlanoContas planoContaMulta = null;
        HierarquiaPlanoContas planoContaDesconto = null;
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PLANO_DE_CONTAS)) {
            if (!NumberUtil.longNullOuZero((Long)baixaDocumento.getIdPlanoContasJuros())) {
                planoContaJuros = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(baixaDocumento.getIdPlanoContasJuros());
            }
            if (!NumberUtil.longNullOuZero((Long)baixaDocumento.getIdPlanoContasMulta())) {
                planoContaMulta = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(baixaDocumento.getIdPlanoContasMulta());
            }
            if (!NumberUtil.longNullOuZero((Long)baixaDocumento.getIdPlanoContasDesconto())) {
                planoContaDesconto = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(baixaDocumento.getIdPlanoContasDesconto());
            }
            if (planoContaJuros == null && !Util.bigDecimalNullOrZero((BigDecimal)baixaDocumento.getJuros())) {
                throw new UnicoMensagemUsuarioException("WFIN193", "Plano de contas de juros n\u00e3o foi informado!");
            }
            if (planoContaMulta == null && !Util.bigDecimalNullOrZero((BigDecimal)baixaDocumento.getMulta())) {
                throw new UnicoMensagemUsuarioException("WFIN194", "Plano de contas de multa n\u00e3o foi informado!");
            }
            if (planoContaDesconto == null && !Util.bigDecimalNullOrZero((BigDecimal)baixaDocumento.getDesconto())) {
                throw new UnicoMensagemUsuarioException("WFIN195", "Plano de contas de desconto n\u00e3o foi informado!");
            }
        }
        List rateiosDesconto = null;
        TipoRateioCentroCusto tipoRateioDesconto = null;
        List rateiosJuros = null;
        TipoRateioCentroCusto tipoRateioJuros = null;
        List rateiosMulta = null;
        TipoRateioCentroCusto tipoRateioMulta = null;
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CENTRO_CUSTO)) {
            if (planoContaDesconto != null && planoContaDesconto.isCentroCustoObrigatorio() && !Util.bigDecimalNullOrZero((BigDecimal)baixaDocumento.getDesconto())) {
                rateiosDesconto = baixaDocumento.getRateiosDesconto();
                CentroCustoRateioRN.getInstance().validarRateio(baixaDocumento.getDesconto(), rateiosDesconto);
                tipoRateioDesconto = baixaDocumento.getTipoRateioDesconto();
            }
            if (planoContaJuros != null && planoContaJuros.isCentroCustoObrigatorio() && !Util.bigDecimalNullOrZero((BigDecimal)baixaDocumento.getJuros())) {
                rateiosJuros = baixaDocumento.getRateiosJuros();
                CentroCustoRateioRN.getInstance().validarRateio(baixaDocumento.getJuros(), rateiosJuros);
                tipoRateioJuros = baixaDocumento.getTipoRateioJuros();
            }
            if (planoContaMulta != null && planoContaMulta.isCentroCustoObrigatorio() && !Util.bigDecimalNullOrZero((BigDecimal)baixaDocumento.getMulta())) {
                rateiosMulta = baixaDocumento.getRateiosMulta();
                CentroCustoRateioRN.getInstance().validarRateio(baixaDocumento.getMulta(), rateiosMulta);
                tipoRateioMulta = baixaDocumento.getTipoRateioMulta();
            }
        }
        List<Long> idsEventos = FinanceiroDadoRN.getInstance().efetuarBaixaDocumentosFinanceiro(SessaoUtil.getSessao(), this.tipoFinanceiro, documentosBaixados, baixaDocumento.getPagamentos(), baixaDocumento.getDesconto(), baixaDocumento.getJuros(), baixaDocumento.getMulta(), baixaDocumento.getPagamento(), baixaDocumento.getBaixa(), baixaDocumento.getHistorico(), baixaDocumento.getObservacao(), baixaDocumento.isAlterarPlanoConta() ? baixaDocumento.getIdPlanoContas() : null, baixaDocumento.isAlterarPlanoConta(), null, baixaDocumento.getIdPlanoContasJuros(), baixaDocumento.getIdPlanoContasMulta(), baixaDocumento.getIdPlanoContasDesconto(), tipoRateioJuros, rateiosJuros, tipoRateioMulta, rateiosMulta, tipoRateioDesconto, rateiosDesconto, 0, null).stream().map(EventoFinanceiro::getId).collect(Collectors.toList());
        if (this.tipoFinanceiro == TipoFinanceiro.PAGAR) {
            if (!NumberUtil.longNullOuZero((Long)baixaDocumento.getIdUltimaFormaPgmto())) {
                PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 430, baixaDocumento.getIdUltimaFormaPgmto());
                this.propriedadeService.getPropriedadeValor().put(430, baixaDocumento.getIdUltimaFormaPgmto().toString());
            }
            if (!NumberUtil.longNullOuZero((Long)baixaDocumento.getIdUltimoDestino())) {
                PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 573, baixaDocumento.getIdUltimoDestino());
                this.propriedadeService.getPropriedadeValor().put(573, baixaDocumento.getIdUltimoDestino().toString());
            }
        } else {
            if (!NumberUtil.longNullOuZero((Long)baixaDocumento.getIdUltimaFormaPgmto())) {
                PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 431, baixaDocumento.getIdUltimaFormaPgmto());
                this.propriedadeService.getPropriedadeValor().put(431, baixaDocumento.getIdUltimaFormaPgmto().toString());
            }
            if (!NumberUtil.longNullOuZero((Long)baixaDocumento.getIdUltimoDestino())) {
                PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 574, baixaDocumento.getIdUltimoDestino());
                this.propriedadeService.getPropriedadeValor().put(574, baixaDocumento.getIdUltimoDestino().toString());
            }
        }
        int n = numeroPropriedade = TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro) ? 736 : 735;
        if (PropriedadeRN.getInstance().getPropriedadeLong(SessaoUtil.getSessao().getFilial(), numeroPropriedade) != baixaDocumento.getNumeroPrefixoDocumento().longValue() && baixaDocumento.getNumeroPrefixoDocumento() != 0L) {
            PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), numeroPropriedade, baixaDocumento.getNumeroPrefixoDocumento());
        }
        if (file != null) {
            for (FinanceiroDado documentoVerificar : baixaDocumento.getDocumentos()) {
                this.gravarArquivo(file, documentoVerificar.getId(), gravarArquivos, descricao, nomeArquivo);
            }
        }
        return idsEventos;
    }

    @RequestMapping(value={"/documentos-troca-endosso"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<FinanceiroDado> buscarDocumentosTrocaEndosso(@RequestBody TrocaEndossoWrapper trocaEndosso) {
        return FinanceiroDadoRN.getInstance().buscarDuplicatasWeb(this.tipoFinanceiro.equals((Object)TipoFinanceiro.PAGAR) ? TipoFinanceiro.RECEBER : TipoFinanceiro.PAGAR, StatusDocumentoFinanceiro.ABERTO, trocaEndosso.getIdEntidade(), trocaEndosso.getDataInicial(), trocaEndosso.getDataFinal(), trocaEndosso.getIdTipoDocumento(), trocaEndosso.getDataBaixa(), false, trocaEndosso.getIdsUtilizados());
    }

    @RequestMapping(value={"/buscar-por-cheque"})
    @DBAutoCommit
    public FinanceiroDado buscarChequePorNumero(@RequestParam String codigoBarras) throws UnicoMensagemUsuarioException {
        FinanceiroDado financeiro = null;
        if (codigoBarras != null && !codigoBarras.trim().equals("") && codigoBarras.trim().length() == 30) {
            String codigoBanco = codigoBarras.substring(0, 3);
            String agencia = codigoBarras.substring(3, 7);
            String conta = codigoBarras.substring(22, 28);
            String numeroCheque = codigoBarras.substring(11, 17);
            Banco banco = (Banco)BancoRN.getInstance().buscarPorCodigo(codigoBanco);
            financeiro = FinanceiroDadoRN.getInstance().buscarChequePorNumero(Long.valueOf(banco != null ? banco.getId() : 0L), agencia, conta, numeroCheque);
            if (financeiro != null) {
                Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId(financeiro.getIdEntidade());
                financeiro.setNomeEntidade(cliente != null ? cliente.getNome() : null);
            }
        }
        if (financeiro == null) {
            throw new UnicoMensagemUsuarioException("WFIN137", "Cheque n\u00e3o encontrado!");
        }
        return financeiro;
    }

    @RequestMapping(value={"/validar-estorno-exclusao"}, method={RequestMethod.POST})
    @DBTransaction
    public ExclusaoEstornoDocumentosFinanceirosWrapper validaEstornoExclusao(@RequestBody ParametrosValidacaoDocumentosFinanceirosWrapper parametros) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        List documentos = parametros.getIdsDocumentos().stream().map(id -> (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(id)).filter(Objects::nonNull).collect(Collectors.toList());
        if (ListMapUtil.listNullOrEmpty(documentos)) {
            throw new UnicoMensagemUsuarioException("FIN307", "Nenhum documento encontrado!");
        }
        NegociacaoFinanceiroOrigemRN.getInstance().validaFinanceiroJaNegociado(documentos);
        HashMap<Long, StatusExclusaoEventoFinanceiro> mapStatus = new HashMap<Long, StatusExclusaoEventoFinanceiro>();
        for (FinanceiroDado financeiroDado2 : documentos) {
            mapStatus.put(financeiroDado2.getId(), FinanceiroDadoRN.getInstance().verificaSePodeExcluir(sessao, financeiroDado2, parametros.getOpcao() == 1));
        }
        boolean usuarioDeveTomarAcao = mapStatus.values().stream().anyMatch(status -> status.getTipoMensagem().equals((Object)StatusExclusaoEventoFinanceiro.TipoMensagem.NEGACAO));
        if (!usuarioDeveTomarAcao) {
            FinanceiroDadoRN.getInstance().excluirDocumentos(sessao, documentos, parametros.getOpcao());
            this.dashBoardRabbitService.sendMessage(ContextoHolder.getTenant());
            this.notificationService.notifyTenantNow(NotificationType.DASH_BOARD, "");
            return new ExclusaoEstornoDocumentosFinanceirosWrapper();
        }
        ExclusaoEstornoDocumentosFinanceirosWrapper exclusaoDocumentos = new ExclusaoEstornoDocumentosFinanceirosWrapper();
        exclusaoDocumentos.setExisteAcao(mapStatus.values().stream().anyMatch(status -> status.getTipoMensagem().equals((Object)StatusExclusaoEventoFinanceiro.TipoMensagem.QUESTIONAMENTO)));
        exclusaoDocumentos.setDocumentos(documentos.stream().filter(financeiroDado -> !((StatusExclusaoEventoFinanceiro)mapStatus.get(financeiroDado.getId())).getTipoMensagem().equals((Object)StatusExclusaoEventoFinanceiro.TipoMensagem.NEGACAO)).collect(Collectors.toList()));
        exclusaoDocumentos.setStatusDocumentos(mapStatus.values().stream().filter(status -> status.getTipoMensagem().equals((Object)StatusExclusaoEventoFinanceiro.TipoMensagem.NEGACAO)).collect(Collectors.toList()));
        return exclusaoDocumentos;
    }

    @RequestMapping(value={"/validar-estorno-recorrente"}, method={RequestMethod.POST})
    @DBAutoCommit
    public boolean validaExclusaoRecorrente(@RequestBody ParametrosValidacaoDocumentosFinanceirosWrapper parametros) {
        List documentos = parametros.getIdsDocumentos().stream().map(id -> (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(id)).filter(Objects::nonNull).collect(Collectors.toList());
        return FinanceiroDadoRN.getInstance().isPossuiDocumentoRecorrenteSelecionado(documentos);
    }

    @RequestMapping(value={"/estornar-documentos"}, method={RequestMethod.POST})
    @DBTransaction
    public boolean estornarExcluirDocumentos(@RequestBody ExclusaoEstornoDocumentosFinanceirosWrapper parametros) throws UnicoMensagemUsuarioException {
        for (FinanceiroDado financeiroDado : parametros.getDocumentos()) {
            EventoFinanceiro eventoFinanceiro = EventoFinanceiroRN.getInstance().buscarPorId(financeiroDado.getEvento());
            if (eventoFinanceiro != null) {
                EventoFinanceiroRN.getInstance().estornaDocumento(eventoFinanceiro, SessaoUtil.getSessao());
                continue;
            }
            FinanceiroDadoRN.getInstance().excluirDocumentoSemEventoFinanceiro(SessaoUtil.getSessao(), financeiroDado);
        }
        return true;
    }

    @RequestMapping(value={"/verificar-adiantamentos"})
    @DBAutoCommit
    public String verificarDocumentosAdiantamento(@RequestParam Long idEntidade, @RequestParam(required=false, defaultValue="true") boolean isNotaSaida) {
        List listaDocumentos;
        if (this.funcionalidadeService.isAtiva(Funcionalidade.ADIANTAMENTO) && !Util.listNullOrEmpty((List)(listaDocumentos = FinanceiroDadoRN.getInstance().buscaListaDocumento(idEntidade, null, isNotaSaida ? TipoFinanceiro.PAGAR : TipoFinanceiro.RECEBER, true, null, null)))) {
            BigDecimal valorApagar = listaDocumentos.stream().map(FinanceiroDado::getSaldo).reduce(BigDecimal.ZERO, BigDecimal::add);
            return "\"Este " + (isNotaSaida ? "cliente" : "fornecedor") + " possui documentos a " + (isNotaSaida ? "pagar" : "receber") + " referente a adiantamentos realizados! Saldo total: R$ " + Util.formataNumero((BigDecimal)valorApagar, (String)Util.getMascaraPreco((int)2)) + "\"";
        }
        return null;
    }

    @RequestMapping(value={"/alterar-plano-conta"})
    @DBTransaction
    public boolean alterarPlanoContas(@RequestParam List<Long> ids, @RequestParam Long idPlanoConta) throws UnicoMensagemUsuarioException {
        ArrayList<AbstractPojo> documentos = new ArrayList<AbstractPojo>();
        for (Long id : ids) {
            documentos.add(FinanceiroDadoRN.getInstance().buscarPorId(id));
        }
        FinanceiroDadoRN.getInstance().alterarPlanoContas(SessaoUtil.getSessao(), documentos, idPlanoConta);
        return true;
    }

    @RequestMapping(value={"/buscar-tipos-cobranca-alteracao"})
    @DBAutoCommit
    public Map<String, Object> buscarTiposCobrancaAlteracao(@RequestParam List<Long> ids) {
        ArrayList<Long> listaTipoDocumentoAnterior = new ArrayList<Long>();
        boolean possuiQuitado = false;
        for (Long id : ids) {
            FinanceiroDado financeiroDado = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(id);
            listaTipoDocumentoAnterior.add(financeiroDado.getTipoDocumento().getId());
            if (!StatusDocumentoFinanceiro.QUITADO.getId().equals(financeiroDado.getStatus()) && !StatusDocumentoFinanceiro.SUBSTITUIDO.getId().equals(financeiroDado.getStatus())) continue;
            possuiQuitado = true;
        }
        List tiposCobranca = TipoCobrancaRN.getInstance().buscarLista();
        ArrayList<TipoCobranca> tiposCobrancaRetorno = new ArrayList<TipoCobranca>();
        for (TipoCobranca tipoCobranca : tiposCobranca) {
            if (!listaTipoDocumentoAnterior.contains(tipoCobranca.getIdTipoDocumentoFinanceiro())) continue;
            tiposCobrancaRetorno.add(tipoCobranca);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("possuiQuitado", possuiQuitado);
        map.put("tipos", tiposCobrancaRetorno);
        return map;
    }

    @RequestMapping(value={"/alterar-tipo-cobranca"})
    @DBTransaction
    public void alterarTipoCobranca(@RequestParam List<Long> ids, @RequestParam Long idTipoCobranca, @RequestParam Long idCaixa) throws UnicoMensagemUsuarioException {
        int qtdQuitados = 0;
        ArrayList<FinanceiroDado> documentos = new ArrayList<FinanceiroDado>();
        for (Long id : ids) {
            FinanceiroDado financeiroDado = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(id);
            documentos.add(financeiroDado);
            if (!StatusDocumentoFinanceiro.QUITADO.getId().equals(financeiroDado.getStatus()) && !StatusDocumentoFinanceiro.SUBSTITUIDO.getId().equals(financeiroDado.getStatus())) continue;
            ++qtdQuitados;
        }
        TipoCobranca tipoCobrancaSelecionada = (TipoCobranca)TipoCobrancaRN.getInstance().buscarPorId(idTipoCobranca);
        if (tipoCobrancaSelecionada == null) {
            throw new UnicoMensagemUsuarioException("WFIN105", "Selecione um tipo de cobran\u00e7a");
        }
        if (idCaixa == null && qtdQuitados > 0) {
            throw new UnicoMensagemUsuarioException("WFIN106", "Selecione uma conta caixa para a altera\u00e7\u00e3o de documentos quitados");
        }
        ContaCorrente caixa = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(idCaixa);
        for (FinanceiroDado financeiroDado : documentos) {
            if (StatusDocumentoFinanceiro.QUITADO.getId().equals(financeiroDado.getStatus())) {
                FinanceiroDadoRN.getInstance().alterarTipoCobranca(SessaoUtil.getSessao(), financeiroDado, tipoCobrancaSelecionada, caixa);
                continue;
            }
            FinanceiroDadoRN.getInstance().alterarApenasTipoCobranca(SessaoUtil.getSessao(), financeiroDado, tipoCobrancaSelecionada.getId());
        }
    }

    @RequestMapping(value={"/desconto-acrescimo"}, method={RequestMethod.POST})
    @DBTransaction
    public void lancarAcrescimoDesconto(@RequestBody AcrescimoDescontoWrapper acreDescWrapper) throws UnicoMensagemUsuarioException {
        List dados = FinanceiroDadoRN.getInstance().buscarListaPorIds(acreDescWrapper.getIdsDocumentos());
        for (FinanceiroDado financeiroDado : dados) {
            if (!DescontoDocumentoFinanceiroItemRN.getInstance().isDocumentoExisteEmDescontoNaoEfetivado(null, financeiroDado.getId(), false)) continue;
            throw new UnicoMensagemUsuarioException("WFIN264", "O documento " + financeiroDado.getDocumento() + " se encontra em um border\u00f4 de desconto! Imposs\u00edvel continuar.");
        }
        HierarquiaPlanoContas planoContas = null;
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PLANO_DE_CONTAS) && acreDescWrapper.getIdPlanoContas() != null) {
            planoContas = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(acreDescWrapper.getIdPlanoContas());
        }
        List rateiosCentroCusto = null;
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CENTRO_CUSTO) && planoContas != null && planoContas.isCentroCustoObrigatorio() && !Util.bigDecimalNullOrZero((BigDecimal)acreDescWrapper.getValor())) {
            rateiosCentroCusto = acreDescWrapper.getRateiosCentroCusto();
            CentroCustoRateioRN.getInstance().validarRateio(acreDescWrapper.getValor(), rateiosCentroCusto);
        }
        Sessao sessao = SessaoUtil.getSessao();
        FinanceiroDadoRN.getInstance().gravarLancamentoAcrescimoDesconto(sessao, acreDescWrapper.getTipoFinanceiro(), dados, acreDescWrapper.getTipoEventoFinanceiro(), acreDescWrapper.getData(), acreDescWrapper.getValor(), acreDescWrapper.getObservacao(), acreDescWrapper.getIdPlanoContas(), rateiosCentroCusto);
        for (FinanceiroDado financeiroDado : dados) {
            FinanceiroDadoCommonRN.getInstance().atualizarCobrancaParceiro(financeiroDado, sessao, this.carregarArquivo(this.saveFile));
        }
    }

    protected void afterUpdate(FinanceiroDado financeiroDado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        FinanceiroDadoCommonRN.getInstance().atualizarCobrancaParceiro(financeiroDado, SessaoUtil.getSessao(), this.carregarArquivo(this.saveFile));
    }

    protected void beforeCreate(FinanceiroDado financeiroDado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        financeiroDado.setTipoDocumento(TipoDocumentoFinanceiroRN.getInstance().buscarPorId(financeiroDado.getTipoDocumento().getId()));
        financeiroDado.setRegistro(DataHoraFactory.getDataHora());
        financeiroDado.setTipo(this.tipoFinanceiro.getId());
        financeiroDado.setSaldo(financeiroDado.getValor());
        financeiroDado.setSaldoComissao(financeiroDado.getValorOriginalComissao());
        this.validarGravacao(financeiroDado, 0);
        this.verificarOpcoesCheque(financeiroDado);
        this.atualizarDadosArquivo(financeiroDado);
    }

    protected void afterCreate(FinanceiroDado financeiroDado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 597)) {
            if (TipoFinanceiro.PAGAR.getId().equals(financeiroDado.getTipo())) {
                PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 595, financeiroDado.getIdCodigoContabil());
            } else {
                PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 596, financeiroDado.getIdCodigoContabil());
            }
        }
        String prefixo = PropriedadeRN.getInstance().getPropriedadeString(SessaoUtil.getSessao().getFilial(), TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro) ? 734 : 733);
        if (financeiroDado.getDocumento().startsWith(prefixo)) {
            String sufixo = financeiroDado.getDocumento().substring(prefixo.length());
            if (financeiroDado.getRepeticoes() > 1 && sufixo.contains("(")) {
                sufixo = sufixo.substring(0, sufixo.indexOf("("));
            }
            if (Util.isApenasNumeros((String)sufixo)) {
                if (TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro)) {
                    PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 736, sufixo);
                } else {
                    PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), 735, sufixo);
                }
            }
        }
    }

    protected void beforeRead(FinanceiroDado financeiroDado, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        ContaCorrente contaCorrente;
        if (Util.longNullOuZero((Long)financeiroDado.getIdBanco()) && !Util.longNullOuZero((Long)financeiroDado.getIdContaGeraBoleto()) && (contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(financeiroDado.getIdContaGeraBoleto())) != null && !Util.longNullOuZero((Long)contaCorrente.getIdbanco())) {
            financeiroDado.setIdBanco(contaCorrente.getIdbanco());
        }
        financeiroDado.setConfiguracoesAdicionaisFinanceiro(new ConfiguracoesAdicionaisFinanceiro(FinanceiroDadoRN.getInstance().existeLancamento(financeiroDado)));
        List financeiroImagems = FinanceiroImagemCommonRN.getInstance().buscarListaPorIdFinanceiro(financeiroDado.getId());
        financeiroImagems.forEach(arquivo -> arquivo.setCaminhoOriginal(this.saveFile.publishArquivo(arquivo.getCaminhoOriginal())));
        financeiroDado.setArquivos(financeiroImagems);
    }

    protected void beforeUpdate(FinanceiroDado financeiroDado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        financeiroDado.setTipoDocumento(TipoDocumentoFinanceiroRN.getInstance().buscarPorId(financeiroDado.getTipoDocumento().getId()));
        if (financeiroDado.getPagamento() == null) {
            financeiroDado.setVencimentoCalculoEncargos(financeiroDado.getVencimento());
        }
        this.validarGravacao(financeiroDado, 1);
        this.verificarOpcoesCheque(financeiroDado);
        this.atualizarDadosArquivo(financeiroDado);
    }

    protected void beforeSave(FinanceiroDado financeiroDado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        HierarquiaPlanoContas planoContas;
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.CENTRO_CUSTO) && (planoContas = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(financeiroDado.getIdCodigoContabil())) != null && planoContas.isCentroCustoObrigatorio()) {
            CentroCustoRateioRN.getInstance().validarRateio(financeiroDado.getValor(), financeiroDado.getRateiosCentroCusto());
        }
    }

    protected GridBuilder<FinanceiroDadoRN> getGridBuilder() {
        LocalDate data;
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("evento", "Evento", 0, false));
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("pagamento", "pagamentodoc", "Pagamento", 0, false, new String[0]));
        colunas.add(new ColunaSQL("idFilial", "Filial", 10, false));
        colunas.add(new ColunaSQL("idEntidade", "IdEntidade", 0, false));
        colunas.add(new ColunaSQL("idBanco", "Id do banco", 0, false));
        colunas.add(new ColunaSQL("idtipodocumentofinanceiro", "IdTipoDocumento", 10, false));
        colunas.add(new ColunaSQL("idcontageraboleto", "idcontageraboleto", 10, false));
        colunas.add(new ColunaSQL("acao", "acaoTipoDoc", "Ac\u00e3o", 17, false, new String[]{"fk_financeiro_tipdocfin"}));
        colunas.add(new ColunaSQL("codigo", "codigo", "Filial", 50, LicencaManager.getInstance().isEnterprise(), new String[]{"fk_financeiro_filial"}));
        colunas.add(new ColunaSQL("documento", "Documento", 130, true));
        colunas.add(new ColunaSQL("nome", "nomeEntidade", "Nome", 350, true, new String[]{"fk_financeiro_entidade"}));
        colunas.add(new ColunaSQL("status", "Status", 100, true, StatusDocumentoFinanceiro.class));
        colunas.add(new ColunaSQL("emissao", "Emiss\u00e3o", 100, true));
        colunas.add(new ColunaSQL("vencimento", "Vencimento", 120, true));
        ColunaSQL colunaValor = new ColunaSQL("valor", "Valor", 100, true);
        colunaValor.setTotalizar(true);
        colunas.add(colunaValor);
        ColunaSQL colunaSQLRemessaGerda = new ColunaSQL("remessaGerada", "remessagerada", 0, false);
        colunaSQLRemessaGerda.setNaoAlterarValorEnum(true);
        colunas.add(colunaSQLRemessaGerda);
        ColunaSQL colunaSaldo = new ColunaSQL("saldo", "saldo_atualizado", "Saldo", 100, true, new String[0]);
        colunaSaldo.setTotalizar(TipoFinanceiro.PAGAR.equals((Object)this.tipoFinanceiro));
        colunas.add(colunaSaldo);
        if (TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro)) {
            ColunaSQL colunaSaldoOriginal = new ColunaSQL("saldo", "saldooriginal", "Saldo sem juros/multa", 180, true, new String[0]);
            colunaSaldoOriginal.setTotalizar(true);
            colunas.add(colunaSaldoOriginal);
        }
        colunas.add(new ColunaSQL("descricao", "descricaoTipoDocumento", "Tipo", 130, true, new String[]{"fk_financeiro_tipdocfin"}));
        colunas.add(new ColunaSQL("razaoSocial", "razaoSocialEntidade", "Raz\u00e3o social", 350, true, new String[]{"fk_financeiro_entidade"}));
        colunas.add(new ColunaSQL("descricao", "descricaoTipoCobranca", "Cobran\u00e7a", 130, true, new String[]{"fk_financeiro_tipocobranca"}));
        ColunaSQL colunaStatus = new ColunaSQL("status", "codigostatus", "Status", 0, false, new String[0]);
        colunaStatus.setClasseEnum(StatusDocumentoFinanceiro.class);
        colunas.add(colunaStatus);
        colunas.add(new ColunaSQL("tipoOrigem", "tipoorigem", "Tipo Origem", 0, false, new String[0]));
        colunas.add(new ColunaSQL("idOrigem", "idorigem", "ID Origem", 0, false, new String[0]));
        if (TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro)) {
            colunas.add(new ColunaSQL("vencimentoCalculoEncargos", "Vencimento encargos", 100, false));
        }
        colunas.add(new ColunaSQL("saldo", "saldoestatico", "Saldo_xxx", 0, false, new String[0]));
        colunas.add(new ColunaSQL("pagamento", "Pagamento", 120, true));
        colunas.add(new ColunaSQL("nossoNumero", "Nosso Numero", 120, true));
        String aliasTabela = this.tipoFinanceiro != null ? ((FinanceiroDadoRN)this.rn).getTabela().concat("_").concat(this.tipoFinanceiro.getId()) : null;
        GridBuilder grid = new GridBuilder(FinanceiroDadoRN.getInstance().getTabela(), colunas, aliasTabela);
        colunas.add(new ColunaSQL("vencimento", "vencimentofin", "Vencimento", 0, false, new String[0]));
        colunas.add(new ColunaSQL("pagamento", "pagamentofin", "Pagamento", 0, false, new String[0]));
        colunas.add(new ColunaSQL("emissao", "emissaofin", "Emiss\u00e3o", 0, false, new String[0]));
        colunas.add(new ColunaSQL("datareferencia", "referenciafin", "Refer\u00eancia", 0, false, new String[0]));
        colunas.add(new ColunaSQL("entrada", "entradafin", "Entrada", 0, false, new String[0]));
        grid.addReferencia(new Referencia("tipo"));
        grid.addReferencia(new Referencia("inativo", "filialinativa", new String[]{"fk_financeiro_filial"}));
        grid.addReferenciaDefault(new Referencia("idorigem"));
        grid.addReferenciaDefault(new Referencia("tipoorigem"));
        if (TipoFinanceiro.PAGAR.equals((Object)this.tipoFinanceiro)) {
            grid.addCodicaoDefault(new Condicao("tipo", Operador.IGUAL, "P"));
            grid.setOrdemDefault(new Ordem("vencimentofin", true));
            if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 279)) {
                data = DataHoraFactory.getData();
                grid.addCondicao(new Condicao("vencimentofin", Operador.IGUAL, data));
            }
            if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 932)) {
                grid.addCodicaoDefault(new Condicao("idFilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
            } else {
                grid.addCodicaoDefault(new Condicao("idFilial", Operador.CONTIDO_EM, FilialRN.getInstance().getIdsFiliaisUsuario(SessaoUtil.getSessao())));
            }
            grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelStatusCoferenciaNFFinanceiro(SessaoUtil.getSessao()));
        } else {
            grid.addCodicaoDefault(new Condicao("tipo", Operador.IGUAL, "R"));
            grid.setOrdemDefault(new Ordem("vencimentofin", false));
            if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 591)) {
                data = DataHoraFactory.getData();
                grid.addCondicao(new Condicao("vencimentofin", Operador.IGUAL, data));
            }
            if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 933)) {
                grid.addCodicaoDefault(new Condicao("idFilial", Operador.IGUAL, SessaoUtil.getSessao().getIdFilial()));
            } else {
                grid.addCodicaoDefault(new Condicao("idFilial", Operador.CONTIDO_EM, FilialRN.getInstance().getIdsFiliaisUsuario(SessaoUtil.getSessao())));
            }
        }
        Condicao condicao = PerfilPermissaoCommonRN.getInstance().perfilPermissaoFiltro(SessaoUtil.getSessao(), "idtipodocumentofinanceiro", new EEventos[]{TipoFinanceiro.PAGAR.equals((Object)this.tipoFinanceiro) ? EEventos.TIPO_DOC_FINANCEIRO_PAGAR : EEventos.TIPO_DOC_FINANCEIRO_RECEBER});
        if (condicao != null) {
            grid.addReferenciaDefault(new Referencia("idtipodocumentofinanceiro"));
            grid.addCodicaoDefault(condicao);
        }
        grid.addCodicaoDefault(new Condicao("filialinativa", Operador.IGUAL, EnumSimNao.NAO.getId().intValue()));
        grid.addCondicao(new Condicao("codigostatus", Operador.IGUAL, StatusDocumentoFinanceiro.ABERTO.getId()));
        if (SessaoUtil.getSessao().getUsuario().getPreferenciaUsuario().isFiltrarFatVendedorUsuario() && !NumberUtil.longNullOuZero((Long)SessaoUtil.getSessao().getUsuario().getIdEntidade())) {
            USelect uSelect = new USelect("entidade");
            uSelect.add(new ColunaSQL("id"));
            uSelect.add((ColunaSQL)new Referencia("idrepresentante"));
            uSelect.add(new Condicao("idrepresentante", Operador.IGUAL, SessaoUtil.getSessao().getUsuario().getIdEntidade()));
            grid.addCodicaoDefault(new Condicao("idEntidade", Operador.CONTIDO_EM, uSelect));
        }
        return grid;
    }

    protected String getCacheId() {
        boolean filialCorrente;
        Sessao sessao = SessaoUtil.getSessao();
        int propriedade = 0;
        String idsFiliais = null;
        if (this.tipoFinanceiro.equals((Object)TipoFinanceiro.RECEBER)) {
            propriedade = 933;
        } else if (this.tipoFinanceiro.equals((Object)TipoFinanceiro.PAGAR)) {
            propriedade = 932;
        }
        if (propriedade > 0 && (filialCorrente = PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getIdFilial(), propriedade))) {
            idsFiliais = sessao.getIdFilial().toString();
        }
        if (StringUtil.stringNullOrEmpty(idsFiliais)) {
            idsFiliais = Stream.of(FilialRN.getInstance().getIdsFiliaisUsuario(sessao)).map(Object::toString).collect(Collectors.joining(","));
        }
        return "financeiros".concat("_").concat(this.tipoFinanceiro.name()).concat("_FILIAIS=(").concat(idsFiliais).concat(")").concat(String.valueOf(sessao.getUsuario().getPreferenciaUsuario().isFiltrarFatVendedorUsuario()));
    }

    public void loadFile(MultipartFile[] files, FinanceiroDado financeiroDado) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.arrayNullOrEmpty((Object[])files)) {
            HashMap<String, List<FinanceiroImagem>> mapArquivos = new HashMap<String, List<FinanceiroImagem>>();
            if (!ListMapUtil.listNullOrEmpty((List)financeiroDado.getArquivos())) {
                mapArquivos.putAll(financeiroDado.getArquivos().stream().filter(f -> !Util.stringNullOrEmpty((String)f.getCaminho())).collect(Collectors.groupingBy(FinanceiroImagem::getCaminho)));
            }
            for (MultipartFile file : files) {
                Object[] split;
                String nomeArquivo = file.getOriginalFilename();
                if (StringUtil.stringNullOrEmpty((String)nomeArquivo) || ListMapUtil.arrayNullOrEmpty((Object[])(split = nomeArquivo.split("\\|")))) continue;
                try {
                    List arquivo;
                    Object fieldName = split[0];
                    if (!((String)fieldName).equalsIgnoreCase("arq") || ListMapUtil.listNullOrEmpty((List)(arquivo = (List)mapArquivos.get(split[1])))) continue;
                    String caminho = this.saveFile.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Financeiro, file, false);
                    byte[] imagem = file.getBytes();
                    arquivo.forEach(i -> {
                        i.setCaminhoOriginal(caminho);
                        if (this.saveFile.isTabela()) {
                            i.setArquivo(imagem);
                        }
                    });
                }
                catch (IOException e) {
                    throw new UnicoMensagemUsuarioException("WWW623", "N\u00e3o foi poss\u00edvel atribuir os arquivos: " + e.getMessage());
                }
            }
        }
    }

    public List<Coluna> getColunasCustomizaveis() {
        return FinanceiroDadoRN.getInstance().getColunaGridCustomozavelFinanceiroWW(this.tipoFinanceiro);
    }

    protected String getSufixoParametrosRelatorio() {
        return "_".concat(this.tipoFinanceiro.getId());
    }

    private void verificarOpcoesCheque(FinanceiroDado financeiroDado) throws UnicoMensagemUsuarioException {
        boolean isHabilitaCheque;
        if (TipoFinanceiro.PAGAR.equals((Object)this.tipoFinanceiro)) {
            isHabilitaCheque = financeiroDado.getTipoDocumento().getAcao().equals((Object)TipoAcaoFinanceiro.CHEQUE_TERCEIRO);
        } else {
            boolean bl = isHabilitaCheque = financeiroDado.getTipoDocumento().getAcao().equals((Object)TipoAcaoFinanceiro.CHEQUE) || financeiroDado.getTipoDocumento().getAcao().equals((Object)TipoAcaoFinanceiro.CHEQUE_TERCEIRO);
        }
        if (!isHabilitaCheque) {
            financeiroDado.setAgencia("");
            financeiroDado.setNumeroContaCorrente("");
            financeiroDado.setCnpjCpfEmitente("");
            financeiroDado.setEmitente("");
        } else if (PropriedadeRN.getInstance().getPropriedadeBoolean(SessaoUtil.getSessao().getFilial(), 396)) {
            if (StringUtil.stringNullOrEmpty((String)financeiroDado.getAgencia())) {
                throw new UnicoMensagemUsuarioException("WWW183", "Ag\u00eancia n\u00e3o informada.");
            }
            if (StringUtil.stringNullOrEmpty((String)financeiroDado.getNumeroContaCorrente())) {
                throw new UnicoMensagemUsuarioException("WWW184", "N\u00famero de conta corrente n\u00e3o informada.");
            }
            if (NumberUtil.longNullOuZero((Long)financeiroDado.getIdBanco())) {
                throw new UnicoMensagemUsuarioException("WWW185", "Banco n\u00e3o informado.");
            }
        }
    }

    private void validarGravacao(FinanceiroDado financeiroDado, int modo) throws UnicoMensagemUsuarioException {
        if (financeiroDado.getTipoDocumento() == null) {
            throw new UnicoMensagemUsuarioException("WFIN348", "Tipo de documento n\u00e3o informado.");
        }
        if (financeiroDado.getEmissao() == null) {
            throw new UnicoMensagemUsuarioException("WFIN349", "Data de emiss\u00e3o n\u00e3o informada.");
        }
        if (financeiroDado.getVencimento() == null) {
            throw new UnicoMensagemUsuarioException("WFIN350", "Data de vencimento n\u00e3o informada.");
        }
        if (NumberUtil.longNullOuZero((Long)financeiroDado.getIdEntidade())) {
            throw new UnicoMensagemUsuarioException("WFIN351", (this.tipoFinanceiro.equals((Object)TipoFinanceiro.PAGAR) ? "Fornecedor " : "Cliente ") + "n\u00e3o informado.");
        }
        if (NumberUtil.bigDecimalNullOrZero((BigDecimal)financeiroDado.getValor())) {
            throw new UnicoMensagemUsuarioException("WFIN352", "Valor n\u00e3o informado.");
        }
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PLANO_DE_CONTAS) && NumberUtil.longNullOuZero((Long)financeiroDado.getIdCodigoContabil())) {
            throw new UnicoMensagemUsuarioException("WFIN353", "Plano de contas n\u00e3o informado.");
        }
        FinanceiroDadoRN.getInstance().validaDataEntradaFinanceiro(SessaoUtil.getSessao().getFilial(), modo, financeiroDado.getEmissao(), financeiroDado.getEntrada(), FinanceiroDadoRN.getInstance().converteFinanceiroDadoParaPagamentoRecorrente(financeiroDado));
        if (modo == 1) {
            this.validarNegociacao(Collections.singletonList(financeiroDado));
        }
    }

    private void prepararDocumentosParaBaixa(List<FinanceiroDado> documentos) throws UnicoMensagemUsuarioException {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.PLANO_DE_CONTAS)) {
            if (Util.longNullOuZero((Long)PropriedadeRN.getInstance().getPropriedadeLong(SessaoUtil.getSessao().getFilial(), TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro) ? 438 : 467))) {
                throw new UnicoMensagemUsuarioException("WFIN181", "Por favor configure o Plano de contas para multa nas prefer\u00eancias do sistema.");
            }
            if (Util.longNullOuZero((Long)PropriedadeRN.getInstance().getPropriedadeLong(SessaoUtil.getSessao().getFilial(), TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro) ? 439 : 468))) {
                throw new UnicoMensagemUsuarioException("WFIN190", "Por favor configure o Plano de contas para juros nas prefer\u00eancias do sistema.");
            }
            if (Util.longNullOuZero((Long)PropriedadeRN.getInstance().getPropriedadeLong(SessaoUtil.getSessao().getFilial(), TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro) ? 440 : 469))) {
                throw new UnicoMensagemUsuarioException("WFIN191", "Por favor configure o Plano de contas para desconto nas prefer\u00eancias do sistema.");
            }
        }
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.DESCONTO)) {
            for (FinanceiroDado financeiroDado : documentos) {
                if (!DescontoDocumentoFinanceiroItemRN.getInstance().isDocumentoExisteEmDescontoNaoEfetivado(null, financeiroDado.getId(), true)) continue;
                throw new UnicoMensagemUsuarioException("WFIN213", "N\u00e3o \u00e9 poss\u00edvel baixar o documento " + financeiroDado.getDocumento() + ", pois ele se encontra em um border\u00f4 de desconto n\u00e3o efetivado!");
            }
        }
        if (TipoFinanceiro.RECEBER.equals((Object)this.tipoFinanceiro)) {
            Map parametros = FinanceiroDadoRN.getInstance().getParametrosCalculoEncargo();
            Map parametrosTiposDocumentos = TipoDocumentoFinanceiroCommonRN.getInstance().getParametrosCalculoEncargoPorTipoDocumento();
            Map parametrosEncargosPorContaCorrente = ContaCorrenteRN.getInstance().getParametrosCalculoEncargoPorContaCorrente();
            for (FinanceiroDado documento : documentos) {
                EncargoFinanceiro encargo;
                ParametroCalculoEncargo parametro = null;
                if (!Util.longNullOuZero((Long)documento.getIdContaGeraBoleto())) {
                    parametro = (ParametroCalculoEncargo)parametrosEncargosPorContaCorrente.get(documento.getIdContaGeraBoleto());
                }
                if (parametro == null && (parametro = (ParametroCalculoEncargo)parametrosTiposDocumentos.get(documento.getTipoDocumento().getId())) == null) {
                    parametro = (ParametroCalculoEncargo)parametros.get(documento.getIdFilial());
                }
                if ((encargo = FinanceiroDadoRN.getInstance().calcularEncargosFinanceiros(DataHoraFactory.getData(), documento.getSaldo(), documento.getVencimentoCalculoEncargos() != null ? documento.getVencimentoCalculoEncargos() : documento.getVencimento(), parametro, documento.getVencimentoCalculoEncargos() != null && documento.getVencimentoCalculoEncargos().compareTo(documento.getVencimento()) != 0)) == null) continue;
                documento.setJuros(encargo.getValorJuros());
                documento.setMulta(encargo.getValorMulta());
                documento.setDesconto(encargo.getDesconto());
            }
        }
    }

    private boolean validarNegociacao(List<FinanceiroDado> documentos) throws UnicoMensagemUsuarioException {
        NegociacaoFinanceiroOrigemRN.getInstance().validaFinanceiroJaNegociado(documentos);
        return true;
    }

    private void atualizarDadosArquivo(FinanceiroDado financeiroDado) throws UnicoMensagemUsuarioException {
        HashMap mapArquivos = !ListMapUtil.listNullOrEmpty((List)financeiroDado.getArquivos()) ? financeiroDado.getArquivos().stream().filter(i -> !NumberUtil.longNullOuZero((Long)i.getId())).collect(Collectors.toMap(FinanceiroImagem::getId, Function.identity())) : new HashMap();
        List arquivos = FinanceiroImagemCommonRN.getInstance().buscarListaPorIdFinanceiro(financeiroDado.getId());
        for (FinanceiroImagem arquivo : arquivos) {
            if (mapArquivos.containsKey(arquivo.getId())) {
                FinanceiroImagem financeiroImagem = (FinanceiroImagem)mapArquivos.get(arquivo.getId());
                String arquivoRelativoImagem = this.saveFile.publishImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Financeiro, TipoImagem.TamanhoOriginal, arquivo.getCaminhoOriginal());
                if (StringUtil.stringNullOrEmpty((String)financeiroImagem.getCaminhoOriginal()) || !financeiroImagem.getCaminhoOriginal().equals(arquivoRelativoImagem)) {
                    this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Financeiro, arquivo.getCaminhoOriginal());
                    continue;
                }
                financeiroImagem.setCaminhoOriginal(arquivo.getCaminhoOriginal());
                continue;
            }
            FinanceiroImagemCommonRN.getInstance().excluir((AbstractPojo)arquivo, SessaoUtil.getSessao());
            this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Financeiro, arquivo.getCaminhoOriginal());
        }
    }

    @RequestMapping(value={"/validar-datas"}, method={RequestMethod.POST})
    @DBAutoCommit
    public void validarDatas(@RequestBody FinanceiroWrapper wrapper) throws UnicoMensagemUsuarioException {
        FinanceiroDado financeiroDadoOriginal = wrapper.getFinanceiroDadoOriginal();
        FinanceiroDado financeiroDadoAtual = wrapper.getFinanceiroDadoAtual();
        if (financeiroDadoOriginal.getEntrada() != null && financeiroDadoAtual.getEntrada() != null && !financeiroDadoOriginal.getEntrada().isEqual(financeiroDadoAtual.getEntrada()) || financeiroDadoOriginal.getEmissao() != null && financeiroDadoAtual.getEmissao() != null && !financeiroDadoOriginal.getEmissao().isEqual(financeiroDadoAtual.getEmissao())) {
            FinanceiroDadoRN.getInstance().validaDataEntradaFinanceiro(SessaoUtil.getSessao().getFilial(), 0, financeiroDadoAtual.getEmissao(), financeiroDadoAtual.getEntrada(), FinanceiroDadoRN.getInstance().converteFinanceiroDadoParaPagamentoRecorrente(financeiroDadoAtual));
        }
        if (financeiroDadoOriginal.getVencimento() != null && financeiroDadoAtual.getVencimento() != null && !financeiroDadoOriginal.getVencimento().isEqual(financeiroDadoAtual.getVencimento())) {
            FinanceiroDadoRN.getInstance().validaDataVencimento(SessaoUtil.getSessao().getFilial(), financeiroDadoAtual.getEmissao(), financeiroDadoAtual.getVencimento());
        }
    }

    @RequestMapping(value={"/gerar-recorrentes"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<PagamentoRecorrente> gerarDocumentosRecorrentes(@RequestBody FinanceiroWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (Util.stringNullOrEmpty((String)wrapper.getFinanceiroDadoAtual().getDocumento())) {
            throw new UnicoMensagemUsuarioException("WFIN393", "Informe o documento!");
        }
        List<Object> listaPagamentosRecorrentes = new ArrayList<PagamentoRecorrente>();
        if (wrapper.getRepeticoes() > 0) {
            listaPagamentosRecorrentes = FinanceiroDadoRN.getInstance().multiplicaDocumentoRecorrente(wrapper.getFinanceiroDadoAtual(), wrapper.getRepeticoes(), SessaoUtil.getSessao().getFilial());
        }
        return listaPagamentosRecorrentes;
    }

    @RequestMapping(value={"/buscar-percentual-desconto"})
    @DBAutoCommit
    public Map<String, BigDecimal> getPercentualValorDesconto(@RequestParam Long[] ids, @RequestParam BigDecimal valorDesconto) {
        List listaDocumentos = FinanceiroDadoRN.getInstance().buscarListaPorIds(Arrays.asList(ids));
        BigDecimal valorDescontoAnterior = FinanceiroLancamentoRN.getInstance().buscarValorPorDocumentoEColunaValor(ColunaValorFinanceiroLancamento.VALOR_DESCONTO, ids);
        BigDecimal valorDescontoTotal = valorDescontoAnterior.add(valorDesconto);
        BigDecimal percentualDescontoTotal = Util.percentual((BigDecimal)valorDescontoTotal, (BigDecimal)listaDocumentos.stream().map(FinanceiroDado::getValor).reduce(BigDecimal.ZERO, BigDecimal::add));
        HashMap<String, BigDecimal> retorno = new HashMap<String, BigDecimal>();
        retorno.put("percentual", percentualDescontoTotal);
        retorno.put("valor", valorDescontoTotal);
        return retorno;
    }

    @RequestMapping(value={"/validar-reabrir-cheque"})
    @DBAutoCommit
    public ReabrirChequeWrapper validarReabrirCheque(@RequestParam Long id) throws UnicoMensagemUsuarioException {
        FinanceiroDado financeiroDado = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(id);
        if (!StatusDocumentoFinanceiro.QUITADO.getId().equals(financeiroDado.getStatus()) && !StatusDocumentoFinanceiro.BAIXADO.getId().equals(financeiroDado.getStatus())) {
            throw new UnicoMensagemUsuarioException("WFIN115", "Documento selecionado tem que estar Quitado ou Baixado");
        }
        if (!TipoAcaoFinanceiro.CHEQUE.equals((Object)financeiroDado.getTipoDocumento().getAcao()) && !TipoAcaoFinanceiro.CHEQUE_TERCEIRO.equals((Object)financeiroDado.getTipoDocumento().getAcao())) {
            throw new UnicoMensagemUsuarioException("WFIN116", "Documento selecionado n\u00e3o \u00e9 um tipo de documento de cheque");
        }
        ReabrirChequeWrapper wrapper = new ReabrirChequeWrapper();
        List tiposCobranca = TipoCobrancaRN.getInstance().buscarLista();
        ArrayList<TipoCobranca> tiposCobrancaSelecao = new ArrayList<TipoCobranca>();
        for (TipoCobranca tipoCobranca : tiposCobranca) {
            if (financeiroDado.getTipoDocumento().getId().equals(tipoCobranca.getIdTipoDocumentoFinanceiro())) {
                tiposCobrancaSelecao.add(tipoCobranca);
            }
            if (!tipoCobranca.getId().equals(financeiroDado.getIdTipoCobranca())) continue;
            wrapper.setIdTipoCobrancaSelecionado(tipoCobranca.getId());
        }
        Long idcontacorrente = null;
        List finLancamento = FinanceiroLancamentoRN.getInstance().buscarPorIdFinanceiro(financeiroDado.getId());
        if (!Util.listNullOrEmpty((List)finLancamento)) {
            LocalDateTime baixa = null;
            FinanceiroLancamento lancamento = null;
            for (FinanceiroLancamento fl : finLancamento) {
                if (baixa == null) {
                    baixa = fl.getBaixa();
                    lancamento = fl;
                }
                if (!baixa.isBefore(fl.getBaixa())) continue;
                baixa = fl.getBaixa();
                lancamento = fl;
            }
            if (lancamento != null) {
                List financeiroDestino = EventoFinanceiroDestinoRN.getInstance().buscarPorIdEventoFinanceiro(lancamento.getEvento());
                for (EventoFinanceiroDestino fd : financeiroDestino) {
                    ContaCorrenteLancamento contaCorrenteLancamento = (ContaCorrenteLancamento)ContaCorrenteLancamentoRN.getInstance().buscarPorId(fd.getIdContaCorrenteLancamento());
                    if (contaCorrenteLancamento == null) continue;
                    idcontacorrente = contaCorrenteLancamento.getIdcontacorrente();
                }
            }
        }
        if (Util.longNullOuZero(idcontacorrente)) {
            throw new UnicoMensagemUsuarioException("WFIN329", "Documento n\u00e3o pode ser reaberto, pois n\u00e3o foi poss\u00edvel encontrar o lan\u00e7amento na conta corrente. Fa\u00e7a o estorno do lan\u00e7amento de baixa.");
        }
        ContaCorrente caixa = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(idcontacorrente);
        wrapper.setIdDocumento(id);
        wrapper.setIdContaCorrente(caixa.getId());
        wrapper.setDescricaoContaCorrente(caixa.getDescricao());
        wrapper.setTiposCobranca(tiposCobrancaSelecao);
        return wrapper;
    }

    @PostMapping(value={"/gravar-reabrir-cheque"})
    @DBTransaction
    public void gravarReabrirCheque(@RequestBody ReabrirChequeWrapper wrapper) throws UnicoMensagemUsuarioException {
        FinanceiroDado financeiroDado = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(wrapper.getIdDocumento());
        if (wrapper.getDataReabertura() == null) {
            throw new UnicoMensagemUsuarioException("WFIN326", "Data da reabertura n\u00e3o informado.");
        }
        if (financeiroDado.getPagamento().isAfter(wrapper.getDataReabertura())) {
            throw new UnicoMensagemUsuarioException("WFIN117", "Data da reabertura n\u00e3o pode ser menor que a data do pagamento.");
        }
        if (wrapper.getDataReabertura().isAfter(DataHoraFactory.getData())) {
            throw new UnicoMensagemUsuarioException("WFIN118", "Data da reabertura n\u00e3o pode ser maior que a data atual.");
        }
        TipoCobranca tipoCobrancaSelecionada = (TipoCobranca)TipoCobrancaRN.getInstance().buscarPorId(wrapper.getIdTipoCobrancaSelecionado());
        if (tipoCobrancaSelecionada == null) {
            throw new UnicoMensagemUsuarioException("WFIN119", "Tipo de cobran\u00e7a n\u00e3o informado");
        }
        ContaCorrente caixa = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(wrapper.getIdContaCorrente());
        financeiroDado.setChequeDevolvido(true);
        FinanceiroDadoRN.getInstance().reabreCheque(Contexto.getInstance().getSessao(), financeiroDado, tipoCobrancaSelecionada, caixa, wrapper.getDataReabertura());
        String txt = "Cheque n\u00ba " + financeiroDado.getDocumento() + " no valor de " + financeiroDado.getValor() + " foi devolvido.";
        ContatoEntidadeRN.getInstance().gravaHistoricoEntidade(Contexto.getInstance().getSessao(), financeiroDado.getIdEntidade(), txt);
    }

    @RequestMapping(value={"/gravar-arquivos"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBAutoCommit
    public void gravarArquivo(@RequestPart(value="file") MultipartFile file, @RequestPart(value="idFinanceiro") Long idFinanceiro, @RequestPart(value="gravarArquivos") EnumSimNao gravarArquivos, @RequestPart(value="descricao") String descricao, @RequestPart(value="nomeArquivo") String nomeArquivo) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        String caminho = this.saveFile.saveFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Financeiro, file, false);
        FinanceiroImagem fi = new FinanceiroImagem();
        fi.setIdFinanceiro(idFinanceiro);
        fi.setCaminhoOriginal(caminho);
        fi.setCaminho(nomeArquivo);
        fi.setDescricao(descricao);
        FinanceiroDado financeiro = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(idFinanceiro);
        if (!Util.longNullOuZero((Long)financeiro.getId())) {
            if (gravarArquivos.equals((Object)EnumSimNao.SIM) && !Util.longNullOuZero((Long)financeiro.getEvento())) {
                List idsFinanceiros = EventoFinanceiroDestinoRN.getInstance().buscarPorIdEventoFinanceiro(financeiro.getEvento()).stream().map(EventoFinanceiroDestino::getIdFinanceiroLancamento).sorted(Comparator.comparing(IdFinanceiroLancamento -> IdFinanceiroLancamento)).collect(Collectors.toList());
                FinanceiroImagemCommonRN.getInstance().gravarArquivosPorIdFinanceiro(sessao, Collections.singletonList(fi), idsFinanceiros);
            } else {
                List<Long> idsFinanceiros = Collections.singletonList(financeiro.getId());
                FinanceiroImagemCommonRN.getInstance().gravarArquivosPorIdFinanceiro(sessao, Collections.singletonList(fi), idsFinanceiros.stream().limit(1L).collect(Collectors.toList()));
            }
        }
    }

    protected void afterLoadColunaSQL(List<ColunaSQL> colunas) throws UnicoMensagemUsuarioException {
        for (ColunaSQL coluna : colunas) {
            if (!coluna.getNome().equalsIgnoreCase("valorpagorecebido")) continue;
            coluna.setTotalizar(true);
        }
    }
}

