/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Notificacao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.core.whatsapp.TipoIntegracaoWhatsAppEnum;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoWhatsAppRN;
import br.intelidata.commons.domain.wrapper.NotificacaoCompartilhamento;
import br.intelidata.commons.modulo.cadastros.regranegocio.TextoGenericoRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CompartilhamentoController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.job.JobEmailCartaCobranca;
import br.intelidata.uniplusweb.web.rest.app.wrapper.EmailCartaCobrancaWrapper;
import br.intelidata.uniplusweb.wrapper.ParametrosEmailWeb;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/financeiros"})
public class FinanceiroJobController
extends CompartilhamentoController<NotificacaoCompartilhamento>
implements ICreateTask {
    public FinanceiroJobController(TaskManager taskManager) {
        super(taskManager);
    }

    public TipoJob getTipoJob() {
        return TipoJob.EMAIL_CARTA_COBRANCA;
    }

    public Class<? extends AbstractJob> job() {
        return JobEmailCartaCobranca.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @RequestMapping(value={"/agendar-email-cobranca"})
    @DBAutoCommit
    public void agendarEnvioEmailCartaCobranca(@RequestBody EmailCartaCobrancaWrapper cobrancaWrapper) throws UnicoMensagemUsuarioException {
        this.validarTexto(cobrancaWrapper.getIdTextoGenerico());
        this.createTask((Object)cobrancaWrapper);
    }

    protected void validarCompartilhamento(NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        this.validarTexto(compartilhamento.getIdTextoGenerico());
    }

    protected List<Notificacao> getNotificacoes(Sessao sessao, NotificacaoCompartilhamento compartilhamento) throws UnicoMensagemUsuarioException {
        TextoGenerico textoGenerico = (TextoGenerico)TextoGenericoRN.getInstance().buscarPorId(compartilhamento.getIdTextoGenerico());
        List documentos = FinanceiroDadoRN.getInstance().buscarListaPorIds(compartilhamento.getIdsDocumentos());
        Map mapClientes = FinanceiroDadoRN.getInstance().montaTextoCartaCobranca(sessao, textoGenerico, documentos);
        if (mapClientes.size() > 1 && ConfiguracaoWhatsAppRN.getInstance().buscaConfiguracaoUsuario(sessao).getTipoIntegracao().equals((Object)TipoIntegracaoWhatsAppEnum.PADRAO)) {
            throw new UnicoMensagemUsuarioException("WWW577", "Para envio de notifica\u00e7\u00e3o via WhatsApp, selecione apenas documentos do mesmo cliente!");
        }
        ArrayList<Notificacao> notificacoes = new ArrayList<Notificacao>();
        for (Map.Entry map : mapClientes.entrySet()) {
            Entidade cliente = (Entidade)EntidadeRN.getInstance().buscarPorId((Long)map.getKey());
            String fone = null;
            if (cliente != null) {
                fone = Util.apenasNumeros((String)cliente.getNumeroEnvioWhatsapp());
            }
            if (Util.stringNullOrEmpty(fone)) {
                throw new UnicoMensagemUsuarioException("WWW578", "Cliente " + cliente + " n\u00e3o possui whatsapp ou celular cadastrado.");
            }
            Notificacao notificacao = new Notificacao();
            notificacao.setMalote(new Malote());
            notificacao.setFone(fone);
            notificacao.setMsg((String)map.getValue());
            notificacoes.add(notificacao);
        }
        return notificacoes;
    }

    protected void createJobEmail(Sessao sessao, ParametrosEmailWeb parametrosEmail, NotificacaoCompartilhamento compartilhamento) {
    }

    private void validarTexto(Long idTextoGenerico) throws UnicoMensagemUsuarioException {
        if (NumberUtil.longNullOuZero((Long)idTextoGenerico)) {
            throw new UnicoMensagemUsuarioException("FIN344", "Por favor escolha um texto gen\u00e9rico para o contrato.");
        }
    }
}

