/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamentocontacorrente.banco;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.licenca.FuncionalidadeManager;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.HierarquiaPlanoContas;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimentoPlanoContas;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteLancamento;
import br.intelidata.commons.domain.pojo.financeiro.cobranca.ConciliacaoBancariaMovimento;
import br.intelidata.commons.domain.regranegocio.ContaCorrenteLancamentoCommonRN;
import br.intelidata.commons.modulo.financeiro.enums.OperacaoLancamentoFinanceiro;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteLancamentoRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.HierarquiaPlanoContasRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.PropriedadeService;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamentocontacorrente.ContaCorrenteLancamentoCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamentocontacorrente.banco.ConciliacaoManualWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamentocontacorrente.banco.ConciliacaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.lancamentocontacorrente.banco.LancamentoFiltroWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sf.ofx4j.domain.data.MessageSetType;
import net.sf.ofx4j.domain.data.ResponseEnvelope;
import net.sf.ofx4j.domain.data.ResponseMessageSet;
import net.sf.ofx4j.domain.data.banking.BankStatementResponseTransaction;
import net.sf.ofx4j.domain.data.banking.BankingResponseMessageSet;
import net.sf.ofx4j.io.AggregateUnmarshaller;
import net.sf.ofx4j.io.OFXParseException;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/lancamentos-conta-corrente-banco"})
@SubMenuMapping(MENU="SubMenuFinanceiroGeral", NOME="Bancos", ICONE="icon-money16", ROTA="/financeiros/lancamentos-conta-corrente-banco", PROGRAMA=434)
public class ContaCorrenteLancamentoBancoCrudController
extends ContaCorrenteLancamentoCrudController {
    private final PropriedadeService propriedadeService;

    public ContaCorrenteLancamentoBancoCrudController(PropriedadeService propriedadeService, FuncionalidadeService funcionalidadeService) {
        super(funcionalidadeService, false);
        this.propriedadeService = propriedadeService;
    }

    @RequestMapping(value={"/filtrar"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ContaCorrenteLancamento> filtrarLancamentos(@RequestBody LancamentoFiltroWrapper filtroWrapper) {
        return ContaCorrenteLancamentoRN.getInstance().buscarListPorIdContaCorrentePeriodo(filtroWrapper.getIdContaCorrente(), filtroWrapper.getDataInicial(), filtroWrapper.getDataFinal(), filtroWrapper.getTipoMovimento(), filtroWrapper.isAlteraValoresNegativos(), filtroWrapper.isApenasSemDataConciliacao(), filtroWrapper.getIdsLancamentosParaIgnorar());
    }

    @RequestMapping(value={"/conciliacao"}, method={RequestMethod.POST})
    @DBTransaction
    public boolean conciliacaoManualDocumentos(@RequestBody ConciliacaoManualWrapper conciliacao) throws UnicoMensagemUsuarioException {
        List documentos = this.getDocumentosConciliacaoManual(conciliacao);
        if (conciliacao.isConciliar()) {
            ContaCorrenteLancamentoRN.getInstance().conciliarLancamentosManualmente(SessaoUtil.getSessao(), documentos);
        } else {
            ContaCorrenteLancamentoRN.getInstance().desconciliarLancamentos(SessaoUtil.getSessao(), documentos);
        }
        return true;
    }

    @RequestMapping(value={"/importar"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    @DBTransaction
    public ConciliacaoWrapper importarArquivo(@RequestPart(value="file") MultipartFile file, @RequestPart(value="idContaCorrente") Long idContaCorrente) throws UnicoMensagemUsuarioException {
        ConciliacaoWrapper wrapper = new ConciliacaoWrapper();
        ArrayList listaMovimentos = new ArrayList();
        ContaCorrente contaCorrente = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(idContaCorrente);
        if (contaCorrente == null) {
            throw new UnicoMensagemUsuarioException("FIN310", "Conta corrente n\u00e3o encontrada! Verifique.");
        }
        try {
            StringBuilder sb = new StringBuilder();
            this.ajustarArquivo(file.getInputStream(), sb);
            ByteArrayInputStream bis = new ByteArrayInputStream(sb.toString().getBytes(StandardCharsets.UTF_8));
            AggregateUnmarshaller a = new AggregateUnmarshaller(ResponseEnvelope.class);
            ResponseEnvelope responseEnvelope = (ResponseEnvelope)a.unmarshal((InputStream)bis);
            MessageSetType type = MessageSetType.banking;
            ResponseMessageSet message = responseEnvelope.getMessageSet(type);
            ArrayList idsLancamentosJaProcessados = new ArrayList();
            if (message != null) {
                List banks = ((BankingResponseMessageSet)message).getStatementResponses();
                for (BankStatementResponseTransaction bank : banks) {
                    List list;
                    if (!bank.getMessage().getAccount().getAccountNumber().contains(contaCorrente.getNumeroConta())) {
                        wrapper.setContaDiferente(true);
                        wrapper.setMensagem("FIN276 - Este arquivo n\u00e3o pertence \u00e0 conta corrente selecionada! Conta escolhida: ".concat(contaCorrente.getNumeroConta()).concat(". Conta do arquivo: ").concat(bank.getMessage().getAccount().getAccountNumber()).concat(". Deseja continuar?"));
                    }
                    if (ListMapUtil.listNullOrEmpty((List)(list = bank.getMessage().getTransactionList().getTransactions()))) {
                        file.getInputStream().close();
                        throw new UnicoMensagemUsuarioException("WFIN290", "Este arquivo n\u00e3o possui transa\u00e7\u00f5es! Verifique.");
                    }
                    ContaCorrenteLancamentoRN.getInstance().processarDocumentosConciliacao(list, listaMovimentos, contaCorrente, idsLancamentosJaProcessados);
                }
                file.getInputStream().close();
            }
        }
        catch (IOException | OFXParseException e) {
            throw new UnicoMensagemUsuarioException("WFIN277", "Erro ao ler o arquivo de concilia\u00e7\u00e3o banc\u00e1ria.", e);
        }
        wrapper.setMovimentos(listaMovimentos);
        return wrapper;
    }

    @RequestMapping(value={"/conciliar"}, method={RequestMethod.POST})
    @DBTransaction
    public Map<String, List<Long>> conciliar(@RequestBody List<ConciliacaoBancariaMovimento> movimentos) throws UnicoMensagemUsuarioException {
        return ContaCorrenteLancamentoRN.getInstance().conciliarLancamentosPorProcessamento(SessaoUtil.getSessao(), movimentos, true);
    }

    @RequestMapping(value={"/historico-conciliacao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public List<ContaCorrenteLancamento> buscarLancamentosHistorico(@RequestBody ConciliacaoBancariaMovimento movimento, @RequestParam Long idContaCorrente) throws UnicoMensagemUsuarioException {
        return ContaCorrenteLancamentoCommonRN.getInstance().buscarLancamentosHitoricoConciliacao(movimento, idContaCorrente);
    }

    private List<ContaCorrenteLancamento> getDocumentosConciliacaoManual(ConciliacaoManualWrapper conciliacao) throws UnicoMensagemUsuarioException {
        ArrayList<ContaCorrenteLancamento> listaLancamentos = new ArrayList<ContaCorrenteLancamento>();
        if (!ListMapUtil.listNullOrEmpty((List)conciliacao.getIds())) {
            for (Long id : conciliacao.getIds()) {
                ContaCorrenteLancamento lancamento;
                if (NumberUtil.longNullOuZero((Long)id) || (lancamento = (ContaCorrenteLancamento)ContaCorrenteLancamentoRN.getInstance().buscarPorId(id)) == null) continue;
                if (conciliacao.isConciliar()) {
                    if (!NumberUtil.longNullOuZero((Long)lancamento.getIdUsuarioConciliacao())) {
                        throw new UnicoMensagemUsuarioException("WFIN272", "Lan\u00e7amento do dia ".concat(StringUtil.formataDataHora((Temporal)lancamento.getDatahora(), (String)"dd/MM/yyyy")).concat(!StringUtil.stringNullOrEmpty((String)lancamento.getHistorico()) ? " - ".concat(lancamento.getHistorico()) : "").concat(" - R$ ").concat(StringUtil.formataNumero((BigDecimal)lancamento.getValor().abs(), (String)"#,##0.00")).concat(" j\u00e1 est\u00e1 conciliado!"));
                    }
                } else if (NumberUtil.longNullOuZero((Long)lancamento.getIdUsuarioConciliacao())) {
                    throw new UnicoMensagemUsuarioException("WFIN273", "Lan\u00e7amento do dia ".concat(StringUtil.formataDataHora((Temporal)lancamento.getDatahora(), (String)"dd/MM/yyyy")).concat(!StringUtil.stringNullOrEmpty((String)lancamento.getHistorico()) ? " - ".concat(lancamento.getHistorico()) : "").concat(" - R$ ").concat(StringUtil.formataNumero((BigDecimal)lancamento.getValor().abs(), (String)"#,##0.00")).concat(" n\u00e3o est\u00e1 conciliado!"));
                }
                listaLancamentos.add(lancamento);
            }
        }
        if (ListMapUtil.listNullOrEmpty(listaLancamentos)) {
            throw new UnicoMensagemUsuarioException("WFIN271", "Nenhum lan\u00e7amento selecionado!");
        }
        return listaLancamentos;
    }

    private void ajustarArquivo(InputStream is, StringBuilder sb) throws IOException {
        String linha;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        boolean removeEspacos = true;
        while ((linha = reader.readLine()) != null) {
            if (linha.contains("TRNAMT")) {
                linha = linha.replace(",", ".");
            }
            linha = Util.removerAcentosSubstituiCaracteresEspeciais((String)linha);
            linha = linha.replaceAll("&", "");
            if (removeEspacos && (linha = Util.removeChar((String)linha, (char)' ')).contains("<OFX>")) {
                removeEspacos = false;
            }
            sb.append(linha);
        }
    }

    protected void beforeSave(ContaCorrenteLancamento lancamento, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        HierarquiaPlanoContas planoContas;
        super.beforeSave(lancamento, parentId);
        if (FuncionalidadeManager.getInstance().isAtiva(Funcionalidade.PLANO_DE_CONTAS) && !Util.longNullOuZero((Long)lancamento.getIdplanocontas()) && (planoContas = (HierarquiaPlanoContas)HierarquiaPlanoContasRN.getInstance().buscarPorId(lancamento.getIdplanocontas())) != null && (lancamento.getOperacao().equals((Object)OperacaoLancamentoFinanceiro.SAIDA) && TipoMovimentoPlanoContas.ENTRADA.equals((Object)planoContas.getTipoMovimento()) || lancamento.getOperacao().equals((Object)OperacaoLancamentoFinanceiro.ENTRADA) && TipoMovimentoPlanoContas.SAIDA.equals((Object)planoContas.getTipoMovimento()))) {
            throw new UnicoMensagemUsuarioException("WFIN449", "Plano de contas incorreto! Selecione um plano de contas do tipo " + lancamento.getOperacao().getDescricao() + ".");
        }
    }
}

