/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.financeiro.receber;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.bancoonline.IntegracaoBancoOnline;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sql.Sql;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.EncargoFinanceiro;
import br.intelidata.commons.domain.pojo.FinanceiroDado;
import br.intelidata.commons.domain.pojo.ParametroCalculoEncargo;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.QuantidadeCampoExtra;
import br.intelidata.commons.domain.pojo.enuns.StatusDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoFinanceiro;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrente;
import br.intelidata.commons.domain.pojo.financeiro.ContaCorrenteCarteira;
import br.intelidata.commons.domain.pojo.financeiro.TipoFinanceiro;
import br.intelidata.commons.domain.pojo.generico.TextoGenerico;
import br.intelidata.commons.domain.regranegocio.TipoDocumentoFinanceiroCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.TextoGenericoRN;
import br.intelidata.commons.modulo.financeiro.bancoonline.BancoOnlineRetornoBoleto;
import br.intelidata.commons.modulo.financeiro.impressao.FinanceiroImpressao;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteCarteiraRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.FinanceiroDadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.ConfiguracaoCampoExtra;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.CustomFilterGrid;
import br.intelidata.uniplusweb.core.grid.FilterField;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.PropriedadeService;
import br.intelidata.uniplusweb.web.enums.TipoImpressaoFinanceiro;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.FinanceiroCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.financeiro.receber.FiltroGridCarga;
import br.intelidata.uniplusweb.web.rest.app.wrapper.ParametrosValidacaoDocumentosFinanceirosWrapper;
import java.io.BufferedReader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@ConfiguracaoCampoExtra(TABELA="contas_receber", QUANTIDADE=QuantidadeCampoExtra.CONTAS_RECEBER_PAGAR)
@RestController
@RequestMapping(value={"/api/financeiros-contas-receber"})
@SubMenuMapping(MENU="SubMenuFinanceiroGeral", NOME="Contas a Receber", ICONE="icon-e-moeda", ROTA="/financeiros/financeiros-contas-receber", PROGRAMA=402)
public class FinanceiroContasReceberCrudController
extends FinanceiroCrudController {
    @Autowired
    public FinanceiroContasReceberCrudController(ResponseEntityService responseEntityService, PropriedadeService propriedadeService, FuncionalidadeService funcionalidadeService, TaskManager taskManager) {
        super(responseEntityService, propriedadeService, funcionalidadeService, TipoFinanceiro.RECEBER, taskManager);
    }

    @RequestMapping(value={"/imprimir-documentos"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirDocumentos(@RequestBody ParametrosValidacaoDocumentosFinanceirosWrapper parametros) throws UnicoMensagemUsuarioException {
        byte[] pdf;
        parametros.setValidarDocumentos(true);
        parametros.setAtualizarDadosPagmto(true);
        List documentos = this.getListaDocumentosSelecionados(parametros);
        String nomeArquivo = parametros.getTipoImpressao().getDescricao();
        if (parametros.getTipoImpressao() == TipoImpressaoFinanceiro.CARNE) {
            this.validarEntidade(documentos);
            pdf = FinanceiroImpressao.getInstance().imprimirCarnePagamento(SessaoUtil.getSessao(), documentos);
        } else if (parametros.getTipoImpressao() == TipoImpressaoFinanceiro.PARCELAMENTO) {
            pdf = FinanceiroImpressao.getInstance().imprimirParcelamento(SessaoUtil.getSessao(), documentos).getMalote().extrai("pdf");
        } else {
            if (NumberUtil.longNullOuZero((Long)parametros.getIdTextoGenerico())) {
                throw new UnicoMensagemUsuarioException("FIN343", "Por favor escolha um texto gen\u00e9rico para o contrato.");
            }
            TextoGenerico textoGenerico = (TextoGenerico)TextoGenericoRN.getInstance().buscarPorId(parametros.getIdTextoGenerico());
            if (parametros.getTipoImpressao() == TipoImpressaoFinanceiro.CONTRATO) {
                List linhas = new BufferedReader(new StringReader(textoGenerico.getTexto())).lines().collect(Collectors.toList());
                pdf = FinanceiroImpressao.getInstance().imprimirContrato(SessaoUtil.getSessao(), linhas, documentos).getMalote().extrai("pdf");
            } else {
                pdf = ((Remessa)FinanceiroDadoRN.getInstance().gerarCartaCobranca(SessaoUtil.getSessao(), textoGenerico, documentos).get(0)).getMalote().extrai("pdf");
            }
        }
        return this.responseEntityService.createPDFResponse(pdf, nomeArquivo);
    }

    @RequestMapping(value={"/alterar-dados-cartao"})
    @DBTransaction
    public void alterarDadosCartao(@RequestParam List<Long> idsDocumentos, @RequestParam Long idAdm, @RequestParam(required=false) Long idBandeira, @RequestParam(required=false) Long idTipoDocumentoFinanceiro) throws UnicoMensagemUsuarioException {
        List documentos = FinanceiroDadoRN.getInstance().buscarListaPorIds(idsDocumentos);
        if (!Util.listNullOrEmpty((List)documentos)) {
            for (FinanceiroDado documento : documentos) {
                if (TipoAcaoFinanceiro.RECEBER_CARTAO_DEBITO.equals((Object)documento.getTipoDocumento().getAcao()) || TipoAcaoFinanceiro.RECEBER_CARTAO_CREDITO.equals((Object)documento.getTipoDocumento().getAcao())) continue;
                throw new UnicoMensagemUsuarioException("WFIN299", "Selecione apenas documentos onde a a\u00e7\u00e3o do tipo de documento seja Cart\u00e3o!");
            }
        }
        if (Util.longNullOuZero((Long)idAdm)) {
            throw new UnicoMensagemUsuarioException("WFIN313", "N\u00e3o foi informada a nova administradora de cart\u00e3o! Verifique.");
        }
        FinanceiroDadoRN.getInstance().alterarDadosCartao(SessaoUtil.getSessao(), documentos, idAdm, idBandeira, idTipoDocumentoFinanceiro);
    }

    @RequestMapping(value={"/atualizar-taxas"})
    @DBTransaction
    public void atualizarTaxaCarta(@RequestParam List<Long> idsDocumentos) throws UnicoMensagemUsuarioException {
        List documentos = FinanceiroDadoRN.getInstance().buscarListaPorIds(idsDocumentos);
        if (!Util.listNullOrEmpty((List)documentos)) {
            this.validarDocumento(documentos);
            FinanceiroDadoRN.getInstance().atualizaTaxaCartao(documentos, SessaoUtil.getSessao());
        }
    }

    protected void afterLoadGrid(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) {
        Map parametros = FinanceiroDadoRN.getInstance().getParametrosCalculoEncargo();
        Map parametrosTiposDocumentos = TipoDocumentoFinanceiroCommonRN.getInstance().getParametrosCalculoEncargoPorTipoDocumento();
        Map parametrosEncargosPorContaCorrente = ContaCorrenteRN.getInstance().getParametrosCalculoEncargoPorContaCorrente();
        LocalDate HOJE = DataHoraFactory.getData();
        int idxVencimento = this.getIndexColuna("vencimento", colunas);
        if (idxVencimento > -1) {
            dados.forEach(registro -> {
                LocalDate vencimento = DataHoraFactory.date2LocalDate((Date)((Date)registro[idxVencimento]));
                LocalDate vencimentoCalculoEncargos = DataHoraFactory.date2LocalDate((Date)((Date)registro[this.getIndexColuna("vencimentoCalculoEncargos", colunas)]));
                int idxStatus = this.getIndexColuna("codigostatus", colunas);
                if (idxStatus > -1) {
                    int idxDiasVenc;
                    String valor = (String)registro[idxStatus];
                    String status = "";
                    StatusDocumentoFinanceiro enumStatus = (StatusDocumentoFinanceiro)EnumUtils.getPorNomeConstante(StatusDocumentoFinanceiro.class, (String)valor);
                    if (enumStatus == null) {
                        enumStatus = Stream.of(StatusDocumentoFinanceiro.values()).filter(stt -> stt.getDescricao().equalsIgnoreCase(valor)).findFirst().orElse(null);
                    }
                    if (enumStatus != null) {
                        status = enumStatus.getId();
                    }
                    if ((idxDiasVenc = this.getIndexColuna("diasvencidos", colunas)) > -1) {
                        int dias;
                        LocalDate dataPagamento = DataHoraFactory.date2LocalDate((Date)((Date)registro[this.getIndexColuna("pagamentodoc", colunas)]));
                        if (dataPagamento == null || status.equals(StatusDocumentoFinanceiro.ABERTO.getId())) {
                            dataPagamento = DataHoraFactory.getData();
                        }
                        registro[idxDiasVenc] = (dias = Util.getDiferencaEmDias((LocalDate)vencimento, (LocalDate)dataPagamento)) > 0 ? Integer.valueOf(dias) : Integer.valueOf(0);
                    }
                    if (!(status.equals(StatusDocumentoFinanceiro.QUITADO.getId()) || status.equals(StatusDocumentoFinanceiro.SUBSTITUIDO.getId()) || status.equals(StatusDocumentoFinanceiro.BAIXADO.getId()) || vencimento == null || vencimento.compareTo(HOJE) >= 0)) {
                        BigDecimal saldo;
                        String nomeColunaSaldo = "saldo_atualizado";
                        int indexSaldoCalculado = this.getIndexColuna("saldo_atualizado", colunas);
                        if (indexSaldoCalculado < 0) {
                            indexSaldoCalculado = this.getIndexColuna("saldo", colunas);
                            nomeColunaSaldo = "saldo";
                        }
                        if (indexSaldoCalculado > -1 && (saldo = (BigDecimal)registro[this.getIndexColuna("saldoestatico", colunas)]) != null) {
                            EncargoFinanceiro encargoFinanceiro;
                            Long idTipoDocumentoFinanceiro = (Long)registro[this.getIndexColuna("idtipodocumentofinanceiro", colunas)];
                            Long idFilial = (Long)registro[this.getIndexColuna("idFilial", colunas)];
                            if (NumberUtil.longNullOuZero((Long)idFilial)) {
                                idFilial = SessaoUtil.getSessao().getIdFilial();
                            }
                            ParametroCalculoEncargo parametro = null;
                            Long idContaCorrente = (Long)registro[this.getIndexColuna("idcontageraboleto", colunas)];
                            if (!NumberUtil.longNullOuZero((Long)idContaCorrente)) {
                                parametro = (ParametroCalculoEncargo)parametrosEncargosPorContaCorrente.get(idContaCorrente);
                            }
                            if (parametro == null && (parametro = (ParametroCalculoEncargo)parametrosTiposDocumentos.get(idTipoDocumentoFinanceiro)) == null) {
                                parametro = (ParametroCalculoEncargo)parametros.get(idFilial);
                            }
                            if ((encargoFinanceiro = FinanceiroDadoRN.getInstance().calcularEncargosFinanceiros(HOJE, saldo, vencimentoCalculoEncargos != null ? vencimentoCalculoEncargos : vencimento, parametro, vencimentoCalculoEncargos != null && vencimentoCalculoEncargos.compareTo(vencimento) != 0)) != null) {
                                saldo = saldo.add(encargoFinanceiro.getValorJuros()).add(encargoFinanceiro.getValorMulta());
                                int indexJuros = this.getIndexColuna("jurosencargos", colunas);
                                int indexMulta = this.getIndexColuna("multaencargos", colunas);
                                if (indexJuros > -1) {
                                    registro[indexJuros] = encargoFinanceiro.getValorJuros();
                                }
                                if (indexMulta > -1) {
                                    registro[indexMulta] = encargoFinanceiro.getValorMulta();
                                }
                            }
                            registro[this.getIndexColuna((String)nomeColunaSaldo, (List)colunas)] = saldo;
                        }
                    }
                }
            });
        }
    }

    @RequestMapping(value={"/consultar-cobranca-online"})
    @DBAutoCommit
    public BancoOnlineRetornoBoleto consultarDocumentoOnlineCobranca(@RequestParam Long idFinanceiro) throws UnicoMensagemUsuarioException {
        ContaCorrente conta = null;
        FinanceiroDado financeiro = (FinanceiroDado)FinanceiroDadoRN.getInstance().buscarPorId(idFinanceiro);
        if (financeiro == null) {
            return null;
        }
        boolean contaComApi = ContaCorrenteRN.getInstance().possuiIntegracaoOnline(financeiro.getIdContaGeraBoleto());
        if (contaComApi) {
            conta = (ContaCorrente)ContaCorrenteRN.getInstance().buscarPorId(financeiro.getIdContaGeraBoleto());
        }
        if (conta != null) {
            ContaCorrenteCarteira contaCorrenteCarteira;
            String carteira = null;
            if (!Util.longNullOuZero((Long)financeiro.getIdCarteiraGeradaUBoleto()) && (contaCorrenteCarteira = (ContaCorrenteCarteira)ContaCorrenteCarteiraRN.getInstance().buscarPorId(financeiro.getIdCarteiraGeradaUBoleto())) != null) {
                carteira = contaCorrenteCarteira.getCarteira();
            }
            String nossoNumero = financeiro.getNossoNumero() + financeiro.getDvNossoNumero();
            return new IntegracaoBancoOnline(SessaoUtil.getSessao(), conta).consultarBoleto(nossoNumero, carteira);
        }
        return null;
    }

    private void validarEntidade(List<FinanceiroDado> listaDocumentosSelecionados) throws UnicoMensagemUsuarioException {
        if (!ListMapUtil.listNullOrEmpty(listaDocumentosSelecionados)) {
            Long idEntidade = listaDocumentosSelecionados.get(0).getIdEntidade();
            boolean entidadesIguais = listaDocumentosSelecionados.stream().allMatch(fd -> idEntidade != null && idEntidade.equals(fd.getIdEntidade()));
            if (!entidadesIguais) {
                throw new UnicoMensagemUsuarioException("WFIN323", "Selecione documentos do mesmo cliente!");
            }
        }
    }

    private void validarDocumento(List<FinanceiroDado> documentos) throws UnicoMensagemUsuarioException {
        String critica = null;
        for (FinanceiroDado financeiroDado : documentos) {
            if (financeiroDado.getStatus().equals(StatusDocumentoFinanceiro.ABERTO.getId())) continue;
            critica = "Selecione somente documentos abertos";
            break;
        }
        if (documentos.isEmpty()) {
            critica = "Nenhum documento selecionado";
        }
        if (critica != null) {
            throw new UnicoMensagemUsuarioException("WFIN107", critica);
        }
    }

    protected void prepareGrid() throws UnicoMensagemUsuarioException {
        super.prepareGrid();
        if (ModuloManager.getInstance().isAtivo(Modulo.EXPEDICAO)) {
            this.addCustomFilterGrid((CustomFilterGrid)new FiltroGridCarga());
        }
    }

    protected void beforeSave(FinanceiroDado financeiroDado, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Long idEntidade;
        if (!StringUtil.stringNullOrEmpty((String)financeiroDado.getReferenciaParceiro()) && !(idEntidade = (Long)FinanceiroDadoRN.getInstance().buscarValorPorID(financeiroDado.getId(), "identidade")).equals(financeiroDado.getIdEntidade())) {
            throw new UnicoMensagemUsuarioException("WWW727", "O documento j\u00e1 foi enviado ao Asaas e n\u00e3o \u00e9 permitido alterar o cliente.");
        }
        super.beforeSave(financeiroDado, parentId);
    }

    protected Map<String, BigDecimal> getMapValoresTotalizados(List<ColunaSQL> colunas, List<Object[]> dados, List<FilterField> filters, MultiValueMap<String, String> parameters) {
        Map mapValores = super.getMapValoresTotalizados(colunas, dados, filters, parameters);
        if (mapValores != null) {
            Map parametrosGerais = FinanceiroDadoRN.getInstance().getParametrosCalculoEncargo();
            Map parametrosPorTipoDocumento = TipoDocumentoFinanceiroCommonRN.getInstance().getParametrosCalculoEncargoPorTipoDocumento();
            Map parametrosPorContaCorrente = ContaCorrenteRN.getInstance().getParametrosCalculoEncargoPorContaCorrente();
            LocalDate hoje = DataHoraFactory.getData();
            BigDecimal saldoAtualizado = BigDecimal.ZERO;
            Sql sql = new Sql(this.grid.getGridBuilder().getSelect().setLimit(0));
            sql.executaQuery();
            while (sql.next()) {
                LocalDate vencimento = sql.getDate("vencimento");
                LocalDate vencimentoEncargos = Optional.ofNullable(sql.getDate("vencimentocalculoencargos")).orElse(vencimento);
                Long idTipoDocumento = sql.getLong("idtipodocumentofinanceiro");
                Long idFilial = Optional.ofNullable(sql.getLong("idfilial")).orElse(SessaoUtil.getSessao().getIdFilial());
                Long idContaCorrente = sql.getLong("idcontageraboleto");
                BigDecimal valor = sql.getBigDecimal("saldoestatico");
                ParametroCalculoEncargo parametro = this.obterParametroCalculoEncargo(idContaCorrente, idTipoDocumento, idFilial, parametrosPorContaCorrente, parametrosPorTipoDocumento, parametrosGerais);
                EncargoFinanceiro encargo = FinanceiroDadoRN.getInstance().calcularEncargosFinanceiros(hoje, valor, vencimentoEncargos, parametro, !vencimentoEncargos.equals(vencimento));
                if (encargo == null) continue;
                saldoAtualizado = saldoAtualizado.add(valor).add(encargo.getValorJuros()).add(encargo.getValorMulta());
            }
            sql.close();
            mapValores.put("saldo_atualizado", saldoAtualizado);
        }
        return mapValores;
    }

    private ParametroCalculoEncargo obterParametroCalculoEncargo(Long idContaCorrente, Long idTipoDocumento, Long idFilial, Map<Long, ParametroCalculoEncargo> parametrosPorContaCorrente, Map<Long, ParametroCalculoEncargo> parametrosPorTipoDocumento, Map<Long, ParametroCalculoEncargo> parametrosGerais) {
        if (!NumberUtil.longNullOuZero((Long)idContaCorrente)) {
            return parametrosPorContaCorrente.getOrDefault(idContaCorrente, parametrosPorTipoDocumento.getOrDefault(idTipoDocumento, parametrosGerais.get(idFilial)));
        }
        return parametrosPorTipoDocumento.getOrDefault(idTipoDocumento, parametrosGerais.get(idFilial));
    }
}

