/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.familia;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.Funcionalidade;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.FamiliaProduto;
import br.intelidata.commons.domain.regranegocio.FamiliaProdutoPautaPrecoRN;
import br.intelidata.commons.domain.regranegocio.HierarquiaRN;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.web.rest.app.crud.hierarquia.HierarquiaCrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/familias-produto"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarProdutos", NOME="Fam\u00edlias de produto", ICONE="icon-incluir-subgrupo", ROTA="/produtos-module/familias-produto", PROGRAMA=1336)
public class FamiliaProdutoCrudController
extends HierarquiaCrudController<FamiliaProduto, FamiliaProdutoRN> {
    private final FuncionalidadeService funcionalidadeService;

    public FamiliaProdutoCrudController(FuncionalidadeService funcionalidadeService) {
        super((HierarquiaRN)FamiliaProdutoRN.getInstance(), FamiliaProduto::new);
        this.funcionalidadeService = funcionalidadeService;
    }

    protected GridBuilder<FamiliaProdutoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id", 0, false));
        colunas.add(new ColunaSQL("codigo", "C\u00f3digo", 0, false));
        colunas.add(new ColunaSQL("nome", "Nome", 0, true));
        this.addColunaNivel(colunas);
        GridBuilder grid = new GridBuilder(FamiliaProdutoRN.getInstance().getTabela(), colunas);
        grid.setOrdemDefault(new Ordem("codigo"));
        return grid;
    }

    protected void beforeRead(FamiliaProduto familiaProduto, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (this.funcionalidadeService.isAtiva(Funcionalidade.ATACAREJO) && this.funcionalidadeService.isAtiva(Funcionalidade.PAUTA_PRECO_CADASTRO)) {
            familiaProduto.setPautasPreco(FamiliaProdutoPautaPrecoRN.getInstance().buscarListaPorIdFamilia(familiaProduto.getId()));
        }
    }

    protected String getCacheId() {
        return "familias-produto";
    }
}

