/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importardenotafiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.DescontoInterface;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.NaturezaOperacao;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoMovimento;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.regranegocio.DescontoRN;
import br.intelidata.commons.domain.regranegocio.NaturezaOperacaoCommonRN;
import br.intelidata.commons.domain.regranegocio.NotaFiscalCommonRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalItemRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.vendas.regranegocio.PromocaoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importardenotafiscal.ItemCfopWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.importarnota.importardenotafiscal.NotaFiscalImportacaoWrapper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/importar-notas-fiscais"})
public class ImportarNotaFiscalCrudController
extends SimpleController {
    @RequestMapping(value={"/importar"})
    @DBAutoCommit
    public NotaFiscalImportacaoWrapper importarNotaDeNotaFiscal(@RequestParam String codigo, @RequestParam String serie, @RequestParam String modelo, @RequestParam Long idEntidade, @RequestParam boolean isNotaSaida, @RequestParam TipoNotaFiscal tipoDocumentoASerGerado, @RequestParam Long idOperacaoFiscal, @RequestParam boolean isTransferencia) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal;
        Sessao sessao = SessaoUtil.getSessao();
        if (isTransferencia) {
            idEntidade = sessao.getFilial().getIdEntidade();
            Entidade entidade = (Entidade)EntidadeRN.getInstance().buscarPorId(idEntidade);
            if (entidade == null) {
                throw new UnicoMensagemUsuarioException("WNTF783", "Cliente/Fornecedor n\u00e3o informado na filial. Por favor Verifique!");
            }
            if (!entidade.getCnpjCpf().equals(Contexto.getInstance().getFilial().getCnpj())) {
                throw new UnicoMensagemUsuarioException("WNTF784", "CNPJ da filial [" + Util.formataCpfCnpj((String)Contexto.getInstance().getFilial().getCnpj()) + "] n\u00e3o confere com o CNPJ do cadastro de cliente/fornecedor [" + Util.formataCpfCnpj((String)entidade.getCnpjCpf()) + "]!");
            }
            notaFiscal = NotaFiscalRN.getInstance().buscarNotaTransferencia(codigo, serie, idEntidade);
        } else {
            notaFiscal = NotaFiscalRN.getInstance().buscarNota(codigo, serie, modelo, SessaoUtil.getSessao().getIdFilial(), isNotaSaida ? TipoNotaFiscal.SAIDA : TipoNotaFiscal.ENTRADA, idEntidade);
        }
        if (notaFiscal == null) {
            throw new UnicoMensagemUsuarioException("WNTF376", "Nota fiscal n\u00e3o encontrada.");
        }
        TipoMovimento tipoMovimento = (TipoMovimento)EnumUtils.getPorId(TipoMovimento.class, (Object)tipoDocumentoASerGerado.getId());
        NotaFiscalImportacaoWrapper notaWrapper = new NotaFiscalImportacaoWrapper();
        notaWrapper.setIdNotaFiscal(notaFiscal.getId());
        notaWrapper.setTipoNotaFiscal(tipoDocumentoASerGerado);
        notaWrapper.setCfopInterna(sessao.getFilial().getIdEstado().equals(notaFiscal.getIdEstado()));
        if (isTransferencia) {
            notaWrapper.setNotaFiscal(NotaFiscalRN.getInstance().importarNotaFiscalTransferencia(notaFiscal.getId(), sessao.getFilial()));
        } else {
            if (!NotaFiscalRN.getInstance().utilizaOperacaoFiscal(TipoNotaFiscal.SAIDA.equals((Object)tipoDocumentoASerGerado), sessao.getIdFilial())) {
                this.buscarNaturezaOperacao(sessao, notaFiscal.getId(), tipoMovimento, notaWrapper);
                this.buscarListaNaturezaOperacao(sessao, notaFiscal.getId(), NotaFiscalItemRN.getInstance().buscarListaByIdNotaFiscal(notaFiscal.getId()), tipoMovimento, notaWrapper);
            }
            if (!notaWrapper.isExiteCritica()) {
                Map cfopsItens = this.converterLista(notaWrapper.getItens());
                NaturezaOperacao naturezaOperacao = this.getNaturezaOperacaoCabecalho(notaWrapper);
                notaWrapper.getItens().clear();
                notaWrapper.setNotaFiscal(NotaFiscalRN.getInstance().importarNotaFiscal(sessao, notaFiscal.getId(), tipoDocumentoASerGerado, naturezaOperacao, cfopsItens, idOperacaoFiscal));
            }
        }
        if (notaWrapper.getNotaFiscal() != null) {
            notaWrapper.getNotaFiscal().getNotaFiscalItens().forEach(item -> item.setItemPermiteDesconto(DescontoRN.getInstance().isItemPermiteDesconto(SessaoUtil.getSessao().getFilial(), (DescontoInterface)item, !NumberUtil.longNullOuZero((Long)item.getIdPromocao()) ? PromocaoRN.getInstance().buscarPorId(item.getIdPromocao()) : null)));
        }
        return notaWrapper;
    }

    @RequestMapping(value={"/importar-nota-fiscal"}, method={RequestMethod.POST})
    @DBAutoCommit
    public NotaFiscal importarNotaFiscal(@RequestBody NotaFiscalImportacaoWrapper notaWrapper) throws UnicoMensagemUsuarioException {
        Map cfopsItens = this.converterLista(notaWrapper.getItens());
        NaturezaOperacao naturezaOperacao = this.getNaturezaOperacaoCabecalho(notaWrapper);
        return NotaFiscalRN.getInstance().importarNotaFiscal(SessaoUtil.getSessao(), notaWrapper.getIdNotaFiscal(), notaWrapper.getTipoNotaFiscal(), naturezaOperacao, cfopsItens, notaWrapper.getIdOperacaoFiscal());
    }

    private void buscarNaturezaOperacao(Sessao sessao, Long idOrigem, TipoMovimento tipoMovimentoDestino, NotaFiscalImportacaoWrapper notaWrapper) {
        NaturezaOperacao naturezaOperacao = null;
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalCommonRN.getInstance().buscarPorId(idOrigem);
        if (notaFiscal != null) {
            NaturezaOperacao naturezaOperacaoNota = NaturezaOperacaoCommonRN.getInstance().buscarPorId(notaFiscal.getIdCfop());
            if (naturezaOperacaoNota != null) {
                if (notaFiscal.getTipoDocumento().getId().equals(tipoMovimentoDestino.getId())) {
                    naturezaOperacao = naturezaOperacaoNota;
                } else {
                    naturezaOperacao = NaturezaOperacaoCommonRN.getInstance().buscarPorId(naturezaOperacaoNota.getIdNaturezaOperacaoInversa());
                    if (naturezaOperacao == null) {
                        naturezaOperacao = (NaturezaOperacao)NaturezaOperacaoCommonRN.getInstance().buscarPorCodigo(NaturezaOperacaoCommonRN.getInstance().getCodigoCFOPPorTipoMovimento(sessao, naturezaOperacaoNota.getCodigo(), notaFiscal.getEstado(), tipoMovimentoDestino));
                    }
                }
            }
            if (naturezaOperacao != null) {
                notaWrapper.setIdNaturezaOperacaoCabecalho(naturezaOperacao.getId());
            } else {
                notaWrapper.setExiteCritica(true);
            }
        }
    }

    private void buscarListaNaturezaOperacao(Sessao sessao, Long idOrigem, List<NotaFiscalItem> itens, TipoMovimento tipoMovimentoDestino, NotaFiscalImportacaoWrapper notaWrapper) {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalCommonRN.getInstance().buscarPorId(idOrigem);
        if (notaFiscal != null) {
            for (NotaFiscalItem notaFiscalItem : itens) {
                NaturezaOperacao naturezaOperacao;
                NaturezaOperacao naturezaOperacaoItem = NaturezaOperacaoCommonRN.getInstance().buscarPorId(notaFiscalItem.getIdCfop());
                if (notaFiscal.getTipoDocumento().getId().equals(tipoMovimentoDestino.getId())) {
                    naturezaOperacao = naturezaOperacaoItem;
                } else {
                    naturezaOperacao = NaturezaOperacaoCommonRN.getInstance().buscarPorId(naturezaOperacaoItem.getIdNaturezaOperacaoInversa());
                    if (naturezaOperacao == null) {
                        naturezaOperacao = (NaturezaOperacao)NaturezaOperacaoCommonRN.getInstance().buscarPorCodigo(NaturezaOperacaoCommonRN.getInstance().getCodigoCFOPPorTipoMovimento(sessao, naturezaOperacaoItem.getCodigo(), notaFiscal.getEstado(), tipoMovimentoDestino));
                    }
                }
                ItemCfopWrapper itemCritica = new ItemCfopWrapper();
                itemCritica.setIdNotaFiscalItem(notaFiscalItem.getId());
                if (naturezaOperacao != null) {
                    itemCritica.setIdNaturezaOperacao(naturezaOperacao.getId());
                } else {
                    notaWrapper.setExiteCritica(true);
                }
                itemCritica.setCodigoProduto(notaFiscalItem.getProduto());
                itemCritica.setProduto(notaFiscalItem.getNomeProduto());
                notaWrapper.addItem(itemCritica);
            }
        }
    }

    private Map<Long, NaturezaOperacao> converterLista(List<ItemCfopWrapper> itens) {
        HashMap<Long, NaturezaOperacao> map = new HashMap<Long, NaturezaOperacao>();
        for (ItemCfopWrapper item : itens) {
            map.put(item.getIdNotaFiscalItem(), NaturezaOperacaoCommonRN.getInstance().buscarPorId(item.getIdNaturezaOperacao()));
        }
        return map;
    }

    private NaturezaOperacao getNaturezaOperacaoCabecalho(NotaFiscalImportacaoWrapper notaWrapper) {
        NaturezaOperacao naturezaOperacao = null;
        if (!Util.longNullOuZero((Long)notaWrapper.getIdNaturezaOperacaoCabecalho())) {
            naturezaOperacao = NaturezaOperacaoCommonRN.getInstance().buscarPorId(notaWrapper.getIdNaturezaOperacaoCabecalho());
        } else {
            for (ItemCfopWrapper item : notaWrapper.getItens()) {
                if (Util.longNullOuZero((Long)item.getIdNaturezaOperacao())) continue;
                naturezaOperacao = NaturezaOperacaoCommonRN.getInstance().buscarPorId(item.getIdNaturezaOperacao());
                break;
            }
        }
        return naturezaOperacao;
    }
}

