/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.integracaofiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.integracao.RetornoIntegracaoFiscal;
import br.intelidata.commons.modulo.integracao.regranegocio.EnvioIntegracaoFiscalRN;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.service.CacheInterfaceService;
import br.intelidata.uniplusweb.web.rest.app.crud.integracaofiscal.FiltroProdutoIntegracaoWrapper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/lotes-integracao-fiscal"})
public class LoteIntegracaoFiscalIncluirConsultaController {
    @Autowired
    protected CacheInterfaceService cacheInterfaceService;

    @RequestMapping(value={"/incluir-consulta-tributacao"}, method={RequestMethod.POST})
    @DBAutoCommit
    public RetornoIntegracaoFiscal incluirConsultaTributacao(@RequestBody FiltroProdutoIntegracaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        List ids = wrapper.getFiltroGrid() != null ? this.cacheInterfaceService.getListaIDs("produtos", wrapper.getFiltroGrid().getQuery(), wrapper.getFiltroGrid().getFilter()) : wrapper.getIdsProdutos();
        List produtos = ProdutoRN.getInstance().buscarListaPorIdsSqlUnico(ids);
        RetornoIntegracaoFiscal retornoIntegracaoFiscal = EnvioIntegracaoFiscalRN.getInstance().incluirConsultaTributacao(SessaoUtil.getSessao(), produtos);
        if (retornoIntegracaoFiscal != null) {
            if (!Util.listNullOrEmpty((List)retornoIntegracaoFiscal.getProdutosComProblema()) && Util.listNullOrEmpty((List)retornoIntegracaoFiscal.getProdutos())) {
                throw new UnicoMensagemUsuarioException("WINT111", "N\u00e3o foi poss\u00edvel consultar a tributa\u00e7\u00e3o para o(s) produto(s)!");
            }
            if (!Util.stringNullOrEmpty((String)retornoIntegracaoFiscal.getMensagemRetorno())) {
                retornoIntegracaoFiscal.setMensagemRetorno(retornoIntegracaoFiscal.getMensagemRetorno().replace("\n", "<br/>"));
            }
            if (!Util.stringNullOrEmpty((String)retornoIntegracaoFiscal.getMensagemRetornoDetalhe())) {
                retornoIntegracaoFiscal.setMensagemRetornoDetalhe(retornoIntegracaoFiscal.getMensagemRetornoDetalhe().replace("\n", "<br/>"));
            }
        }
        return retornoIntegracaoFiscal;
    }
}

