/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.localretirada;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.LocalRetirada;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.LocalRetiradaRN;
import br.intelidata.commons.domain.regranegocio.b2c.LocalRetiradaShopRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.EstadoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/local-retirada"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarFilial", ICONE="icon-local-trabalho", NOME="Locais de retirada", ROTA="/cadastros/local-retirada", PROGRAMA=1000064)
public class LocalRetiradaCrudController
extends CrudController<LocalRetirada, LocalRetiradaRN> {
    public LocalRetiradaCrudController() {
        super((AbstractRegraNegocio)LocalRetiradaRN.getInstance(), LocalRetirada::new);
    }

    protected String getCacheId() {
        return "local-retirada";
    }

    protected GridBuilder<LocalRetiradaShopRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("razaosocialnome", "Raz\u00e3o Social/Nome", 0, true));
        colunas.add(new ColunaSQL("cnpjcpf", "CNPJ/CPF", 0, true));
        return new GridBuilder(LocalRetiradaRN.getInstance().getTabela(), colunas);
    }

    protected void beforeSave(LocalRetirada localRetirada, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        super.beforeSave((AbstractPojo)localRetirada, parentId);
        Estado estado = (Estado)EstadoRN.getInstance().buscarPorId(localRetirada.getIdEstado());
        if (estado != null) {
            localRetirada.setIdPais(estado.getIdPais());
        }
    }

    @RequestMapping(value={"/filtrar-por-filial"})
    @DBAutoCommit
    public List<LocalRetirada> filtrarCPorFilial() {
        return LocalRetiradaRN.getInstance().getComboWeb(SessaoUtil.getSessao());
    }
}

