/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.log;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.core.wrapper.ArquivoInfoWrapper;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.SystemUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/gerenciador-logs"})
public class GerenciadorLogSimpleController {
    private final ResponseEntityService responseEntityService;

    public GerenciadorLogSimpleController(ResponseEntityService responseEntityService) {
        this.responseEntityService = responseEntityService;
    }

    @RequestMapping(value={"/arquivos"})
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public List<ArquivoInfoWrapper> getArquivos() throws UnicoMensagemUsuarioException {
        try {
            ArrayList<ArquivoInfoWrapper> arquivos = new ArrayList<ArquivoInfoWrapper>();
            List paths = FileUtil.buscarListaLog((String)(SystemUtil.getDiretorioAplicacao() + File.separator));
            for (Path path : paths) {
                BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                LocalDateTime dataCriacaoArquivo = DataHoraFactory.long2LocalDateTime((long)attr.lastModifiedTime().to(TimeUnit.MILLISECONDS));
                String nome = path.getFileName() != null ? path.getFileName().toString() : "";
                ArquivoInfoWrapper arq = new ArquivoInfoWrapper(path.toString(), nome, dataCriacaoArquivo, attr.size());
                arq.setTenant("logWeb");
                arquivos.add(arq);
            }
            ArquivoInfoWrapper arquivoPaiWeb = new ArquivoInfoWrapper();
            arquivoPaiWeb.setTenant("logWeb");
            arquivoPaiWeb.setNome("UniplusWeb");
            arquivoPaiWeb.setData(DataHoraFactory.getDataHora());
            arquivos.add(arquivoPaiWeb);
            ArquivoInfoWrapper arquivoPai = new ArquivoInfoWrapper();
            arquivoPai.setTenant("log");
            arquivoPai.setNome("Log");
            arquivoPai.setData(DataHoraFactory.getDataHora());
            arquivos.add(arquivoPai);
            this.listFilesRecursive(Paths.get(SystemUtil.getDiretorioAplicacao() + File.separator + "log", new String[0]), arquivos);
            return arquivos;
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW656", "N\u00e3o foi poss\u00edvel recuperar os aquivos", (Throwable)e);
        }
    }

    public void listFilesRecursive(Path dir, List<ArquivoInfoWrapper> arquivos) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    this.listFilesRecursive(path, arquivos);
                    String pai = path.getFileName().toString();
                    if (!arquivos.stream().anyMatch(a -> a.getTenant().equalsIgnoreCase(pai))) continue;
                    ArquivoInfoWrapper arquivoPai = new ArquivoInfoWrapper();
                    arquivoPai.setTenant(pai);
                    arquivoPai.setNome(pai);
                    arquivoPai.setData(DataHoraFactory.getDataHora());
                    arquivos.add(arquivoPai);
                    continue;
                }
                BasicFileAttributes attr = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
                LocalDateTime dataCriacaoArquivo = DataHoraFactory.long2LocalDateTime((long)attr.lastModifiedTime().to(TimeUnit.MILLISECONDS));
                String nome = path.getFileName() != null ? path.getFileName().toString() : "";
                ArquivoInfoWrapper arquivo = new ArquivoInfoWrapper(path.toString(), nome, dataCriacaoArquivo, attr.size());
                if (!nome.startsWith("uniplusweb")) {
                    arquivo.setTenant(path.getParent().getFileName().toString());
                }
                arquivos.add(arquivo);
            }
        }
    }

    @RequestMapping(value={"/download"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> download(@RequestBody ArquivoInfoWrapper log) throws UnicoMensagemUsuarioException {
        File file = new File(log.getPath());
        if (!file.exists()) {
            throw new UnicoMensagemUsuarioException("WWW657", "Arquivo n\u00e3o encontrado.");
        }
        return this.responseEntityService.createFileResponse(FileUtil.file2ByteArray((File)file), MediaType.APPLICATION_OCTET_STREAM, log.getNome());
    }
}

