/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.mobile.pedidovenda;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.domain.pojo.enuns.StatusDAV;
import br.intelidata.commons.domain.pojo.enuns.TipoDocumentoDAV;
import br.intelidata.commons.domain.pojo.pvdav.Dav;
import br.intelidata.commons.modulo.pvdav.regranegocio.DavRN;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.service.AtacarejoService;
import br.intelidata.uniplusweb.service.FuncionalidadeService;
import br.intelidata.uniplusweb.service.ModuloService;
import br.intelidata.uniplusweb.web.rest.app.crud.davs.DavCrudController;
import java.math.RoundingMode;
import java.util.List;
import java.util.Optional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pedido-venda-mobile"})
public class PedidoVendaMobileController
extends DavCrudController {
    public PedidoVendaMobileController(FuncionalidadeService funcionalidadeService, AtacarejoService atacarejoService, ModuloService moduloService) {
        super(funcionalidadeService, atacarejoService, moduloService);
    }

    @PostMapping(value={"/venda/create"})
    @DBTransaction
    public void davCreate(@RequestBody Dav dav) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty((List)dav.getItens())) {
            throw new UnicoMensagemUsuarioException("COM2366925", "N\u00e3o existem itens para esse documento");
        }
        dav.setCodigo(DavRN.getInstance().getCodigoDav(SessaoUtil.getSessao(), dav.getTipodocumento()));
        dav.setIdFilial(SessaoUtil.getSessao().getFilial().getId());
        if (dav.getData() == null) {
            dav.setData(DataHoraFactory.getData());
        }
        dav.setStatus(StatusDAV.FECHADO);
        dav.setIdUsuario(SessaoUtil.getSessao().getIdUsuario());
        dav.setCupomemitido(Integer.valueOf(0));
        if (dav.getTipodocumento().equals((Object)TipoDocumentoDAV.PREVENDA)) {
            dav.setTituloDav("PRE-VENDA");
        } else if (dav.getTipodocumento().equals((Object)TipoDocumentoDAV.ORCAMENTO)) {
            dav.setTituloDav("ORCAMENTO");
        } else if (dav.getTipodocumento().equals((Object)TipoDocumentoDAV.PEDIDO)) {
            dav.setTituloDav("PEDIDO");
        } else if (dav.getTipodocumento().equals((Object)TipoDocumentoDAV.DAV_OS)) {
            dav.setTituloDav("ORDEM DE SERVICO");
        }
        dav.setValor(dav.getValor().setScale(7, RoundingMode.HALF_EVEN));
        this.create(dav, null);
    }

    protected void beforeCreate(Dav dav, Optional<Long> parentId) {
        dav.setCodigo(DavRN.getInstance().getCodigoDav(SessaoUtil.getSessao(), dav.getTipodocumento()));
        dav.setIdFilial(SessaoUtil.getSessao().getFilial().getId());
        if (dav.getData() == null) {
            dav.setData(DataHoraFactory.getData());
        }
    }
}

