/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.modeloetiqueta.danfesimplificada;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ModeloEtiqueta;
import br.intelidata.commons.domain.pojo.ModeloEtiquetaCampo;
import br.intelidata.commons.domain.pojo.enuns.LayoutEtiqueta;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoEtiqueta;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.modulo.etiqueta.EtiquetaDanfeSimplificada;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaDanfeSimplificada;
import br.intelidata.commons.modulo.etiqueta.ModeloEtiquetaModel;
import br.intelidata.commons.modulo.etiqueta.regranegocio.ModeloEtiquetaRN;
import br.intelidata.commons.modulo.etiqueta.relatorio.EtiquetaDriverNativoRelatorio;
import br.intelidata.commons.modulo.etiqueta.relatorio.EtiquetaJasperRelatorio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloetiqueta.ModeloEtiquetaCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloetiqueta.danfesimplificada.ImprimirDanfeSimplificadaWrapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import unipaf.servidor.RestUtil;

@RestController
@RequestMapping(value={"/api/modelos-danfe-simplificado"})
@SubMenuMapping(MENU="SubMenuCadastroAuxiliarModeloImpressao", NOME="Etiqueta de DANFE Simplificado", ROTA="/cadastros/modelos-danfe-simplificado", PROGRAMA=1000078)
public class ModeloEtiquetaDanfeSimplificadaCrudController
extends ModeloEtiquetaCrudController {
    public ModeloEtiquetaDanfeSimplificadaCrudController() {
        super(LayoutEtiqueta.DANFE_SIMPLIFICADA);
    }

    protected String getCacheId() {
        return "modelos-danfe-simplificado";
    }

    public ModeloEtiquetaDanfeSimplificada getModelo() {
        return new ModeloEtiquetaDanfeSimplificada();
    }

    protected List<ModeloEtiquetaCampo> carregarModeloDefault() {
        ModeloEtiquetaDanfeSimplificada modelo = new ModeloEtiquetaDanfeSimplificada();
        modelo.getMapCampos().clear();
        modelo.getMapCamposPadrao().clear();
        return modelo.getListaCamposPadrao();
    }

    @RequestMapping(value={"/combo-campos-danfe-simplificado"})
    @DBAutoCommit
    public List<ModeloEtiquetaCampo> buscaListaCampos() {
        List<ModeloEtiquetaCampo> lista = this.getModelo().getListaCamposPadrao().stream().filter(campo -> campo.getTipoCampo() != 99).collect(Collectors.toList());
        for (int i = 0; i < lista.size(); ++i) {
            ModeloEtiquetaCampo campo2 = lista.get(i);
            campo2.setId(Long.valueOf(i + 1));
        }
        return lista;
    }

    protected GridBuilder<ModeloEtiquetaRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "id"));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("tipo", "tipo_", "Tipo", 300, true, new String[0]));
        colunas.add(new ColunaSQL("tipo", "tipo_", 0, false));
        GridBuilder grid = new GridBuilder(ModeloEtiquetaRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("scriptetiqueta"));
        grid.addReferenciaDefault(new Referencia("tipolayout"));
        grid.addCodicaoDefault(new Condicao("tipolayout", Operador.IGUAL, this.layoutEtiqueta.getId().intValue()));
        grid.addOrdem(new Ordem("descricao"));
        return grid;
    }

    protected ModeloEtiqueta importar(MultipartFile file) throws UnicoMensagemUsuarioException {
        try {
            return (ModeloEtiqueta)RestUtil.getObject((String)Util.byteArrayToString((byte[])file.getBytes()), ModeloEtiqueta.class);
        }
        catch (IOException | ClassCastException ex) {
            throw new UnicoMensagemUsuarioException("COM23669848", "N\u00e3o \u00e9 poss\u00edvel importar o modelo de impress\u00e3o nesta vers\u00e3o do sistema.");
        }
    }

    protected ResponseEntity<byte[]> exportar(ModeloEtiqueta modelo) throws UnicoMensagemUsuarioException {
        modelo.setId(null);
        modelo.setJrxmlCompilado(null);
        String json = RestUtil.getJSONObject((Object)modelo).toString();
        String nomeArquivo = "modeloEtiqueta";
        if (!Util.stringNullOrEmpty((String)modelo.getDescricao())) {
            nomeArquivo = modelo.getDescricao();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment;filename=" + nomeArquivo + ".json");
        return new ResponseEntity((Object)json.getBytes(StandardCharsets.UTF_8), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/preview"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> preview(@RequestBody ModeloEtiqueta modelo) throws UnicoMensagemUsuarioException {
        modelo.setJrxmlCompilado(null);
        Remessa remessa = new EtiquetaJasperRelatorio(true).getRelatorio(SessaoUtil.getSessao(), (ModeloEtiquetaModel)this.getModelo().getPreview(modelo), null, 1, 1);
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)SaidaRelatorio.PDF, (String)"preview_danfe_simplificada");
    }

    @RequestMapping(value={"/buscar-modelos"})
    @DBAutoCommit
    public List<ModeloEtiqueta> carregarListaModelo() {
        return ModeloEtiquetaRN.getInstance().getListModeloImpressaoWeb(LayoutEtiqueta.DANFE_SIMPLIFICADA);
    }

    @RequestMapping(value={"/imprimir-danfe-simplificado"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimir(@RequestBody ImprimirDanfeSimplificadaWrapper wrapper) throws UnicoMensagemUsuarioException {
        ModeloEtiqueta modelo = ModeloEtiquetaRN.getInstance().buscarPorId(wrapper.getIdModelo(), true);
        Remessa remessa = modelo.getTipo() == TipoEtiqueta.GRAFICO ? new EtiquetaJasperRelatorio().getRelatorio(SessaoUtil.getSessao(), (ModeloEtiquetaModel)this.getModel(modelo, wrapper.getIds()), null, 1, 1) : EtiquetaDriverNativoRelatorio.getInstance().getRelatorio(SessaoUtil.getSessao(), (ModeloEtiquetaModel)this.getModel(modelo, wrapper.getIds()), Collections.emptyMap());
        return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseEntityService, (SaidaRelatorio)SaidaRelatorio.PDF, (String)"danfe_simplificada");
    }

    private ModeloEtiquetaDanfeSimplificada getModel(ModeloEtiqueta modeloEtiqueta, Long[] ids) throws UnicoMensagemUsuarioException {
        ModeloEtiquetaDanfeSimplificada model = new ModeloEtiquetaDanfeSimplificada();
        model.setModeloEtiqueta(modeloEtiqueta);
        ArrayList<EtiquetaDanfeSimplificada> etiquetas = new ArrayList<EtiquetaDanfeSimplificada>(ids.length);
        for (Long id : ids) {
            NotaFiscal nf = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(id);
            if (nf.getStatus() != StatusNotaFiscal.NFE_AUTORIZADA) {
                throw new UnicoMensagemUsuarioException("WNTF9457", "A nota fiscal s\u00e9rie " + nf.getModelo() + " n\u00famero " + nf.getNumeroNotaFiscal() + " n\u00e3o est\u00e1 autorizada");
            }
            etiquetas.add(new EtiquetaDanfeSimplificada(nf));
        }
        model.setEtiquetas(etiquetas);
        return model;
    }
}

