/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.ComandoImpressao;
import br.intelidata.commons.core.impressao.FormaUtilizacaoModeloImpressao;
import br.intelidata.commons.core.impressao.ImpressaoDocumentoConfigurado;
import br.intelidata.commons.core.impressao.TipoImpressao;
import br.intelidata.commons.core.impressao.TipoModelo;
import br.intelidata.commons.core.impressao.TrataImagemWeb;
import br.intelidata.commons.core.impressao.TrataModeloIReportWeb;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ImpressoraNaoFiscal;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ImpressoraNaoFiscalFactory;
import br.intelidata.commons.core.periferico.impressoraNaoFiscal.ModeloImpressoraNaoFiscal;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.util.Malote;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ConfiguracaoImpressora;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.Layout;
import br.intelidata.commons.domain.pojo.ModeloImpressaoCabecalho;
import br.intelidata.commons.domain.pojo.ModeloImpressaoIReport;
import br.intelidata.commons.domain.pojo.PreferenciaUsuarioModeloImpressao;
import br.intelidata.commons.domain.pojo.TipoRelatorioIReport;
import br.intelidata.commons.domain.pojo.VariavelLayout;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoImpressoraRN;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoCabecalhoRN;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoIReportRN;
import br.intelidata.commons.domain.regranegocio.ModeloImpressaoRN;
import br.intelidata.commons.domain.regranegocio.PreferenciaUsuarioModeloImpressaoRN;
import br.intelidata.commons.modulo.financeiro.impressao.ImpressaoReciboPagamentoSemEvento;
import br.intelidata.commons.modulo.financeiro.regranegocio.ContaCorrenteLancamentoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ValidarIReportInterface;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.ComandoImpressaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.ImpressaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.ParametrosModeloImpressaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao.TrataModeloIReportWebImpl;
import java.awt.Image;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import unipaf.nfce.ImpressaoDanfePDF;

@RestController
@RequestMapping(value={"/api/modelos-impressao"})
public class ModeloImpressaoCrudController
extends CrudController<ModeloImpressaoCabecalho, ModeloImpressaoCabecalhoRN>
implements TrataImagemWeb,
ValidarIReportInterface {
    private final TipoModelo modelo;
    @Autowired
    protected TrataModeloIReportWebImpl trataModeloIReportWeb;

    public ModeloImpressaoCrudController() {
        this(null);
    }

    public ModeloImpressaoCrudController(TipoModelo modelo) {
        super((AbstractRegraNegocio)ModeloImpressaoCabecalhoRN.getInstance(), ModeloImpressaoCabecalho::new, TipoArquivoArmazenado.Modelos_Impressao);
        this.modelo = modelo;
    }

    @RequestMapping(value={"/exportar-modelo"}, method={RequestMethod.POST})
    public ResponseEntity<byte[]> exportarModelo(@RequestBody Layout layout) {
        Malote malote = ModeloImpressaoRN.getInstance().exportaModeloImpressao(layout).getMalote();
        String nomeArquivo = "modelo-" + this.modelo.getDescricao();
        HttpHeaders headers = new HttpHeaders();
        headers.add("Content-Disposition", "attachment;filename=" + nomeArquivo + ".obj");
        return new ResponseEntity((Object)malote.extrai("modeloimp"), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/importar-modelo"}, method={RequestMethod.POST})
    public Layout importarModelo(@RequestPart(value="file") MultipartFile file) throws UnicoMensagemUsuarioException {
        try {
            Malote malote = new Malote();
            malote.inclui("modeloimp", file.getBytes());
            malote.fecha();
            return ModeloImpressaoRN.getInstance().importaModeloImpressao(new Remessa(malote), this.modelo);
        }
        catch (IOException ex) {
            throw new UnicoMensagemUsuarioException("COM236626", "N\u00e3o \u00e9 poss\u00edvel importar o modelo de impress\u00e3o nesta vers\u00e3o do sistema.");
        }
    }

    @RequestMapping(value={"/variaveis-layout"})
    @DBAutoCommit
    public List<VariavelLayout> getVariaveisLayout() {
        Layout layout = ModeloImpressaoRN.getInstance().carregaModelo(SessaoUtil.getSessao(), this.modelo, (ModeloImpressaoCabecalho)null);
        return layout.getListVariavelLayout();
    }

    @RequestMapping(value={"/parametros"})
    @DBAutoCommit
    public ParametrosModeloImpressaoWrapper buscaModelosImpressao(@RequestParam TipoModelo tipoModelo) {
        List modelos = ModeloImpressaoCabecalhoRN.getInstance().buscarListaPorTipoModelo(SessaoUtil.getSessao(), tipoModelo, new FormaUtilizacaoModeloImpressao[]{FormaUtilizacaoModeloImpressao.IMPRESSAO, FormaUtilizacaoModeloImpressao.IMPRESSAO_EMAIL}).stream().peek(m -> {
            Layout layout = this.buscarLayout(m.getId());
            m.setTipoImpressao(layout.getTipoImpressao());
        }).collect(Collectors.toList());
        PreferenciaUsuarioModeloImpressao preferencias = PreferenciaUsuarioModeloImpressaoRN.getInstance().buscarPorIdUsuarioTipoImpressao(tipoModelo, FormaUtilizacaoModeloImpressao.IMPRESSAO, SessaoUtil.getSessao().getUsuario().getId());
        return new ParametrosModeloImpressaoWrapper(modelos, preferencias);
    }

    @RequestMapping(value={"/layout"})
    @DBAutoCommit
    public Layout buscarLayout(@RequestParam Long idModelo) {
        return ModeloImpressaoRN.getInstance().carregaModelo(SessaoUtil.getSessao(), (ModeloImpressaoCabecalho)ModeloImpressaoCabecalhoRN.getInstance().buscarPorId(idModelo));
    }

    @RequestMapping(value={"/configuracoes-impressoras"})
    @DBAutoCommit
    public List<ConfiguracaoImpressora> buscaImpressoras(@RequestParam Long idModelo, @RequestParam TipoModelo tipoModelo) {
        ArrayList configuracoes = ConfiguracaoImpressoraRN.getInstance().buscarListaPorTipoModeloTipoImpressao(tipoModelo, this.buscarLayout(idModelo).getTipoImpressao());
        if (ListMapUtil.listNullOrEmpty((List)configuracoes)) {
            configuracoes = new ArrayList();
        }
        return configuracoes;
    }

    @RequestMapping(value={"/imprimir"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimir(@RequestBody ImpressaoWrapper impressaoWrapper, @RequestParam(required=false) Map<String, String> queryMap) throws UnicoMensagemUsuarioException {
        ModeloImpressaoCabecalho modeloImpressao = (ModeloImpressaoCabecalho)ModeloImpressaoCabecalhoRN.getInstance().buscarPorId(impressaoWrapper.getIdModelo());
        PreferenciaUsuarioModeloImpressaoRN.getInstance().gravarPreferencia(SessaoUtil.getSessao(), impressaoWrapper.getTipoModelo(), modeloImpressao.getFormaUtilizacao(), modeloImpressao.getId(), null);
        ArrayList<byte[]> list = new ArrayList<byte[]>();
        Sessao sessao = SessaoUtil.getSessao();
        if (TipoModelo.DUPLICATA.equals((Object)impressaoWrapper.getTipoModelo())) {
            ImpressaoDocumentoConfigurado impressaoDocumentoConfigurado = impressaoWrapper.getTipoModelo().getImpressaoDocumentoConfigurado(sessao);
            impressaoDocumentoConfigurado.setTrataImagemWeb((TrataImagemWeb)this);
            list.add(impressaoDocumentoConfigurado.imprimir(modeloImpressao, (TrataModeloIReportWeb)this.trataModeloIReportWeb, (Long[])impressaoWrapper.getId()).getMalote().extrai("pdf"));
        } else {
            for (Object id : (ImpressaoDocumentoConfigurado)impressaoWrapper.getId()) {
                ImpressaoDocumentoConfigurado impressaoDocumentoConfigurado = impressaoWrapper.getTipoModelo().getImpressaoDocumentoConfigurado(sessao);
                ArrayList<Map> listParametroPorMap = null;
                if (TipoModelo.RECIBO_PAGAMENTO.equals((Object)impressaoWrapper.getTipoModelo()) && queryMap.containsKey("idLancamento") && NumberUtil.longNullOuZero((Long)id)) {
                    impressaoDocumentoConfigurado = new ImpressaoReciboPagamentoSemEvento(sessao);
                    id = Long.parseLong(queryMap.get("idLancamento"));
                    listParametroPorMap = new ArrayList<Map>();
                    Map result = ContaCorrenteLancamentoRN.getInstance().mapImpressaoReciboSemEvento((Long)id, sessao.getIdFilial());
                    listParametroPorMap.add(result);
                }
                impressaoDocumentoConfigurado.setTrataImagemWeb((TrataImagemWeb)this);
                list.add(impressaoDocumentoConfigurado.imprimir(modeloImpressao, listParametroPorMap, (TrataModeloIReportWeb)this.trataModeloIReportWeb, new Long[]{id}).getMalote().extrai("pdf"));
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Util.concatPDFsSimplificado(list, (OutputStream)baos);
        return this.responseEntityService.createPDFResponse(baos.toByteArray());
    }

    @RequestMapping(value={"/imprimir-nao-fiscal"}, method={RequestMethod.POST})
    @DBAutoCommit
    public String impressaoNaoFiscal(@RequestBody ImpressaoWrapper impressaoWrapper) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        byte[] impressao = null;
        ModeloImpressaoCabecalho modeloImpressao = (ModeloImpressaoCabecalho)ModeloImpressaoCabecalhoRN.getInstance().buscarPorId(impressaoWrapper.getIdModelo());
        ImpressaoDocumentoConfigurado impressaoDocumentoConfigurado = impressaoWrapper.getTipoModelo().getImpressaoDocumentoConfigurado(SessaoUtil.getSessao());
        PreferenciaUsuarioModeloImpressaoRN.getInstance().gravarPreferencia(SessaoUtil.getSessao(), impressaoWrapper.getTipoModelo(), modeloImpressao.getFormaUtilizacao(), modeloImpressao.getId(), null, impressaoWrapper.getImpressora());
        if (impressaoWrapper.getModeloNaoFiscal() != null) {
            ImpressoraNaoFiscal inf = ImpressoraNaoFiscalFactory.getImpressora((ModeloImpressoraNaoFiscal)impressaoWrapper.getModeloNaoFiscal());
            BigDecimal espacoEntreLinhas = impressaoWrapper.getEspacoEntreLinhas();
            if (!Util.bigDecimalNullOrZero((BigDecimal)espacoEntreLinhas)) {
                inf.setEspacamentoEntreLinhas(espacoEntreLinhas.doubleValue());
            }
            inf.setNaoCriarPrintService(true);
            inf.setRemoveAcentos(impressaoWrapper.isRemoveAcento());
            inf.inicializa("", impressaoWrapper.getLinhas(), impressaoWrapper.getPagina(), true);
            inf.setCabecalho(ImpressaoDanfePDF.getCabecalhoPadrao((Filial)sessao.getFilial()));
            impressaoDocumentoConfigurado.setImpressoraNaoFiscal(inf);
            for (Long id : (Long[])impressaoWrapper.getId()) {
                impressaoDocumentoConfigurado.imprimir(modeloImpressao, (TrataModeloIReportWeb)this.trataModeloIReportWeb, new Long[]{id});
                inf.acionaGuilhotinha();
            }
            impressao = inf.getBytesImpressao();
        } else {
            ArrayList<byte[]> impressoes = new ArrayList<byte[]>();
            for (Long id : (Long[])impressaoWrapper.getId()) {
                Remessa remessa = impressaoDocumentoConfigurado.imprimir(modeloImpressao, (TrataModeloIReportWeb)this.trataModeloIReportWeb, new Long[]{id});
                impressoes.add(remessa.getMalote().extrai("matricial"));
            }
            impressao = Util.concatByteArrays(impressoes);
        }
        if (impressao != null) {
            return Base64.getEncoder().encodeToString(impressao);
        }
        return "";
    }

    @RequestMapping(value={"/comandos-impressao"})
    public List<ComandoImpressaoWrapper> getComandosImpressao(@RequestParam TipoImpressao tipoImpressao) {
        ArrayList<ComandoImpressaoWrapper> comandos = new ArrayList<ComandoImpressaoWrapper>();
        for (ComandoImpressao comandoImpressao : ComandoImpressao.values()) {
            for (TipoImpressao tipo : comandoImpressao.getTipoImpressao()) {
                if (!tipoImpressao.equals((Object)tipo)) continue;
                comandos.add(new ComandoImpressaoWrapper(comandoImpressao.getId(), comandoImpressao.getDescricao()));
            }
        }
        return comandos;
    }

    protected void beforeRead(ModeloImpressaoCabecalho modeloImpressaoCabecalho, int modo, Optional<Long> parentId) {
        String caminhoCompleto;
        Layout layout = ModeloImpressaoRN.getInstance().carregaModelo(SessaoUtil.getSessao(), this.modelo, modeloImpressaoCabecalho);
        modeloImpressaoCabecalho.setLayout(layout);
        modeloImpressaoCabecalho.setModelosImpressaoIReport(ModeloImpressaoIReportRN.getInstance().buscarRelatoriosPorModelo(modeloImpressaoCabecalho.getId()));
        if (7 == modo) {
            modeloImpressaoCabecalho.setId(null);
            modeloImpressaoCabecalho.setDescricao(null);
        }
        if (!StringUtil.stringNullOrEmpty((String)layout.getCaminhoLogo())) {
            caminhoCompleto = this.saveFile.publishImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), TipoImagem.TamanhoOriginal, layout.getCaminhoLogo());
            layout.setCaminhoLogo(caminhoCompleto);
        }
        if (!StringUtil.stringNullOrEmpty((String)layout.getCaminhoLogo2())) {
            caminhoCompleto = this.saveFile.publishImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), TipoImagem.TamanhoOriginal, layout.getCaminhoLogo2());
            layout.setCaminhoLogo2(caminhoCompleto);
        }
    }

    protected GridBuilder<ModeloImpressaoCabecalhoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("descricao", "Descri\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("formaUtilizacao", "Forma de utiliza\u00e7\u00e3o", 300, true));
        colunas.add(new ColunaSQL("modeloEmailPadrao", "Padr\u00e3o do modelo de email", 300, true));
        colunas.add(new ColunaSQL("idserie", "Id da s\u00e9rie do modelo", 200, false));
        GridBuilder gridBuilder = new GridBuilder(ModeloImpressaoCabecalhoRN.getInstance().getTabela(), colunas);
        if (this.modelo != null) {
            gridBuilder.addCodicaoDefault(new Condicao("idserie", Operador.IGUAL, this.modelo.getSerie()));
        }
        return gridBuilder;
    }

    protected void beforeSave(ModeloImpressaoCabecalho modeloImpressaoCabecalho, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        Layout layout = modeloImpressaoCabecalho.getLayout();
        if (layout == null) {
            layout = ModeloImpressaoRN.getInstance().carregaModelo(SessaoUtil.getSessao(), this.modelo, (ModeloImpressaoCabecalho)null);
            modeloImpressaoCabecalho.setLayout(layout);
        }
        if (TipoImpressao.IREPORT_CONFIGURADO.equals((Object)layout.getTipoImpressao())) {
            if (ListMapUtil.listNullOrEmpty((List)modeloImpressaoCabecalho.getModelosImpressaoIReport())) {
                throw new UnicoMensagemUsuarioException("COM279900", "Nenhum arquivo iReport foi informado. Verifique");
            }
            if (!NumberUtil.longNullOuZero((Long)modeloImpressaoCabecalho.getId()) && modeloImpressaoCabecalho.getModelosImpressaoIReport().stream().allMatch(m -> StringUtil.stringNullOrEmpty((String)m.getUrl()))) {
                modeloImpressaoCabecalho.setModelosImpressaoIReport(ModeloImpressaoIReportRN.getInstance().buscarRelatoriosPorModelo(modeloImpressaoCabecalho.getId()));
            }
        }
        if (!NumberUtil.longNullOuZero((Long)modeloImpressaoCabecalho.getId())) {
            String caminhoCompleto;
            Layout original = ModeloImpressaoRN.getInstance().carregaModelo(SessaoUtil.getSessao(), modeloImpressaoCabecalho);
            if (!StringUtil.stringNullOrEmpty((String)original.getCaminhoLogo())) {
                caminhoCompleto = this.saveFile.publishImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), TipoImagem.TamanhoOriginal, original.getCaminhoLogo());
                if (caminhoCompleto.equals(layout.getCaminhoLogo())) {
                    layout.setCaminhoLogo(original.getCaminhoLogo());
                } else if (this.saveFile.existObject(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, original.getCaminhoLogo(), false)) {
                    this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, original.getCaminhoLogo());
                }
            }
            if (!StringUtil.stringNullOrEmpty((String)original.getCaminhoLogo2())) {
                caminhoCompleto = this.saveFile.publishImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), TipoImagem.TamanhoOriginal, original.getCaminhoLogo2());
                if (caminhoCompleto.equals(layout.getCaminhoLogo2())) {
                    layout.setCaminhoLogo2(original.getCaminhoLogo2());
                } else if (this.saveFile.existObject(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, original.getCaminhoLogo2(), false)) {
                    this.saveFile.excluirImagem(ContextoHolder.getTenant(), TipoArquivoArmazenado.Usuario, original.getCaminhoLogo2());
                }
            }
        }
        modeloImpressaoCabecalho.setIdSerie(this.modelo.getSerie());
        modeloImpressaoCabecalho.getLayout().setIdSerie(this.modelo.getSerie());
    }

    protected String getCacheId() {
        return "modelos-impressao".concat("_").concat(this.modelo != null ? this.modelo.name() : "");
    }

    public void loadFile(MultipartFile[] files, ModeloImpressaoCabecalho modeloImpressaoCabecalho) throws UnicoMensagemUsuarioException {
        String url;
        ArrayList<MultipartFile> imagens = new ArrayList<MultipartFile>();
        ArrayList<MultipartFile> imagensIReport = new ArrayList<MultipartFile>();
        ArrayList<MultipartFile> arquivosIReport = new ArrayList<MultipartFile>();
        for (MultipartFile file : files) {
            String originalName = file.getOriginalFilename();
            if (StringUtil.stringNullOrEmpty((String)originalName)) continue;
            if (FileUtil.isExtensaoImagem((String)originalName)) {
                if (originalName.contains("imagem_ireport_uniplus_")) {
                    imagensIReport.add(file);
                    continue;
                }
                imagens.add(file);
                continue;
            }
            if (!originalName.endsWith("jrxml")) continue;
            arquivosIReport.add(file);
        }
        if (!arquivosIReport.isEmpty()) {
            List listaModeloImpressaoIReport = this.validarArquivoIReport(arquivosIReport);
            ArrayList<ModeloImpressaoIReport> relatorios = new ArrayList<ModeloImpressaoIReport>();
            for (ValidarIReportInterface.ArquivoIReport arquivoIReport : listaModeloImpressaoIReport) {
                url = this.getStorageService().saveFile(ContextoHolder.getTenant(), this.getTipoArmazenamento(), arquivoIReport.getFile(), false);
                ModeloImpressaoIReport modeloImpressaoIReport = new ModeloImpressaoIReport();
                modeloImpressaoIReport.setNome(Objects.requireNonNull(arquivoIReport.getFile().getOriginalFilename()).split("\\|")[1]);
                modeloImpressaoIReport.setParametro(arquivoIReport.getParametro());
                modeloImpressaoIReport.setTipo(arquivoIReport.getTipo());
                modeloImpressaoIReport.setUrl(url);
                relatorios.add(modeloImpressaoIReport);
            }
            if (!imagensIReport.isEmpty()) {
                for (MultipartFile arquivoImagem : imagensIReport) {
                    url = this.getStorageService().saveFile(ContextoHolder.getTenant(), this.getTipoArmazenamento(), arquivoImagem, false);
                    String nome = Objects.requireNonNull(arquivoImagem.getOriginalFilename()).split("\\|")[1];
                    ModeloImpressaoIReport modeloImpressaoIReportImagem = new ModeloImpressaoIReport();
                    modeloImpressaoIReportImagem.setNome(nome);
                    modeloImpressaoIReportImagem.setParametro(nome.substring(0, nome.indexOf(".")));
                    modeloImpressaoIReportImagem.setTipo(TipoRelatorioIReport.IMAGEM);
                    modeloImpressaoIReportImagem.setUrl(url);
                    relatorios.add(modeloImpressaoIReportImagem);
                }
            }
            modeloImpressaoCabecalho.setModelosImpressaoIReport(relatorios);
        } else if (ListMapUtil.listNullOrEmpty((List)modeloImpressaoCabecalho.getModelosImpressaoIReport()) && TipoImpressao.IREPORT_CONFIGURADO.equals((Object)modeloImpressaoCabecalho.getLayout().getTipoImpressao())) {
            throw new UnicoMensagemUsuarioException("COM279897", "Nenhum arquivo iReport foi informado. Verifique");
        }
        for (MultipartFile file : imagens) {
            Object[] split = Objects.requireNonNull(file.getOriginalFilename()).split("\\|");
            if (ListMapUtil.arrayNullOrEmpty((Object[])split)) continue;
            Object fieldName = split[0];
            url = this.getStorageService().saveImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), file, false);
            if (((String)fieldName).equals("logo")) {
                modeloImpressaoCabecalho.getLayout().setCaminhoLogo(url);
                continue;
            }
            modeloImpressaoCabecalho.getLayout().setCaminhoLogo2(url);
        }
    }

    public byte[] downloadImagem(String url) throws UnicoMensagemUsuarioException {
        File file = this.getStorageService().downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Produto, url, false, true);
        return FileUtil.file2ByteArray((File)file, (boolean)false);
    }

    public Image downloadLogo(String url) throws UnicoMensagemUsuarioException {
        File file = this.getStorageService().downloadFile(ContextoHolder.getTenant(), this.getTipoArmazenamento(), url, false, true);
        return Util.getImageFromFile((File)file);
    }

    public static byte[] addAll(byte[] array1, byte[] array2) {
        byte[] joinedArray = Arrays.copyOf(array1, array1.length + array2.length);
        System.arraycopy(array2, 0, joinedArray, array1.length, array2.length);
        return joinedArray;
    }

    @RequestMapping(value={"/exportar-ireport"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> exportarArquivosIReport(@RequestBody Long idModelo) throws UnicoMensagemUsuarioException {
        List relatorios = ModeloImpressaoIReportRN.getInstance().buscarRelatoriosPorModelo(idModelo);
        if (!ListMapUtil.listNullOrEmpty((List)relatorios)) {
            HashMap<String, byte[]> mapArquivos = new HashMap<String, byte[]>();
            for (ModeloImpressaoIReport relatorio : relatorios) {
                byte[] bArquivo = relatorio.getArquivo();
                if (!StringUtil.stringNullOrEmpty((String)relatorio.getUrl())) {
                    File file = this.getStorageService().downloadFile(ContextoHolder.getTenant(), this.getTipoArmazenamento(), relatorio.getUrl(), false, true);
                    bArquivo = FileUtil.file2ByteArray((File)file);
                }
                mapArquivos.put(relatorio.getNome(), bArquivo);
            }
            if (mapArquivos.size() > 1) {
                File file = FileUtil.montaZipFilePorByte(mapArquivos, (String)"Arquivos iReport");
                return this.responseEntityService.createZIPResponse(FileUtil.file2ByteArray((File)file), "Arquivos iReport");
            }
            return this.responseEntityService.createFileResponse((byte[])mapArquivos.values().toArray()[0], MediaType.APPLICATION_OCTET_STREAM, mapArquivos.keySet().toArray()[0].toString());
        }
        throw new UnicoMensagemUsuarioException("COM279901", "Nenhum arquivo iReport foi encontrado para o modelo de impress\u00e3o.");
    }
}

