/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.modeloimpressao;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.impressao.TrataModeloIReportWeb;
import br.intelidata.commons.domain.pojo.ModeloImpressaoIReport;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import java.io.File;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TrataModeloIReportWebImpl
implements TrataModeloIReportWeb {
    @Autowired
    private StorageService storageService;

    public JasperReport getJarperReport(ModeloImpressaoIReport modeloImpressaoIReport) throws UnicoMensagemUsuarioException {
        if (StringUtil.stringNullOrEmpty((String)modeloImpressaoIReport.getUrl())) {
            throw new UnicoMensagemUsuarioException("COM279898", "N\u00e3o foi poss\u00edvel encontrar a URL do modelo de impress\u00e3o iReport. Verifique.");
        }
        File file = this.storageService.downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Modelos_Impressao, modeloImpressaoIReport.getUrl(), false, true);
        try {
            return JasperCompileManager.compileReport((String)file.getPath());
        }
        catch (Throwable e) {
            throw new UnicoMensagemUsuarioException("COM279899", "Erro ao compilar o relat\u00f3rio! ", e);
        }
    }

    public File getImagem(ModeloImpressaoIReport modeloImpressaoIReport) throws UnicoMensagemUsuarioException {
        if (StringUtil.stringNullOrEmpty((String)modeloImpressaoIReport.getUrl())) {
            throw new UnicoMensagemUsuarioException("COM279910", "N\u00e3o foi poss\u00edvel encontrar a URL do imagem do modelo de impress\u00e3o iReport. Verifique.");
        }
        return this.storageService.downloadFile(ContextoHolder.getTenant(), TipoArquivoArmazenado.Modelos_Impressao, modeloImpressaoIReport.getUrl(), false, true);
    }
}

