/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.naturezaoperacao.cfopincentivofiscal;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.domain.pojo.CfopIncentivoFiscal;
import br.intelidata.commons.domain.pojo.enuns.CstICMS;
import br.intelidata.commons.domain.pojo.enuns.CstSNICMS;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.CfopIncentivoFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.Collections;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/cfops-incentivo-fiscal"})
public class CfopIncentivoFiscalCrudController
extends CrudController<CfopIncentivoFiscal, CfopIncentivoFiscalRN> {
    public CfopIncentivoFiscalCrudController() {
        super((AbstractRegraNegocio)CfopIncentivoFiscalRN.getInstance(), CfopIncentivoFiscal::new);
    }

    @RequestMapping(value={"/buscar"})
    @DBAutoCommit
    public List<CfopIncentivoFiscal> buscarLista(@RequestParam Long idNaturezaOperacao) {
        List CfopIncentivoFiscal2 = CfopIncentivoFiscalRN.getInstance().buscarPorIdNaturezaOperacao(idNaturezaOperacao);
        for (CfopIncentivoFiscal incentivoFiscal : CfopIncentivoFiscal2) {
            CstSNICMS cst;
            if (SessaoUtil.getSessao().getFilial().isSimplesNacional()) {
                cst = (CstSNICMS)EnumUtils.getPorId(CstSNICMS.class, (Object)incentivoFiscal.getSt());
                if (cst == null) continue;
                incentivoFiscal.setSt(cst.name());
                continue;
            }
            cst = (CstICMS)EnumUtils.getPorId(CstICMS.class, (Object)incentivoFiscal.getSt());
            if (cst == null) continue;
            incentivoFiscal.setSt(cst.name());
        }
        return CfopIncentivoFiscal2;
    }

    protected GridBuilder<CfopIncentivoFiscalRN> getGridBuilder() {
        return new GridBuilder(CfopIncentivoFiscalRN.getInstance().getTabela(), Collections.emptyList());
    }

    protected String getCacheId() {
        return "cfops-incentivo-fiscal";
    }
}

