/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.sat;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.sql.usql.ColunaCustomizavelGrid;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.modulo.pdv.dao.ColunaCustomizavelPagamentoNFCe;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.TabelaConfigurada;
import br.intelidata.uniplusweb.web.rest.app.crud.nfcesat.NfceSatCrudController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/sat"})
@SubMenuMapping(MENU="SubMenuPdvFiscal", NOME="Consulta CF-e", ROTA="/pdvs/sat", PROGRAMA=1000035, ICONE="icon icon-date")
public class SatCrudController
extends NfceSatCrudController {
    public SatCrudController(ResponseEntityService responseEntityService) {
        super(responseEntityService);
    }

    protected GridBuilder<OperacaoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id"));
        colunas.add(new ColunaSQL("filial"));
        colunas.add(new ColunaSQL("data", "data_filtro"));
        colunas.add(new ColunaSQL("modelonfce"));
        colunas.add(new ColunaSQL("satSerie", "S\u00e9rie SAT", 0, true));
        colunas.add(new ColunaSQL("numeroNfce", "N\u00famero", 0, true));
        colunas.add(new ColunaSQL("horaInicial", "Emiss\u00e3o", 0, true));
        colunas.add(new ColunaSQL("pdv", "Pdv", 0, true));
        colunas.add(new ColunaSQL("tipo", "Tipo opera\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("chaveAcessoNfce", "Chave de acesso", 0, true));
        colunas.add(new ColunaSQL("tipoAmbienteNfce", "Ambiente", 0, true));
        colunas.add(new ColunaSQL("statusNfce", "Status", 0, true));
        colunas.add(new ColunaSQL("tempoAutorizacao", "Tempo Aut.", 0, true));
        GridBuilder grid = new GridBuilder(OperacaoRN.getInstance().getTabela(), colunas, "operacaosat");
        grid.addCodicaoDefault(new Condicao("modelonfce", Operador.IGUAL, ModeloNotaFiscal.CUPOM_FISCAL_SAT.getId()));
        grid.addCodicaoDefault(new Condicao("filial", Operador.IGUAL, SessaoUtil.getSessao().getCodigoFilial()));
        grid.addOrdem(new Ordem("data_filtro", true));
        grid.addOrdem(new Ordem("satSerie", true));
        grid.addOrdem(new Ordem("numeroNfce", true));
        grid.addColunaCustomizavel((ColunaCustomizavelGrid)new ColunaCustomizavelPagamentoNFCe(SessaoUtil.getSessao()));
        return grid;
    }

    protected List<TabelaConfigurada> getTabelasConfiguracaoRelatorio() {
        return Arrays.asList(new TabelaConfigurada(OperacaoRN.getInstance().getTabela(), "operacao"), new TabelaConfigurada("vendas_itens_view", "Itens de venda"));
    }

    protected String getCacheId() {
        return "sat".concat("_").concat("_FILIAL=(").concat(SessaoUtil.getSessao().getCodigoFilial()).concat(")");
    }
}

