/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.documentosfiscais.sefaz.nfsenacional.enuns.JustificativaCancelamento;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.LicencaManager;
import br.intelidata.commons.core.licenca.Modulo;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.IFileStorage;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.CartaCorrecao;
import br.intelidata.commons.domain.pojo.ModeloNotaFiscal;
import br.intelidata.commons.domain.pojo.ProdutoDTOWeb;
import br.intelidata.commons.domain.pojo.ProdutoItemWeb;
import br.intelidata.commons.domain.pojo.enuns.StatusCartaCorrecao;
import br.intelidata.commons.domain.pojo.enuns.StatusNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoExcluir;
import br.intelidata.commons.domain.pojo.enuns.TipoEmissaoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoNotaFiscal;
import br.intelidata.commons.domain.pojo.enuns.TipoNotificacaoSimples;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscalItem;
import br.intelidata.commons.domain.pojo.notafiscal.StatusAtualizacaoNFe;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.nfe.NfeManagerWeb;
import br.intelidata.commons.modulo.notafiscal.nfse.NfseManagerWeb;
import br.intelidata.commons.modulo.notafiscal.regranegocio.CartaCorrecaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.service.TrabalhoImpressaoNFSeComponent;
import br.intelidata.uniplusweb.core.util.BeanUtil;
import br.intelidata.uniplusweb.core.util.FileUtil;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.ArquivoFiscalWeb;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoController;
import br.intelidata.uniplusweb.web.rest.app.calculoimposto.CalculoImpostoService;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.NotaFiscalAtualizacaoStatusWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.NotaFiscalTransmissaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.notafiscal.transmissao.inutilizacao.InutilizacaoWrapper;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

public abstract class TransmissaoNotaFiscalCrudController
extends CalculoImpostoController<NotaFiscal, NotaFiscalItem, NotaFiscalItem, NotaFiscalRN> {
    protected ArquivoFiscalWeb arquivoFiscal;

    public TransmissaoNotaFiscalCrudController(CalculoImpostoService<NotaFiscalItem> calculoImpostoService, ArquivoFiscalWeb arquivoFiscal) {
        super((AbstractRegraNegocio)NotaFiscalRN.getInstance(), calculoImpostoService, NotaFiscal::new);
        this.setItemSupplier(NotaFiscalItem::new);
        this.arquivoFiscal = arquivoFiscal;
    }

    @RequestMapping(value={"/atualizar-status"}, method={RequestMethod.POST})
    @DBTransaction
    public StatusAtualizacaoNFe atualizarStatusNfe(@RequestPart(value="wrapper") NotaFiscalAtualizacaoStatusWrapper wrapper, @RequestPart(value="file", required=false) MultipartFile file) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(wrapper.getIdNotaFiscal());
        if (notaFiscal != null && notaFiscal.getSerie().equalsIgnoreCase("55") && TipoEmissaoNotaFiscal.PROPRIA.equals((Object)notaFiscal.getTipoEmissao())) {
            NfeManagerWeb nfeManager = new NfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyNfeNow(mensagem));
            this.verificarValidadeCertificado(nfeManager);
            try {
                return nfeManager.atualizarStatusNfe(notaFiscal, wrapper.getChaveNFe(), file != null ? file.getBytes() : null, wrapper.getJustificativaCancelamento());
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("WNTF869", "N\u00e3o foi poss\u00edvel carregar o XML da NF-e.");
            }
        }
        throw new UnicoMensagemUsuarioException("WNTF701", "Op\u00e7\u00e3o habilitada apenas para notas como modelo 55 (Nf-e) e que foram emitidas pelo sistema");
    }

    @RequestMapping(value={"/transmitir-epec"}, method={RequestMethod.POST})
    @DBTransaction
    public void transmitirEpec(@RequestBody NotaFiscalTransmissaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        this.validarEPEC(wrapper);
        NfeManagerWeb nfeManager = new NfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyNfeNow(mensagem));
        this.verificarValidadeCertificado(nfeManager);
        nfeManager.transmitirNFeEpec((Long)wrapper.getIds().get(0), wrapper.getMotivoContingencia(), wrapper.getDataHoraContingencia());
    }

    @RequestMapping(value={"/verificar-inutilizar"}, method={RequestMethod.POST})
    @DBTransaction
    public String verificarInutilizarNumeracao(@RequestBody InutilizacaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(wrapper.getIdNotaFiscal());
        if (notaFiscal != null) {
            if (!notaFiscal.getSerie().equals(ModeloNotaFiscal.NOTA_FISCAL_ELETRONICA.getId()) || !notaFiscal.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.PROPRIA)) {
                throw new UnicoMensagemUsuarioException("WNTF8968", "Selecione uma nota fiscal modelo 55 de emiss\u00e3o pr\u00f3pria.");
            }
            if (!notaFiscal.getStatus().getTipoAcaoExcluirNotaFiscal().equals((Object)TipoAcaoExcluir.EXCLUIR)) {
                throw new UnicoMensagemUsuarioException("WNTF8969", "N\u00e3o \u00e9 poss\u00edvel inutilizar uma nota fiscal com status [" + notaFiscal.getStatus().getDescricao() + "].");
            }
            if (ModuloManager.getInstance().isAtivo(Modulo.EXPEDICAO) && notaFiscal.isNotaSaida()) {
                return NotaFiscalRN.getInstance().buscarNotasExpedicaoVinculadas(notaFiscal.getId());
            }
        }
        return null;
    }

    @RequestMapping(value={"/inutilizar"}, method={RequestMethod.POST})
    @DBTransaction
    public void inutilizarNumeracao(@RequestBody InutilizacaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(wrapper.getIdNotaFiscal());
        if (notaFiscal != null) {
            if (!notaFiscal.getSerie().equals(ModeloNotaFiscal.NOTA_FISCAL_ELETRONICA.getId()) || !notaFiscal.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.PROPRIA)) {
                throw new UnicoMensagemUsuarioException("WNTF8966", "Selecione uma nota fiscal modelo 55 de emiss\u00e3o pr\u00f3pria.");
            }
            if (!notaFiscal.getStatus().getTipoAcaoExcluirNotaFiscal().equals((Object)TipoAcaoExcluir.EXCLUIR)) {
                throw new UnicoMensagemUsuarioException("WNTF8967", "N\u00e3o \u00e9 poss\u00edvel inutilizar uma nota fiscal com status [" + notaFiscal.getStatus().getDescricao() + "].");
            }
        }
        NfeManagerWeb nfeManager = new NfeManagerWeb(SessaoUtil.getSessao(), null);
        this.verificarValidadeCertificado(nfeManager);
        nfeManager.inutilizarNumeracao(wrapper.getAno(), wrapper.getSerie(), wrapper.getNumeracaoInicial(), wrapper.getNumeracaoFinal(), wrapper.getJustificativa());
    }

    @RequestMapping(value={"/cancelar"})
    @DBTransaction
    public void cancelarNotaFiscal(@RequestParam Long idNotaFiscal, @RequestParam(required=false) String justificativa, @RequestParam(required=false) JustificativaCancelamento justificativaNfse) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)((NotaFiscalRN)this.rn).buscarPorId(idNotaFiscal);
        if (notaFiscal == null) {
            throw new UnicoMensagemUsuarioException("WWW258", "Nota fiscal selecionada n\u00e3o foi encontrada.");
        }
        if (NotaFiscalRN.getInstance().isNfe(idNotaFiscal)) {
            NfeManagerWeb nfeManager = new NfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyNfeNow(mensagem));
            this.verificarValidadeCertificado(nfeManager);
            nfeManager.cancelarNFe(notaFiscal, justificativa, true);
        } else if (NotaFiscalRN.getInstance().isNfse(idNotaFiscal)) {
            new NfseManagerWeb(SessaoUtil.getSessao(), (mensagem, pularLinha) -> this.notificationService.notifyNfeNow(mensagem), (IFileStorage)this.arquivoFiscal).cancelarNfse(idNotaFiscal, justificativa, justificativaNfse);
        } else {
            NotaFiscalRN.getInstance().cancelaNotaFiscal(SessaoUtil.getSessao(), notaFiscal.getId(), TipoAcaoExcluir.CANCELAR, true);
        }
    }

    @RequestMapping(value={"/possui-epec"})
    @DBAutoCommit
    public boolean possuiNotaComStatusEpec() {
        return NotaFiscalRN.getInstance().possuiNotaComStatusEpec();
    }

    @RequestMapping(value={"/download-xml"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> downloadXML(@RequestBody NotaFiscalTransmissaoWrapper wrapper, @RequestParam(defaultValue="false", required=false) boolean nfse) throws UnicoMensagemUsuarioException {
        HashMap<String, byte[]> mapArquivos = new HashMap<String, byte[]>();
        for (Long idNotaFiscal : wrapper.getIds()) {
            NotaFiscal notaFiscal = (NotaFiscal)((NotaFiscalRN)this.rn).buscarPorId(idNotaFiscal);
            if (notaFiscal == null) continue;
            NotaFiscalRN.getInstance().validarSePermiteSalvarXmlEmDisco(notaFiscal);
            if (nfse && !NotaFiscalRN.getInstance().isNfse(notaFiscal)) {
                throw new UnicoMensagemUsuarioException("NTF9497", "A nota fiscal " + notaFiscal.getNumeroNotaFiscal() + " n\u00e3o \u00e9 uma NFS-e v\u00e1lida. Verifique.");
            }
            if (!nfse && !NotaFiscalRN.getInstance().isNfe(notaFiscal)) {
                throw new UnicoMensagemUsuarioException("NTF9498", "A nota fiscal " + notaFiscal.getNumeroNotaFiscal() + " n\u00e3o \u00e9 uma NF-e v\u00e1lida. Verifique.");
            }
            if (notaFiscal.getArquivoXmlAutorizada() != null) {
                String numeroDocumento;
                String string = numeroDocumento = nfse ? notaFiscal.getNumeroNfse() : notaFiscal.getChaveNfe();
                if (Util.stringNullOrEmpty((String)numeroDocumento)) {
                    numeroDocumento = notaFiscal.getNumeroNotaFiscal();
                }
                String chaveAutorizada = nfse ? numeroDocumento.concat("-NFSe.xml") : numeroDocumento.concat("-procNFe.xml");
                mapArquivos.put(chaveAutorizada, notaFiscal.getArquivoXmlAutorizada());
                if (notaFiscal.getArquivoXmlCancelada() != null) {
                    String chaveCancelada = nfse ? numeroDocumento.concat("-NFSeCanc.xml") : numeroDocumento.concat("-canc.xml");
                    mapArquivos.put(chaveCancelada, notaFiscal.getArquivoXmlCancelada());
                }
                List cartaCorrecaos = CartaCorrecaoRN.getInstance().buscarListaPorIdNotaFiscal(notaFiscal.getId());
                for (CartaCorrecao cartaCorrecao : cartaCorrecaos) {
                    if (!cartaCorrecao.getStatus().equals((Object)StatusCartaCorrecao.AUTORIZADA)) continue;
                    String arquivo = notaFiscal.getChaveNfe().concat("-").concat(StringUtil.zeroEsquerda((String)String.valueOf(cartaCorrecao.getSequencia()), (int)3)).concat("-cce.xml");
                    mapArquivos.put(arquivo, cartaCorrecao.getArquivoTransmitido());
                }
                continue;
            }
            if (notaFiscal.getArquivoXmlNotaOriginal() == null) continue;
            mapArquivos.put(notaFiscal.getChaveNfe(), notaFiscal.getArquivoXmlNotaOriginal());
        }
        if (mapArquivos.isEmpty()) {
            throw new UnicoMensagemUsuarioException("WNTF722", "Nenhum arquivo xml foi encontrado.");
        }
        if (mapArquivos.size() == 1) {
            String chaveAutorizada = (String)mapArquivos.keySet().stream().findFirst().get();
            return this.responseEntityService.createXMLResponse((byte[])mapArquivos.get(chaveAutorizada), chaveAutorizada.replace(".xml", ""));
        }
        File file = FileUtil.montaZipFilePorByte(mapArquivos, (String)"Xmls das notas fiscais.zip");
        return this.responseEntityService.createZIPResponse(FileUtil.file2ByteArray((File)file), "Xmls das notas fiscais");
    }

    @RequestMapping(value={"/validar-xml-sefaz"})
    @DBAutoCommit
    public String validarXML(@RequestParam Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)((NotaFiscalRN)this.rn).buscarPorId(idNotaFiscal);
        if (notaFiscal != null && notaFiscal.getSerie().equalsIgnoreCase("55") && TipoEmissaoNotaFiscal.PROPRIA.equals((Object)notaFiscal.getTipoEmissao())) {
            return new NfeManagerWeb(SessaoUtil.getSessao(), null).validarXML(SessaoUtil.getSessao(), notaFiscal);
        }
        throw new UnicoMensagemUsuarioException("WWNTF700", "Op\u00e7\u00e3o habilitada apenas para notas com o modelo 55 (Nf-e) e que foram emitidas pelo sistema.");
    }

    @RequestMapping(value={"/validar-carta-correcao"})
    @DBAutoCommit
    public boolean permiteEdicaoCartaCorrecaoNotaFiscal(@RequestParam Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        boolean podeAbrir = false;
        boolean somenteImportar = false;
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNotaFiscal);
        if (notaFiscal != null && notaFiscal.getSerie().equalsIgnoreCase("55")) {
            if (notaFiscal.getTipoDocumento().equals((Object)TipoNotaFiscal.SAIDA)) {
                if (notaFiscal.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.PROPRIA)) {
                    podeAbrir = notaFiscal.getStatus().equals((Object)StatusNotaFiscal.NFE_AUTORIZADA);
                }
            } else if (notaFiscal.getTipoDocumento().equals((Object)TipoNotaFiscal.ENTRADA)) {
                boolean bl = podeAbrir = !StringUtil.stringNullOrEmpty((String)notaFiscal.getChaveNfe());
                if (notaFiscal.getTipoEmissao().equals((Object)TipoEmissaoNotaFiscal.TERCEIROS)) {
                    somenteImportar = true;
                }
            }
        }
        if (!podeAbrir) {
            throw new UnicoMensagemUsuarioException("WNTF721", "Voc\u00ea n\u00e3o pode emitir uma carta de corre\u00e7\u00e3o para essa nota fiscal.");
        }
        return somenteImportar;
    }

    @RequestMapping(value={"/atualizar-status-nfse"})
    @DBTransaction
    public void atualizarStatusNFSe(@RequestParam List<Long> ids) throws UnicoMensagemUsuarioException {
        new NfseManagerWeb(SessaoUtil.getSessao(), (mensagem, pularLinha) -> this.notificationService.notifyNfeNow(mensagem), (IFileStorage)this.arquivoFiscal).atualizaStatusNfse(ids);
    }

    @RequestMapping(value={"/imprimir-nfse"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> imprimirNFSe(@RequestBody Long idNotaFiscal) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)((NotaFiscalRN)this.rn).buscarPorId(idNotaFiscal);
        if (notaFiscal != null) {
            if (!NotaFiscalRN.getInstance().isNfse(notaFiscal)) {
                throw new UnicoMensagemUsuarioException("WWW279", "A nota fiscal selecionada n\u00e3o \u00e9 uma NFS-e v\u00e1lida! Verifique.");
            }
            TrabalhoImpressaoNFSeComponent trabalhoImpressao = (TrabalhoImpressaoNFSeComponent)BeanUtil.getBean((String)"trabalhoImpressaoNFSeComponent");
            return trabalhoImpressao.imprimirDanfe(notaFiscal, this.arquivoFiscal);
        }
        throw new UnicoMensagemUsuarioException("WWW280", "N\u00e3o foram selecionadas notas fiscais para a impress\u00e3o! Verifique.");
    }

    @RequestMapping(value={"/processar-retorno-nfse"}, method={RequestMethod.POST})
    @DBTransaction
    public void processaRetornoLoteNfse(@RequestPart(value="file", required=false) MultipartFile xml) throws UnicoMensagemUsuarioException {
        try {
            new NfseManagerWeb(SessaoUtil.getSessao(), (mensagem, pularLinha) -> this.notificationService.notifyNfeNow(mensagem), (IFileStorage)this.arquivoFiscal).processaRetornoLoteNfse(xml.getBytes());
        }
        catch (IOException e) {
            throw new UnicoMensagemUsuarioException("WWW281", "N\u00e3o foi poss\u00edvel processar o arquivo informado.");
        }
    }

    @RequestMapping(value={"/importar-aidf"}, method={RequestMethod.POST})
    @DBTransaction
    public void importarAIDF(@RequestPart(value="file", required=false) MultipartFile aidf) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        List arquivoAidf = FileUtil.convertToLines((MultipartFile)aidf);
        new NfseManagerWeb(sessao, (mensagem, pularLinha) -> this.notificationService.notifyNfeNow(mensagem), (IFileStorage)this.arquivoFiscal).importarAIDFNotas(sessao, arquivoAidf);
    }

    @RequestMapping(value={"/inutilizar-nfse"})
    @DBTransaction
    public void inutilizarNumeracaoNfse(@RequestParam String numero, @RequestParam String serie, @RequestParam String modelo) throws UnicoMensagemUsuarioException {
        new NfseManagerWeb(SessaoUtil.getSessao(), null, (IFileStorage)this.arquivoFiscal).inutilizarNumeracao(modelo, serie, numero, numero);
    }

    void transmitirNotas(NotaFiscalTransmissaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        if (ListMapUtil.listNullOrEmpty((List)wrapper.getIds())) {
            throw new UnicoMensagemUsuarioException("WWW254", "Por favor informe as notas fiscais.");
        }
        Map nota = NotaFiscalRN.getInstance().buscarValoresPorID((Long)wrapper.getIds().get(0), new String[]{"serie"});
        boolean isNFe = ((String)nota.get("serie")).equalsIgnoreCase("55");
        this.validarNotas(wrapper.getIds(), isNFe);
        if (isNFe) {
            NfeManagerWeb nfeManager = new NfeManagerWeb(SessaoUtil.getSessao(), (mensagem, processo) -> this.notificationService.notifyNfeNow(mensagem));
            this.verificarValidadeCertificado(nfeManager);
            nfeManager.processarNfe(wrapper.getIds());
        } else {
            if (!LicencaManager.getInstance().isNfse()) {
                throw new UnicoMensagemUsuarioException("WWW747", "N\u00e3o \u00e9 poss\u00edvel transmitir NFS-e sem a respectiva licen\u00e7a.");
            }
            new NfseManagerWeb(SessaoUtil.getSessao(), (mensagem, pularLinha) -> this.notificationService.notifyNfeNow(mensagem), (IFileStorage)this.arquivoFiscal).processaNfse(wrapper.getIds());
        }
    }

    void validarNotas(List<Long> ids, boolean isNFe) throws UnicoMensagemUsuarioException {
        for (Long idNota : ids) {
            Map nota = NotaFiscalRN.getInstance().buscarValoresPorID(idNota, new String[]{"serie", "idSerie"});
            boolean _isNFe = ((String)nota.get("serie")).equalsIgnoreCase("55");
            boolean _isNFSe = NotaFiscalRN.getInstance().isNfse((Long)nota.get("idSerie"), (String)nota.get("serie"));
            if (isNFe) {
                if (_isNFe && !_isNFSe && NotaFiscalRN.getInstance().isPermiteGeracaoNFeWeb(idNota)) continue;
                throw new UnicoMensagemUsuarioException("WNTF976", "Selecione apenas NF-es v\u00e1lidas para transmiss\u00e3o.");
            }
            if (_isNFSe && !_isNFe && NotaFiscalRN.getInstance().isPermiteGeracaoNFeWeb(idNota)) continue;
            throw new UnicoMensagemUsuarioException("WNTF9097", "Selecione apenas NFS-es v\u00e1lidas para transmiss\u00e3o.");
        }
    }

    String validarEPEC(NotaFiscalTransmissaoWrapper wrapper) throws UnicoMensagemUsuarioException {
        NotaFiscal notaFiscal = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId((Long)wrapper.getIds().get(0));
        if (notaFiscal == null || !NotaFiscalRN.getInstance().permiteTransmissaoEpec(notaFiscal)) {
            throw new UnicoMensagemUsuarioException("WWW255", "Op\u00e7\u00e3o habilitada apenas para notas como modelo 55 (Nf-e) e que foram emitidas pelo sistema.");
        }
        if (StringUtil.stringNullOrEmpty((String)wrapper.getMotivoContingencia())) {
            throw new UnicoMensagemUsuarioException("WWW256", "Motivo n\u00e3o informado.");
        }
        if (wrapper.getDataHoraContingencia() == null) {
            throw new UnicoMensagemUsuarioException("WWW257", "Data/hora de conting\u00eancia n\u00e3o informada.");
        }
        return notaFiscal.getNumeroNotaFiscal();
    }

    void verificarValidadeCertificado(NfeManagerWeb nfeManager) throws UnicoMensagemUsuarioException {
        String mensagemCertificado = nfeManager.getValidadeCertificado();
        if (!StringUtil.stringNullOrEmpty((String)mensagemCertificado)) {
            this.notificationService.simpleNotifyUserTenantNow(ContextoHolder.getTenant(), SessaoUtil.getSessao().getIdUsuario(), TipoNotificacaoSimples.WARNING, mensagemCertificado);
        }
    }

    public ProdutoItemWeb<NotaFiscalItem> carregarDadosItem(ProdutoDTOWeb produto, MultiValueMap<String, String> parametros) throws UnicoMensagemUsuarioException {
        return null;
    }
}

