/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.parametrosnfse;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Cidade;
import br.intelidata.commons.domain.pojo.Estado;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.domain.pojo.batch.Task;
import br.intelidata.commons.domain.regranegocio.CidadeCommonRN;
import br.intelidata.commons.domain.regranegocio.EstadoCommonRN;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.client.thread.AbstractPrepareJob;
import br.intelidata.uniplusweb.web.rest.app.client.thread.Notificacao;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.springframework.core.io.ClassPathResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class JobAtualizarCidadeTOM
extends AbstractPrepareJob {
    public JobAtualizarCidadeTOM(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public void onFailure(Exception ex) {
    }

    public void execute() throws Exception {
        List cidades = CidadeCommonRN.getInstance().buscarLista();
        for (Cidade cidade : cidades) {
            Estado estado;
            if (cidade.getCodigoTOM() != null && !cidade.getCodigoTOM().trim().equals("") || (estado = (Estado)EstadoCommonRN.getInstance().buscarPorId(cidade.getIdEstado())) == null || estado.getCodigo().equals("EX")) continue;
            String nomeArquivo = StringUtil.fileSeparator + "tom" + StringUtil.fileSeparator + estado.getCodigo() + ".csv";
            try {
                String linha;
                InputStream stream = new ClassPathResource(nomeArquivo).getInputStream();
                InputStreamReader streamReader = new InputStreamReader(stream, StandardCharsets.UTF_8);
                BufferedReader reader = new BufferedReader(streamReader);
                while ((linha = reader.readLine()) != null) {
                    String nomeCidadeArquivo;
                    String nomeCidade;
                    String[] string;
                    if (!linha.contains(";") || (string = linha.split(";")).length < 2 || !(nomeCidade = StringUtil.removerAcentos((String)cidade.getNome())).equalsIgnoreCase(nomeCidadeArquivo = StringUtil.removerAcentos((String)string[0]))) continue;
                    String codigoTom = JobAtualizarCidadeTOM.validaCodigoTom((String)string[1]);
                    cidade.setCodigoTOM(codigoTom);
                    CidadeCommonRN.getInstance().alterar((AbstractPojo)cidade, this.getSessao());
                    break;
                }
                reader.close();
                streamReader.close();
                stream.close();
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("COM236630", "N\u00e3o foi poss\u00edvel ler o arquivo " + nomeArquivo);
            }
        }
        this.addMensagemRetorno("Atualiza\u00e7\u00e3o de cidades conclu\u00edda.");
    }

    private static String validaCodigoTom(String tom) {
        StringBuilder codigoTom = new StringBuilder();
        if (tom != null) {
            for (int i = 0; i < tom.length(); ++i) {
                if (!"1234567890".contains(tom.substring(i, i + 1))) continue;
                codigoTom.append(tom, i, i + 1);
            }
        }
        return StringUtil.zeroEsquerda((String)codigoTom.toString(), (int)4);
    }

    protected Notificacao getNotificacaoSucesso(Task task) {
        return new Notificacao("Atualiza\u00e7\u00e3o de cidades conclu\u00edda.");
    }

    protected Notificacao getNotificacaoErro(Task task) {
        return new Notificacao("Falhou ao atualizar cidades");
    }
}

