/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.patchs;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Contexto;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.DataHoraFactory;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.core.uviewer.SaidaRelatorio;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.CartaCorrecao;
import br.intelidata.commons.domain.pojo.Operacao;
import br.intelidata.commons.domain.pojo.SimpleController;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoAcaoExcluir;
import br.intelidata.commons.domain.pojo.enuns.TipoAmbienteNfe;
import br.intelidata.commons.domain.pojo.enuns.TipoImagem;
import br.intelidata.commons.domain.pojo.enuns.TipoPessoa;
import br.intelidata.commons.domain.pojo.notafiscal.NotaFiscal;
import br.intelidata.commons.domain.pojo.pafecf.InutilizacaoNfce;
import br.intelidata.commons.domain.regranegocio.ConfiguradorModuloFuncionalidadeBackupRNSimplificada;
import br.intelidata.commons.domain.regranegocio.EntidadeCommonRN;
import br.intelidata.commons.domain.regranegocio.NaturezaOperacaoCommonRN;
import br.intelidata.commons.domain.regranegocio.NotaFiscalCommonRN;
import br.intelidata.commons.modulo.c3po.ecommerce.patches.CorrigirTransacaoFinanceiraSemPedido;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.ecommerce.patchs.VerificaInconsistenciaProdutoNuvemShop;
import br.intelidata.commons.modulo.estoque.patches.VerificaProdutoComGradeExcluida;
import br.intelidata.commons.modulo.notafiscal.regranegocio.CartaCorrecaoRN;
import br.intelidata.commons.modulo.notafiscal.regranegocio.NotaFiscalRN;
import br.intelidata.commons.modulo.pdv.regranegocio.InutilizacaoNfceRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoNfceRN;
import br.intelidata.commons.modulo.pdv.regranegocio.OperacaoRN;
import br.intelidata.commons.modulo.pdv.regranegocio.ReprocessaOperacao;
import br.intelidata.commons.modulo.preco.patches.AtualizarPercentualLucroMarkupProdutoPauta;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.RelatorioUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.print.SaidaImpressaoWrapper;
import br.intelidata.uniplusweb.web.rest.app.crud.patchs.PatchSimpleController;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.time.LocalDate;
import java.util.List;
import javax.imageio.ImageIO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import unipaf.processa.ProcessaCancelamento;

@RestController
@RequestMapping(value={"/api/patch"})
@SubMenuMapping(MENU="SubMenuFerramentasAuxiliar", NOME="Patchs / Arquivo Morto", ICONE="icon-imprimir", ROTA="/ferramentas/patch", PROGRAMA=551)
public class PatchSimpleController
extends SimpleController {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ResponseEntityService responseService;
    private final TaskManager taskManager;
    private final StorageService storageService;

    public PatchSimpleController(ResponseEntityService responseService, TaskManager taskManager, StorageService storageService) {
        this.responseService = responseService;
        this.taskManager = taskManager;
        this.storageService = storageService;
    }

    @RequestMapping(value={"/corrige-saldo-estoque"})
    @DBTransaction
    public void corrigirSaldoEstoque(@RequestParam(required=false, defaultValue="0") Long idProduto) throws UnicoMensagemUsuarioException {
        1 createTask = new /* Unavailable Anonymous Inner Class!! */;
        String resumo = NumberUtil.longNullOuZero((Long)idProduto) ? "" : "Patch executado para o produto id " + idProduto;
        createTask.createTask((Object)idProduto, null, resumo, true);
    }

    @RequestMapping(value={"/limpar-estoque"})
    @DBTransaction
    public void limparEstoque(@RequestParam(required=false) List<Long> idsFilial, @RequestParam Long idLocalEstoque, @RequestParam String data) throws UnicoMensagemUsuarioException {
        LocalDate dataEstoque = DataHoraFactory.string2LocalDate((String)data, (String)"dd/MM/yyyy");
        List filiais = FilialRN.getInstance().buscarListaPorIds(idsFilial);
        ProdutoRN.getInstance().limparEstoqueAnteriorAData(SessaoUtil.getSessao(), dataEstoque, filiais, idLocalEstoque);
    }

    @RequestMapping(value={"/popular-produto-empresa"})
    @DBTransaction
    public void popularProdutoEmpresa() throws UnicoMensagemUsuarioException {
        2 createTask = new /* Unavailable Anonymous Inner Class!! */;
        createTask.createTask((Object)"");
    }

    @PostMapping(value={"/reprocessar-operacoes"})
    @DBTransaction
    public ResponseEntity<byte[]> reprocessarOperacoes(@RequestParam String dataInicial, @RequestParam String dataFinal) throws UnicoMensagemUsuarioException {
        LocalDate objDataFinal;
        LocalDate objDataInicial = DataHoraFactory.string2LocalDate((String)dataInicial, (String)"dd/MM/yyyy");
        ReprocessaOperacao rotina = new ReprocessaOperacao(objDataInicial, objDataFinal = DataHoraFactory.string2LocalDate((String)dataFinal, (String)"dd/MM/yyyy"));
        Remessa remessa = rotina.reprocessar();
        if (remessa != null) {
            return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio)br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio.ARQUIVO_TEXTO_FORMATADO, (String)"Erros ao reprocessar opera\u00e7\u00f5es");
        }
        return null;
    }

    @GetMapping(value={"/corrigir-transacao-financeira-sem-pedido"})
    @DBTransaction
    public void corrigirTransacaoFinanceira() throws UnicoMensagemUsuarioException {
        CorrigirTransacaoFinanceiraSemPedido.getInstance().aplicarWeb(SessaoUtil.getSessao());
    }

    @GetMapping(value={"/redimencionar-icone-gourmet"})
    @DBAutoCommit
    public void redimencionarImagensUnichef() throws UnicoMensagemUsuarioException {
        List caminhos = ProdutoRN.getInstance().buscarImagemIconeWeb();
        for (String caminho : caminhos) {
            try {
                BufferedImage image = ImageIO.read(new File(caminho));
                this.storageService.resizeImage(image, caminho, TipoImagem.Icone_Gourmet);
            }
            catch (IOException ignored) {
                this.log.error("N\u00e3o foi poss\u00edvel redimencionar a image " + caminho);
            }
        }
    }

    @GetMapping(value={"/buscar-notas-exclusao"})
    @DBAutoCommit
    public List<NotaFiscal> buscarNotasHomologacao(@RequestParam LocalDate inicio, @RequestParam LocalDate fim) {
        List notas = NotaFiscalCommonRN.getInstance().buscarNotasParaExclusaoPatch(SessaoUtil.getSessao(), inicio, fim);
        notas.forEach(nota -> {
            nota.setCodigoCfop((String)NaturezaOperacaoCommonRN.getInstance().buscarValorPorID(nota.getIdCfop(), "codigo"));
            TipoPessoa tipoPessoa = (TipoPessoa)EnumUtils.getPorId(TipoPessoa.class, (Object)EntidadeCommonRN.getInstance().buscarValorPorID(nota.getIdEntidade(), "tipoPessoa"));
            nota.setTipoPessoa(tipoPessoa.name());
        });
        return notas;
    }

    @GetMapping(value={"/excluir-notas-homologacao"})
    @DBTransaction
    public void excluirNotasHomologacao(@RequestParam List<Long> ids) throws UnicoMensagemUsuarioException {
        for (Long idNota : ids) {
            NotaFiscal nota = (NotaFiscal)NotaFiscalRN.getInstance().buscarPorId(idNota);
            if (nota.isPossuiCartaCorrecao() && nota.getTipoAmbienteNfe().equals(TipoAmbienteNfe.HOMOLOGACAO.getId())) {
                for (CartaCorrecao carta : CartaCorrecaoRN.getInstance().buscarListaPorIdNotaFiscal(idNota)) {
                    CartaCorrecaoRN.getInstance().excluir((AbstractPojo)carta, Contexto.getInstance().getSessao());
                }
            }
            NotaFiscalRN.getInstance().cancelaNotaFiscal(Contexto.getInstance().getSessao(), idNota, TipoAcaoExcluir.EXCLUIR, true);
        }
    }

    @GetMapping(value={"/buscar-operacao-exclusao"})
    @DBAutoCommit
    public List<Operacao> buscarOperacaoHomologacao(@RequestParam LocalDate inicio, @RequestParam LocalDate fim) {
        return OperacaoNfceRN.getInstance().buscarOperacaoParaExclusaoPatch(SessaoUtil.getSessao(), inicio, fim, TipoAmbienteNfe.HOMOLOGACAO, null);
    }

    @GetMapping(value={"/excluir-operacao-homologacao"})
    @DBTransaction
    public void excluirOperacaoHomologacao(@RequestParam List<Long> ids) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        for (Long idOperacao : ids) {
            Operacao operacao = OperacaoRN.getInstance().buscarOperacaoCompletaPorId(idOperacao);
            if (operacao == null) continue;
            operacao.setCanceladoData(DataHoraFactory.getDataHora());
            operacao.setCanceladoUsuario(operacao.getUsuario());
            new ProcessaCancelamento().processar(operacao);
            OperacaoRN.getInstance().excluir(operacao, sessao);
            InutilizacaoNfce inut = InutilizacaoNfceRN.getInstance().buscarPorNumero(operacao);
            if (inut == null) continue;
            InutilizacaoNfceRN.getInstance().excluir(inut, sessao);
        }
    }

    @RequestMapping(value={"/estado-anterior"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> estadoAnterior() throws UnicoMensagemUsuarioException {
        Remessa remessa = ConfiguradorModuloFuncionalidadeBackupRNSimplificada.getInstance().gerarRelatorio(SessaoUtil.getSessao());
        return this.responseService.createPDFResponse(remessa.getMalote().extrai("pdf"));
    }

    @RequestMapping(value={"/variacoes-excluidas"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> variacoesExcluidas() throws UnicoMensagemUsuarioException {
        VerificaProdutoComGradeExcluida verificaProdutoComGradeExcluida = new VerificaProdutoComGradeExcluida();
        verificaProdutoComGradeExcluida.aplicar(SessaoUtil.getSessao());
        Remessa remessa = verificaProdutoComGradeExcluida.getRelatorioProcesso();
        if (remessa != null) {
            return this.responseService.createPDFResponse(remessa.getMalote().extrai("pdf"));
        }
        return null;
    }

    @GetMapping(value={"/atualizar-percentuais-margem-markup-pautas"})
    @DBTransaction
    public void atualizarPercentualMargemMakup() throws UnicoMensagemUsuarioException {
        AtualizarPercentualLucroMarkupProdutoPauta.getInstance().aplicarWeb(SessaoUtil.getSessao());
    }

    @RequestMapping(value={"/validacao-ecommerce"}, method={RequestMethod.POST})
    @DBAutoCommit
    public ResponseEntity<byte[]> validaaoEcommerce(@RequestBody SaidaImpressaoWrapper saidaRelatorio) throws UnicoMensagemUsuarioException {
        VerificaInconsistenciaProdutoNuvemShop vericar = new VerificaInconsistenciaProdutoNuvemShop();
        SaidaRelatorio saida = new SaidaRelatorio(saidaRelatorio.getSaidaRelatorio().getSaida(), null);
        Remessa remessa = vericar.verificaInconsistencia(SessaoUtil.getSessao(), saida);
        if (remessa != null) {
            return RelatorioUtil.visualizar((Remessa)remessa, (ResponseEntityService)this.responseService, (br.intelidata.uniplusweb.web.rest.app.client.report.SaidaRelatorio)saidaRelatorio.getSaidaRelatorio(), (String)"Nuvem SHOP");
        }
        return null;
    }

    static /* synthetic */ TaskManager access$000(PatchSimpleController x0) {
        return x0.taskManager;
    }
}

