/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.produto.produtoecommerce;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ConfiguracaoEcommerce;
import br.intelidata.commons.domain.pojo.Produto;
import br.intelidata.commons.domain.pojo.ProdutoEcommerce;
import br.intelidata.commons.domain.pojo.ProdutoImagem;
import br.intelidata.commons.domain.pojo.enuns.TipoIntegracaoEcommerce;
import br.intelidata.commons.domain.regranegocio.CategoriaEcommerceRN;
import br.intelidata.commons.domain.regranegocio.CategoriaMercadoLivreCommonRN;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoEcommerceCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoAtributoCategoriaMercadoLivreCommonRN;
import br.intelidata.commons.domain.regranegocio.ProdutoEcommerceCommonRN;
import br.intelidata.commons.domain.regranegocio.UnicoIntegracaoEcommerceRN;
import br.intelidata.commons.domain.regranegocio.b2c.GrupoShopRN;
import br.intelidata.commons.modulo.c3po.ecommerce.obj.mercadolivre.produto.AtributoCategoriaMercadoLivre;
import br.intelidata.commons.modulo.c3po.ecommerce.regranegocio.geral.ConversorImagem;
import br.intelidata.commons.modulo.c3po.ecommerce.regranegocio.mercadolivre.ProcessarEcommerceMercadoLivre;
import br.intelidata.commons.modulo.produto.regranegocio.ProdutoRN;
import br.intelidata.commons.modulo.produto.regranegocio.UnidademedidaRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.util.NumberUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.produtoecommerce.ProdutoEcommerceCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.produto.produtoecommerce.ProdutoEcommerceWrapper;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/produto-ecommerce"})
public class ProdutoEcommerceCrudController
extends SimpleCrudController<Produto, ProdutoRN> {
    private final StorageService storageService;

    public ProdutoEcommerceCrudController(StorageService storageService) {
        this.storageService = storageService;
    }

    @DBAutoCommit
    public Produto get(Long parentId) throws UnicoMensagemUsuarioException {
        Produto produto = (Produto)ProdutoRN.getInstance().buscarPorId(parentId);
        produto.setCasasDecimaisUN(Integer.valueOf(UnidademedidaRN.getInstance().getCasasDecimais(produto.getIdUnidadeMedida())));
        produto.setListaProdutoEcommerce(ProdutoEcommerceCommonRN.getInstance().buscarListaPorProdutoComDados(SessaoUtil.getSessao(), produto.getId()));
        produto.setAtributosCategoriaMercadoLivre(ProdutoAtributoCategoriaMercadoLivreCommonRN.getInstance().buscarListaPorIdProduto(produto.getId()));
        produto.setPossuiGradeAntiga(ProdutoRN.getInstance().isPossuiGradeAntiga(produto.getId()));
        if (!NumberUtil.longNullOuZero((Long)produto.getId())) {
            List listaCategoriaEcommerce = CategoriaEcommerceRN.getInstance().buscarListaCategoriaPorProduto(produto.getId());
            listaCategoriaEcommerce.forEach(cat -> {
                String nomeGrupo = (String)GrupoShopRN.getInstance().buscarValorPorID(cat.getIdGrupoShop(), "nome");
                cat.setNomeGrupoShop(StringUtil.stringNullOrEmpty((String)nomeGrupo) ? "Categoria n\u00e3o registrada no sistema" : nomeGrupo);
            });
            produto.setListaCategoriaEcommerce(listaCategoriaEcommerce);
        }
        return produto;
    }

    @RequestMapping(method={RequestMethod.PUT})
    @DBTransaction
    public Long update(@RequestBody Produto produto) throws UnicoMensagemUsuarioException {
        List confsML = produto.getListaProdutoEcommerce().stream().filter(item -> TipoIntegracaoEcommerce.MERCADO_LIVRE.equals((Object)item.getTipoIntegracaoEcommerce())).map(item -> (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(item.getIdConfiguracaoEcommerce())).collect(Collectors.toList());
        if (!confsML.isEmpty() && !Util.longNullOuZero((Long)produto.getIdCategoriaMercadoLivre())) {
            for (ConfiguracaoEcommerce configuracaoEcommerce : confsML) {
                List atributos;
                if (configuracaoEcommerce == null || !configuracaoEcommerce.getTipoIntegracao().equals((Object)TipoIntegracaoEcommerce.MERCADO_LIVRE) || Util.listNullOrEmpty((List)(atributos = CategoriaMercadoLivreCommonRN.getInstance().buscarAtributosCategoria(SessaoUtil.getSessao(), produto.getIdCategoriaMercadoLivre(), null, produto.getId(), configuracaoEcommerce)))) continue;
                produto.setAtributosCategoriaMercadoLivreOriginal(atributos);
            }
        }
        if (!Util.listNullOrEmpty((List)produto.getAtributosCategoriaMercadoLivreOriginal())) {
            JSONArray json = JSONUtil.getJSONArray((Object)produto.getAtributosCategoriaMercadoLivreOriginal());
            produto.getListaProdutoEcommerce().forEach(item -> {
                ConfiguracaoEcommerce configuracaoEcommerce = (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(item.getIdConfiguracaoEcommerce());
                if (configuracaoEcommerce.getTipoIntegracao().equals((Object)TipoIntegracaoEcommerce.MERCADO_LIVRE)) {
                    item.setAtributosMercadoLivre(json.toString());
                }
            });
        }
        ProdutoRN.getInstance().gravarEcommerce(SessaoUtil.getSessao(), produto);
        return produto.getId();
    }

    @RequestMapping(value={"/validar-atributos-ml"})
    @DBAutoCommit
    public void validaAtributosMercadoLivre(@RequestBody ProdutoEcommerceWrapper wrapper) throws UnicoMensagemUsuarioException {
        List atributos;
        if (wrapper == null || wrapper.getProdutoEcommerce() == null || wrapper.getProduto() == null || Util.longNullOuZero((Long)wrapper.getProduto().getIdCategoriaMercadoLivre())) {
            return;
        }
        ProdutoEcommerce produtoEcommerce = wrapper.getProdutoEcommerce();
        ConfiguracaoEcommerce configuracaoEcommerce = (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(produtoEcommerce.getIdConfiguracaoEcommerce());
        Produto produto = wrapper.getProduto();
        if (configuracaoEcommerce != null && configuracaoEcommerce.getTipoIntegracao().equals((Object)TipoIntegracaoEcommerce.MERCADO_LIVRE) && !Util.listNullOrEmpty((List)(atributos = CategoriaMercadoLivreCommonRN.getInstance().buscarAtributosCategoria(SessaoUtil.getSessao(), produto.getIdCategoriaMercadoLivre(), null, produto.getId(), configuracaoEcommerce)))) {
            for (AtributoCategoriaMercadoLivre atributo : atributos) {
                if (!atributo.getTags().isRequired()) continue;
                boolean achou = false;
                if (!Util.listNullOrEmpty((List)produto.getAtributosCategoriaMercadoLivre())) {
                    achou = produto.getAtributosCategoriaMercadoLivre().stream().anyMatch(atr -> atr.getAtributo().equalsIgnoreCase(atributo.getId()) && !Util.stringNullOrEmpty((String)atr.getValor()));
                }
                if (achou) continue;
                throw new UnicoMensagemUsuarioException("WPRD315", "O atributo '" + atributo.getName() + "' deve ser informado.");
            }
        }
    }

    @RequestMapping(value={"/importar-imagens-ml"})
    @DBAutoCommit
    public List<ProdutoImagem> importarImagensMercadoLivre(@RequestParam Long idConfiguracaoEcommerce, @RequestParam Long idProduto, @RequestParam String codigoEcommerce) throws UnicoMensagemUsuarioException {
        1 conversorImagem = new /* Unavailable Anonymous Inner Class!! */;
        ProcessarEcommerceMercadoLivre processarEcommerce = new ProcessarEcommerceMercadoLivre();
        List listaImagem = processarEcommerce.consultaImagensAnuncio(SessaoUtil.getSessao(), codigoEcommerce, idConfiguracaoEcommerce);
        return processarEcommerce.downloadImagemMercadoLivre(idProduto, codigoEcommerce, listaImagem, (ConversorImagem)conversorImagem);
    }

    @RequestMapping(value={"/anuncio-possui-vendas"})
    @DBAutoCommit
    public boolean anuncioPossuiVendas(@RequestParam Long idConfiguracaoEcommerce, @RequestParam String codigoEcommerce) throws UnicoMensagemUsuarioException {
        ConfiguracaoEcommerce configuracaoEcommerce = (ConfiguracaoEcommerce)ConfiguracaoEcommerceCommonRN.getInstance().buscarPorId(idConfiguracaoEcommerce);
        if (configuracaoEcommerce != null && TipoIntegracaoEcommerce.MERCADO_LIVRE.equals((Object)configuracaoEcommerce.getTipoIntegracao())) {
            ProcessarEcommerceMercadoLivre processarEcommerceMercadoLivre = (ProcessarEcommerceMercadoLivre)UnicoIntegracaoEcommerceRN.getInstance((TipoIntegracaoEcommerce)TipoIntegracaoEcommerce.MERCADO_LIVRE).getProcessarEcommerce();
            return processarEcommerceMercadoLivre.isAnuncioPossuiVendas(SessaoUtil.getSessao(), configuracaoEcommerce, codigoEcommerce);
        }
        return false;
    }

    static /* synthetic */ StorageService access$000(ProdutoEcommerceCrudController x0) {
        return x0.storageService;
    }
}

