/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.propriedade;

import br.intelidata.commons.bridge.ContextoHolder;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.GridControler;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.licenca.ModuloManager;
import br.intelidata.commons.core.sistema.ItemComboBox;
import br.intelidata.commons.core.sistema.Propriedade;
import br.intelidata.commons.core.sistema.PropriedadeRN;
import br.intelidata.commons.core.sistema.Propriedades;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.sistema.UnicoCarregarComboboxListener;
import br.intelidata.commons.core.sistema.UnicoComboboxControler;
import br.intelidata.commons.core.util.UnicoCrypt;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Configuracao;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.AbstractEnum;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.PropriedadeTipo;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.domain.regranegocio.ConfiguracaoCommonRN;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.service.CacheService;
import br.intelidata.uniplusweb.core.service.ResponseEntityService;
import br.intelidata.uniplusweb.core.util.ListMapUtil;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.service.StorageService;
import br.intelidata.uniplusweb.web.enums.TipoArquivoArmazenado;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.propriedade.PropriedadeWrapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/propriedades"})
@SubMenuMapping(MENU="SubMenuFerramentasGeral", NOME="Prefer\u00eancias do sistema", ROTA="/cadastros/propriedades", PROGRAMA=502, ICONE="icon-preferencias")
public class PropriedadeSimpleController
extends SimpleCrudController<Configuracao, ConfiguracaoCommonRN> {
    private final CacheService cacheService;
    private final ResponseEntityService responseEntityService;
    private final StorageService storageService;

    @Autowired
    public PropriedadeSimpleController(CacheService cacheService, ResponseEntityService responseEntityService, StorageService storageService) {
        super((AbstractRegraNegocio)ConfiguracaoCommonRN.getInstance(), TipoArquivoArmazenado.Imagens_Preferencias);
        this.cacheService = cacheService;
        this.responseEntityService = responseEntityService;
        this.storageService = storageService;
    }

    @RequestMapping(value={"/listas"})
    @DBAutoCommit
    public Propriedades getPropriedades() throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        ModuloManager.getInstance().recarregarPreferencias(sessao);
        Propriedades propriedades = PropriedadeRN.getInstance().getPropriedadesEdicao(sessao);
        ArrayList arquivos = new ArrayList();
        propriedades.getListAtivo().removeIf(propriedade -> propriedade.getId() == 239);
        propriedades.getListAtivo().forEach(propriedade -> {
            Stream stream;
            String valorString = "";
            Configuracao configuracao = ConfiguracaoCommonRN.getInstance().buscarPorChave(propriedade.getId(), sessao.getIdFilial());
            if (configuracao != null) {
                valorString = configuracao.getValor();
            } else if (!(propriedade.getValorDefault() instanceof Class) && !(propriedade.getValorDefault() instanceof String[]) && propriedade.getValorDefault() != null) {
                valorString = propriedade.getValorDefault().toString();
            }
            if (propriedade.getPropriedadeTipo().in(new AbstractEnum[]{PropriedadeTipo.COMBO})) {
                if (propriedade.getValorDefault() instanceof String[]) {
                    String valorAtual = valorString;
                    valorString = Stream.of((String[])propriedade.getValorDefault()).filter(item -> item.substring(0, item.indexOf(";")).equalsIgnoreCase(valorAtual)).findFirst().map(item -> item.substring(item.indexOf(";") + 1)).orElseGet(String::new);
                    propriedade.setValorDefaultWeb((Object)String.join((CharSequence)",", (String[])propriedade.getValorDefault()));
                } else {
                    AbstractEnum abstractEnum;
                    if (!StringUtil.stringNullOrEmpty((String)valorString) && (abstractEnum = propriedade.getTipo() != null && propriedade.getTipo().equals(Integer.class) ? EnumUtils.getPorId((Class)((Class)propriedade.getValorDefault()), (Object)StringUtil.string2int((String)valorString)) : EnumUtils.getPorId((Class)((Class)propriedade.getValorDefault()), (Object)valorString)) != null) {
                        valorString = abstractEnum.getDescricaoWeb();
                    }
                    stream = ((AbstractEnum)((Class)propriedade.getValorDefault()).getEnumConstants()[0]).getValoresWeb();
                    String[] valores = (String[])stream.map(e -> e.getId().toString().concat(";").concat(e.getDescricao())).toArray(String[]::new);
                    propriedade.setValorDefaultWeb((Object)valores);
                }
            } else if (propriedade.getPropriedadeTipo().in(new AbstractEnum[]{PropriedadeTipo.COMBO_MULTIPLA_SELECAO})) {
                stream = ((AbstractEnum)((Class)propriedade.getValorDefault()).getEnumConstants()[0]).getValoresWeb();
                String[] valores = (String[])stream.map(e -> e.getId().toString().concat(";").concat(e.getDescricao())).toArray(String[]::new);
                propriedade.setValorDefaultWeb((Object)valores);
                if (!StringUtil.stringNullOrEmpty((String)valorString)) {
                    List<String> ids = Arrays.asList(valorString.split(";"));
                    ArrayList<String> descricoes = new ArrayList<String>();
                    for (String s : valores) {
                        if (!ids.contains(s.substring(0, s.indexOf(";")))) continue;
                        descricoes.add(s.substring(s.indexOf(";") + 1));
                    }
                    valorString = String.join((CharSequence)",", descricoes);
                }
            } else if (!StringUtil.stringNullOrEmpty((String)valorString)) {
                GridControler gridControler;
                if (propriedade.getPropriedadeTipo().in(new AbstractEnum[]{PropriedadeTipo.COMBO_DINAMICO, PropriedadeTipo.COMBO_DINAMICO_WEB})) {
                    UnicoComboboxControler comboboxControler = null;
                    if (propriedade.getValorDefault() instanceof UnicoComboboxControler) {
                        comboboxControler = (UnicoComboboxControler)propriedade.getValorDefault();
                    } else if (propriedade.getValorDefault() instanceof UnicoCarregarComboboxListener) {
                        comboboxControler = ((UnicoCarregarComboboxListener)propriedade.getValorDefault()).getCombo();
                    }
                    if (comboboxControler != null) {
                        String valorAtual = valorString;
                        comboboxControler.recarregarValores();
                        ItemComboBox itemComboBox = comboboxControler.getValores().stream().filter(item -> item.getId().toString().equalsIgnoreCase(valorAtual)).findFirst().orElseGet(ItemComboBox::new);
                        valorString = itemComboBox.getDescricao() != null ? itemComboBox.getDescricao().toString() : "";
                    } else {
                        valorString = "";
                    }
                } else if (propriedade.getPropriedadeTipo().equals((Object)PropriedadeTipo.COMBO_TABLE) && (gridControler = (GridControler)propriedade.getValorDefault()) != null) {
                    List dados = gridControler.getDados2();
                    for (Object object : dados) {
                        if (!((Object[])object)[gridControler.getColunaValor()].toString().equalsIgnoreCase(valorString)) continue;
                        valorString = ((Object[])object)[gridControler.getColunaDescricao()].toString();
                    }
                }
            }
            if (propriedade.getPropriedadeTipo().in(new AbstractEnum[]{PropriedadeTipo.PERCENTUAL, PropriedadeTipo.VALOR, PropriedadeTipo.INTEIRO})) {
                try {
                    String valor = !StringUtil.stringNullOrEmpty((String)valorString) ? valorString : (!StringUtil.stringNullOrEmpty((String)((String)propriedade.getNovoValor())) ? (String)propriedade.getNovoValor() : "0");
                    propriedade.setNovoValor((Object)new BigDecimal(valor));
                }
                catch (NumberFormatException e2) {
                    propriedade.setNovoValor((Object)BigDecimal.ZERO);
                }
            }
            if (propriedade.getPropriedadeTipo().equals((Object)PropriedadeTipo.ARQUIVO) && propriedade.getId() != 48) {
                arquivos.add(propriedade);
            }
            propriedade.setDescricaoValor(valorString);
        });
        propriedades.setArquivos(arquivos);
        return propriedades;
    }

    @RequestMapping(value={"/gravar-propriedades"}, method={RequestMethod.POST})
    @DBTransaction
    public void gravarPropriedades(@RequestBody Propriedades propriedades) throws UnicoMensagemUsuarioException {
        Propriedade propriedadeBlocoX;
        Sessao sessao = SessaoUtil.getSessao();
        ModuloManager.getInstance().recarregarPreferencias(sessao);
        Optional<Propriedade> optionBlocoX = propriedades.getListAtivo().stream().filter(propriedade -> propriedade.getId() == 631).findFirst();
        if (optionBlocoX.isPresent() && !Boolean.parseBoolean((propriedadeBlocoX = optionBlocoX.get()).getNovoValor().toString()) && PropriedadeRN.getInstance().getPropriedadeBoolean(sessao.getFilial(), 631)) {
            String chave = (String)this.validarChaveInativacaoTransmissaoBlocoX(propriedadeBlocoX.getDescricaoValor()).getBody();
            propriedades.getList().stream().filter(p -> p.getId() == 633).findFirst().ifPresent(p -> p.setNovoValor((Object)chave));
        }
        AtomicBoolean apagarLogoFilial = new AtomicBoolean(false);
        propriedades.getListAtivo().forEach(propriedade -> {
            if (propriedade.getPropriedadeTipo().equals((Object)PropriedadeTipo.ARQUIVO)) {
                String caminhoAtual = PropriedadeRN.getInstance().getPropriedadeString(sessao.getFilial(), propriedade.getId());
                if (!StringUtil.stringNullOrEmpty((String)caminhoAtual) && !caminhoAtual.equals(propriedade.getNovoValor())) {
                    String servidor;
                    if (this.storageService.isFileServer() && !StringUtil.stringNullOrEmpty((String)(servidor = this.storageService.getServidorURL()))) {
                        caminhoAtual = caminhoAtual.replace(servidor, "");
                    }
                    this.storageService.excluirImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), caminhoAtual);
                }
                if (propriedade.getId() == 50 && StringUtil.stringNullOrEmpty((String)StringUtil.all2Atring((Object)propriedade.getNovoValor()))) {
                    apagarLogoFilial.set(true);
                }
            }
            propriedades.getList().stream().filter(p -> p.getId() == propriedade.getId()).findFirst().ifPresent(p -> p.setNovoValor(propriedade.getNovoValor()));
        });
        Filial filial = sessao.getFilial();
        if (apagarLogoFilial.get() && filial.getLogoFilial() != null) {
            filial.setLogoFilial(null);
            FilialRN.getInstance().alterar((AbstractPojo)filial, sessao);
        }
        PropriedadeRN.getInstance().setPropriedadesEdicaoWeb(sessao, propriedades);
        this.cacheService.clear();
    }

    @ResponseBody
    @RequestMapping(value={"/gravar-imagens"}, method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @DBTransaction
    public void gravarPropriedadesLogo(@RequestPart MultipartFile[] files, @RequestPart(value="propriedades") Propriedades propriedades) throws UnicoMensagemUsuarioException {
        Sessao sessao = SessaoUtil.getSessao();
        for (MultipartFile file : files) {
            Object[] split;
            String originalName = file.getOriginalFilename();
            if (StringUtil.stringNullOrEmpty((String)originalName) || ListMapUtil.arrayNullOrEmpty((Object[])(split = originalName.split("\\|")))) continue;
            try {
                Object idPreferencia = split[0];
                Propriedade propriedade = propriedades.getListAtivo().stream().filter(arg_0 -> PropriedadeSimpleController.lambda$gravarPropriedadesLogo$15((String)idPreferencia, arg_0)).findFirst().orElse(null);
                if (propriedade == null) continue;
                String caminho = this.saveFile.saveImagem(ContextoHolder.getTenant(), this.getTipoArmazenamento(), file, false);
                if (propriedade.getId() == 50) {
                    byte[] imagem = file.getBytes();
                    Filial filial = sessao.getFilial();
                    filial.setLogoFilial(imagem);
                    FilialRN.getInstance().alterar((AbstractPojo)filial, sessao);
                }
                propriedade.setNovoValor((Object)caminho);
            }
            catch (IOException e) {
                throw new UnicoMensagemUsuarioException("WWW566", "N\u00e3o foi poss\u00edvel atribuir os arquivos: " + e.getMessage());
            }
        }
        this.gravarPropriedades(propriedades);
    }

    @RequestMapping(value={"/validar-bloco-x"})
    @DBAutoCommit
    public ResponseEntity<String> validarChaveInativacaoTransmissaoBlocoX(@RequestParam String chave) throws UnicoMensagemUsuarioException {
        String novaChave = UnicoCrypt.decriptIfErroReturnNull((String)StringUtil.hexToString((String)chave));
        if (novaChave == null) {
            throw new UnicoMensagemUsuarioException("COM236181", "Chave inv\u00e1lida");
        }
        Filial filial = FilialRN.getInstance().buscarFilialPorCnpj(StringUtil.formataCpfCnpj((String)novaChave), null);
        if (filial == null) {
            throw new UnicoMensagemUsuarioException("COM236182", "N\u00e3o foi encontrado nenhuma filial com o CNPJ " + novaChave);
        }
        return this.responseEntityService.createJSONResponse(novaChave);
    }

    @RequestMapping(value={"/atualizar"}, method={RequestMethod.POST})
    @DBTransaction
    public void atualizarPreferencia(@RequestBody PropriedadeWrapper wrapper) throws UnicoMensagemUsuarioException {
        PropriedadeRN.getInstance().setPropriedade(SessaoUtil.getSessao(), wrapper.getId().intValue(), wrapper.getValue());
        this.cacheService.clear();
    }

    @GetMapping(value={"/valor-atualizado/{propriedade}"})
    @DBAutoCommit
    public Object getValorAtualizado(@PathVariable int propriedade) {
        return PropriedadeRN.getInstance().getPropriedade(SessaoUtil.getSessao().getIdFilial(), propriedade);
    }

    @RequestMapping(value={"/modo-calc-preco-venda/{idFilial}"})
    @DBAutoCommit
    public int getModoCalculoPrecoVenda(@PathVariable Long idFilial) {
        return PropriedadeRN.getInstance().getPropriedadeInt((Filial)FilialRN.getInstance().buscarPorId(idFilial), 203);
    }

    private static /* synthetic */ boolean lambda$gravarPropriedadesLogo$15(String idPreferencia, Propriedade p) {
        return p.getId() == Integer.parseInt(idPreferencia);
    }
}

