/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.sintegra;

import br.intelidata.api.batch.AbstractJob;
import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.JSONUtil;
import br.intelidata.commons.core.util.Util;
import br.intelidata.commons.domain.pojo.ConfiguracaoCampos;
import br.intelidata.commons.domain.pojo.Filial;
import br.intelidata.commons.domain.pojo.enuns.TipoJob;
import br.intelidata.commons.domain.pojo.fiscal.InventarioSintegra;
import br.intelidata.commons.domain.pojo.fiscal.InventarioSintegraItem;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.cadastros.regranegocio.ConfiguracaoCamposRN;
import br.intelidata.commons.modulo.custo.regranegocio.CustoMedioDiarioRN;
import br.intelidata.commons.sped.fiscal.TipoGeracaoInventario;
import br.intelidata.commons.sped.regranegocio.InventarioSintegraItemRN;
import br.intelidata.commons.sped.regranegocio.InventarioSintegraRN;
import br.intelidata.core.aop.DBAutoCommit;
import br.intelidata.core.aop.DBTransaction;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.util.StringUtil;
import br.intelidata.uniplusweb.web.rest.app.batch.TaskManager;
import br.intelidata.uniplusweb.web.rest.app.client.crud.ICreateTask;
import br.intelidata.uniplusweb.web.rest.app.client.crud.SimpleCrudController;
import br.intelidata.uniplusweb.web.rest.app.crud.sintegra.JobSintegra;
import br.intelidata.uniplusweb.web.rest.app.crud.sintegra.SintegraModel;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jobs/sintegra"})
@SubMenuMapping(MENU="SubMenuPainelContadorGeral", ICONE="icon-gravar", NOME="Sintegra", ROTA="/speds/sintegra", PROGRAMA=1103)
public class SintegraCrudController
extends SimpleCrudController<SintegraModel, ConfiguracaoCamposRN>
implements ICreateTask {
    private final TaskManager taskManager;
    private final String TABELA = "Sintegra";

    @Autowired
    public SintegraCrudController(TaskManager taskManager) {
        super((AbstractRegraNegocio)ConfiguracaoCamposRN.getInstance());
        this.taskManager = taskManager;
    }

    public TipoJob getTipoJob() {
        return TipoJob.SINTEGRA;
    }

    public Class<? extends AbstractJob> job() {
        return JobSintegra.class;
    }

    public TaskManager taskManager() {
        return this.taskManager;
    }

    @DBAutoCommit
    public SintegraModel get(Long parentId) {
        ConfiguracaoCampos configuracaoCampos = ConfiguracaoCamposRN.getInstance().buscarPorIdFilialTabela(SessaoUtil.getSessao().getIdFilial(), "Sintegra");
        if (configuracaoCampos != null) {
            SintegraModel sintegra = (SintegraModel)JSONUtil.getObject((JSONObject)configuracaoCampos.getCamposSerializados(), SintegraModel.class);
            sintegra.setIdsProduto(Collections.emptyList());
            return sintegra;
        }
        return new SintegraModel();
    }

    @RequestMapping(method={RequestMethod.POST})
    @DBTransaction
    public Long create(@RequestBody SintegraModel sintegra) throws UnicoMensagemUsuarioException {
        this.validarDados(sintegra);
        this.createTask((Object)sintegra, this.resumoFiltros(sintegra));
        Sessao sessao = SessaoUtil.getSessao();
        sintegra.setItens(null);
        sintegra.setDataInicio(null);
        sintegra.setDataFim(null);
        sintegra.setIdsProduto(Collections.emptyList());
        return ((ConfiguracaoCamposRN)this.getRegraNegocio()).gravarConfiguracaoPorFilial(sessao, (Object)sintegra, "Sintegra");
    }

    private void validarDados(SintegraModel sintegra) throws UnicoMensagemUsuarioException {
        if (sintegra != null) {
            ArrayList<Filial> filial = new ArrayList<Filial>(Collections.singletonList(SessaoUtil.getSessao().getFilial()));
            if (sintegra.getItens() != null && sintegra.getItens().size() > 0) {
                sintegra.setIdsProduto(sintegra.getItens().stream().map(InventarioSintegraItem::getId).collect(Collectors.toList()));
            }
            if (sintegra.getTipoGeracaoInventario().equals((Object)TipoGeracaoInventario.CADASTRO)) {
                List listaInventarios = InventarioSintegraRN.getInstance().buscaListaPorPeriodo(sintegra.getDataInicio(), SessaoUtil.getSessao().getFilial().getId());
                if (Util.listNullOrEmpty((List)listaInventarios)) {
                    throw new UnicoMensagemUsuarioException("WSTG12", "N\u00e3o foi encontrado invent\u00e1rio cadastrado! Verifique.");
                }
                if (listaInventarios.size() > 1) {
                    throw new UnicoMensagemUsuarioException("WSTG11", "Foi cadastrado mais de um invent\u00e1rio para o per\u00edodo! Verifique.");
                }
                InventarioSintegra inventario = (InventarioSintegra)listaInventarios.get(0);
                sintegra.setIdsProduto(InventarioSintegraItemRN.getInstance().buscaListaIdProdutos(inventario.getId()));
                sintegra.setTipoCalculoCusto(inventario.getTipoCalculo());
                sintegra.setEnviarProdutoInativo(inventario.isEnviarInativo());
                sintegra.setDataEstoque(inventario.getDataInventario());
                CustoMedioDiarioRN.getInstance().validarCustoMedio(sintegra.getTipoCalculoCusto(), sintegra.getDataEstoque(), sintegra.getDataEstoque(), filial);
            } else if (sintegra.isRegistroTipo74()) {
                if (sintegra.getDataEstoque() == null) {
                    throw new UnicoMensagemUsuarioException("WWW627", "Para o registro tipo 74, deve ser informado a 'Data estoque' na aba Estoque");
                }
                CustoMedioDiarioRN.getInstance().validarCustoMedio(sintegra.getTipoCalculoCusto(), sintegra.getDataEstoque(), sintegra.getDataEstoque(), filial);
            }
        }
    }

    private String resumoFiltros(SintegraModel parametros) {
        if (parametros != null) {
            return "Periodo: " + StringUtil.formataDataHora((Temporal)parametros.getDataInicio(), (String)"dd/MM/yy") + " \u00e0 " + StringUtil.formataDataHora((Temporal)parametros.getDataFim(), (String)"dd/MM/yy");
        }
        return "";
    }
}

