/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.crud.tabelaconversaocst;

import br.intelidata.commons.bridge.SessaoUtil;
import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Condicao;
import br.intelidata.commons.core.sql.usql.Funcao;
import br.intelidata.commons.core.sql.usql.Operador;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.TabelaConversaoCst;
import br.intelidata.commons.domain.pojo.enuns.CstICMS;
import br.intelidata.commons.domain.pojo.enuns.CstSNICMS;
import br.intelidata.commons.domain.pojo.enuns.EnumUtils;
import br.intelidata.commons.domain.pojo.enuns.TipoEnquadramentoFilial;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.notafiscal.regranegocio.TabelaConversaoCstRN;
import br.intelidata.uniplusweb.core.coreinterfaces.SubMenuMapping;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import java.util.Optional;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/tabelas-conversao-cst"})
@SubMenuMapping(MENU="SubMenuFiscalAuxiliarParametrosNotaFiscal", NOME="Tabelas de convers\u00e3o de CST/CSOSN", ROTA="/notas-fiscais/tabelas-conversao-cst", PROGRAMA=81)
public class TabelaConversaoCstCrudController
extends CrudController<TabelaConversaoCst, TabelaConversaoCstRN> {
    public TabelaConversaoCstCrudController() {
        super((AbstractRegraNegocio)TabelaConversaoCstRN.getInstance(), TabelaConversaoCst::new, true, true);
    }

    protected void beforeRead(TabelaConversaoCst tabelaConversaoCst, int modo, Optional<Long> parentId) throws UnicoMensagemUsuarioException {
        if (SessaoUtil.getSessao().getFilial().getTipoEnquadramento() == TipoEnquadramentoFilial.SIMPLESNACIONAL) {
            tabelaConversaoCst.setCstDe(((CstICMS)EnumUtils.getPorId(CstICMS.class, (Object)tabelaConversaoCst.getCstDe())).name());
            tabelaConversaoCst.setCstPara(((CstSNICMS)EnumUtils.getPorId(CstSNICMS.class, (Object)tabelaConversaoCst.getCstPara())).name());
        } else {
            tabelaConversaoCst.setCstDe(((CstSNICMS)EnumUtils.getPorId(CstSNICMS.class, (Object)tabelaConversaoCst.getCstDe())).name());
            tabelaConversaoCst.setCstPara(((CstICMS)EnumUtils.getPorId(CstICMS.class, (Object)tabelaConversaoCst.getCstPara())).name());
        }
    }

    public GridBuilder<TabelaConversaoCstRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("cstDe", "De", 0, true));
        colunas.add(new ColunaSQL("cstPara", "Para", 0, true));
        GridBuilder grid = new GridBuilder(TabelaConversaoCstRN.getInstance().getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("cstde"));
        grid.addReferenciaDefault(new Referencia(Funcao.LENGTH, "cstde", "tamanhocstde", new Object[0]));
        int tamanho = TipoEnquadramentoFilial.SIMPLESNACIONAL.equals((Object)SessaoUtil.getSessao().getFilial().getTipoEnquadramento()) ? 2 : 3;
        grid.setCondicaoDefault(new Condicao("tamanhocstde", Operador.IGUAL, tamanho));
        return grid;
    }

    protected String getCacheId() {
        return "tabelas-conversao-cst";
    }
}

