/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.intelidata.contrato.movimento;

import br.intelidata.commons.core.sql.usql.ColunaSQL;
import br.intelidata.commons.core.sql.usql.Ordem;
import br.intelidata.commons.core.sql.usql.Referencia;
import br.intelidata.commons.domain.pojo.ContratoVendaMovimento;
import br.intelidata.commons.domain.regranegocio.AbstractRegraNegocio;
import br.intelidata.commons.modulo.intelidata.regranegocio.ContratoVendaMovimentoRN;
import br.intelidata.uniplusweb.core.grid.GridBuilder;
import br.intelidata.uniplusweb.web.rest.app.client.crud.CrudController;
import java.util.ArrayList;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contratos-movimentos"})
public class ContratoMovimentoCrudController
extends CrudController<ContratoVendaMovimento, ContratoVendaMovimentoRN> {
    public ContratoMovimentoCrudController() {
        super((AbstractRegraNegocio)ContratoVendaMovimentoRN.getInstance(), ContratoVendaMovimento::new);
        this.dependsOn("idContrato");
    }

    protected String getCacheId() {
        return "contratos-movimentos";
    }

    protected GridBuilder<ContratoVendaMovimentoRN> getGridBuilder() {
        ArrayList<ColunaSQL> colunas = new ArrayList<ColunaSQL>();
        colunas.add(new ColunaSQL("id", "ID", 0, false));
        colunas.add(new ColunaSQL("dataHora", "Data e hora", 0, true));
        colunas.add(new ColunaSQL("nome", "produto", "Licen\u00e7a", 0, true, new String[]{"fk_contvendamov_produto"}));
        colunas.add(new ColunaSQL("chaveAtivacao", "Chave de ativa\u00e7\u00e3o", 0, true));
        colunas.add(new ColunaSQL("tipo", "Tipo", 0, true));
        colunas.add(new ColunaSQL("nome", "usuarioSite", "Usu\u00e1rio do site", 0, true, new String[]{"fk_contvendamov_ususite"}));
        GridBuilder grid = new GridBuilder(((ContratoVendaMovimentoRN)this.rn).getTabela(), colunas);
        grid.addReferenciaDefault(new Referencia("idContrato"));
        grid.addOrdem(new Ordem("dataHora", true));
        return grid;
    }
}

