/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.compras.estoquecompra;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.FamiliaProduto;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.estoque.relatorio.EstoqueParaComprasRelatorio;
import br.intelidata.commons.modulo.produto.regranegocio.FamiliaProdutoRN;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.compras.estoquecompra.EstoqueCompra;
import java.util.List;

public class EstoqueCompraReportExecute
extends AbstractReporteExecute<EstoqueCompra> {
    public EstoqueCompraReportExecute(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        EstoqueCompra parametros = (EstoqueCompra)this.fromJson(parametrosObj, EstoqueCompra.class);
        return this.executa(sessao, parametros);
    }

    public Remessa executa(Sessao sessao, EstoqueCompra estoqueCompra) throws UnicoMensagemUsuarioException {
        List filiais = FilialRN.getInstance().getFiliais(estoqueCompra.getIdsFiliais());
        Entidade fornecedor = (Entidade)EntidadeRN.getInstance().buscarPorId(estoqueCompra.getIdFornecedor());
        FamiliaProduto familia = (FamiliaProduto)FamiliaProdutoRN.getInstance().buscarPorId(estoqueCompra.getIdFamilia());
        return new EstoqueParaComprasRelatorio().getRelatorio(estoqueCompra.getSaida(), filiais, fornecedor, estoqueCompra.getPeriodoInicial(), estoqueCompra.getPeriodoFinal(), estoqueCompra.getIdGrupo(), estoqueCompra.getIdFamilia(), familia != null ? familia.getNome() : null, estoqueCompra.getAgrupamento(), estoqueCompra.getOrdenacao(), estoqueCompra.getImprimirCusto());
    }
}

