/*
 * Decompiled with CFR 0.152.
 */
package br.intelidata.uniplusweb.web.rest.app.report.financeiro.documentoendossado;

import br.intelidata.commons.core.execoes.UnicoMensagemUsuarioException;
import br.intelidata.commons.core.sistema.Sessao;
import br.intelidata.commons.core.util.Remessa;
import br.intelidata.commons.domain.pojo.AbstractPojo;
import br.intelidata.commons.domain.pojo.Entidade;
import br.intelidata.commons.domain.pojo.TipoDocumentoFinanceiro;
import br.intelidata.commons.domain.pojo.batch.JobMetadata;
import br.intelidata.commons.modulo.cadastros.regranegocio.FilialRN;
import br.intelidata.commons.modulo.entidade.regranegocio.EntidadeRN;
import br.intelidata.commons.modulo.financeiro.regranegocio.TipoDocumentoFinanceiroRN;
import br.intelidata.commons.modulo.financeiro.relatorio.DocumentosEndossadosRelatorio;
import br.intelidata.uniplusweb.web.rest.app.client.report.AbstractReporteExecute;
import br.intelidata.uniplusweb.web.rest.app.report.financeiro.documentoendossado.DocumentoEndossado;
import java.util.ArrayList;

public class DocumentoEndossadoReportExecuter
extends AbstractReporteExecute<DocumentoEndossado> {
    public DocumentoEndossadoReportExecuter(String parameters, JobMetadata metadata) {
        super(parameters, metadata);
    }

    public Remessa deserialize(Sessao sessao, String parametrosObj) throws UnicoMensagemUsuarioException {
        DocumentoEndossado documentoEndossado = (DocumentoEndossado)this.fromJson(parametrosObj, DocumentoEndossado.class);
        return this.executa(sessao, documentoEndossado);
    }

    public Remessa executa(Sessao sessao, DocumentoEndossado parametros) throws UnicoMensagemUsuarioException {
        ArrayList<AbstractPojo> filiais = new ArrayList<AbstractPojo>();
        for (Long idFilial : parametros.getIdsFiliais()) {
            filiais.add(FilialRN.getInstance().buscarPorId(idFilial));
        }
        Long idTipoDocumento = null;
        String nome = null;
        TipoDocumentoFinanceiro tipoDocumento = TipoDocumentoFinanceiroRN.getInstance().buscarPorId(parametros.getIdTipoDocumentoFinanceiro());
        if (tipoDocumento != null) {
            idTipoDocumento = tipoDocumento.getId();
            nome = tipoDocumento.getDescricao();
        }
        Entidade cliente = parametros.getIdCliente() != null ? (Entidade)EntidadeRN.getInstance().buscarPorId(parametros.getIdCliente()) : null;
        return new DocumentosEndossadosRelatorio().getRelatorio(parametros.getSaida(), filiais, idTipoDocumento, nome, cliente, parametros.getEmissaoInicial(), parametros.getEmissaoFinal(), parametros.getVencimentoInicial(), parametros.getVencimentoFinal(), parametros.getPagamentoInicial(), parametros.getPagamentoFinal());
    }
}

